/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>

#include "mserver.h"

extern FILE *outsock;
extern int cspeed;

extern struct msrv_client *clients[MAXCLIENTS];

void mserver_dial (const char *cname, const char *user)
{
	int retval;

	char script[1024];

	netload_init();
	
	fprintf (outsock,"BEGIN\n");
	util_fflush (outsock);

	if (shmem_get_dial_lock() > 0)
	{
		fprintf(outsock, "ERROR: Server is currently locked!\n");
		fprintf(outsock,"END\n");
		return;
	}

	if (!find_cname(cname))
	{
		fprintf(outsock, "ERROR: Could not find connection!\n");
		fprintf(outsock,"END\n");
		return;
	}
	
	if (!auth_check(cname, AUTH_CONNECT))
	{
		fprintf(outsock, "ERROR: You are not authorized to manipulate this connection!\n");
		fprintf(outsock,"END\n");
		return;
	}

	if (shmem_get_captured())
	{
		char capname[1024];

		shmem_get_capname(capname);	

		fprintf(outsock, "ERROR: Modem is captured (%s)\n", capname);
		fprintf(outsock, "END\n");
		return;
	}

	/*
	 * If we are already connected to this location, we will clear
	 * and pending KILL requests and report success at this point.
	 */
	if (getstat())
	{
		shmem_set_pending_kill(false);
		fprintf(outsock, "Connected to %s at %d\n", cname, shmem_get_cspeed());
		fprintf(outsock, "END\n");
		return;
	}


	if (!cfile_write(cname))
	{
		fprintf(outsock, "Could not write connection information file!\n");
		fprintf(outsock, "END\n");
		return;
	}
	shmem_set_dialing(getpid());

	fprintf(outsock, "Dialing connection: %s by user %s\n", cname, user);
	syslog(LOG_INFO, "Dialing connection: %s by user %s\n", cname, user);
	config_getvalue_cname_specified("script", script, cname, 1024);
	syslog(LOG_INFO, "Executing: %s", script);
	fprintf(outsock, "Executing: %s\n", script);

	util_fflush (outsock);

	if (!parse_init(cname))
	{
		fprintf(outsock, "Could not initialize logfile parsing!\n");
		fprintf(outsock, "END\n");
		shmem_set_dialing(-1);
		return;
	}

	retval = util_system(script);	

	if (retval != 0)
	{
		syslog (LOG_WARNING, "There was an error while executing %s", script);
		fprintf(outsock, "ERROR:There was an error while executing %s\n", script);
		fprintf(outsock,"END\n");
		shmem_set_dialing(-1);
		return;
	}


	if(parse(cname))
	{
		fprintf(outsock, "Connected to %s at %d\n", cname, cspeed);
	}
	else
	{
		fprintf(outsock, "END\n");
		shmem_set_dialing(-1);
		return;
	}

	util_sleep(config_getvalue_int("statwait", 0));
	
	if (getstat())
	{
		char command[1024];

		cfile_write(cname);
	
		config_getvalue_cname("linkup", command, 1024);
		snprintf(command, 1024, "%s \"%s\"", command, cname);
		util_system(command);
	}
	netload_init();

	fprintf(outsock,"END\n");
	shmem_set_dialing(-1);
}

void auto_dial (const char *cname)
{
       int retval;

       char script[1024];

       netload_init();

       if (!find_cname(cname))
       {
               syslog(LOG_ERR, "ERROR: Could not find connection!");
               return;
       }

       if (shmem_get_captured())
       {
               char capname[1024];

               shmem_get_capname(capname);

               syslog(LOG_ERR, "ERROR: Modem is captured (%s)", capname);
               return;
       }

       /*
        * If we are already connected to this location, we will clear
        * and pending KILL requests and report success at this point.
        */
       if (getstat())
       {
               shmem_set_pending_kill(false);
               return;
       }


       if (!cfile_write(cname))
       {
               return;
       }
       shmem_set_dialing(getpid());

       syslog(LOG_INFO, "Auto-Dialing connection: %s", cname);
       config_getvalue_cname_specified("script", script, cname, 1024);
       syslog(LOG_INFO, "Executing: %s", script);

       if (!parse_init(cname))
       {
               syslog(LOG_ERR, "Could not initialize logfile parsing!");
               shmem_set_dialing(-1);
               return;
       }

       retval = util_system(script);   

       if (retval != 0)
       {
               syslog (LOG_WARNING, "There was an error while executing %s", script);
               shmem_set_dialing(-1);
               return;
       }


       if(parse(cname))
       {
               syslog(LOG_INFO, "Connected to %s at %d", cname, cspeed);
       }
       else
       {
               shmem_set_dialing(-1);
               return;
       }

       util_sleep(config_getvalue_int("statwait", 0));
       
       if (getstat())
       {
               char command[1024];

               cfile_write(cname);
       
               config_getvalue_cname("linkup", command, 1024);
               snprintf(command, 1024, "%s \"%s\"", command, cname);
               util_system(command);
       }
       netload_init();

       shmem_set_dialing(-1);
}
