/*
 *  pqstat.c
 *
 *  List the jobs in a print queue on a server
 *
 *  Copyright (C) 1998 by David Woodhouse
 *  Derived from pqlist.c, (C) 1996 Volker Lendecke
 *
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <ncp/nwcalls.h>

#include <libintl.h>
#define _(X) gettext(X)
#define N_(X) (X)

/* move this to library ? */
int
ncp_time_to_tm(struct tm* out, u_int8_t* netwareTime)
{
	struct tm tmp;

	tmp.tm_year = netwareTime[0];
	if (tmp.tm_year < 80) tmp.tm_year += 100;
	tmp.tm_mon = netwareTime[1]-1;
	if ((tmp.tm_mon < 0) || (tmp.tm_mon >= 12)) return 1;
	tmp.tm_mday = netwareTime[2];
	if ((tmp.tm_mday < 1) || (tmp.tm_mday >= 32)) return 1;
	tmp.tm_hour = netwareTime[3];
	if (tmp.tm_hour >= 24) return 1;
	tmp.tm_min = netwareTime[4];
	if (tmp.tm_min >= 60) return 1;
	tmp.tm_sec = netwareTime[5];
	if (tmp.tm_sec >= 60) return 1;
	memcpy(out, &tmp, sizeof(tmp));
	return 0;
}

int
ncp_cmp_time(struct tm* tm1, struct tm* tm2)
{
#undef XTST
#define XTST(Y) if (tm1->tm_##Y## != tm2->tm_##Y##) { \
			return (tm1->tm_##Y## > tm2->tm_##Y##) ? 1 : -1; \
		}
	XTST(year);
	XTST(mon);
	XTST(mday);
	XTST(hour);
	XTST(min);
	XTST(sec);
#undef XTST
	return 0;
}

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	struct ncp_bindery_object q,u;
        unsigned long maxqlen=~0;
	long err;

        u_int32_t qlen, idl1,idl2, job_id;
        struct nw_queue_job_entry j;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("when initializing"));
		return 1;
	}

        if (argc == 3)
        {
                char *end;

                maxqlen=strtoul(argv[2], &end, 10);
                if (*end != 0)
                        argc = 4;

        }
	if (argc < 2 || argc > 3)
	{
		fprintf(stderr, _("usage: %s <queue> [<qlen>]\n"), argv[0]);
		return 1;
	}


	if (ncp_get_bindery_object_id(conn, NCP_BINDERY_PQUEUE, 
                                      argv[1], &q) != 0)
	{
		char server[NW_MAX_SERVER_NAME_LEN];
		const char* sptr = server;
		NWCCODE err;

		err = NWCCGetConnInfo(conn, NWCC_INFO_SERVER_NAME, 
			sizeof(server), server);
		if (err)
			sptr = "?";
               	printf(_("Queue \"%s\" on server %s not found.\n"),
			argv[1], server);
                ncp_close(conn);
                exit(1);

	}

	if (isatty(1))
	{
		char server[NW_MAX_SERVER_NAME_LEN];
		const char* sptr = server;
		NWCCODE err;

		err = NWCCGetConnInfo(conn, NWCC_INFO_SERVER_NAME,
			sizeof(server), server);
		if (err)
			sptr = "?";

		printf(_("\nServer: %s\tQueue: %s\tQueue ID: %8.8X\n"), sptr, 
			q.object_name, q.object_id);
                printf(_(" %5s  %-12s  %-32s  %-7s  %-4s  %-8s\n"
		       "-----------------------------------------------"
		       "--------------------------------\n"),
		       _("Seq"),_("Name"),
		       _("Description"), _("Status"), _("Form"), _("Job ID"));
	}


        if ((err=ncp_get_queue_length(conn, q.object_id, &qlen)) != 0)
        {
		if (err == NWE_Q_NO_RIGHTS) {
			fprintf(stderr, _("You have insufficient rights to list queue jobs\n"));
		} else {
			com_err(argv[0], err, _(": cannot get queue length"));
		}
                ncp_close(conn);
                exit(1);
        }
/*        printf("There are %d jobs in the queue.\n",qlen); */
               
        idl1=1;
        job_id =0;
        
        if ((err=ncp_get_queue_job_ids(conn, q.object_id, 1, 
                                       &idl1, &idl2, &job_id)) != 0)
        {
                printf(_("Error getting queue jobs ids: %ld\n"),err);
                ncp_close(conn);
                exit(1);
        }
        
/*        printf("First queue job ID is %8X\n",job_id);*/
     
        while (maxqlen-- && job_id && (ncp_get_queue_job_info(conn, q.object_id, job_id, &j) == 0))
	{
		const char* jst;

                char user[50];
                if ((ncp_get_bindery_object_name
                     (conn, ntohl(j.ClientObjectID), &u))
                    == 0)
                {
                        memcpy(user,u.object_name,48);
			user[48]=0;
                } 
                else
                {
                        sprintf(user,_("<Unknown>"));
                }

                j.JobFileName[j.FileNameLen]=0;

		if (j.JobControlFlags & 0xC0) {
			jst = N_("Held");
		} else if (j.JobControlFlags & 0x20) {
			jst = N_("Adding");
		} else if (j.ServerStation) {
			jst = N_("Active");
		} else {
			struct tm jobtime;

			jst = N_("Ready");
			if (!ncp_time_to_tm(&jobtime, j.TargetExecTime)) {
				time_t ltime;
				struct tm* loctime;

				time(&ltime);
				loctime = localtime(&ltime);
				
				if (ncp_cmp_time(&jobtime, loctime) >= 0)
					jst = N_("Waiting");
			}
		}
               
                printf(_(" %5d  %-12s  %-32.32s  %-7s  %4d  %08X\n"),
                       j.JobPosition, user, j.JobTextDescription, _(jst), ntohs(j.JobType), j.JobNumber);
                if (j.next == job_id) 
                        job_id = 0;
                else job_id = j.next;
        }

	ncp_close(conn);
	return 0;
}

