/*
 * mknbi.h  -  Definitions for the MGL compiler
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _MKNBI_H_MGL_
#define _MKNBI_H_MGL_


/*
 * Include version information
 */
#include "version.h"



/*
 * We need internet header files almost everywhere, so include them here
 */
#include "common.h"
#ifdef HAVE_INET
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define INADDR_SIZE	sizeof(struct in_addr)
#else
#define INADDR_SIZE	4
#endif
#include <limits.h>



/*
 * The following structures have to be packed.
 */
#ifdef USE_PRAGMA
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * The bootrom loads the load header to 0x10000 and the compiled
 * program to 0x20000.
 */
#define HEADERSEG	0x1000		/* segment for boot image header */
#define HEADERLSIZE	512		/* maximum load size of image header */
#define HEADERMSIZE	512		/* maximum memory size of image header */
#define PROGSEG		0x2000		/* segment for primary load header */
#define PROGLSIZE	131072L		/* maximum load size of load header */
#define PROGMSIZE	131072L		/* maximum memory size of load header */

#define BOOT_SIGNATURE	0xaa55		/* boot signature */
#define BOOT_SIG_OFF	510		/* boot signature offset */

#define SECTSIZE	512		/* Size of one sector */



/*
 * The boot image has the following header in it's first sector
 */
struct load_header {
  struct i_long magic		PACKED;		/* magic number */
  __u8          hlength		PACKED;		/* length of header */
  __u8          hflags1		PACKED;		/* header flags */
  __u8          hflags2		PACKED;
  __u8          hflags3		PACKED;
  struct i_addr locn		PACKED;		/* location of this header */
  struct i_addr execute		PACKED;		/* execution address */
  __u8          dummy[494];			/* up to full sector */
  __u16         bootsig		PACKED;		/* boot signature */
};

#define HEADER_MAGIC	0x1B031336		/* Magic no for load header */
#define HEADER_RETFLAG	0x01			/* Flag for return to bootrom */


struct load_record {
  __u8              rlength	PACKED;		/* length of record */
  __u8              rtag1	PACKED;		/* record tags */
  __u8              rtag2	PACKED;
  __u8              rflags	PACKED;		/* record flags */
  struct i_long     address	PACKED;		/* abs addr for part in mem */
  struct i_long     ilength	PACKED;		/* len of part in boot image */
  struct i_long     mlength	PACKED;		/* memory needed for part */
};

#define FLAG_B0		1
#define FLAG_B1		2
#define FLAG_EOF	4



/*
 * Number of each load record.
 */
#define PROGNUM		0		/* compiled program */
#define NUM_RECORDS	1		/* total number of load records */
#define VENDOR_ID	"GK-mknbi-mgl"	/* Vendor ID */
#define VENDOR_OFF	16		/* Offset for vendor tags */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif



/*
 * Global variables
 */
extern int is186;			/* we have a 186+ processor */
extern int is386;			/* we have a 386+ processor */
extern int debug;			/* include debugging information */



/*
 * External routines
 */
extern int gencode __P((char *infile));	/* compile the MGL program */


#endif

