/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *  			  Centro SERRA, University of Pisa
 *  			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

/* #define PRINT_PKTS */

/*
  Courtesy of 
  Peter Marquardt <wwwutz@mpimg-berlin-dahlem.mpg.de>
*/
#define SD(a,b) ((b)?((float)a)/(b):0)

/* Extern */
extern char domainName[], *shortDomainName;
extern int broadcastEntryIdx;
extern float last60MinutesThpt[60], last24HoursThpt[24], last30daysThpt[30];
extern unsigned short last60MinutesThptIdx, last24HoursThptIdx, last30daysThptIdx;
extern char domainName[];
extern unsigned long numThptSamples;
extern int newSock, datalink, lastNumLines, lastNumCols;
extern u_int maxNumLines;
extern u_short numIpProtosToMonitor;
extern char *protoIPTrafficInfos[MAX_NUM_HANDLED_IP_PROTOCOLS];
extern TrafficCounter ethernetPkts, ethernetBytes, ipBytes;
extern TrafficCounter broadcastPkts, multicastPkts;
extern float peakThroughput, actualThpt, lastMinThpt, lastFiveMinsThpt;
extern void sendString(char *x);
extern void usage(int);
extern void createVendorTable();
extern char* getVendorInfo(u_char* ethAddress, short);
extern unsigned int localnet, netmask, webMode;
extern RETSIGTYPE cleanup(int signo);
extern int numericFlag, refreshRate, localAddrFlag, percentMode, idleFlag, logTimeout;
extern char deviceName[], *separator;
extern FILE *logd;
extern HostTraffic* hash_hostTraffic[HASHNAMESIZE];
extern IPSession *tcpSession[HASHNAMESIZE]; /* TCP sessions */
extern IPSession *udpSession[HASHNAMESIZE]; /* UDP sessions */
extern u_short numTcpSessions, numUdpSessions;
extern short sortSendMode;
extern time_t actTime, initialSniffTime, lastRefreshTime;
extern TrafficEntry ipTrafficMatrix[256][256]; /* Subnet traffic Matrix */
extern HostTraffic* ipTrafficMatrixHosts[256]; /* Subnet traffic Matrix Hosts */
extern pcap_t *pcapPtr;
extern TrafficCounter numRcvdPackets;
extern FlowFilterList *flowsList;
extern PacketStats rcvdPktStats;
extern SimpleProtoTrafficInfo *ipProtoStats;
extern TrafficCounter tcpBytes, udpBytes, icmpBytes, dlcBytes, ipxBytes, decnetBytes,
  netbiosBytes, arpRarpBytes, atalkBytes, ospfBytes, igmpBytes, otherBytes, osiBytes, otherIpBytes;
extern SimpleProtoTrafficInfo tcpGlobalTrafficStats, udpGlobalTrafficStats, icmpGlobalTrafficStats;
extern short printingUsage;
#ifdef MULTITHREADED
extern TrafficCounter droppedPackets;
#endif
#ifdef HAVE_LSOF /* util.c */
extern ProcessInfo *processes[MAX_NUM_PROCESSES];
extern u_short numProcesses;
extern ProcessInfoList *localPorts[TOP_IP_PORT];
#endif
#if defined(HAVE_LSOF) & defined(MULTITHREADED)
extern pthread_mutex_t     lsofMutex;
#endif


/* Global */
short screenNumber=0, columnSort, sortFilter;
TrafficCounter lastethernetPkts, lastTotalPkts, lastBroadcastPkts, lastMulticastPkts;
TrafficCounter lastEthernetBytes, lastIpBytes, lastNonIpBytes;


/* Static */
static short domainSort = 0;
		  
/* Extern Functions */
extern void updateOSName(HostTraffic *el);
extern char* ipaddr2str(struct in_addr hostIpAddress);
extern char* getPortByNum(int port, int type);
extern char* getAllPortByNum(int port);
extern void clrscr();
extern void init_curses();
extern char* getRowColor();
extern char* getActualRowColor();
extern unsigned char isLocalAddress(struct in_addr *addr);
extern unsigned char isPseudoLocalAddress(struct in_addr *addr);
extern unsigned char isBroadcastAddress(struct in_addr *addr);
extern char* intoa(struct in_addr addr);
extern void  quicksort(void *, size_t, size_t,
		       int (*)(const void *, const void *));
extern void  printLogTime();
extern void  printHTTPheader();
#ifdef MULTITHREADED
#endif
extern int checkKeyPressed();
extern u_int checkSessionIdx(u_int idx);

/* Forward */
char* getHostCountryIconURL(HostTraffic *el);
void fillDomainName(HostTraffic *el);
char* getCountryIconURL(char* hostName);
void printIpProtocolDistribution(int mode, int);
void printTableEntryPercentage(char *buf, char *label, char* label_1, 
			       char* label_2, float total, float percentage);
void printTableDoubleEntry(char *buf, char *label, char* color, 
			   float totalS, float percentageS, 
			   float totalR, float percentageR);
void printTableEntry(char *buf, char *label, char* color, float total, float percentage);
char* formatPkts(TrafficCounter pktNr);
void printBar(char *buf, unsigned short percentage,
	      unsigned short maxPercentage, unsigned short ratio);

/* ******************************* */

void printHelp() {
  if(webMode)
    return;
  
  usage(1);
}

/* ******************************* */

void printHeader(int reportType, int revertOrder) {
  char buf[BUF_SIZE];
  char tmpBuf[24], *c="", *d="", *e="", *sign;
#ifdef HAVE_CURSES
  int idx;
  char progName[255];
#endif

  if(revertOrder)
    sign = "";
  else
    sign = "-";

  memset(buf, 0, sizeof(buf));

  if(!webMode) {
#ifdef HAVE_CURSES
    clrscr(); /* clear the screen */  
    sprintf(progName,  " ntop v.%s %s [%s] listening on %s",
	    version, THREAD_MODE, osName, deviceName);
    /* avoid long lines on small screens */
    progName[80] = '\0'; progName[COLS-2] = '\0'; 
    mvprintw(0, 40 - (strlen(progName)/2), progName);

    switch(screenNumber) {
    case 0:
      c = "TCP";
      d = "UDP";
      e = "ICMP";
      break;
    case 1:
      c = "DLC";
      d = "IPX";
      e = "Decnet";
      break;
    case 2:
      c = "(R)ARP";
      d = "ATalk";
      e = "OSPF";
      break;
    case 3:
      c = "NBios";
      d = "IGMP";
      e = "OSI";
      break;
    case 4:
      c = "Other";
      d = "";
      e = "";
      break;
    default:
      idx = (screenNumber-MAX_NUM_PROTOS_SCREENS)*3;
      if(idx < numIpProtosToMonitor)
	c = protoIPTrafficInfos[idx];
      else
	c = "";

      ++idx;
      if(idx < numIpProtosToMonitor)
	d = protoIPTrafficInfos[idx];
      else
	d = "";

      ++idx;
      if(idx < numIpProtosToMonitor)
	e = protoIPTrafficInfos[idx];
      else
	e = "";
    }
#else
    ;
#endif
  } else {
    int i;
    char htmlAnchor[64];

    printHTTPheader();

    if(sortSendMode) {
      if(sortSendMode == 1)
	sendString("<CENTER><P><H1><FONT FACE=Helvetica>Network Traffic: Data Sent</FONT></H1><P>\n");
      else {
	sendString("<CENTER><P><H1><FONT FACE=Helvetica>Host Information</FONT></H1><P>\n");
	return;
      }
      
      if((reportType == 0) || (reportType == 1)) {
	if(reportType == 0)
	  sprintf(htmlAnchor, "<A HREF=/%s?%s", STR_SORT_DATA_SENT_PROTOS, sign);
	else
	  sprintf(htmlAnchor, "<A HREF=/%s?%s", STR_SORT_DATA_SENT_IP, sign);
      } else if(reportType == 2)
	sprintf(htmlAnchor, "<A HREF=/%s?%s",   STR_SORT_DATA_SENT_THPT, sign);     

      if((reportType == 0) || (reportType == 1))
	sprintf(buf, "<TABLE BORDER=1><TR><TH>%s"HOST_DUMMY_IDX_STR">Host</A></TH>\n"
		"<TH>%s"DOMAIN_DUMMY_IDX_STR">Domain</A></TH>"
		"<TH COLSPAN=2>%s0>Sent</A></TH>\n", 
		htmlAnchor, htmlAnchor, htmlAnchor);
      else
	sprintf(buf, "<TABLE BORDER=1><TR><TH>%s"HOST_DUMMY_IDX_STR">Host</A></TH>"
		"<TH>%s"DOMAIN_DUMMY_IDX_STR">Domain</A></TH>\n\n", htmlAnchor, htmlAnchor);
	
      sendString(buf);
    } else {
      sendString("<CENTER><P><H1><FONT FACE=Helvetica>Network Traffic"
		 ": Data Received</FONT></H1><P>\n");

      if((reportType == 0) || (reportType == 1)) {
	if(reportType == 0)
	  sprintf(htmlAnchor, "<A HREF=/%s?%s", STR_SORT_DATA_RECEIVED_PROTOS, sign);
	else
	  sprintf(htmlAnchor, "<A HREF=/%s?%s", STR_SORT_DATA_RECEIVED_IP, sign);
      } else if(reportType == 2)
	sprintf(htmlAnchor, "<A HREF=/%s?%s",   STR_SORT_DATA_RECEIVED_THPT, sign);

      if((reportType == 0) || (reportType == 1))
	sprintf(buf, "<TABLE BORDER=1><TR><TH>%s"HOST_DUMMY_IDX_STR">Host</A></TH>\n"
		"<TH>%s"DOMAIN_DUMMY_IDX_STR">Domain</A></TH>"
		"<TH COLSPAN=2>%s0>Received</A></TH>\n", 
		htmlAnchor, htmlAnchor, htmlAnchor);
      else
	sprintf(buf, "<TABLE BORDER=1><TR><TH>%s"HOST_DUMMY_IDX_STR">Host</A></TH>"
		"<TH>%s"DOMAIN_DUMMY_IDX_STR">Domain</A></TH>\n\n",		
		htmlAnchor, htmlAnchor);
	
      sendString(buf);
    }
	
    if(reportType == 0) {
      sprintf(buf, "<TH>%s1>TCP</A></TH><TH>%s2>UDP</A></TH><TH>%s3>ICMP</A></TH>"
	      "<TH>%s4>DLC</A></TH><TH>%s5>IPX</A></TH><TH>%s6>Decnet</A></TH>"
	      "<TH>%s7>(R)ARP</A></TH><TH>%s8>AppleTalk</A></TH>"
	      "<TH>%s9>OSPF</A></TH><TH>%s10>NetBios</A></TH><TH>%s11>IGMP</A></TH>"
	      "<TH>%s12>OSI</A><TH>%s13>Other</A></TH>",
	      htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor, 
	      htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor,
	      htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor);
      sendString(buf);
    } else if(reportType == 1) {
      for(i=0; i<numIpProtosToMonitor; i++) {
	sprintf(buf, "<TH>%s%d>%s</A></TH>", 
		htmlAnchor, i+1, protoIPTrafficInfos[i]);
	sendString(buf);
      }

      sprintf(buf, "<TH>%s%d>Other&nbsp;IP</A></TH>", htmlAnchor, i+1);
      sendString(buf);
    } else if(reportType == 2) {
      sprintf(buf, "<TH>%s1>Actual Thpt</A></TH>"
	      "<TH>%s2>Average Thpt</A><TH>%s3>Peak Thpt</A></TH>",
	      htmlAnchor, htmlAnchor, htmlAnchor);
      sendString(buf);
    }

    sendString("</TR>\n");
    return;
  }

  switch(columnSort) 
    {
      /* case 0: = no sort */
    case 1:
      sprintf(tmpBuf, "-%s-", c);
      c = tmpBuf;
      break;
    case 2:
      sprintf(tmpBuf, "-%s-", d);
      d = tmpBuf;
      break;
    case 3:
      sprintf(tmpBuf, "-%s-", e);
      e = tmpBuf;
      break;
    }

  if(sortSendMode)
    sprintf(buf, " %-24.24s %s%9s %9s %9s %9s %8s ",
	    "Host", "Act", "Rcvd", "-Sent-", c, d, e);
  else
    sprintf(buf, " %-24.24s %s%9s %9s %9s %9s %8s ",
	    "Host", "Act", "-Rcvd-", "Sent", c, d, e);

#ifdef HAVE_CURSES
  buf[COLS-2] = '\0'; /* avoid long lines on small screens */
  attrset(A_REVERSE); 
  mvprintw(2, 0, buf);  
  attrset(A_NORMAL);
  refresh();
#endif
}

/* ******************************* */

char* getOSFlag(char* osName) {
  static char tmpStr[96], *flagImg;

  if(strstr(osName, "Windoze") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/windows.gif>";
  else if(strstr(osName, "IRIX") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/irix.gif>";
  else if(strstr(osName, "Linux") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/linux.gif>";
  else if(strstr(osName, "SunOS") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/sun.gif>";
  else if(strstr(osName, "Solaris") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/sun.gif>";
  else if(strstr(osName, "HP/JETdirect") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/hp.gif>";
  else if(strstr(osName, "Mac") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/mac.gif>";
  else if(strstr(osName, "BSD") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/bsd.gif>";
  else if(strstr(osName, "Berkeley: HP-UX") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/hp.gif>";
  else if(strstr(osName, "IBM AIX") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/aix.gif>";
  else if(strstr(osName, "Berkeley") != NULL)
    flagImg = "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/os/bsd.gif>";
  else
    flagImg = NULL;

  if(flagImg != NULL)
    sprintf(tmpStr, "%s&nbsp;[%s]", flagImg, osName);
  else
    strcpy(tmpStr, osName);

  return(tmpStr);
}

/* ******************************* */

char* formatKBytes(float numKBytes) {
#define BUFFER_SIZE   24
  static char outStr[BUFFER_SIZE][32];
  static short bufIdx=0;

  if(numKBytes < 0) return(""); /* It shouldn't happen */

  bufIdx = (bufIdx+1)%BUFFER_SIZE;

  if(numKBytes < 1024)
    sprintf(outStr[bufIdx], "%.1f%sKB", numKBytes, separator);
  else {
    float tmpKBytes = numKBytes/1024;

    if(tmpKBytes < 1024)
      sprintf(outStr[bufIdx], "%.1f%sMB",  tmpKBytes, separator);
    else {
      float tmpGBytes = tmpKBytes/1024;

      if(tmpGBytes < 1024)
	sprintf(outStr[bufIdx], "%.1f%sGB", tmpGBytes, separator);
      else
	sprintf(outStr[bufIdx], "%.1f%sTB", ((float)(tmpGBytes)/1024), separator);

    }
  }

  return(outStr[bufIdx]);
}

/* ******************************* */

char* formatBytes(TrafficCounter numBytes, short encodeString) {
#define BUFFER_SIZE   24
  static char outStr[BUFFER_SIZE][32];
  static short bufIdx=0;
  char* locSeparator;

  if(encodeString)
    locSeparator = separator;
  else
    locSeparator = " ";

  bufIdx = (bufIdx+1)%BUFFER_SIZE;

  if(numBytes < 1024)
    sprintf(outStr[bufIdx], "%lu", (unsigned long)numBytes);
  else if (numBytes < 1048576)
    sprintf(outStr[bufIdx], "%.1f%sKb",
	    ((float)(numBytes)/1024), locSeparator);
  else {
    float tmpMBytes = ((float)numBytes)/1048576;
    
    if(tmpMBytes < 1024)
      sprintf(outStr[bufIdx], "%.1f%sMB",
	      tmpMBytes, locSeparator);
    else {
      tmpMBytes /= 1024;

      if(tmpMBytes < 1024)
	sprintf(outStr[bufIdx], "%.1f%sGB", tmpMBytes, locSeparator); 
      else
	sprintf(outStr[bufIdx], "%.1f%sTB", 
		((float)(tmpMBytes)/1024), locSeparator); 
    }
  }

  return(outStr[bufIdx]);
}

/* ******************************* */

char* formatSeconds(unsigned long sec) {
  static char outStr[5][32];
  static short bufIdx=0;
  unsigned int hour=0, min=0, days=0;

  bufIdx = (bufIdx+1)%5;

  if(sec >= 3600) {
    hour = (sec / 3600);

    if(hour > 0) {
      if(hour > 24) {
	days = (hour / 24);
	hour = hour % 24;
	sec -= days*86400;
      }
      sec -= hour*3600;
    } else
      hour = 0;
  }

  min = (sec / 60);
  if(min > 0) sec -= min*60;

  if(days > 0)
    sprintf(outStr[bufIdx], "%u day(s) %u:%02u:%02lu", days, hour, min, sec);
  else if(hour > 0)
    sprintf(outStr[bufIdx], "%u:%02u:%02lu", hour, min, sec);
  else if(min > 0)
    sprintf(outStr[bufIdx], "%u:%02lu", min, sec);
  else
    sprintf(outStr[bufIdx], "%lu sec", sec);

  return(outStr[bufIdx]);
}

/* ******************************* */

char* formatThroughput(float numBytes) {
  static char outStr[5][32];
  static short bufIdx=0;
  float numBits;

  bufIdx = (bufIdx+1)%5;
  
  if(numBytes < 0) numBytes = 0; /* Sanity check */
  numBits = numBytes*8;

  if (numBits < 100)
    numBits = 0; /* Avoid very small decimal values */

  if (numBits < 1024) {
    if(webMode)
      sprintf(outStr[bufIdx], "%.1f&nbsp;Bps", numBits);
    else
      sprintf(outStr[bufIdx], "%.1f Bps", numBits);
  } else if (numBits < 1048576) {
    if(webMode)
      sprintf(outStr[bufIdx], "%.1f&nbsp;Kbps", ((float)(numBits)/1024));
    else
      sprintf(outStr[bufIdx], "%.1f Kbps", ((float)(numBits)/1024));
  } else {
    if(webMode)
      sprintf(outStr[bufIdx], "%.1f&nbsp;Mbps", ((float)(numBits)/1048576));
    else
      sprintf(outStr[bufIdx], "%.1f Mbps", ((float)(numBits)/1048576));
  }

#ifdef DEBUG
  printf("%.2f = %s\n", numBytes, outStr[bufIdx]);
#endif

  return(outStr[bufIdx]);
}

/* ******************************* */

char formatStatus(HostTraffic *el) {

  if((el->lastBytesSent == el->bytesSent) 
     && (el->lastBytesReceived == el->bytesReceived))
    return('I'); /* Idle */
  else if ((el->lastBytesSent != el->bytesSent) 
	   && (el->lastBytesReceived != el->bytesReceived)) 
    return('B'); /* Both */
  else if (el->lastBytesSent != el->bytesSent) 
    return('S'); /* Send */
  else
    return('R'); /* Receive */
}

/* ******************************* */

char* makeHostLink(HostTraffic *el, short mode, 
		   short cutName, short addCountryFlag) {
  static char buf[5][384];
  char symIp[256], *tmpStr, linkName[256], flag[128];
  char *blinkOn, *blinkOff;
  short specialMacAddress = 0;
  static short bufIdx=0;
  short usedEthAddress=0;
  
  if(el->broadcastHost)
    return("&lt;broadcast&gt;");

  if(el->promiscuousMode) {
    blinkOn = "<BLINK><FONT COLOR=#FF0000>", blinkOff = "</FONT></BLINK>";
  } else {
    blinkOn = "", blinkOff = "";
  }
 
  bufIdx = (bufIdx+1)%5;

  switch(numericFlag) {
  case 0: /* symbolic */ 
    tmpStr = el->hostSymIpAddress;

    if(tmpStr == NULL) {
      /* The DNS is still getting the entry name */
      if(el->hostNumIpAddress[0] != '\0') 
	strcpy(symIp, el->hostNumIpAddress);
      else {
	strcpy(symIp, el->ethAddressString);
	usedEthAddress = 1;
      }
    } else if(tmpStr[0] != '\0') {
      strcpy(symIp, tmpStr);
      if(tmpStr[strlen(tmpStr)-1] == ']') /* No "... [MAC]" */ {
	usedEthAddress = 1;
	specialMacAddress = 1;
      } else {
	if(cutName && (symIp[0] != '*') 
	   && strcmp(symIp, el->hostNumIpAddress)) {
	  int i;
	  
	  for(i=0; symIp[i] != '\0'; i++)
	    if(symIp[i] == '.') {
	      symIp[i] = '\0';
	      break;
	    }
	}
      }
    } else {
      strcpy(symIp, el->ethAddressString);
      usedEthAddress = 1;
    }
    break;
  case 1:   /* numeric */
    if(el->hostNumIpAddress[0] != '\0') 
      strcpy(symIp, el->hostNumIpAddress);
    else {
      strcpy(symIp, el->ethAddressString);
      usedEthAddress = 1;
    }
    break;
  case 2: /* ethernet address */
    strcpy(symIp, el->ethAddressString);
    usedEthAddress = 1;
    if((symIp[0] == '\0') && webMode) strcpy(symIp, separator);
    break;
  case 3: /* ethernet constructor */
    strcpy(symIp, getVendorInfo(el->ethAddress, (short)webMode));
    usedEthAddress = 1;
    if(symIp[0] == '\0') strcpy(symIp, el->ethAddressString);
    if((symIp[0] == '\0') && webMode) strcpy(symIp, separator);
    break;
  }

  if(specialMacAddress) {
    tmpStr = el->ethAddressString;
#ifdef DEBUG
    printf("->'%s/%s'\n", symIp, el->ethAddressString);
#endif
  } else {
    if(el->hostNumIpAddress[0] != '\0')
      tmpStr = el->hostNumIpAddress;
    else
      tmpStr = symIp;
  }
  
  strcpy(linkName, tmpStr);

  if(usedEthAddress) {    
    /* Patch for ethernet addresses and MS Explorer */
    int i;

    for(i=0; linkName[i] != '\0'; i++)
      if(linkName[i] == ':')
	linkName[i] = '_';
  }

  if(addCountryFlag == 0)
    flag[0] = '\0';
  else {
    sprintf(flag, "<TD ALIGN=CENTER>%s</TD>", 
	    getHostCountryIconURL(el));
  }

  if(mode == LONG_FORMAT)
    sprintf(buf[bufIdx], "<TH ALIGN=LEFT>%s<A HREF=\"/%s.html\">%s</A>%s</TH>%s",
	    blinkOn, linkName, symIp, blinkOff, flag);
  else
    sprintf(buf[bufIdx], "%s<A HREF=\"/%s.html\">%s</A>%s%s",
	    blinkOn, linkName, symIp, blinkOff, flag);
  
  return(buf[bufIdx]);
}

/* ******************************* */

char* getHostName(HostTraffic *el, short cutName) {
  static char buf[5][80];
  char *tmpStr;
  static short bufIdx=0;

  if(el->broadcastHost)
    return("broadcast");

  bufIdx = (bufIdx+1)%5;

  switch(numericFlag) {
  case 0: /* symbolic */ 
    tmpStr = el->hostSymIpAddress;

    if(tmpStr == NULL) {
      /* The DNS is still getting the entry name */
      if(el->hostNumIpAddress[0] == '\0') 
	strcpy(buf[bufIdx], el->hostNumIpAddress);
      else
	strcpy(buf[bufIdx], el->ethAddressString);
    } else if(tmpStr[0] != '\0') {
      strcpy(buf[bufIdx], tmpStr);
      if(cutName) {
	int i;
	
	for(i=0; buf[bufIdx][i] != '\0'; i++)
	  if((buf[bufIdx][i] == '.') 
	     && (!(isdigit(buf[bufIdx][i-1]) 
		    && isdigit(buf[bufIdx][i+1]))
		 )
	     ) {
	    buf[bufIdx][i] = '\0';
	    break;
	  }
      }
    } else
      strcpy(buf[bufIdx], el->ethAddressString);
    break;
  case 1:   /* numeric */
    if(el->hostNumIpAddress[0] != '\0') 
      strcpy(buf[bufIdx], el->hostNumIpAddress);
    else
      strcpy(buf[bufIdx], el->ethAddressString);
    break;
  case 2: /* ethernet address */
    if(el->ethAddressString[0] != '\0') 
      strcpy(buf[bufIdx], el->ethAddressString);
    else
      strcpy(buf[bufIdx], el->hostNumIpAddress);
    break;
  case 3: /* ethernet constructor */
    if(el->ethAddressString[0] != '\0') 
      strcpy(buf[bufIdx], getVendorInfo(el->ethAddress, (short)webMode));
    else
      strcpy(buf[bufIdx], el->hostNumIpAddress);
    break;
  }

  return(buf[bufIdx]);
}

/* ******************************* */


int sortHostFctn(const void *_a, const void *_b) {
  HostTraffic **a = (HostTraffic **)_a;
  HostTraffic **b = (HostTraffic **)_b;

  if((a == NULL) && (b != NULL)) {
    printf("WARNING (1)\n");
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    printf("WARNING (2)\n");
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    printf("WARNING (3)\n");
    return(0);
  }

  switch(columnSort) {
  case 1:
    if((*a)->hostSymIpAddress == NULL) (*a)->hostSymIpAddress = (*a)->hostNumIpAddress;
    if((*b)->hostSymIpAddress == NULL) (*b)->hostSymIpAddress = (*b)->hostNumIpAddress;		
    return(strcasecmp((*a)->hostSymIpAddress, (*b)->hostSymIpAddress));
    break;
  case 2:
    if((*a)->hostIpAddress.s_addr > (*b)->hostIpAddress.s_addr)
      return(1);
    else if((*a)->hostIpAddress.s_addr < (*b)->hostIpAddress.s_addr)
      return(-1);
    else
      return(0);
    /* return(strcasecmp((*a)->hostNumIpAddress, (*b)->hostNumIpAddress)); */
    break;
  case 3:
    return(strcasecmp((*a)->ethAddressString, (*b)->ethAddressString));
    break;
  case 5:
    return(strcasecmp(getVendorInfo((*a)->ethAddress, 0),
		      getVendorInfo((*b)->ethAddress, 0)));
    break;
  case 4:
  default:
    if((*a)->actBandwidthUsage < (*b)->actBandwidthUsage)
      return(1);
    else if ((*a)->actBandwidthUsage > (*b)->actBandwidthUsage)
      return(-1);
    else
      return(0);
    break;
  }  
}

/* ******************************* */

#ifdef HAVE_LSOF

int cmpUsersTraffic(const void *_a, const void *_b) {
  UsersTraffic **a = (UsersTraffic **)_a;
  UsersTraffic **b = (UsersTraffic **)_b;
  TrafficCounter sum_a, sum_b;

  if((a == NULL) && (b != NULL)) {
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    return(0);
  }
  
  sum_a = (*a)->bytesSent + (*a)->bytesReceived;
  sum_b = (*b)->bytesSent + (*b)->bytesReceived;

  if(sum_a > sum_b)
    return(-1);
  else if (sum_a == sum_b)
    return(0);
  else
    return(1);
}

/* ******************************* */

int cmpProcesses(const void *_a, const void *_b) {
  ProcessInfo **a = (ProcessInfo **)_a;
  ProcessInfo **b = (ProcessInfo **)_b;

  if((a == NULL) && (b != NULL)) {
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    return(0);
  }

  switch(columnSort) {
  case 2: /* PID */
    if((*a)->pid == (*b)->pid)
      return(0); 
    else if((*a)->pid < (*b)->pid)
      return(1);
    else return(-1);
    break;
  case 3: /* User */
    return(strcasecmp((*a)->user, (*b)->user));
    break;
  case 4: /* Sent */
    if((*a)->bytesSent == (*b)->bytesSent)
      return(0); 
    else if((*a)->bytesSent < (*b)->bytesSent)
      return(1);
    else return(-1);
    break;
  case 5: /* Rcvd */
    if((*a)->bytesReceived == (*b)->bytesReceived)
      return(0); 
    else if((*a)->bytesReceived < (*b)->bytesReceived)
      return(1);
    else return(-1);
    break;
  default: /* Process name */
    return(strcasecmp((*a)->command, (*b)->command));
  }
}

#endif /* HAVE_LSOF */

/* ******************************* */

int cmpFctn(const void *_a, const void *_b) {
  HostTraffic **a = (HostTraffic **)_a;
  HostTraffic **b = (HostTraffic **)_b;
  TrafficCounter a_, b_;
  int idx;
  short oldColumnSort;

  if((a == NULL) && (b != NULL)) {
    printf("WARNING (1)\n");
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    printf("WARNING (2)\n");
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    printf("WARNING (3)\n");
    return(0);
  }

  if(columnSort == HOST_DUMMY_IDX_VALUE) {
    /* Host name */
    if((*a)->hostSymIpAddress[0] != '\0')
      return(strcasecmp((*a)->hostSymIpAddress, (*b)->hostSymIpAddress));
    else
      return(strcasecmp((*a)->ethAddressString, (*b)->ethAddressString));
  } else if(columnSort == DOMAIN_DUMMY_IDX_VALUE) {
    int rc;

    fillDomainName(*a); fillDomainName(*b);

#ifdef DEBUG
    printf("%s='%s'/'%s' - %s='%s'/'%s'\n", 
	   (*a)->hostSymIpAddress,
	   (*a)->dotDomainName, (*a)->fullDomainName,
	   (*b)->hostSymIpAddress,
	   (*b)->dotDomainName, (*b)->fullDomainName
	   );
#endif
    rc = strcasecmp((*a)->dotDomainName, (*b)->dotDomainName);
    if(rc == 0)
      return(strcasecmp((*a)->fullDomainName, (*b)->fullDomainName));
    else
      return rc;
  }

  oldColumnSort = columnSort;

  if(screenNumber == DUMMY_IDX_VALUE) {
    /* dirty trick */
    idx = columnSort-1;
    if(idx == -1) {
      idx = 0;
      columnSort = 0;
    } else
      columnSort = 1;
  } else
    idx = (screenNumber-MAX_NUM_PROTOS_SCREENS)*3;

#ifdef DEBUG
  printf("idx=%d/columnSort=%d/sortSendMode=%d/screenNumber=%d/numIpProtosToMonitor=%d\n",
	 idx, columnSort, sortSendMode, screenNumber, numIpProtosToMonitor);
#endif

  switch(columnSort) {
  case 0:
    if(sortSendMode) {
      a_ = (*a)->bytesSent, b_ = (*b)->bytesSent;
    } else {
      a_ = (*a)->bytesReceived, b_ = (*b)->bytesReceived;
    }
    break;
  case 1:
    if(sortSendMode) {
      switch(screenNumber) 
	{
	case 0:
	  a_ = (*a)->tcpSentLocally+(*a)->tcpSentRemotely;
	  b_ = (*b)->tcpSentLocally+(*b)->tcpSentRemotely;
	  break;
	case 1:
	  a_ = (*a)->dlcSent, b_ = (*b)->dlcSent;
	  break;
	case 2:
	  a_ = (*a)->arp_rarpSent, b_ = (*b)->arp_rarpSent;
	  break;
	case 3:
	  a_ = (*a)->netbiosSent, b_ = (*b)->netbiosSent;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->actualSentThpt, b_ = (TrafficCounter)(*b)->actualSentThpt;
	    break;
	  }
	default:
	  if(idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].sentLocally 
	      +(*a)->protoIPTrafficInfos[idx].sentRemotely;
	    b_ = (*b)->protoIPTrafficInfos[idx].sentLocally 
	      +(*b)->protoIPTrafficInfos[idx].sentRemotely;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].sentLocally
		+(*a)->protoIPTrafficInfos[i].sentRemotely;
	      b_ += (*b)->protoIPTrafficInfos[i].sentLocally
		+(*b)->protoIPTrafficInfos[i].sentRemotely;
	    }

	    if((*a)->bytesSent > a_)
	      a_ = (*a)->bytesSent-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesSent > b_)
	      b_ = (*b)->bytesSent-b_;
	    else
	      b_ = 0;
	  }
	}
    } else {
      switch(screenNumber) 
	{
	case 0:
	  a_ = (*a)->tcpReceivedLocally+(*a)->tcpReceivedFromRemote;
	  b_ = (*b)->tcpReceivedLocally+(*b)->tcpReceivedFromRemote;
	  break;
	case 1:
	  a_ = (*a)->dlcReceived, b_ = (*b)->dlcReceived;
	  break;
	case 2:
	  a_ = (*a)->arp_rarpReceived, b_ = (*b)->arp_rarpReceived;
	  break;
	case 3:
	  a_ = (*a)->netbiosReceived, b_ = (*b)->netbiosReceived;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->actualRcvdThpt, b_ = (TrafficCounter)(*b)->actualRcvdThpt;
	    break;
	  }
	default:	  
	  if(idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*a)->protoIPTrafficInfos[idx].receivedFromRemote;
	    b_ = (*b)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*b)->protoIPTrafficInfos[idx].receivedFromRemote;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].receivedLocally
		+(*a)->protoIPTrafficInfos[i].receivedFromRemote;
	      b_ += (*b)->protoIPTrafficInfos[i].receivedLocally
		+(*b)->protoIPTrafficInfos[i].receivedFromRemote;
	    }

	    if((*a)->bytesReceived > a_)
	      a_ = (*a)->bytesReceived-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesReceived > b_)
	      b_ = (*b)->bytesReceived-b_;
	    else
	      b_ = 0;

	    /*
	      printf("=>%d (%s)<=>%d (%s)<=\n",
	      (int)a_, (*a)->hostSymIpAddress,
	      (int)b_, (*b)->hostSymIpAddress);
	    */
	  }
	}
    }
    break;
  case 2:
    if(sortSendMode) {	
      switch(screenNumber) 
	{
	case 0:
	  a_ = (*a)->udpSentLocally +(*a)->udpSentRemotely;
	  b_ = (*b)->udpSentLocally +(*b)->udpSentRemotely;
	  break;
	case 1:
	  a_ = (*a)->ipxSent, b_ = (*b)->ipxSent;
	  break;
	case 2:
	  a_ = (*a)->appletalkSent, b_ = (*b)->appletalkSent;
	  break;
	case 3:
	  a_ = (*a)->igmpSent, b_ = (*b)->igmpSent;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->averageSentThpt, b_ = (TrafficCounter)(*b)->averageSentThpt;
	    break;
	  }
	default:
	  if(++idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].sentLocally 
	      +(*a)->protoIPTrafficInfos[idx].sentRemotely;
	    b_ = (*b)->protoIPTrafficInfos[idx].sentLocally 
	      +(*b)->protoIPTrafficInfos[idx].sentRemotely;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].sentLocally
		+(*a)->protoIPTrafficInfos[i].sentRemotely;
	      b_ += (*b)->protoIPTrafficInfos[i].sentLocally
		+(*b)->protoIPTrafficInfos[i].sentRemotely;
	    }

	    if((*a)->bytesSent > a_)
	      a_ = (*a)->bytesSent-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesSent > b_)
	      b_ = (*b)->bytesSent-b_;
	    else
	      b_ = 0;
	  }
	}
    } else {
      switch(screenNumber)
	{
	case 0:
	  a_ = (*a)->udpReceivedLocally +(*a)->udpReceivedFromRemote;
	  b_ = (*b)->udpReceivedLocally +(*b)->udpReceivedFromRemote;
	  break;
	case 1:
	  a_ = (*a)->ipxReceived, b_ = (*b)->ipxReceived;
	  break;
	case 2:
	  a_ = (*a)->appletalkReceived, b_ = (*b)->appletalkReceived;
	  break;
	case 3:
	  a_ = (*a)->igmpReceived, b_ = (*b)->igmpReceived;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->averageRcvdThpt,
	      b_ = (TrafficCounter)(*b)->averageRcvdThpt;
	    break;
	  }
	default:
	  if(++idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*a)->protoIPTrafficInfos[idx].receivedFromRemote;
	    b_ = (*b)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*b)->protoIPTrafficInfos[idx].receivedFromRemote;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].receivedLocally
		+(*a)->protoIPTrafficInfos[i].receivedFromRemote;
	      b_ += (*b)->protoIPTrafficInfos[i].receivedLocally
		+(*b)->protoIPTrafficInfos[i].receivedFromRemote;
	    }

	    if((*a)->bytesReceived > a_)
	      a_ = (*a)->bytesReceived-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesReceived > b_)
	      b_ = (*b)->bytesReceived-b_;
	    else
	      b_ = 0;
	  }
	}
    }
    break;
  case 3:
    if(sortSendMode) {
      switch(screenNumber) 
	{
	case 0:
	  a_ = (*a)->icmpSent, b_ = (*b)->icmpSent;
	  break;
	case 1:
	  a_ = (*a)->decnetSent, b_ = (*b)->decnetSent;
	  break;
	case 2:
	  a_ = (*a)->ospfSent, b_ = (*b)->ospfSent;
	  break;
	case 3:
	  a_ = (*a)->osiSent, b_ = (*b)->osiSent;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->peakSentThpt, b_ = (TrafficCounter)(*b)->peakSentThpt;
	    break;
	  }
	default:
	  idx+=2;
	  if(idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].sentLocally 
	      +(*a)->protoIPTrafficInfos[idx].sentRemotely;
	    b_ = (*b)->protoIPTrafficInfos[idx].sentLocally 
	      +(*b)->protoIPTrafficInfos[idx].sentRemotely;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].sentLocally
		+(*a)->protoIPTrafficInfos[i].sentRemotely;
	      b_ += (*b)->protoIPTrafficInfos[i].sentLocally
		+(*b)->protoIPTrafficInfos[i].sentRemotely;
	    }

	    if((*a)->bytesSent > a_)
	      a_ = (*a)->bytesSent-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesSent > b_)
	      b_ = (*b)->bytesSent-b_;
	    else
	      b_ = 0;
	  }
	}
    } else {
      switch(screenNumber)
	{
	case 0:
	  a_ = (*a)->icmpReceived, b_ = (*b)->icmpReceived;
	  break;
	case 1:
	  a_ = (*a)->decnetReceived, b_ = (*b)->decnetReceived;
	  break;
	case 2:
	  a_ = (*a)->ospfReceived, b_ = (*b)->ospfReceived;
	  break;
	case 3:
	  a_ = (*a)->osiReceived, b_ = (*b)->osiReceived;
	  break;
	case MAX_NUM_PROTOS_SCREENS:
	  if(webMode) {
	    a_ = (TrafficCounter)(*a)->peakRcvdThpt, b_ = (TrafficCounter)(*b)->peakRcvdThpt;
	    break;
	  }
	default:
	  idx+=2;
	  if(idx < numIpProtosToMonitor) {
	    a_ = (*a)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*a)->protoIPTrafficInfos[idx].receivedFromRemote;
	    b_ = (*b)->protoIPTrafficInfos[idx].receivedLocally 
	      +(*b)->protoIPTrafficInfos[idx].receivedFromRemote;
	  } else {
	    int i;

	    a_ = 0, b_ = 0;

	    for(i=0; i<numIpProtosToMonitor; i++) {
	      a_ += (*a)->protoIPTrafficInfos[i].receivedLocally
		+(*a)->protoIPTrafficInfos[i].receivedFromRemote;
	      b_ += (*b)->protoIPTrafficInfos[i].receivedLocally
		+(*b)->protoIPTrafficInfos[i].receivedFromRemote;
	    }

	    if((*a)->bytesReceived > a_)
	      a_ = (*a)->bytesReceived-a_;
	    else
	      a_ = 0;

	    if((*b)->bytesReceived > b_)
	      b_ = (*b)->bytesReceived-b_;
	    else
	      b_ = 0;
	  }
	}
      break;
    }

  case 4:
    if(sortSendMode)
      switch(screenNumber) {
      case 0:
	a_ = (*a)->otherSent, b_ = (*b)->otherSent;
	break;
      }
    else
      switch(screenNumber) {
      case 0:
	a_ = (*a)->otherReceived, b_ = (*b)->otherReceived;
	  break;
      }
  }
  
  columnSort = oldColumnSort;

  if(a_ < b_)
    return(1);
  else if (a_ > b_)
    return(-1);
  else
    return(0);
}

/* ******************************* */

int cmpMulticastFctn(const void *_a, const void *_b) {
  HostTraffic **a = (HostTraffic **)_a;
  HostTraffic **b = (HostTraffic **)_b;

  if((a == NULL) && (b != NULL)) {
    printf("WARNING (1)\n");
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    printf("WARNING (2)\n");
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    printf("WARNING (3)\n");
    return(0);
  }

  switch(columnSort) {
  case 1:
    if((*a)->pktMulticastSent < (*b)->pktMulticastSent)
      return(1);
    else if ((*a)->pktMulticastSent > (*b)->pktMulticastSent)
      return(-1);
    else
      return(0);
    break; /* NOTREACHED */
  case 2:
    if((*a)->bytesMulticastSent < (*b)->bytesMulticastSent)
      return(1);
    else if ((*a)->bytesMulticastSent > (*b)->bytesMulticastSent)
      return(-1);
    else
      return(0);
    break; /* NOTREACHED */
  default:
    return(strcmp((*a)->hostSymIpAddress, /* Host name */
		  (*b)->hostSymIpAddress));
  }
}

/* ******************************* */

char* getNwInterfaceType() {
  switch(datalink) {
  case DLT_NULL:	return("No&nbsp;link-layer&nbsp;encapsulation");
  case DLT_EN10MB:	return("Ethernet");
  case DLT_EN3MB:	return("Experimental&nbsp;Ethernet&nbsp;(3Mb)");
  case DLT_AX25:	return("Amateur&nbsp;Radio&nbsp;AX.25");
  case DLT_PRONET:	return("Proteon&nbsp;ProNET&nbsp;Token&nbsp;Ring");
  case DLT_CHAOS: 	return("Chaos");
  case DLT_IEEE802:	return("IEEE&nbsp;802&nbsp;Networks");
  case DLT_ARCNET:	return("ARCNET");
  case DLT_SLIP:	return("SLIP");
  case DLT_PPP:         return("PPP");
  case DLT_FDDI:	return("FDDI");
  case DLT_ATM_RFC1483:	return("LLC/SNAP&nbsp;encapsulated&nbsp;ATM");
  case DLT_RAW:  	return("Raw&nbsp;IP");
  case DLT_SLIP_BSDOS:	return("BSD/OS&nbsp;SLIP");
  case DLT_PPP_BSDOS:	return("BSD/OS&nbsp;PPP");
  }

  return(""); /* NOTREACHED (I hope) */
}

/* ******************************* */

void getProtocolDataSent(TrafficCounter *c,
			 TrafficCounter *d, 
			 TrafficCounter *e,
			 HostTraffic *el) 
{
  int idx;

  switch(screenNumber) {
  case 0:
    (*c) = el->tcpSentLocally + el->tcpSentRemotely;
    (*d) = el->udpSentLocally + el->udpSentRemotely;
    (*e) = el->icmpSent;
    break;
  case 1:
    (*c) = el->dlcSent;
    (*d) = el->ipxSent;
    (*e) = el->decnetSent;
    break;
  case 2:
    (*c) = el->arp_rarpSent;
    (*d) = el->appletalkSent;
    (*e) = el->ospfSent;
    break;
  case 3:
    (*c) = el->netbiosSent;
    (*d) = el->igmpSent;
    (*e) = el->osiSent;
    break;
  case 4:
    (*c) = el->otherSent;
    (*d) = 0;
    (*e) = 0;
    break;    
  default:
    idx = (screenNumber-MAX_NUM_PROTOS_SCREENS)*3;
    if(idx < numIpProtosToMonitor)
      (*c) = el->protoIPTrafficInfos[idx].sentLocally 
	+ el->protoIPTrafficInfos[idx].sentRemotely;
    else
      (*c) = 0;

    ++idx;
    if(idx < numIpProtosToMonitor)
      (*d) = el->protoIPTrafficInfos[idx].sentLocally 
	+ el->protoIPTrafficInfos[idx].sentRemotely;
    else
      (*d) = 0;

    ++idx;
    if(idx < numIpProtosToMonitor)
      (*e) = el->protoIPTrafficInfos[idx].sentLocally 
	+ el->protoIPTrafficInfos[idx].sentRemotely;
    else
      (*e) = 0;
  }
}
/* ******************************* */

void getProtocolDataReceived(TrafficCounter *c,
			     TrafficCounter *d, 
			     TrafficCounter *e,
			     HostTraffic *el) 
{
  int idx;

  switch(screenNumber) {
  case 0:
    (*c) = el->tcpReceivedLocally + el->tcpReceivedFromRemote;
    (*d) = el->udpReceivedLocally + el->udpReceivedFromRemote;
    (*e) = el->icmpReceived;
    break;
  case 1:
    (*c) = el->dlcReceived;
    (*d) = el->ipxReceived;
    (*e) = el->decnetReceived;
    break;
  case 2:
    (*c) = el->arp_rarpReceived;
    (*d) = el->appletalkReceived;
    (*e) = el->ospfReceived;
    break;
  case 3:
    (*c) = el->netbiosReceived;
    (*d) = el->igmpReceived;
    (*e) = el->osiReceived;
    break;
  case 4:
    (*c) = el->otherReceived;
    (*d) = 0;
    (*e) = 0;
    break;
  default:
    idx = (screenNumber-MAX_NUM_PROTOS_SCREENS)*3;
    if(idx < numIpProtosToMonitor)
      (*c) = el->protoIPTrafficInfos[idx].receivedLocally 
	+ el->protoIPTrafficInfos[idx].receivedFromRemote;
    else
      (*c) = 0;

    ++idx;
    if(idx < numIpProtosToMonitor)
      (*d) = el->protoIPTrafficInfos[idx].receivedLocally 
	+ el->protoIPTrafficInfos[idx].receivedFromRemote;
    else
      (*d) = 0;

    ++idx;
    if(idx < numIpProtosToMonitor)
      (*e) = el->protoIPTrafficInfos[idx].receivedLocally 
	+ el->protoIPTrafficInfos[idx].receivedFromRemote;
    else
      (*e) = 0;
  }
}

/* ******************************* */

RETSIGTYPE printHostsTraffic(int signumber_ignored, 
			     int reportType, 
			     int sortedColumn,
			     int revertOrder)
{
  int idx, numEntries=0, printedEntries=0;
  HostTraffic *el;
  HostTraffic* tmpTable[HASHNAMESIZE];
  char buf[BUF_SIZE], buf2[BUF_SIZE];
#ifdef HAVE_CURSES
  char buf1[80];
#endif
  float sentPercent, rcvdPercent;
  struct pcap_stat stat;

#ifndef WIN32
  if(!webMode) 
    alarm(0); /* Avoid to be interrupted */
#endif

  memset(buf, 0, sizeof(buf));
  memset(tmpTable, 0, HASHNAMESIZE*sizeof(HostTraffic*));

  if(webMode) {
    sortSendMode = signumber_ignored;

    if(signumber_ignored == 2)
      goto PRINT_TOTALS;
  } 

#ifdef HAVE_CURSES
  if((lastNumLines != LINES) || (lastNumCols != COLS)) {
    init_curses();
  } 

  if(signumber_ignored == -1) {
    /* First iteration */
    if(!webMode) {
      mvprintw (4, 1, "Sampling. Please wait...");
      return;
    }
  }
#endif

  if(!webMode)
    checkKeyPressed();
  else
    printHeader(reportType, revertOrder);

  for(idx=1; idx<HASHNAMESIZE; idx++) {
    if(((el = hash_hostTraffic[idx]) != NULL) 
       && (el->broadcastHost == 0)) {
      if(webMode) {
	if((sortSendMode && (el->bytesSent > 0)) 
	   || ((!sortSendMode) && (el->bytesReceived > 0))) {
	  if((reportType == 1) && (el->hostNumIpAddress[0] == '\0')) continue;
	  tmpTable[numEntries++]=el;	
	}
      } else if(localAddrFlag) {
	if((el->subnetPseudoLocalHost == LOCAL_HOST)
	   && (el->hostNumIpAddress[0] != '\0')) {
	  if(!idleFlag) {
	    if((sortSendMode && (el->bytesSent > 0)) 
	       || ((!sortSendMode) && (el->bytesReceived > 0))) {
	      tmpTable[numEntries++]=el;
	    }
	  }
	  else if((el->lastBytesSent != el->bytesSent) 
		  || (el->lastBytesReceived != el->bytesReceived)) {
	    if((reportType == 1) && (el->hostNumIpAddress[0] == '\0')) continue;
	    tmpTable[numEntries++]=el;
	  }
	}
      } else {
	if(!idleFlag) {
	  if((sortSendMode && (el->bytesSent > 0)) 
	     || ((!sortSendMode) && (el->bytesReceived > 0))) {
	    if((reportType == 1) && (el->hostNumIpAddress[0] == '\0')) continue;
	    tmpTable[numEntries++]=el;
	  }
	} else if((el->lastBytesSent != el->bytesSent) 
		  || (el->lastBytesReceived != el->bytesReceived)) {
	  if((reportType == 1) && (el->hostNumIpAddress[0] == '\0')) continue;
	  tmpTable[numEntries++]=el;
	}
      }
    }
  }

  if(numEntries > 0) {
    /* 
       The switch below is needed to:
       - sort data according to the selected column
       - 'recycle' (somebody would call this "code reuse") the cmpFctn function
    */

    if(webMode) 
      columnSort = 0;
	
    if(sortedColumn == HOST_DUMMY_IDX_VALUE)
      columnSort = HOST_DUMMY_IDX_VALUE; /* Host name */
    else if(sortedColumn == DOMAIN_DUMMY_IDX_VALUE)
      columnSort = DOMAIN_DUMMY_IDX_VALUE; /* domain name */
    else if(reportType == 0 /* Interactive mode */) {
      switch(sortedColumn) {
      case 0:
	/* Nothing to do */
	break;
      case 1: /* TCP */
	screenNumber = 0, columnSort = 1;
	break;
      case 2: /* UDP */
	screenNumber = 0, columnSort = 2;
	break;
      case 3: /* ICMP */
	screenNumber = 0, columnSort = 3;
	break; 
      case 4: /* DLC */
	screenNumber = 1, columnSort = 1;
	break;
      case 5: /* IPX */
	screenNumber = 1, columnSort = 2;
	break;
      case 6: /* Decnet */
	screenNumber = 1, columnSort = 3;
	break;
      case 7: /* (R)ARP */
	screenNumber = 2, columnSort = 1;
	break;
      case 8: /* AppleTalk */
	screenNumber = 2, columnSort = 2;
	break;
      case 9: /* OSPF */
	screenNumber = 2, columnSort = 3;
	break;
      case 10: /* NetBios */
	screenNumber = 3, columnSort = 1;
	break;
      case 11: /* IGMP */
	screenNumber = 3, columnSort = 2;
	break;
      case 12: /* OSI */
	screenNumber = 3, columnSort = 3;
	break;
      case 13: /* Other */
	screenNumber = 0, columnSort = 4;
	break;
      }
    } else if(reportType == 1) { 
      /* if(sortedColumn == 0) sortedColumn = 1; */
      screenNumber = DUMMY_IDX_VALUE /* dirty trick */, columnSort = sortedColumn;
    } else if(reportType == 2) /* Thpt */ {
      if(sortedColumn == 0) sortedColumn = 1;
      screenNumber = MAX_NUM_PROTOS_SCREENS /* dirty trick */, columnSort = sortedColumn;
    }

    /*
    sprintf(buf, ">reportType=%d/sortedColumn=%d/columnSort=%d/screenNumber=%d<\n", 
	    reportType, sortedColumn, columnSort, screenNumber);
    mvprintw(0, 0, buf); 
    */

    quicksort(tmpTable, numEntries, sizeof(HostTraffic*), cmpFctn); 

#ifdef HAVE_CURSES
    if(!webMode) {
      if(numEntries > (LINES-4))  
	numEntries = (LINES-4);
    } 
#endif

    for(idx=0; idx<numEntries; idx++) {
      if(revertOrder)
	el = tmpTable[numEntries-idx-1];
      else
	el = tmpTable[idx];

      if(el != NULL) {       
	char *tmpName;

	if((percentMode == 1) || webMode) {
	  sentPercent = (100*(float)el->bytesSent)/ethernetBytes;
	  rcvdPercent = (100*(float)el->bytesReceived)/ethernetBytes;
	}

	if(!webMode)
	  tmpName = getHostName(el, 0);

	if(percentMode == 1) {
	  float a, b;
	  TrafficCounter c, d, e;

	  /* % mode */
	  if(!sortSendMode) {
	    a = rcvdPercent;
	    b = sentPercent;
	    getProtocolDataReceived(&c, &d, &e, el);
	  } else {
	    a = rcvdPercent;
	    b = sentPercent;
	    getProtocolDataSent(&c, &d, &e, el);
	  }

	  if(!webMode)
	    sprintf(buf, "%-26.26s%c %8.1f  %8.1f  %9s %9s %8s",
		    tmpName, 
		    formatStatus(el),
		    a, b,
		    formatBytes(c, (short)webMode),
		    formatBytes(d, (short)webMode),
		    formatBytes(e, (short)webMode));
	} else {
	  int i;
	  TrafficCounter a, b, c, d, e;
	  
	  a = el->bytesReceived, b = el->bytesSent;	  

	  if(!sortSendMode)
	    getProtocolDataReceived(&c, &d, &e, el);
	  else
	    getProtocolDataSent(&c, &d, &e, el);

	  if(!webMode) {
	    if((strcmp(tmpName, "0.0.0.0") == 0) || (tmpName[0] == '\0'))
	      tmpName = el->ethAddressString;

	    if(percentMode == 0)
	      sprintf(buf, "%-26.26s%c %9s %9s %9s %9s %8s",
		      tmpName, formatStatus(el),
		      formatBytes(a, (short)webMode),
		      formatBytes(b, (short)webMode),
		      formatBytes(c, (short)webMode),
		      formatBytes(d, (short)webMode),
		      formatBytes(e, (short)webMode));	
	    else /* Throughput */ {
	      sprintf(buf, "%-26.26s%c %9s %9s %9s %9s %8s",
		      tmpName, formatStatus(el),
		      formatThroughput(el->actualSentThpt),
		      formatThroughput(el->actualRcvdThpt),
		      formatBytes(c, (short)webMode),
		      formatBytes(d, (short)webMode),
		      formatBytes(e, (short)webMode));
	      
	    }
	  } else /* webMode */ {
	    char webHostName[128];

	    strcpy(webHostName, makeHostLink(el, LONG_FORMAT, 0, 1));

	    if(sortSendMode) {	      
	      if(reportType == 0) /* Protos */ {
		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>",
			getRowColor(), webHostName,
			formatBytes(el->bytesSent, (short)webMode), sentPercent, separator,
			formatBytes(el->tcpSentLocally+el->tcpSentRemotely, (short)webMode),
			formatBytes(el->udpSentLocally+el->udpSentRemotely, (short)webMode),
			formatBytes(el->icmpSent,(short) webMode),
			formatBytes(el->dlcSent, (short)webMode),
			formatBytes(el->ipxSent, (short)webMode),
			formatBytes(el->decnetSent, (short)webMode),
			formatBytes(el->arp_rarpSent, (short)webMode),
			formatBytes(el->appletalkSent, (short)webMode),
			formatBytes(el->ospfSent, (short)webMode),
			formatBytes(el->netbiosSent, (short)webMode),
			formatBytes(el->igmpSent, (short)webMode),
			formatBytes(el->osiSent, (short)webMode),
			formatBytes(el->otherSent, (short)webMode)
			);

		sendString(buf);
	      } else if(reportType == 1) /* IP Protos */ {
		TrafficCounter totalIPTraffic=0;

		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD>",
			getRowColor(), webHostName,
			formatBytes(el->bytesSent, (short)webMode), sentPercent, separator);
		sendString(buf);

		for(i=0; i<numIpProtosToMonitor; i++) {
		  totalIPTraffic += el->protoIPTrafficInfos[i].sentLocally+
		    el->protoIPTrafficInfos[i].sentRemotely;
		  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>", 
			  formatBytes(el->protoIPTrafficInfos[i].sentLocally+
				      el->protoIPTrafficInfos[i].sentRemotely, (short)webMode));
		  sendString(buf);
		}

		/* Rounding may cause troubles */
		if(el->bytesSent > totalIPTraffic)
		  totalIPTraffic = el->bytesSent-totalIPTraffic;
		else
		  totalIPTraffic = 0;
		sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>", formatBytes(totalIPTraffic, (short)webMode));		  
		sendString(buf);
	      } else if(reportType == 2) /* Throughtput */ {
		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>",
			getRowColor(), webHostName,
			formatThroughput(el->actualSentThpt),
			formatThroughput(el->averageSentThpt),
			formatThroughput(el->peakSentThpt));

		sendString(buf);
	      }
	    
	      sendString("</TR>\n");
	    } else {
	      if(reportType == 0) /* Protos */ {
		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>",
			getRowColor(), webHostName,
			formatBytes(el->bytesReceived, (short)webMode), rcvdPercent, separator,
			formatBytes(el->tcpReceivedLocally+el->tcpReceivedFromRemote, (short)webMode),
			formatBytes(el->udpReceivedLocally+el->udpReceivedFromRemote, (short)webMode),
			formatBytes(el->icmpReceived, (short)webMode),
			formatBytes(el->dlcReceived, (short)webMode),
			formatBytes(el->ipxReceived, (short)webMode),
			formatBytes(el->decnetReceived, (short)webMode),
			formatBytes(el->arp_rarpReceived, (short)webMode),
			formatBytes(el->appletalkReceived, (short)webMode),
			formatBytes(el->ospfReceived, (short)webMode),
			formatBytes(el->netbiosReceived, (short)webMode),
			formatBytes(el->igmpReceived, (short)webMode),
			formatBytes(el->osiReceived, (short)webMode),
			formatBytes(el->otherReceived, (short)webMode)
			);

		sendString(buf);
	      } else if(reportType == 1) /* IP Protos */ {
		TrafficCounter totalIPTraffic=0;

		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD>",
			getRowColor(), webHostName,
			formatBytes(el->bytesReceived, (short)webMode), rcvdPercent, separator);
		sendString(buf);

		for(i=0; i<numIpProtosToMonitor; i++) {
		  totalIPTraffic += el->protoIPTrafficInfos[i].receivedLocally+
		    el->protoIPTrafficInfos[i].receivedFromRemote;
		  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>", 
			  formatBytes(el->protoIPTrafficInfos[i].receivedLocally+
				      el->protoIPTrafficInfos[i].receivedFromRemote, (short)webMode));
		  sendString(buf);
		}

		/* Rounding may cause troubles */
		if(el->bytesReceived > totalIPTraffic)
		  totalIPTraffic = el->bytesReceived-totalIPTraffic;
		else
		  totalIPTraffic = 0;
		sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>", formatBytes(totalIPTraffic, (short)webMode));		  
		sendString(buf);
	      } else if(reportType == 2) /* Throughtput */ {
		sprintf(buf, "<TR %s>%s"
			"<TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>"
			"<TD ALIGN=RIGHT>%s</TD>",
			getRowColor(), webHostName,
			formatThroughput(el->actualRcvdThpt),
			formatThroughput(el->averageRcvdThpt),
			formatThroughput(el->peakRcvdThpt));

		sendString(buf);
	      }

	      sendString("</TR>\n");
	    }
	  }
	}

#ifdef HAVE_CURSES
	if(!webMode) {
	  buf[COLS-2] = '\0'; /* avoid long lines on small screens */
	  mvprintw (3+idx, 1, buf);

	  if(percentMode == 1) {
	    mvaddch(3+idx, 37, '%');
	    mvaddch(3+idx, 47, '%');
	  }
	}
#endif
      }
      /* Avoid huge tables */
      if(printedEntries++ > maxNumLines)
		break;
    } 
  } else
    idx = 0;
      
  if(signumber_ignored != -1)  { 
    /* ! First iteration */
#ifdef HAVE_CURSES
    if(!webMode) {
      sprintf(buf, "%-80s", "");
      for(idx+=3; idx<LINES; idx++)
	mvprintw(idx, 1, buf);
    }
#endif
  }

  if(!webMode) {  
#ifdef HAVE_CURSES
    sprintf(buf, "%lu Pkts/%s [IP %s/Other %s]",
	    (unsigned long)ethernetPkts,
	    formatBytes(ethernetBytes, webMode),
	    formatBytes(ipBytes, webMode), formatBytes(ethernetBytes-ipBytes, webMode));	  

    sprintf(buf1, "Thpt: %.11s/%-.11s",
	    formatThroughput(actualThpt),
	    formatThroughput(peakThroughput));

    sprintf(buf2, "%-50.50s %27.27s", buf, buf1);
    buf2[78]='\0'; buf2[COLS-2] = '\0'; /* avoid long lines on small screens */
#endif
  } else {
  PRINT_TOTALS:
    if(signumber_ignored == 2) {
      TrafficCounter unicastPkts=0, avgPktLen;

      if(reportType == 0) {
	sendString("<CENTER><P><H1><FONT FACE=Helvetica>Global Traffic Statistics</FONT>"
		   "</H1><P>\n<TABLE BORDER=1>\n");
		
	sprintf(buf2, "<TR><TH>Nw&nbsp;Interface&nbsp;Type</TH><TD ALIGN=RIGHT>%s"
		" [%s]"
		"</TD></TR>\n",
		getNwInterfaceType()
		, deviceName);
	sendString(buf2);

	if(domainName[0] != '\0') {
	  sprintf(buf2, "<TR><TH>Local&nbsp;Domain&nbsp;Name</TH>"
		  "<TD ALIGN=RIGHT>%s&nbsp;</TD></TR>\n",
		  domainName);
	  sendString(buf2);
	}

	sprintf(buf2, "<TR><TH>Sampling&nbsp;Time</TH><TD ALIGN=RIGHT>%s</TD></TR>\n",
		formatSeconds(actTime-initialSniffTime));
	sendString(buf2);


	sendString("<TR><TH>Packets</TH><TH>\n<TABLE BORDER=1 WIDTH=100%%>");
      }

    if(pcapPtr != NULL) 
	if (pcap_stats(pcapPtr, &stat) >= 0) {
	  unicastPkts = ethernetPkts - broadcastPkts - multicastPkts;
	  if(unicastPkts < 0) unicastPkts = 0; /* It shouldn't happen */
	  if(ethernetPkts <= 0) ethernetPkts = 1;

	  if(reportType == 0) {
	    sprintf(buf2, "<tr %s><th align=left>Total</th><td COLSPAN=2 align=right>%s</td></TR>\n", 
		    getRowColor(), formatPkts(ethernetPkts)); 
	    sendString(buf2);
	    sprintf(buf2, "<tr %s><th align=left>Dropped&nbsp;by&nbsp;the&nbsp;kernel</th>"
		    "<td COLSPAN=2 align=right>%s</td></TR>\n", 
		    getRowColor(), formatPkts((TrafficCounter)stat.ps_drop)); 
	    sendString(buf2);
#ifdef MULTITHREADED
	    sprintf(buf2, "<tr %s><th align=left>Dropped&nbsp;by&nbsp;ntop</th>"
		    "<td COLSPAN=2 align=right>%s</td></TR>\n", 
		    getRowColor(), formatPkts(droppedPackets));
	    sendString(buf2);
#endif
	  }
	}

      if(reportType == 0) {
	sprintf(buf2, "<tr %s><th align=left>Unicast</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*unicastPkts)/(float)ethernetPkts,
		formatPkts(unicastPkts));
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Broadcast</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*broadcastPkts)/(float)ethernetPkts,
		formatPkts(broadcastPkts)); 
	sendString(buf2);

	if(multicastPkts > 0) {
	  sprintf(buf2, "<tr %s><th align=left>Multicast</th>"
		  "<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		  getRowColor(), (float)(100*multicastPkts)/(float)ethernetPkts,
		  formatPkts(multicastPkts)); 
	  sendString(buf2);
	}

	/* 
	   Very rudimental formula. Note that as specified in RMON, packets smaller
	   than 64 or larger than 1518 octets are not counted.
	*/
	sprintf(buf2, "<tr %s><th align=left>Shortest</th>"
		"<td align=right colspan=2>%s bytes</td></TR>\n", 
		getRowColor(), formatPkts((TrafficCounter)rcvdPktStats.shortest));
	sendString(buf2);
	avgPktLen = (96*rcvdPktStats.upTo128+192*rcvdPktStats.upTo256
		     +384*rcvdPktStats.upTo512+768*rcvdPktStats.upTo1024
		     +1271*rcvdPktStats.upTo1518)/
	  (rcvdPktStats.upTo128+rcvdPktStats.upTo256
	   +rcvdPktStats.upTo512+rcvdPktStats.upTo1024
	   +rcvdPktStats.upTo1518+1);
	sprintf(buf2, "<tr %s><th align=left>Average&nbsp;Size</th>"
		"<td align=right colspan=2>%s bytes</td></TR>\n", 
		getRowColor(), formatPkts(avgPktLen));
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Longest</th>"
		"<td align=right colspan=2>%s bytes</td></TR>\n", 
		getRowColor(), formatPkts(rcvdPktStats.longest));
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;64&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo64)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo64)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;128&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo128)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo128)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;256&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo256)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo256)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;512&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo512)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo512)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;1024&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo1024)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo1024)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&lt;&nbsp;1518&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.upTo1518)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.upTo1518)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>&gt;&nbsp;1518&nbsp;bytes</th>"
		"<td align=right>%.1f%%</td><td align=right>%s</td></TR>\n", 
		getRowColor(), (float)(100*rcvdPktStats.above1518)/(float)ethernetPkts,
		formatPkts(rcvdPktStats.above1518)); 
	sendString(buf2);

	sendString("</TABLE></TR><TR><TH>Traffic</TH><TH>\n<TABLE BORDER=1 WIDTH=100%%>");
	sprintf(buf2, "<tr %s><th align=left>Total</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatBytes(ethernetBytes, (short)webMode)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>IP Traffic</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatBytes(ipBytes, (short)webMode)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Non IP Traffic</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatBytes(ethernetBytes-ipBytes, (short)webMode)); 
	sendString(buf2);

	sendString("</TABLE></TR><TR><TH>Throughput</TH><TH>\n<TABLE BORDER=1 WIDTH=100%%>");
	sprintf(buf2, "<tr %s><th align=left>Actual</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatThroughput(actualThpt)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Last Minute</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatThroughput(lastMinThpt)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Last 5 Minutes</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatThroughput(lastFiveMinsThpt)); 
	sendString(buf2);
	sprintf(buf2, "<tr %s><th align=left>Peak</th><td align=right>%s</td></TR>\n", 
		getRowColor(), formatThroughput(peakThroughput)); 
	sendString(buf2);

	sendString("</TABLE></TR></TABLE></CENTER>\n");
      }
    } else {
      /* if(reportType == 0) */
      sendString("\n</TABLE><P>\n");
    }
  }

#ifdef HAVE_CURSES
  if(!webMode) {  
    mvprintw (1, 0, buf2);
    refresh ();  
  } 
#endif

  lastRefreshTime = actTime;

#ifndef WIN32
  if(!webMode)
    alarm(2*refreshRate);
#endif
}

/* ******************************* */

RETSIGTYPE _printHostsTraffic(int signumber_ignored) {
  printHostsTraffic(signumber_ignored, 0, 0, 0);
}

/* ******************************* */

void printMulticastStats(int sortedColumn /* ignored so far */,
			 int revertOrder) {
  int idx, numEntries=0, printedEntries=0;
  HostTraffic *el;
  HostTraffic* tmpTable[HASHNAMESIZE];
  char buf[BUF_SIZE], *sign;

  memset(buf, 0, sizeof(buf));
  memset(tmpTable, 0, HASHNAMESIZE*sizeof(HostTraffic*));

  if(revertOrder)
    sign = "";
  else
    sign = "-";

  for(idx=1; idx<HASHNAMESIZE; idx++) {
    if(((el = hash_hostTraffic[idx]) != NULL) 
       && (el->pktMulticastSent != 0)
       && (!el->broadcastHost))
      tmpTable[numEntries++]=el;	
  }

  printHTTPheader();
  
  if(numEntries > 0) {
    columnSort = sortedColumn; /* Host name */

    sendString("<CENTER><P><H1><FONT FACE=Helvetica>Multicast Stats: Packets Sent</FONT></H1><P>\n");

    sprintf(buf, "<TABLE BORDER=1><TR><TH><A HREF=%s?%s0>Host</A></TH>\n"
	    "<TH><A HREF=%s?%s1>Domain</A>"
	    "<TH><A HREF=%s?%s1>Packets</A></TH><TH><A HREF=%s?%s2>Data</A></TH></TR>\n", 
	    STR_MULTICAST_STATS, sign,
	    STR_MULTICAST_STATS, sign,
	    STR_MULTICAST_STATS, sign, 
	    STR_MULTICAST_STATS, sign);
    sendString(buf);

    quicksort(tmpTable, numEntries, sizeof(HostTraffic*), cmpMulticastFctn); 

    for(idx=0; idx<numEntries; idx++) {
     if(revertOrder)
	el = tmpTable[numEntries-idx-1];
      else
	el = tmpTable[idx];
 
      if(el != NULL) {       
	sprintf(buf, "<TR %s>%s<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD></TR>\n",
		getRowColor(), makeHostLink(el, LONG_FORMAT, 0, 1),
		formatPkts(el->pktMulticastSent), 
		formatBytes(el->bytesMulticastSent, (short)webMode));

	sendString(buf);

      /* Avoid huge tables */
      if(printedEntries++ > maxNumLines)
	break;
      }
    }

    sendString("</TABLE>\n");
  } else
    sendString("<P><CENTER><FONT FACE=Helvetica><CENTER><H1>"
	       "<i>No Data To Display</i></H1></CENTER></FONT></CENTER>\n");

}

/* ******************************* */

int cmpHostsFctn(const void *_a, const void *_b) {
  struct hostTraffic **a = (struct hostTraffic **)_a;
  struct hostTraffic **b = (struct hostTraffic **)_b;
  char *name_a, *name_b;
  TrafficCounter a_, b_;
  
  switch(columnSort) {
  case 2: /* IP Address */
    if((*a)->hostIpAddress.s_addr > (*b)->hostIpAddress.s_addr)
      return(1);
    else if((*a)->hostIpAddress.s_addr < (*b)->hostIpAddress.s_addr)
      return(-1);
    else
      return(0);
    break;

  case 3: /* Data Sent */
    switch(sortFilter) {
    case REMOTE_TO_LOCAL_ACCOUNTING:
      a_ = (*a)->bytesSentLocally;
      b_ = (*b)->bytesSentLocally;
      break;
    case LOCAL_TO_REMOTE_ACCOUNTING:
      a_ = (*a)->bytesSentRemotely;
      b_ = (*b)->bytesSentRemotely;
      break;
    case LOCAL_TO_LOCAL_ACCOUNTING:
      a_ = (*a)->bytesSentLocally;
      b_ = (*b)->bytesSentLocally;
      break;
    }
    if(a_ < b_) return(1); else if (a_ > b_) return(-1); else return(0);
    break;

  case 4: /* Data Rcvd */
    switch(sortFilter) {
    case REMOTE_TO_LOCAL_ACCOUNTING:
      a_ = (*a)->bytesReceivedFromRemote;
      b_ = (*b)->bytesReceivedFromRemote;
      break;
    case LOCAL_TO_REMOTE_ACCOUNTING:
      a_ = (*a)->bytesReceivedFromRemote;
      b_ = (*b)->bytesReceivedFromRemote;
      break;
    case LOCAL_TO_LOCAL_ACCOUNTING:
      a_ = (*a)->bytesReceivedLocally;
      b_ = (*b)->bytesReceivedLocally;
      break;
    }
    if(a_ < b_) return(1); else if (a_ > b_) return(-1); else return(0);
    break;

  default: /* Host Name */
    name_a = (*a)->hostSymIpAddress;
    
    if(name_a == NULL)
      printf("Warning\n");
    if((name_a == NULL) || (strcmp(name_a, "0.0.0.0") == 0)) {
      name_a = (*a)->hostNumIpAddress;
      if((name_a == NULL) || (name_a[0] == '\0'))
	name_a = (*a)->ethAddressString;
    }
    
    name_b = (*b)->hostSymIpAddress;
    
    if(name_b == NULL)
      printf("Warning\n");
    if((name_b == NULL) || (strcmp(name_b, "0.0.0.0") == 0)) {
      name_b = (*b)->hostNumIpAddress;
      if((name_b == NULL) || (name_b[0] == '\0'))
	name_b = (*b)->ethAddressString;
    }
        
    return(strcasecmp(name_a, name_b)); /* case insensitive */
  }
}


/* ******************************* */

RETSIGTYPE printHostsInfo(int sortedColumn, int revertOrder) {
  u_int idx, numEntries, printedEntries=0;
  unsigned short maxBandwidthUsage=1 /* avoid divisions by zero */;
  struct hostTraffic *el;
  struct hostTraffic* tmpTable[HASHNAMESIZE];
  char buf[BUF_SIZE], *sign;

  memset(buf, 0, sizeof(buf));
  memset(tmpTable, 0, HASHNAMESIZE*sizeof(HostTraffic*));

  if(revertOrder)
    sign = "";
  else
    sign = "-";

  columnSort = sortedColumn;

  sortSendMode = 2; /* This is used by print header */

  printHeader(0, revertOrder);

  for(idx=1, numEntries=0; idx<HASHNAMESIZE; idx++)
    if((el = hash_hostTraffic[idx]) != NULL) {
      unsigned short actUsage;

      actUsage = (unsigned short)(100*((float)el->bytesSent/(float)ethernetBytes));

      el->actBandwidthUsage = actUsage;
      if(el->actBandwidthUsage > maxBandwidthUsage)
	maxBandwidthUsage = actUsage;

      tmpTable[numEntries++]=el;
    }

  if(numEntries > 0) {
    quicksort(tmpTable, numEntries, sizeof(struct hostTraffic*), sortHostFctn);

    sprintf(buf, "<TABLE BORDER=1>\n<TR><TH><A HREF=%s?%s1>Host&nbsp;Name</A>"
	    "<TH><A HREF=%s?"DOMAIN_DUMMY_IDX_STR">Domain</A></TH>"
	    "</TH><TH><A HREF=%s?%s2>IP&nbsp;Address</A></TH>\n"
	    "<TH><A HREF=%s?%s3>MAC&nbsp;Address</A></TH>"
	    "<TH><A HREF=%s?%s4>Sent&nbsp;Bandwidth</A></TH>"
	    "<TH><A HREF=%s?%s5>Nw&nbsp;Board&nbsp;Vendor</A></TH>"
	    "</TR>\n",
	    HOSTS_INFO_HTML, sign, 
	    HOSTS_INFO_HTML, 
	    HOSTS_INFO_HTML, sign, 
	    HOSTS_INFO_HTML, sign, 
	    HOSTS_INFO_HTML, sign, 
	    HOSTS_INFO_HTML, sign);
    sendString(buf);

    for(idx=0; idx<numEntries; idx++) {
      if(revertOrder)
	el = tmpTable[numEntries-idx-1];
      else
	el = tmpTable[idx];
      
      if(el != NULL) {       
	char *tmpName1, *tmpName2, *tmpName3;

	if(el->broadcastHost == 0) {
	  tmpName1 = el->hostNumIpAddress;
	  if((tmpName1[0] == '\0') || (strcmp(tmpName1, "0.0.0.0") == 0))
	    tmpName1 = separator;

	  tmpName2 = getVendorInfo(el->ethAddress, (short)webMode);
	  if(tmpName2[0] == '\0') 	     
	    tmpName2 = separator;

	  tmpName3 = el->ethAddressString;
	  if((tmpName3[0] == '\0') 	     
	     || (strcmp(tmpName3, "00:00:00:00:00:00") == 0))
	    tmpName3 = separator;

	  sprintf(buf, "<TR %s>"
		  "%s<TD ALIGN=RIGHT>%s</TD>"
		  "<TD ALIGN=RIGHT>%s</TD>",
		  getRowColor(), 
		  makeHostLink(el, LONG_FORMAT, 0, 1), 
		  tmpName1, tmpName3);		  
	  sendString(buf);

	  printBar(buf, el->actBandwidthUsage, maxBandwidthUsage, 3);

	  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>",
		  tmpName2);
	  sendString(buf);

	  sendString("</TR>\n");
	}
      }

      /* Avoid huge tables */
      if(printedEntries++ > maxNumLines)
	break;
    }

    sendString("</TABLE><P>\n");
  }

}

/* ************************************ */

char* formatTime(time_t *theTime, short encodeString) {
#define TIME_LEN    48
  static char outStr[2][TIME_LEN];
  static short timeBufIdx=0;
  struct tm* locTime = localtime(theTime);

  timeBufIdx = (timeBufIdx+1)%2;
  if(encodeString)
    strftime(outStr[timeBufIdx], TIME_LEN, "%x&nbsp;%X", locTime);
  else
    strftime(outStr[timeBufIdx], TIME_LEN, "%x %X", locTime);
  return(outStr[timeBufIdx]);
#undef TIME_LEN
}


/* ************************************ */

void printAllSessionsHTML(char* host) { 
  u_int idx, elIdx, i, numEntries;
  HostTraffic *el;
  char buf[BUF_SIZE];
  u_short numSessions;
  struct ipGlobalSession *scanner;
  u_int scanIdx;
  float percentage;
  char *sessionType, *vendorName;
  static char _sport[8], _dport[8];
  TrafficCounter actTotalSent, actTotalReceived;
  TrafficCounter totalSent, totalReceived;

  for(elIdx=1; elIdx<HASHNAMESIZE; elIdx++) {
    el = hash_hostTraffic[elIdx];

    if((elIdx != broadcastEntryIdx)
       && (el != NULL) 
       && (el->hostNumIpAddress != NULL)
       && ((strcmp(el->hostNumIpAddress, host) == 0)
	   || (strcmp(el->ethAddressString, host) == 0)))
      break;
  }

  if(el == NULL) {
    sprintf(buf, "<P><H1><FONT FACE=Helvetica>Unable to find "
	    "information related to host<i>%s</i></FONT></H1>\n", host);
    sendString(buf);
    return;
  }
  
  /* ************************************ */

  if(el->hostSymIpAddress[0] == '\0')
    sprintf(buf, "<center><P><H1><FONT FACE=Helvetica>Info about"
	    " %s</FONT></H1><P>\n", 
	    el->ethAddressString);
  else
    sprintf(buf, "<center><P><H1><FONT FACE=Helvetica>Info about"
	    " <A HREF=http://%s/>%s</A></FONT></H1><P>\n", 
	    el->hostNumIpAddress, el->hostSymIpAddress); 
  sendString(buf);

  sendString("<P><TABLE BORDER=1 WIDTH=\"100%%\">\n");

  if(el->hostNumIpAddress[0] != '\0') {
    char* countryIcon;

    if(!isdigit(el->hostSymIpAddress[strlen(el->hostSymIpAddress)-1])) {
      countryIcon = getHostCountryIconURL(el);
    } else
      countryIcon = "";

    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s&nbsp;%s", 
	    getRowColor(), 
	    "IP&nbsp;Address", 
	    el->hostNumIpAddress, countryIcon);
    sendString(buf);

    if(el->promiscuousMode)
      sendString("&nbsp;<BLINK><B><FONT COLOR=#FF0000>[Promiscuous Mode Host]</FONT></B></BLINK>");
    sendString("</TD></TR>\n");
  }

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD></TR>\n", 
	  getRowColor(), 
	  "Last&nbsp;Seen", formatTime(&(el->lastSeen), (short)webMode));
  sendString(buf);

  if(el->fullDomainName && (el->fullDomainName[0] != '\0')) {
	  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s&nbsp;</TD></TR>\n", 
		  getRowColor(), 
		  "Domain", el->fullDomainName);
	  sendString(buf);
  }

  if((el->ethAddressString[0] != '\0') 
     && strcmp(el->ethAddressString, "00:00:00:00:00:00")) {
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s%s</TD></TR>\n", 
	    getRowColor(), "MAC&nbsp;Address", 
	    el->ethAddressString, separator /* it avoids empty cells not to be rendered */);
    sendString(buf);

    vendorName = getVendorInfo(el->ethAddress, (short)webMode);
    if(vendorName[0] != '\0') {      
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s%s</TD></TR>\n", 
	      getRowColor(), "Nw&nbsp;Board&nbsp;Vendor", 
	      vendorName,
	      separator /* it avoids empty cells not to be rendered */);
      sendString(buf);
    }
  }

  if(el->hostNumIpAddress[0] != '\0') {
    updateOSName(el);
    
    if((el->osName != NULL) && (el->osName[0] != '\0')) {
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s%s</TD></TR>\n", 
	      getRowColor(), "OS&nbsp;Name", 
	      getOSFlag(el->osName), separator /* it avoids empty cells not to be rendered */);
      sendString(buf);    
    }
  }

  if(el->subnetPseudoLocalHost == LOCAL_HOST)
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD></TR>\n", getRowColor(), 
	    "Host&nbsp;Location", 
	    "Local (inside specified/local subnet)");
  else
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD></TR>\n", getRowColor(), 
	    "Host&nbsp;Location", 
	    "Remote (outside specified/local subnet)");
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s/%s Pkts</TD></TR>\n", 
	  getRowColor(), "Total&nbsp;Data&nbsp;Sent",
	  formatBytes(el->bytesSent, (short)webMode), formatPkts(el->pktSent));
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s Pkts</TD></TR>\n", 
	  getRowColor(), "Broadcast&nbsp;Pkts&nbsp;Sent",
	  formatPkts(el->pktBroadcastSent));
  sendString(buf);

  if(el->pktMulticastSent>0) {
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s/%s Pkts</TD></TR>\n", 
	    getRowColor(), "Multicast&nbsp;Pkts&nbsp;Sent", 
	    formatBytes(el->bytesMulticastSent, (short)webMode),
	    formatPkts(el->pktMulticastSent));
    sendString(buf);
  }

  if(el->bytesSent == 0)
    percentage = 0;
  else
    percentage = ((float)el->bytesSentLocally*100)/el->bytesSent;

  if(el->hostNumIpAddress[0] != '\0')
    printTableEntryPercentage(buf, "Data&nbsp;Sent&nbsp;Stats", 
			      "Local", "Remote", -1, percentage);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s/%s Pkts</TD></TR>\n", 
	  getRowColor(), "Total&nbsp;Data&nbsp;Rcvd",
	  formatBytes(el->bytesReceived, (short)webMode), formatPkts(el->pktReceived));
  sendString(buf);

  if(el->bytesReceived == 0)
    percentage = 0;
  else
    percentage = ((float)el->bytesReceivedLocally*100)/el->bytesReceived;

  if(el->hostNumIpAddress[0] != '\0')
    printTableEntryPercentage(buf, "Data&nbsp;Received&nbsp;Stats", 
			      "Local", "Remote", -1, percentage);
  
  sendString("</TABLE><P>\n");

  /* ***************************************************** */

  totalSent = el->tcpSentLocally+el->tcpSentRemotely+el->udpSentLocally+el->udpSentRemotely+
    el->icmpSent+el->ospfSent+el->igmpSent+el->ipxSent+el->dlcSent+el->arp_rarpSent+
    el->decnetSent+el->appletalkSent+el->netbiosSent+el->osiSent+el->otherSent;
  totalReceived = el->tcpReceivedLocally+el->tcpReceivedFromRemote+
    el->udpReceivedLocally+el->udpReceivedFromRemote+
    el->icmpReceived+el->ospfReceived+el->igmpReceived+
    el->ipxReceived+el->dlcReceived+el->arp_rarpReceived+
    el->decnetReceived+el->appletalkReceived+
    el->osiReceived+el->netbiosReceived+el->otherReceived;
  
  actTotalSent = el->tcpSentLocally+el->tcpSentRemotely;
  actTotalReceived = el->tcpReceivedLocally+el->tcpReceivedFromRemote;


  if((el->tcpSentLocally+el->tcpSentRemotely+
      el->tcpReceivedLocally+el->tcpReceivedFromRemote+
      el->udpSentLocally+el->udpSentRemotely+
      el->udpReceivedLocally+el->udpReceivedFromRemote) > 0) {   

    sendString("<P><H1><FONT FACE=Helvetica>IP Protocol Distribution</H1><P>\n");

    sendString("<TABLE BORDER=1 WIDTH=400><TR><TH WIDTH=20%%>Protocol</TH>"
	       "<TH WIDTH=40%% COLSPAN=2>Data&nbsp;Sent</TH>"
	       "<TH WIDTH=40%% COLSPAN=2>Data&nbsp;Received</TH></TR>\n");  

    printTableDoubleEntry(buf, "TCP", COLOR_1, (float)actTotalSent/1024, 
			  100*((float)SD(actTotalSent,totalSent)), (float)actTotalReceived/1024, 
			  100*((float)SD(actTotalReceived,totalReceived)));
  
    actTotalSent = el->udpSentLocally+el->udpSentRemotely;
    actTotalReceived = el->udpReceivedLocally+el->udpReceivedFromRemote;

    printTableDoubleEntry(buf, "UDP", COLOR_1, (float)actTotalSent/1024, 
			  100*((float)SD(actTotalSent,totalSent)), 
			  (float)actTotalReceived/1024, 
			  100*((float)SD(actTotalReceived,totalReceived)));
  
    printTableDoubleEntry(buf, "ICMP", COLOR_1, (float)el->icmpSent/1024, 
			  100*((float)SD(el->icmpSent,totalSent)), 
			  (float)el->icmpReceived/1024, 
			  100*((float)SD(el->icmpReceived,totalReceived)));

    printTableDoubleEntry(buf, "(R)ARP", COLOR_1, (float)el->arp_rarpSent/1024, 
			  100*((float)SD(el->arp_rarpSent,totalSent)),
			  (float)el->arp_rarpReceived/1024, 
			  100*((float)SD(el->arp_rarpReceived,totalReceived)));
  
    printTableDoubleEntry(buf, "DLC", COLOR_1, (float)el->dlcSent/1024,
			  100*((float)SD(el->dlcSent,totalSent)),
			  (float)el->dlcReceived/1024,
			  100*((float)SD(el->dlcReceived,totalReceived)));

    printTableDoubleEntry(buf, "IPX", COLOR_1, (float)el->ipxSent/1024, 
			  100*((float)SD(el->ipxSent,totalSent)), 
			  (float)el->ipxReceived/1024, 
			  100*((float)SD(el->ipxReceived,totalReceived)));

    printTableDoubleEntry(buf, "Decnet", COLOR_1, (float)el->decnetSent/1024,
			  100*((float)SD(el->decnetSent,totalSent)), 
			  (float)el->decnetReceived/1024,
			  100*((float)SD(el->decnetReceived,totalReceived)));

    printTableDoubleEntry(buf, "AppleTalk", COLOR_1, (float)el->appletalkSent/1024, 
			  100*((float)SD(el->appletalkSent,totalSent)),
			  (float)el->appletalkReceived/1024, 
			  100*((float)SD(el->appletalkReceived,totalReceived)));

    printTableDoubleEntry(buf, "OSPF", COLOR_1, (float)el->ospfSent/1024, 
			  100*((float)SD(el->ospfSent,totalSent)), 
			  (float)el->ospfReceived/1024, 
			  100*((float)SD(el->ospfReceived,totalReceived)));

    printTableDoubleEntry(buf, "NetBios", COLOR_1, (float)el->netbiosSent/1024, 
			  100*((float)SD(el->netbiosSent,totalSent)), 
			  (float)el->netbiosReceived/1024, 
			  100*((float)SD(el->netbiosReceived,totalReceived)));

    printTableDoubleEntry(buf, "IGMP", COLOR_1, (float)el->igmpSent/1024, 
			  100*((float)SD(el->igmpSent,totalSent)), 
			  (float)el->igmpReceived/1024, 
			  100*((float)SD(el->igmpReceived,totalReceived)));

    printTableDoubleEntry(buf, "OSI", COLOR_1, (float)el->osiSent/1024, 
			  100*((float)SD(el->osiSent,totalSent)),
			  (float)el->osiReceived/1024, 
			  100*((float)SD(el->osiReceived,totalReceived)));

    printTableDoubleEntry(buf, "Other", COLOR_1, (float)el->otherSent/1024,
			  100*((float)SD(el->otherSent,totalSent)), 
			  (float)el->otherReceived/1024,
			  100*((float)SD(el->otherReceived,totalReceived)));

    sendString("</TABLE><P>\n");
  }

  /* ***************************************************** */

  if((el->pktSent != 0) || (el->pktReceived != 0)) {
    int ok =0;

    for(numEntries = 0, i=0; i<MAX_NUM_CONTACTED_PEERS; i++)
      if((el->contactedSentPeersIndexes[i] != NO_PEER) 
	 || (el->contactedRcvdPeersIndexes[i] != NO_PEER)) {
	ok = 1;
	break;
      }

    if(ok) {
      sendString("<P><H1><FONT FACE=Helvetica>Last Contacted Peers</H1>\n"
		 "<TABLE BORDER=0><TR><TD>\n");

      for(numEntries = 0, i=0; i<MAX_NUM_CONTACTED_PEERS; i++)
	if(el->contactedSentPeersIndexes[i] != NO_PEER) {
      
	  if(numEntries == 0) {
	    sendString("<TABLE BORDER=1>"
		       "<TR><TH>Receiver Name</TH><TH>Receiver Address</TH></TR>\n");
	  }

	  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=CENTER>%s&nbsp;</TD></TR>\n",
		  getRowColor(), 
		  makeHostLink(hash_hostTraffic[checkSessionIdx(el->contactedSentPeersIndexes[i])], 0, 0, 0),
		  hash_hostTraffic[checkSessionIdx(el->contactedSentPeersIndexes[i])]->hostNumIpAddress);

	  sendString(buf);
	  numEntries++;
	}

      if(numEntries > 0)
	sendString("</TABLE></TD><TD>\n");
      else
	sendString("&nbsp;</TD><TD>\n");

      /* ***************************************************** */
      for(numEntries = 0, i=0; i<MAX_NUM_CONTACTED_PEERS; i++)
	if(el->contactedRcvdPeersIndexes[i] != NO_PEER) {
      
	  if(numEntries == 0) {
	    sendString("<TABLE BORDER=1>"
		       "<TR><TH>Sender Name</TH><TH>Sender Address</TH></TR>\n");
	  }

	  sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=CENTER>%s&nbsp;</TD></TR>\n",
		  getRowColor(),
		  makeHostLink(hash_hostTraffic[checkSessionIdx(el->contactedRcvdPeersIndexes[i])], 0, 0, 0),
		  hash_hostTraffic[checkSessionIdx(el->contactedRcvdPeersIndexes[i])]->hostNumIpAddress);

	  sendString(buf);
	  numEntries++;
	}

      if(numEntries > 0)
	sendString("</TABLE>\n");

      sendString("</TD></TR></TABLE><P>\n");
    } /* ok */
  }


  /* ***************************************************** */
  
  i = 0;

  for(idx=1; idx<1024; idx++) {
    if((el->usedClientPorts[idx] != 0) 
       || (el->usedServerPorts[idx] != 0)) {
      char *svc = getAllPortByNum(idx);

      if(i == 0) {
	sendString("<P><H1><FONT FACE=Helvetica>IP&nbsp;Service/Port&nbsp;Usage</FONT></H1><P>\n");
	sendString("<TABLE BORDER=1>\n<TR>"
		   "<TH>IP&nbsp;Service</TH><TH>Port</TH><TH>#&nbsp;Client&nbsp;Sessions</TH>"
		   "<TH>#&nbsp;Server&nbsp;Sessions</TH></TR>\n");
	i++;
      }

      if(svc != NULL)
	sprintf(buf, "<TR><TH>%s</TH><TD ALIGN=CENTER>%d</TD>", svc, idx);
      else
	sprintf(buf, "<TR><TH>%d</TH><TD ALIGN=CENTER>%d</TD>", idx, idx);

      sendString(buf);

      if(el->usedClientPorts[idx] > 0) {
	sprintf(buf, "<TD ALIGN=CENTER>%d</TD>", el->usedClientPorts[idx]);
	sendString(buf);
      } else
	sendString("<TD>&nbsp;</TD>");

      if(el->usedServerPorts[idx] > 0) {
	sprintf(buf, "<TD ALIGN=CENTER>%d</TD></TR>", el->usedServerPorts[idx]);
	sendString(buf);
      } else
	sendString("<TD>&nbsp;</TD></TR>");
    }
  }

  if(i > 0)
    sendString("</TABLE></P>\n");

  /* ***************************************************** */

  if((el->tcpSessionList != NULL) || (el->udpSessionList != NULL)) {
    sendString("<P><H1><FONT FACE=Helvetica>IP Session History</FONT></H1><P>\n");
  }

  for(scanIdx=0; scanIdx<2; scanIdx++)
    {
      switch(scanIdx) {
      case 0:
	scanner = el->tcpSessionList; 
	sessionType = "TCP";
	break;
      case 1:
	scanner = el->udpSessionList; 
	sessionType = "UDP";
	break;
      }

      numSessions = 0;

      while(scanner != NULL) {
	char *whoswho, *svc;
	  
	if(scanner->initiator == CLIENT_ROLE)
	  whoswho= "client";
	else
	  whoswho= "server";
	  	      
	switch(scanIdx) {
	case 0:
	  svc = getPortByNum((int)(scanner->port), IPPROTO_TCP);
	  break;
	case 1:
	  svc = getPortByNum((int)(scanner->port), IPPROTO_UDP);
	  break;
	}

	if(numSessions == 0) {
	  sprintf(buf, "<TABLE BORDER WIDTH=\"100%%\">\n<TR><TH>%s&nbsp;Service</TH>"
		  "<TH>Role</TH><TH>#&nbsp;Sessions</TH>"
		  "<TH>Bytes&nbsp;Sent</TH><TH>Bytes&nbsp;Rcvd</TH>"
		  "<TH>Last&nbsp;Seen</TH><TH>First&nbsp;Seen</TH><TH>Peers</TH></TR>\n",
		  sessionType);
	  sendString(buf);
	}

	sprintf(buf,"<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=CENTER>%s</TD><TD ALIGN=CENTER>%d"
		"</TD><TD ALIGN=CENTER>%s</TD>"
		"<TD ALIGN=CENTER>%s</TD><TD>%s</TD><TD>%s</TD>\n",
		getRowColor(), svc, whoswho,
		(int)scanner->sessionCounter,
		formatBytes(scanner->bytesSent, (short)webMode),
		formatBytes(scanner->bytesReceived, (short)webMode),
		formatTime(&(scanner->lastSeen), (short)webMode),
		formatTime(&(scanner->firstSeen), (short)webMode)
		);
	sendString(buf);
	numSessions++;

	sendString("<TD><UL>");
	for(i=0; i < MAX_NUM_SESSION_PEERS; i++) {
	  if((scanner->peersIdx[i] != NO_PEER) 
	     && (hash_hostTraffic[checkSessionIdx(scanner->peersIdx[i])] != NULL)) {
	    HostTraffic *host = hash_hostTraffic[checkSessionIdx(scanner->peersIdx[i])];

	    if(host->hostNumIpAddress[0] == '&')
	      sprintf(buf, "<LI>%s\n", host->hostSymIpAddress);
	    else
	      sprintf(buf, "<LI><A HREF=%s.html>%s</A>\n", 
		      host->hostNumIpAddress,
		      host->hostSymIpAddress);
	    sendString(buf);
	  }
	}
	sendString("</UL></TR>\n");

	scanner = (IpGlobalSession*)(scanner->next);
      }

      if(numSessions > 0) 
	sendString("</TABLE><P>\n");
    }  /* while */

  /* ***************************************************** */

  /* Now print currently established TCP sessions (if any) */
  for(idx=1, numSessions=0; idx<HASHNAMESIZE; idx++)
    if((tcpSession[idx] != NULL)
       && ((tcpSession[idx]->initiatorIdx == elIdx) || (tcpSession[idx]->remotePeerIdx == elIdx))
#ifndef PRINT_ALL_ACTIVE_SESSIONS
       && (tcpSession[idx]->sessionState == STATE_ACTIVE)
#endif
       ) {
      char *sport, *dport, *remotePeer;
      TrafficCounter dataSent, dataReceived;

      if(numSessions == 0) {
	sendString("<P><H1><FONT FACE=Helvetica>Active TCP Sessions</FONT></H1><P>\n");
	sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR>"
		   "<TH>Local&nbsp;Port</TH>"
		   "<TH>Remote&nbsp;Peer:Port</TH>"
		   "<TH>Data&nbsp;Sent</TH>"
		   "<TH>Data&nbsp;Rcvd</TH>"
		   "<TH>Active&nbsp;Since</TH>"
		   "<TH>Last&nbsp;Seen</TH>"
		   "<TH>Duration</TH>"
#ifdef PRINT_ALL_ACTIVE_SESSIONS
		   "<TH>State</TH>"
#endif
		   "</TR>\n");
      }
      
      if(tcpSession[idx]->initiatorIdx == elIdx) {
	sport = getPortByNum(tcpSession[idx]->sport, IPPROTO_TCP);
	dport = getPortByNum(tcpSession[idx]->dport, IPPROTO_TCP);
	if(sport == NULL) {
	  sprintf(_sport, "%d", tcpSession[idx]->sport); sport = _sport;
	}
	
	if(dport == NULL) {
	  sprintf(_dport, "%d", tcpSession[idx]->dport); dport = _dport;
	}
	remotePeer = makeHostLink(hash_hostTraffic[checkSessionIdx(tcpSession[idx]->remotePeerIdx)],
				  SHORT_FORMAT, 0, 0);
	dataSent = tcpSession[idx]->bytesSent;
	dataReceived = tcpSession[idx]->bytesReceived;
      } else { 
	/* Responder */
	sport = getPortByNum(tcpSession[idx]->dport, IPPROTO_TCP);
	dport = getPortByNum(tcpSession[idx]->sport, IPPROTO_TCP);
	if(sport == NULL) {
	  sprintf(_sport, "%d", tcpSession[idx]->dport); sport = _sport;
	}

	if(dport == NULL) {
	  sprintf(_dport, "%d", tcpSession[idx]->sport); dport = _dport;
	}
	
	remotePeer = makeHostLink(hash_hostTraffic[checkSessionIdx(tcpSession[idx]->initiatorIdx)], 
				  SHORT_FORMAT, 0, 0);
	dataSent = tcpSession[idx]->bytesReceived;
	dataReceived = tcpSession[idx]->bytesSent;
      }

      /* Sanity check */
      if((actTime < tcpSession[idx]->firstSeen)
	 || (tcpSession[idx]->firstSeen == 0))
	tcpSession[idx]->firstSeen = actTime;

      sprintf(buf, "<TR %s>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s:%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
#ifdef PRINT_ALL_ACTIVE_SESSIONS
	      "<TD ALIGN=CENTER>%s</TD>"
#endif
	      "</TR>\n",
	      getRowColor(),
	      sport,
	      remotePeer,
	      dport,
	      formatBytes(dataSent, (short)webMode),
	      formatBytes(dataReceived, (short)webMode),
	      formatTime(&(tcpSession[idx]->firstSeen), (short)webMode),
	      formatTime(&(tcpSession[idx]->lastSeen), (short)webMode),
	      formatSeconds(actTime-tcpSession[idx]->firstSeen)
#ifdef PRINT_ALL_ACTIVE_SESSIONS
	      , getSessionState(tcpSession[idx])
#endif
	      );

      sendString(buf);
      numSessions++;
    }

  if(numSessions > 0) {
    sendString("</TABLE><P>\n");
  }
}


/* ************************************ */

/* Debug */
void printSession(IPSession *theSession, u_short sessionType,
		  u_short sessionCounter) 
{
  char *_sport, *_dport, *_sessionType, *direction;  
 
  _sport = getPortByNum(theSession->sport, sessionType);
  _dport = getPortByNum(theSession->dport, sessionType);

  if(_sport == NULL) {
    static char __sport[8];
    sprintf(__sport, "%d", (int)theSession->sport);
    _sport = __sport;
  }

  if(_dport == NULL) {
    static char __dport[8];
    sprintf(__dport, "%d", (int)theSession->dport);
    _dport = __dport;
  }

  if(sessionType == IPPROTO_TCP) {
    _sessionType = "TCP";
    direction = "<->";
  } else {
    _sessionType = "UDP";
    direction = " >";
  }

  printLogTime();

  fprintf(logd," %s %s:%s %s %s:%s s=%lu/r=%lu\n",
	  _sessionType,
	  hash_hostTraffic[checkSessionIdx(theSession->initiatorIdx)]->hostSymIpAddress,  _sport,
	  direction,
	  hash_hostTraffic[checkSessionIdx(theSession->remotePeerIdx)]->hostSymIpAddress, _dport,
	  (unsigned long)theSession->bytesSent,
	  (unsigned long)theSession->bytesReceived); 
}

/* ************************************ */

/* Debug */
void printSessions(IPSession *sessions[], u_short type)
{
  u_int idx;
  char* sessionType;

  if(type == IPPROTO_TCP)
    sessionType = "TCP";
  else
    sessionType = "UDP";
  

  if (logTimeout) {
    for(idx=1; idx<HASHNAMESIZE; idx++)
      if(sessions[idx] != NULL) {

	char *_sport = getPortByNum(sessions[idx]->sport, type);
	char *_dport = getPortByNum(sessions[idx]->dport, type);

	if(_sport == NULL) {
	  static char __sport[8];
	  sprintf(__sport, "%d", sessions[idx]->sport);
	  _sport = __sport;
	}

	if(_dport == NULL) {
	  static char __dport[8];
	  sprintf(__dport, "%d", sessions[idx]->dport);
	  _dport = __dport;
	}

	printLogTime();
	fprintf(logd, "%s\t%s:%s <-> %s:%s\ts=%lu/r=%lu\n", 
		sessionType,
		hash_hostTraffic[checkSessionIdx(sessions[idx]->initiatorIdx)]->hostSymIpAddress,
		_sport,
		hash_hostTraffic[checkSessionIdx(sessions[idx]->remotePeerIdx)]->hostSymIpAddress,
		_dport,
		(unsigned long)sessions[idx]->bytesSent,
		(unsigned long)sessions[idx]->bytesReceived);
      }
  }

}

void printTCPSessions() { printSessions(tcpSession, IPPROTO_TCP); }
void printUDPSessions() { printSessions(udpSession, IPPROTO_UDP); }


/* ************************************ */

RETSIGTYPE printIpAccounting(int remoteToLocal, int sortedColumn,
			     int revertOrder) {
  int idx, numEntries, printedEntries=0;
  struct hostTraffic *el;
  struct hostTraffic* tmpTable[HASHNAMESIZE];
  char buf[BUF_SIZE], *str, *sign;
  TrafficCounter totalBytesSent, totalBytesReceived, totalBytes, a, b;
  float sentpct, rcvdpct;
  time_t timeDiff = time(NULL)-initialSniffTime;

   if(revertOrder)
    sign = "";
  else
    sign = "-";

 totalBytesSent=0, totalBytesReceived=0;
  memset(tmpTable, 0, HASHNAMESIZE*sizeof(HostTraffic*));

  for(idx=1, numEntries=0; idx<HASHNAMESIZE; idx++)  
    if(((el = hash_hostTraffic[idx]) != NULL)        
       && (el->broadcastHost == 0) /* No broadcast addresses please */
       && ((el->hostNumIpAddress[0] != '\0') 
	   && (el->hostNumIpAddress[0] != '0' /* 0.0.0.0 */) 
	   /* This host speaks IP */)) {
      switch(remoteToLocal) {
      case REMOTE_TO_LOCAL_ACCOUNTING:
	if(el->subnetPseudoLocalHost == REMOTE_HOST) {
	  if((el->bytesSentLocally > 0) || (el->bytesReceivedFromRemote > 0)) {
	    tmpTable[numEntries++]=el;  
	    totalBytesSent += el->bytesSentLocally;
	    totalBytesReceived += el->bytesReceivedFromRemote;
	  }
	}
	break;
      case LOCAL_TO_REMOTE_ACCOUNTING:
	if(el->subnetPseudoLocalHost == LOCAL_HOST) {
	  if((el->bytesSentRemotely > 0) || (el->bytesReceivedFromRemote > 0)) {
	    tmpTable[numEntries++]=el;  
	    totalBytesSent += el->bytesSentRemotely;
	    totalBytesReceived += el->bytesReceivedFromRemote;
	  }
	}
	break;
      case LOCAL_TO_LOCAL_ACCOUNTING:
	if(el->subnetPseudoLocalHost == LOCAL_HOST) {
	  if((el->bytesSentLocally > 0) || (el->bytesReceivedLocally > 0)) {
	    tmpTable[numEntries++]=el;  
	    totalBytesSent += el->bytesSentLocally;
	    totalBytesReceived += el->bytesReceivedLocally;
	  }
	}
	break;
      }
    }

  if(numEntries > 0) {
    columnSort = sortedColumn;
    sortFilter = remoteToLocal;
    quicksort(tmpTable, numEntries, sizeof(struct hostTraffic*), cmpHostsFctn);

    switch(remoteToLocal) {
    case REMOTE_TO_LOCAL_ACCOUNTING:
      str = IP_R_2_L_HTML;
      break;
    case LOCAL_TO_REMOTE_ACCOUNTING:
      str = IP_L_2_R_HTML;
      break;
    case LOCAL_TO_LOCAL_ACCOUNTING:
      str = IP_L_2_L_HTML;
      break;
    }    

    sprintf(buf, "<TABLE BORDER=1 WIDTH=\"100%%\">\n<TR><TH>"
	    "<A HREF=%s?%s1>Host&nbsp;Name</A></TH>"
	    "<TH><A HREF=%s?%s2>IP&nbsp;Address</A></TH>\n"
	    "<TH COLSPAN=2><A HREF=%s?%s3>Data&nbsp;Received</A></TH>"
	    "<TH COLSPAN=2><A HREF=%s?%s4>Data&nbsp;Sent</A></TH></TR>\n",
	    str, sign, str, sign, str, sign, str, sign);

    sendString(buf);

    for(idx=0; idx<numEntries; idx++) {
      if(revertOrder)
	el = tmpTable[numEntries-idx-1];
      else
	el = tmpTable[idx];

      if(el != NULL) {       
	char *tmpName1;
	tmpName1 = el->hostNumIpAddress;
	if((tmpName1[0] == '\0') || (strcmp(tmpName1, "0.0.0.0") == 0))
	  tmpName1 = separator;

	switch(remoteToLocal) {
	case REMOTE_TO_LOCAL_ACCOUNTING:
	  a = el->bytesSentLocally;
	  b = el->bytesReceivedFromRemote;
	  break;
	case LOCAL_TO_REMOTE_ACCOUNTING:
	  a = el->bytesSentRemotely;
	  b = el->bytesReceivedFromRemote;
	  break;
	case LOCAL_TO_LOCAL_ACCOUNTING:
	  a = el->bytesSentLocally;
	  b = el->bytesReceivedLocally;
	  break;
	}
	
	if(a < 100)  /* Avoid very small decimal values */
	  sentpct = 0;
	else
	  sentpct = (100*(float)a)/totalBytesSent;
	
	if(b < 100)  /* Avoid very small decimal values */
	  rcvdpct = 0;
	else
	  rcvdpct = (100*(float)b)/totalBytesReceived;
	
	sprintf(buf, "<TR %s>"
		"%s<TD ALIGN=RIGHT>%s</TD>"
		"</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD>"
		"<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%s%%</TD></TR>\n",
		getRowColor(), 
		makeHostLink(el, LONG_FORMAT, 0, 0),
		tmpName1,
		formatBytes(a, (short)webMode),
		sentpct, separator,
		formatBytes(b, (short)webMode),
		rcvdpct, separator);
	sendString(buf);
      }

      /* Avoid huge tables */
      if(printedEntries++ > maxNumLines)
	break;
    }

    sendString("</TABLE>\n");
    sendString("<P><TABLE BORDER=1 WIDTH=\"100%%\">\n<TR><TH>Total Traffic</TH><TH>Data Received</TH>\n"
	       "<TH>Data Sent</TH><TH>Bandwidth</TH></TR>\n");

    totalBytes = totalBytesSent+totalBytesReceived;

    sprintf(buf, "<TR>"
	    "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD></TR>\n",
	    formatBytes(totalBytes, (short)webMode),
	    formatBytes(totalBytesReceived, (short)webMode),
	    formatBytes(totalBytesSent, (short)webMode),
	    formatThroughput((float)(totalBytes/timeDiff)));

    sendString(buf);
    sendString("</TABLE>\n");
  } else
    sendString("<CENTER><P><i>No Data To Display</i></CENTER>\n");

}

/* ********************************** */

void printActiveTCPSessions() {
  int idx;
  char buf[BUF_SIZE];
  int numSessions;

  for(idx=1, numSessions=0; idx<HASHNAMESIZE; idx++) 
    if((tcpSession[idx] != NULL) 
#ifndef PRINT_ALL_ACTIVE_SESSIONS
       && (tcpSession[idx]->sessionState == STATE_ACTIVE)
#endif
       ) {

      char *sport, *dport;
      TrafficCounter dataSent, dataReceived;
      
      if(numSessions == 0) {
	sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR>"
		   "<TH>Client</TH>"
		   "<TH>Server</TH>"
		   "<TH>Data&nbsp;Sent</TH>"
		   "<TH>Data&nbsp;Rcvd</TH>"
		   "<TH>Active&nbsp;Since</TH>"
		   "<TH>Last&nbsp;Seen</TH>"
		   "<TH>Duration</TH>"
#ifdef PRINT_ALL_ACTIVE_SESSIONS
		   "<TH>State</TH>"
#endif
		   "</TR>\n");
      }
      
      sport = getPortByNum(tcpSession[idx]->sport, IPPROTO_TCP);
      dport = getPortByNum(tcpSession[idx]->dport, IPPROTO_TCP);
      dataSent = tcpSession[idx]->bytesSent;
      dataReceived = tcpSession[idx]->bytesReceived;

      if(sport == NULL) {
	static char _sport[8];
	sprintf(_sport, "%d", tcpSession[idx]->sport);
	sport = _sport;
      }

      if(dport == NULL) {
	static char _dport[8];
	sprintf(_dport, "%d", tcpSession[idx]->dport);
	dport = _dport;
      }

      /* Sanity check */
      if((actTime < tcpSession[idx]->firstSeen)
	 || (tcpSession[idx]->firstSeen == 0))
	tcpSession[idx]->firstSeen = actTime;

      sprintf(buf, "<TR %s>"
	      "<TD ALIGN=RIGHT>%s:%s</TD>"
	      "<TD ALIGN=RIGHT>%s:%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD>"
#ifdef PRINT_ALL_ACTIVE_SESSIONS
	      "<TD ALIGN=CENTER>%s</TD>"
#endif
	      "</TR>\n",
	      getRowColor(),
	      makeHostLink(hash_hostTraffic[checkSessionIdx(tcpSession[idx]->initiatorIdx)], SHORT_FORMAT, 0, 0),
	      sport,
	      makeHostLink(hash_hostTraffic[checkSessionIdx(tcpSession[idx]->remotePeerIdx)], SHORT_FORMAT, 0, 0),
	      dport,
	      formatBytes(dataSent, (short)webMode),
	      formatBytes(dataReceived, (short)webMode),
	      formatTime(&(tcpSession[idx]->firstSeen), (short)webMode),
	      formatTime(&(tcpSession[idx]->lastSeen), (short)webMode),
	      formatSeconds(actTime-tcpSession[idx]->firstSeen)
#ifdef PRINT_ALL_ACTIVE_SESSIONS
	      , getSessionState(tcpSession[idx])
#endif
	      );

      sendString(buf);
      numSessions++;
    }
      
  if(numSessions > 0)
    sendString("</TABLE><P>\n");
  else
    sendString("<P><i>No Active TCP Sessions</i>\n");
}


/* ********************************** */

void printIpProtocolUsage() {
  HostTraffic *hosts[HASHNAMESIZE];
  u_short clientPorts[TOP_ASSIGNED_IP_PORTS], serverPorts[TOP_ASSIGNED_IP_PORTS];
  int i, j, idx1, hostsNum=0, numPorts=0;
  char buf[BUF_SIZE];

  memset(clientPorts, 0, sizeof(clientPorts));
  memset(serverPorts, 0, sizeof(serverPorts));

  for(i=0; i<HASHNAMESIZE; i++)
    if((hash_hostTraffic[i] != NULL)
       && (hash_hostTraffic[i]->subnetPseudoLocalHost == LOCAL_HOST)
       && (hash_hostTraffic[i]->hostNumIpAddress[0] != '\0')) {
      hosts[hostsNum++] = hash_hostTraffic[i];
            
      for(j=0; j<TOP_ASSIGNED_IP_PORTS; j++) {
	if((hash_hostTraffic[i]->usedClientPorts[j] > 0) 
	   || (hash_hostTraffic[i]->usedServerPorts[j] > 0)) {	   
	  clientPorts[j] += hash_hostTraffic[i]->usedClientPorts[j];
	  serverPorts[j] += hash_hostTraffic[i]->usedServerPorts[j];	
	  numPorts++;
	}
      }
    }

  if(numPorts == 0) {
    sendString("<CENTER><P><i>No Data To Display</i></CENTER>\n");
    return;
  }

  /* Hosts are now in a contiguous structure (hosts[])... */
  
  sendString("<TABLE BORDER=1><TR><TH COLSPAN=2>Service</TH>"
	     "<TH>Clients</TH><TH>Servers</TH>\n");

  for(j=0; j<TOP_ASSIGNED_IP_PORTS; j++) 
    if((clientPorts[j] > 0) || (serverPorts[j] > 0)) {
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=CENTER>%d</TD>"
	      "<TD>\n", getRowColor(), getAllPortByNum(j), j);
      sendString(buf);

      if(clientPorts[j] > 0) {
	sendString("<UL>");
	for(idx1=0; idx1<hostsNum; idx1++)
	  if(hosts[idx1]->usedClientPorts[j] > 0) {
	    sprintf(buf, "<li>%s\n", makeHostLink(hosts[idx1], SHORT_FORMAT, 1, 0));
	    sendString(buf);
	  }
	sendString("</UL>");
      } else
	sendString("&nbsp;");
    
      sendString("</TD><TD>");
      
      if(serverPorts[j] > 0) {
	sendString("<UL>");
	for(idx1=0; idx1<hostsNum; idx1++)
	  if(hosts[idx1]->usedServerPorts[j] > 0) {
	    sprintf(buf, "<li>%s\n", makeHostLink(hosts[idx1], SHORT_FORMAT, 1, 0));
	    sendString(buf);
	  }
	sendString("</UL>");
      } else
	sendString("&nbsp;");

      sendString("</TD></TR>");
    } /* for */

  sendString("</TABLE><P>\n");
}


/* ********************************** */

char* calculateCellColor(TrafficCounter actualValue,
			 TrafficCounter avgTrafficLow,
			 TrafficCounter avgTrafficHigh) {

  if(actualValue < avgTrafficLow)
    return("BGCOLOR=#AAAAAAFF"); /* light blue */
  else if(actualValue < avgTrafficHigh)
    return("BGCOLOR=#00FF75"); /* light green */
  else
    return("BGCOLOR=#FF7777"); /* light red */
}


/* ********************************** */

void printBar(char *buf, unsigned short percentage, 
	      unsigned short maxPercentage, 
	      unsigned short ratio) {
  int int_perc = (int)((100*percentage)/maxPercentage);

  /* This shouldn't happen */
  if(int_perc < 0) {
    int_perc = 0;
    percentage = 0;
  } else if(int_perc > 100) {
    int_perc = 100;
    percentage = 100;
  }
  
  switch(int_perc) {
  case 0:
    sprintf(buf, "<TD %s>&nbsp;</TD>\n", getActualRowColor());
    break;
  default:    
    sprintf(buf, "<TD ALIGN=LEFT><IMG ALIGN=ABSMIDDLE SRC=/gauge.jpg"
	    " WIDTH=%d HEIGHT=12>&nbsp;</TD>\n", 
	    ratio*int_perc);
    break;
  }

  sendString(buf);
}

/* ********************************** */

void printTableEntry(char *buf, char *label, char* color, 
		     float total, float percentage) {
  int int_perc;

  if(total == 0) return;

  int_perc = (int)percentage;
  
  /* This shouldn't happen */
  if(int_perc < 0) {
    int_perc = 0;
    percentage = 0;
  } else if(int_perc > 100) {
    int_perc = 100;
    percentage = 100;
  }
  
  switch(int_perc) {
  case 0:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD>&nbsp;</TD></TR>\n",
	    getRowColor(), label, formatKBytes(total));
    break;
  case 100:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=CENTER BGCOLOR=\"%s\">100%%</TD></TR>\n",
	    getRowColor(), label, formatKBytes(total), color);
    break;
  default:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD><TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%%\">" 
	    "<TR><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">"
	    "<P>%.1f&nbsp;%%</TD><TD ALIGN=CENTER WIDTH=\"%d%%\" %s>" 
	    "<P>&nbsp;</TD></TR></TABLE></TD></TR>\n",
	    getRowColor(), label, formatKBytes(total), 
	    int_perc, color, percentage, (100-int_perc), getActualRowColor());
  }

  sendString(buf);
}

/* ********************************** */

void printTableDoubleEntry(char *buf, char *label, char* color, 
			   float totalS, float percentageS, 
			   float totalR, float percentageR) {
  int int_perc;

  if((totalS == 0) && (totalR == 0)) return;
  int_perc = (int)percentageS;
  
  /* This shouldn't happen */
  if(int_perc < 0) {
    int_perc = 0;
    percentageS = 0;
  } else if(int_perc > 100) {
    int_perc = 100;
    percentageS = 100;
  }
  
  switch(int_perc) {
  case 0:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD>&nbsp;</TD>\n",
	    getRowColor(), label, formatKBytes(totalS));
    break;
  case 100:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=CENTER BGCOLOR=\"%s\">100%%</TD>\n",
	    getRowColor(), label, formatKBytes(totalS), color);
    break;
  default:
    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	    "<TD><TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%%\">" 
	    "<TR><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">"
	    "<P>%.1f&nbsp;%%</TD><TD ALIGN=CENTER WIDTH=\"%d%%\" %s>" 
	    "<P>&nbsp;</TD></TR></TABLE></TD>\n",
	    getRowColor(), label, formatKBytes(totalS), 
	    int_perc, color, percentageS, (100-int_perc), getActualRowColor());
  }

  sendString(buf);

  /* ************************ */

  if(totalR == 0) percentageR = 0;

  int_perc = (int)percentageR;
  
  /* This shouldn't happen */
  if(int_perc < 0) {
    int_perc = 0;
    percentageR = 0;
  } else if(int_perc > 100) {
    int_perc = 100;
    percentageS = 100;
  }
  
  switch(int_perc) {
  case 0:
    sprintf(buf, "<TD ALIGN=RIGHT>%s</TD><TD>&nbsp;</TD></TR>\n",
	    formatKBytes(totalR));
    break;
  case 100:
    sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=CENTER BGCOLOR=\"%s\">100%%</TD></TR>\n",
	    formatKBytes(totalR), color);
    break;
  default:
    sprintf(buf, "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD><TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%%\">" 
	    "<TR><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">"
	    "<P>%.1f&nbsp;%%</TD><TD ALIGN=CENTER WIDTH=\"%d%%\" %s>" 
	    "<P>&nbsp;</TD></TR></TABLE></TD></TR>\n",
	    formatKBytes(totalR), 
	    int_perc, color, percentageR, 
	    (100-int_perc), getActualRowColor());
  }

  sendString(buf);
}

/* ********************************** */

void printTableEntryPercentage(char *buf, char *label, char* label_1, 
			       char* label_2, float total, 
			       float percentage) {
  int int_perc = (int)percentage;

  /* This shouldn't happen */
  if(int_perc < 0) 
    int_perc = 0;
  else if(int_perc > 100) 
    int_perc = 100;

  switch(int_perc) {
  case 0:
    if(total == -1)
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH>"
	      "<TD ALIGN=CENTER BGCOLOR=\"%s\">%s&nbsp;(100&nbsp;%%)</TD></TR>\n",
	      getRowColor(), label, COLOR_2, label_2);
    else
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=CENTER BGCOLOR=\"%s\">%s&nbsp;(100&nbsp;%%)</TD></TR>\n",
	      getRowColor(), label, formatKBytes(total), COLOR_2, label_2);
    break;
  case 100:
    if(total == -1)
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH>"
	      "<TD ALIGN=CENTER BGCOLOR=\"%s\">%s&nbsp;(100&nbsp;%%)</TD></TR>\n",
	      getRowColor(), label, COLOR_1, label_1);
    else
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	      "<TD ALIGN=CENTER BGCOLOR=\"%s\">%s&nbsp;(100&nbsp;%%)</TD></TR>\n",
	      getRowColor(), label, formatKBytes(total), COLOR_1, label_1);
    break;
  default:
    if(total == -1)
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH>"
	      "<TD><TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%%\">" 
	      "<TR><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">"
	      "<P>%s&nbsp;(%.1f&nbsp;%%)</TD><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">" 
	      "<P>%s&nbsp;(%.1f&nbsp;%%)</TD></TR></TABLE></TD></TR>\n",
	      getRowColor(), label,
	      int_perc, COLOR_1,
	      label_1, percentage, (100-int_perc), COLOR_2,
	      label_2, (100-percentage));
    else
      sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=RIGHT>%s</TD>"
	      "<TD><TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%%\">" 
	      "<TR><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">"
	      "<P>%s&nbsp;(%.1f&nbsp;%%)</TD><TD ALIGN=CENTER WIDTH=\"%d%%\" BGCOLOR=\"%s\">" 
	      "<P>%s&nbsp;(%.1f&nbsp;%%)</TD></TR></TABLE></TD></TR>\n",
	      getRowColor(), label, formatKBytes(total),
	      int_perc, COLOR_1,
	      label_1, percentage, (100-int_perc), COLOR_2,
	      label_2, (100-percentage));
  }

  sendString(buf);
}

/* ********************************** */

void printIpProtocolDistribution(int mode, int revertOrder) {
  u_int i;
  char buf[2*BUF_SIZE], *sign;
  float total, partialTotal, remainingTraffic;
  float percentage;

  if(revertOrder)
    sign = "";
  else
    sign = "-";

 if(mode == SHORT_FORMAT) {
    sendString("<CENTER><P><H1><FONT FACE=Helvetica>Local Traffic</FONT></H1><P>\n");
    
    total = (float)(tcpGlobalTrafficStats.local+udpGlobalTrafficStats.local)/1024;
    if(total == 0)
      sendString("<CENTER><i>No Data To Display</i><P></CENTER>\n");
    else {
      sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR><TH WIDTH=20%%>IP&nbsp;Protocol</TH>"
		 "<TH WIDTH=10%%>Data</TH><TH WIDTH=70%%>Percentage</TH></TR>\n");
      if(total == 0) total = 1; /* Avoids divisions by zero */
      remainingTraffic = 0;

      partialTotal = tcpGlobalTrafficStats.local/1024;
      percentage = ((float)(partialTotal*100))/((float)total);
      printTableEntryPercentage(buf, "TCP&nbsp;vs.&nbsp;UDP", "TCP", "UDP", total, percentage);

      for(i=0; i<numIpProtosToMonitor; i++) {
	partialTotal = (float)ipProtoStats[i].local/1024;

	if(partialTotal > 0) {
	  remainingTraffic += partialTotal;
	  percentage = ((float)(partialTotal*100))/((float)total);
	  printTableEntry(buf, protoIPTrafficInfos[i], COLOR_1, partialTotal, percentage);	
	}
      }

      if(total > remainingTraffic)
	remainingTraffic = total - remainingTraffic; 
      else
	remainingTraffic = 0;

      if(remainingTraffic > 0) {
	percentage = ((float)(remainingTraffic*100))/((float)total);
	printTableEntry(buf, "Other&nbsp;TCP/UDP-based&nbsp;Prot.", COLOR_1, remainingTraffic, percentage);
      }

      sendString("</TABLE><P>\n");
    }

    /* ********************************************************** */

    total = (float)(tcpGlobalTrafficStats.remote2local+udpGlobalTrafficStats.remote2local)/1024;

    sendString("<H1><FONT FACE=Helvetica>Remote to Local Traffic</FONT></H1><P>\n");

    if(total == 0)
      sendString("<CENTER><i>No Data To Display</i><P></CENTER>\n");
    else {
      sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR><TH WIDTH=20%%>IP&nbsp;Protocol</TH>"
		 "<TH WIDTH=10%%>Data</TH><TH WIDTH=70%%>Percentage</TH></TR>\n");

      if(total == 0) total = 1; /* Avoids divisions by zero */
      remainingTraffic = 0;

      partialTotal = (float)tcpGlobalTrafficStats.remote2local/1024;
      percentage = ((float)(partialTotal*100))/((float)total);
      printTableEntryPercentage(buf, "TCP&nbsp;vs.&nbsp;UDP", "TCP", "UDP", total, percentage);

      for(i=0; i<numIpProtosToMonitor; i++) {
	partialTotal = (float)ipProtoStats[i].remote2local/1024;

	if(partialTotal > 0) {
	  remainingTraffic += partialTotal;
	  percentage = ((float)(partialTotal*100))/((float)total);
	  printTableEntry(buf, protoIPTrafficInfos[i], COLOR_1, partialTotal, percentage);	
	}
      }

      if(total > remainingTraffic)
	remainingTraffic = total - remainingTraffic; 
      else
	remainingTraffic = 0;

      if(remainingTraffic > 0) {
	percentage = ((float)(remainingTraffic*100))/((float)total);
	printTableEntry(buf, "Other&nbsp;TCP/UDP-based&nbsp;Prot.", COLOR_1, remainingTraffic, percentage);
      }
      sendString("</TABLE>\n<P>\n");
    }

    /* ********************************************************** */

    sendString("<H1><FONT FACE=Helvetica>Local to Remote Traffic</FONT></H1><P>\n");

    total = (float)(tcpGlobalTrafficStats.local2remote+udpGlobalTrafficStats.local2remote)/1024;
    if(total == 0)
      sendString("<CENTER><i>No Data To Display</i></CENTER>\n");
    else {
      sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR><TH WIDTH=20%%>IP&nbsp;Protocol</TH>"
		 "<TH WIDTH=10%%>Data</TH><TH WIDTH=70%%>Percentage</TH></TR>\n");

      if(total == 0) total = 1; /* Avoids divisions by zero */
      remainingTraffic = 0;

      partialTotal = (float)tcpGlobalTrafficStats.local2remote/1024;
      percentage = ((float)(partialTotal*100))/((float)total);
      printTableEntryPercentage(buf, "TCP&nbsp;vs.&nbsp;UDP", "TCP", "UDP", total, percentage);

      for(i=0; i<numIpProtosToMonitor; i++) {
	partialTotal = (float)ipProtoStats[i].local2remote/1024;

	if(partialTotal > 0) {
	  remainingTraffic += partialTotal;
	  percentage = ((float)(partialTotal*100))/((float)total);
	  printTableEntry(buf, protoIPTrafficInfos[i], COLOR_1, partialTotal, percentage);	
	}
      }

      if(total > remainingTraffic)
	remainingTraffic = total - remainingTraffic; 
      else
	remainingTraffic = 0;

      if(remainingTraffic > 0) {     
	percentage = ((float)(remainingTraffic*100))/((float)total);
	printTableEntry(buf, "Other&nbsp;TCP/UDP-based&nbsp;Prot.",
			COLOR_1, remainingTraffic, percentage);
      }
      sendString("</TABLE><P>\n");
    }
  } else {
    /* 
       sendString("<P><H1><FONT FACE=Helvetica>IP Protocol Distribution:"
       " Total Traffic</FONT></H1><P>\n");
    */
    total = (float)ipBytes/1024; /* total is expressed in KBytes */

    sendString("<CENTER><P><H1><FONT FACE=Helvetica>Global IP Protocol Distribution</FONT>"
	       "</H1><P>\n");

    if(total == 0)
      sendString("<CENTER><i>No Data To Display</i></CENTER>\n");
    else {
      sendString("<TABLE BORDER=1 WIDTH=\"100%%\"><TR><TH WIDTH=20%%>IP&nbsp;Protocol</TH>"
		 "<TH WIDTH=10%%>Data</TH><TH WIDTH=70%%>Percentage</TH></TR>\n");

      remainingTraffic = 0;

      for(i=0; i<numIpProtosToMonitor; i++) {
	partialTotal  = (float)ipProtoStats[i].local+ipProtoStats[i].remote;
	partialTotal += (float)ipProtoStats[i].remote2local+ipProtoStats[i].local2remote;

	if(partialTotal > 0) {
	  partialTotal /= 1024;
	  remainingTraffic += partialTotal;
	  percentage = ((float)(partialTotal*100))/((float)total);
	  printTableEntry(buf, protoIPTrafficInfos[i], COLOR_1, partialTotal, percentage);	
	}
      }

      if(total > remainingTraffic)
	remainingTraffic = total - remainingTraffic; 
      else
	remainingTraffic = 0;

      if(remainingTraffic > 0) {
	percentage = ((float)(remainingTraffic*100))/((float)total);
	printTableEntry(buf, "Other&nbsp;TCP/UDP-based&nbsp;Prot.", COLOR_1, remainingTraffic, percentage);
      }
   
      sendString("</TABLE><P>\n");
    }
  }
}


/* ************************ */

void printProtoTraffic() {
  float total;
  char buf[BUF_SIZE];

  total = ethernetBytes/1024; /* total is expressed in KBytes */
  
  if(total == 0) {
    sendString("<CENTER><i>No Data To Display</i><P></CENTER>\n");
    return; 
  }

  sendString("<CENTER><P><H1><FONT FACE=Helvetica>Global Protocol Distribution</FONT></H1><P>\n");
  sendString("<P><TABLE BORDER=1 WIDTH=\"100%%\"><TR><TH WIDTH=20%%>Protocol</TH>"
	     "<TH WIDTH=10%%>Data</TH><TH WIDTH=70%%>Percentage</TH></TR>\n");  
  sprintf(buf, "<TH WIDTH=20%% ALIGN=LEFT>IP</TH><TD WIDTH=10%% ALIGN=RIGHT>%s"
	  "&nbsp;(%.1f%%)</TD><TD WIDTH=70%%>"
	  "<TABLE BORDER=1 WIDTH=\"100%%\">", formatBytes(ipBytes, (short)webMode),
	  100*((float)ipBytes/ethernetBytes));
  sendString(buf);

  printTableEntry(buf, "TCP", COLOR_1, (float)tcpBytes/1024, 
		  100*((float)tcpBytes/ipBytes));
  printTableEntry(buf, "UDP", COLOR_1, (float)udpBytes/1024, 
		  100*((float)udpBytes/ipBytes));
  printTableEntry(buf, "ICMP", COLOR_1, (float)icmpBytes/1024, 
		  100*((float)icmpBytes/ipBytes));
  printTableEntry(buf, "Other&nbsp;IP", COLOR_1, (float)otherIpBytes/1024,
		  ((float)otherIpBytes/ipBytes));
  sendString("</TABLE></TR>");
  printTableEntry(buf, "(R)ARP", COLOR_1, (float)arpRarpBytes/1024, 
		  100*((float)arpRarpBytes/ipBytes));
  printTableEntry(buf, "DLC", COLOR_1, (float)dlcBytes/1024,
		  100*((float)dlcBytes/ethernetBytes));
  printTableEntry(buf, "IPX", COLOR_1, (float)ipxBytes/1024, 
		  100*((float)ipxBytes/ethernetBytes));
  printTableEntry(buf, "Decnet", COLOR_1, (float)decnetBytes/1024,
		  100*((float)decnetBytes/ethernetBytes));
  printTableEntry(buf, "AppleTalk", COLOR_1, (float)atalkBytes/1024, 
		  100*((float)atalkBytes/ethernetBytes));
  printTableEntry(buf, "OSPF", COLOR_1, (float)ospfBytes/1024, 
		  100*((float)ospfBytes/ethernetBytes));
  printTableEntry(buf, "NetBios", COLOR_1, (float)netbiosBytes/1024,
		  100*((float)netbiosBytes/ethernetBytes));
  printTableEntry(buf, "IGMP", COLOR_1, (float)igmpBytes/1024, 
		  100*((float)igmpBytes/ethernetBytes));
  printTableEntry(buf, "OSI", COLOR_1, (float)osiBytes/1024, 
		  100*((float)osiBytes/ethernetBytes));
  printTableEntry(buf, "Other", COLOR_1, (float)otherBytes/1024,
		  100*((float)otherBytes/ethernetBytes));
  sendString("</TABLE><P></CENTER>\n");
}

/* ************************ */

#ifdef HAVE_LSOF

void printProcessInfo(int processPid) {
  char buf[BUF_SIZE];
  int i, j, numEntries;

#ifdef MULTITHREADED
  accessMutex(&lsofMutex);
#endif

  for(i=0; i<numProcesses; i++)
    if((processes[i] != NULL) 
       && (processes[i]->pid == processPid))
      break;

  printHTTPheader();

  if(processes[i]->pid != processPid) {
    sprintf(buf, "<H1><CENTER><FONT FACE=Helvetica>Unable to find process PID %d</FONT>"
	    "<CENTER></H1><P>\n", processPid);
    sendString(buf);
#ifdef MULTITHREADED
    releaseMutex(&lsofMutex);
#endif
    return;
  }

  sprintf(buf, "<H1><CENTER><FONT FACE=Helvetica>Info about process %s</FONT>"
	  "<CENTER></H1><P>\n", processes[i]->command);
  sendString(buf);

  sendString("<TABLE BORDER=1>");

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>User&nbsp;Name</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD></TR>\n", processes[i]->user);
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>Process&nbsp;PID</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%d</TD></TR>\n", processes[i]->pid);
  sendString(buf);
  
  sprintf(buf, "<TR %s><TH ALIGN=LEFT>First&nbsp;Seen</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD></TR>\n", 
	  formatTime(&processes[i]->firstSeen, webMode));
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>Last&nbsp;Seen</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD></TR>\n", 
	  formatTime(&processes[i]->lastSeen, webMode));
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>Data&nbsp;Sent</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%s</TD></TR>\n", 
	  formatBytes(processes[i]->bytesSent, webMode));
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>Data&nbsp;Rcvd</TH>", getRowColor());
  sendString(buf);
  sprintf(buf, "<TD ALIGN=RIGHT>%s</T></TR>\n", 
	  formatBytes(processes[i]->bytesReceived, webMode));
  sendString(buf);

  sprintf(buf, "<TR %s><TH ALIGN=LEFT>Open&nbsp;TCP&nbsp;Ports"
	  "</TH><TD ALIGN=RIGHT>", getRowColor());
  sendString(buf);

  for(j=0; j<TOP_IP_PORT; j++)
    if(localPorts[j] != NULL) {
      ProcessInfoList *elem = localPorts[j];

      while(elem != NULL) {
	if(elem->element == processes[i]) {
	  sprintf(buf, "%d<BR>\n", j);
	  sendString(buf);
	  break;
	}
	elem = elem->next;
      }
    }

  sendString("</TD></TR>\n");

  for(j=0, numEntries=0; j<MAX_NUM_CONTACTED_PEERS; j++)
    if(processes[i]->contactedIpPeersIndexes[j] != NO_PEER) {
      
      if(numEntries == 0) {
	sprintf(buf, "<TR %s><TH ALIGN=LEFT>Contacted&nbsp;Peers"
		"</TH><TD ALIGN=RIGHT>", getRowColor());
	sendString(buf);
      }

      sprintf(buf, "%s<BR>\n",
	      makeHostLink(hash_hostTraffic[checkSessionIdx(processes[i]->contactedIpPeersIndexes[j])],
			   0, 0, 1));
      sendString(buf);
      numEntries++;
    }

  sendString("</TD></TR>\n</TABLE><P>\n");

#ifdef MULTITHREADED
  releaseMutex(&lsofMutex);
#endif
}

/* ************************ */

#ifdef HAVE_LSOF
void printLsofData(int mode) {
  char buf[BUF_SIZE];
  int i, j, numUsers, found;
  ProcessInfo *processesList[MAX_NUM_PROCESSES];
  UsersTraffic usersTraffic[256], *usersTrafficList[256];

  printHTTPheader();

  /* ************************ */

  sendString("<H1><CENTER><FONT FACE=Helvetica>Local Network Usage by Process</FONT>"
	     "</H1><P>\n");
  
  sprintf(buf, "<TABLE BORDER=1><TR>"
	  "<TH><A HREF=\"%s?1\">Process</A></TH>"
	  "<TH><A HREF=\"%s?2\">PID</A></TH>"
	  "<TH><A HREF=\"%s?3\">User</A></TH>"
	  "<TH><A HREF=\"%s?4\">Sent</A></TH>"
	  "<TH><A HREF=\"%s?5\">Rcvd</A></TH></TR>\n", 
	  STR_LSOF_DATA, STR_LSOF_DATA, STR_LSOF_DATA,
	  STR_LSOF_DATA, STR_LSOF_DATA);
  sendString(buf);

#ifdef MULTITHREADED
  accessMutex(&lsofMutex);
#endif

  memcpy(processesList, processes, sizeof(processes));
  columnSort = mode;
  quicksort(processesList, numProcesses, sizeof(ProcessInfo*), cmpProcesses);

  /* Avoid huge tables */
  if(numProcesses > maxNumLines)
    numProcesses = maxNumLines;  

  for(i=0, numUsers=0; i<numProcesses; i++) {
    sprintf(buf, "<TR %s><TD><A HREF=\""PROCESS_INFO_HTML"?%d\">%s</A></TD>"
	    "<TD ALIGN=CENTER>%d</TD>"
	    "<TD ALIGN=CENTER>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD></TR>\n",
	    getRowColor(),
	    processesList[i]->pid,
	    processesList[i]->command,
	    processesList[i]->pid,
	    processesList[i]->user,
	    formatBytes(processesList[i]->bytesSent, webMode),
	    formatBytes(processesList[i]->bytesReceived, webMode));
    sendString(buf);

    if((processesList[i]->bytesSent > 0) || (processesList[i]->bytesReceived > 0)) {
      for(j=0, found=0; j<numUsers; j++)
	if(strcmp(usersTraffic[j].userName, processesList[i]->user) == 0) {
	  found = 1;
	  break;
	}
      
      if(!found) {
	usersTraffic[numUsers].userName = processesList[i]->user;
	usersTrafficList[numUsers++] = &usersTraffic[numUsers];
	usersTraffic[j].bytesSent = usersTraffic[j].bytesReceived = 0;
      }
      
      usersTraffic[j].bytesSent     += processesList[i]->bytesSent;
      usersTraffic[j].bytesReceived += processesList[i]->bytesReceived;
    }
  }

  sendString("</TABLE><P>\n");

  /* ************************ */

  sendString("\n<P><H1><FONT FACE=Helvetica>Local Network Usage by Port</FONT>"
	     "</H1><P>\n");
  
  sendString("<TABLE BORDER=1><TR><TH>Port</TH><TH>Processes</TH></TR>\n");

  for(i=0; i<TOP_IP_PORT; i++)
    if(localPorts[i] != NULL) {
      ProcessInfoList *scanner;

      sprintf(buf, "<TR %s><TD ALIGN=CENTER>%d</TD><TD>", getRowColor(), i);
      sendString(buf);

      scanner = localPorts[i];

      while(scanner != NULL) {
	sprintf(buf, "<li><A HREF=\""PROCESS_INFO_HTML"?%d\">%s</A><BR>\n",
		scanner->element->pid, scanner->element->command);
	sendString(buf);
	scanner = scanner->next;
      }

      sendString("</TR>");      
  }

  sendString("</TABLE><P></CENTER>\n\n");

  /* ******************************* */

  if(numUsers > 0) {
    quicksort(usersTrafficList, numUsers, sizeof(UsersTraffic**), cmpUsersTraffic);

    /* Avoid huge tables */
    if(numUsers > maxNumLines)
      numUsers = maxNumLines;

    sendString("<H1><CENTER><FONT FACE=Helvetica>Local Network Usage by User</FONT>"
	       "<CENTER></H1><P>\n");
    sendString("<TABLE BORDER=1><TR><TH>User</TH>"
	       "<TH>Traffic&nbsp;in/out</TH></TR>\n");

    for(i=0; i<numUsers; i++) {
      sprintf(buf, "<TR %s><TD>%s</TD>"
	      "<TD ALIGN=RIGHT>%s</TD></TR>\n",
	      getRowColor(),
	      usersTrafficList[i]->userName,
	      formatBytes(usersTrafficList[i]->bytesSent+
			  usersTrafficList[i]->bytesReceived, webMode));
      sendString(buf);
    }

    sendString("</TABLE><P></CENTER>\n");
  }

#ifdef MULTITHREADED
  releaseMutex(&lsofMutex);
#endif
}
#endif
#endif

/* ************************ */

char* buildHTMLBrowserWindowsLabel(int i, int j) {
  static char buf[BUF_SIZE];

  if((ipTrafficMatrix[i][j].bytesSent == 0) &&  (ipTrafficMatrix[i][j].bytesReceived == 0))
    buf[0]='\0';
  else if ((ipTrafficMatrix[i][j].bytesSent > 0) &&  (ipTrafficMatrix[i][j].bytesReceived == 0))
    sprintf(buf, "(%s->%s)=%s", ipTrafficMatrixHosts[i]->hostSymIpAddress, ipTrafficMatrixHosts[j]->hostSymIpAddress, formatBytes(ipTrafficMatrix[i][j].bytesSent, (short)webMode));
  else if ((ipTrafficMatrix[i][j].bytesSent == 0) &&  (ipTrafficMatrix[i][j].bytesReceived > 0))
    sprintf(buf, "(%s->%s)=%s", ipTrafficMatrixHosts[j]->hostSymIpAddress, ipTrafficMatrixHosts[i]->hostSymIpAddress, formatBytes(ipTrafficMatrix[i][j].bytesReceived, (short)webMode));
  else
    sprintf(buf, "(%s->%s)=%s, (%s->%s)=%s", 
	    ipTrafficMatrixHosts[i]->hostSymIpAddress, ipTrafficMatrixHosts[j]->hostSymIpAddress, formatBytes(ipTrafficMatrix[i][j].bytesSent, (short)webMode),
	    ipTrafficMatrixHosts[j]->hostSymIpAddress, ipTrafficMatrixHosts[i]->hostSymIpAddress, formatBytes(ipTrafficMatrix[i][j].bytesReceived, (short)webMode));

  return(buf);
}

/* ************************ */

void printIpTrafficMatrix() {
  int i, j, numEntries=0, numConsecutiveEmptyCells;
  char buf[BUF_SIZE];
  short activeHosts[256];
  TrafficCounter minTraffic=-1, maxTraffic=0, avgTraffic;
  TrafficCounter avgTrafficLow, avgTrafficHigh, tmpCounter;

  for(i=1; i<255; i++) {
    activeHosts[i] = 0;
    for(j=1; j<255; j++) {
      if((ipTrafficMatrix[i][j].bytesSent != 0)
	 || (ipTrafficMatrix[i][j].bytesReceived != 0)) {
	activeHosts[i] = 1;
	numEntries++;
	break;
      }
    }
    
    if(activeHosts[i] == 1) {
      if(numEntries == 1)
	sendString("<TABLE BORDER=1><TR><TH ALIGN=LEFT><SMALL>&nbsp;F&nbsp;"
		   "&nbsp;&nbsp;To<br>&nbsp;r<br>&nbsp;o<br>&nbsp;m</SMALL></TH>\n");
  
      sprintf(buf, "<TH ALIGN=CENTER><SMALL>%s</SMALL></TH>", 
	      getHostName(ipTrafficMatrixHosts[i], 1));
      sendString(buf);
    }
  }

  if(numEntries == 0) {
    sendString("<CENTER><P><i>No Data To Display</i></CENTER>\n");
    return;
  } else
    sendString("</TR>\n");

  for(i=1; i<255; i++) 
    for(j=1; j<255; j++)
      if((ipTrafficMatrix[i][j].bytesSent != 0)
	 || (ipTrafficMatrix[i][j].bytesReceived != 0)) {
	if(minTraffic > ipTrafficMatrix[i][j].bytesSent)
	  minTraffic = ipTrafficMatrix[i][j].bytesSent;
	if(minTraffic > ipTrafficMatrix[i][j].bytesReceived)
	  minTraffic = ipTrafficMatrix[i][j].bytesReceived;
	if(maxTraffic < ipTrafficMatrix[i][j].bytesSent)
	  maxTraffic = ipTrafficMatrix[i][j].bytesSent;
	if(maxTraffic < ipTrafficMatrix[i][j].bytesReceived)
	  maxTraffic = ipTrafficMatrix[i][j].bytesReceived;
      }
    
  avgTraffic = (TrafficCounter)(((float)minTraffic+(float)maxTraffic)/2);
  avgTrafficLow  = (avgTraffic*15)/100; /* 15% of the average */
  avgTrafficHigh = 2*(maxTraffic/3);   /* 75% of max traffic */


  for(i=1; i<255; i++)
    if(activeHosts[i] == 1) {
      numConsecutiveEmptyCells=0;

      sprintf(buf, "<TR %s><TH ALIGN=LEFT><SMALL>%s</SMALL></TH>", 
	      getRowColor(), makeHostLink(ipTrafficMatrixHosts[i], SHORT_FORMAT, 1, 0));
      sendString(buf);      
      
      for(j=1; j<255; j++) {
	if((i == j) && strcmp(ipTrafficMatrixHosts[i]->hostNumIpAddress, "127.0.0.1"))
	  numConsecutiveEmptyCells++;
	else if(activeHosts[j] == 1) {
	  if((ipTrafficMatrix[i][j].bytesReceived == 0) && (ipTrafficMatrix[i][j].bytesSent == 0))
	    numConsecutiveEmptyCells++;
	  else {
	    if(numConsecutiveEmptyCells > 0) {
	      sprintf(buf, "<TD COLSPAN=%d>&nbsp;</TD>\n", numConsecutiveEmptyCells); 
	      sendString(buf);
	      numConsecutiveEmptyCells = 0;
	    }
	    
	    tmpCounter = ipTrafficMatrix[i][j].bytesSent+ipTrafficMatrix[i][j].bytesReceived;
	    sprintf(buf, "<TD ALIGN=CENTER %s><A HREF=# onMouseOver=\"window.status='"
		    "%s'\"><SMALL>%s</SMALL></A></TH>\n", 
		    calculateCellColor(tmpCounter, avgTrafficLow, avgTrafficHigh),
		    buildHTMLBrowserWindowsLabel(i, j), 
		    formatBytes(tmpCounter, (short)webMode));
	    sendString(buf);	  	  
	  }
	}
      }

      if(numConsecutiveEmptyCells > 0) {
	sprintf(buf, "<TD COLSPAN=%d>&nbsp;</TD>\n", numConsecutiveEmptyCells); 
	sendString(buf);
	numConsecutiveEmptyCells = 0;
      }
      
      sendString("</TR>\n");
    }

  sendString("</TABLE>\n<P>\n");
}

/* ************************ */

char* formatTimeStamp(unsigned int ndays,
		      unsigned int nhours,
		      unsigned int nminutes) {
#define TIME_STAMP_BUFFER_SIZE   2
  time_t theTime;

  /* printf("%u - %u - %u\n", ndays, nhours, nminutes); */

  if((ndays == 0) 
     && (nhours == 0) 
     && (nminutes == 0))
    return("now");
  else {
    static char timeBuffer[TIME_STAMP_BUFFER_SIZE][32];
    static short bufIdx=0;

    bufIdx = (bufIdx+1)%TIME_STAMP_BUFFER_SIZE;
    theTime = actTime-(ndays*86500)-(nhours*3600)-(nminutes*60);
    strcpy(timeBuffer[bufIdx], ctime(&theTime));
    timeBuffer[bufIdx][strlen(timeBuffer[bufIdx])-1] = '\0'; /* Remove trailer '\n' */
    return(timeBuffer[bufIdx]);
  }
}

/* ************************ */

#define MAGNIFICATION  3

void printThptStats(int sortedColumn) {
  unsigned int firstSample, i, minIdx, maxIdx;
  char buf[BUF_SIZE];
  
  printHTTPheader();

  if(numThptSamples == 0) {
    sendString("<CENTER><P><i>No Data To Display (yet)</i></CENTER>\n");
    return;
  }
  
  firstSample = last60MinutesThptIdx-1;
  
  sendString("<CENTER><SCRIPT language=JavaScript1.2 src=graph.js></SCRIPT>\n");

  /* ************************************** */
  sendString("<p><FONT FACE=Helvetica SIZE=-1>\n<SCRIPT language=JavaScript>\n");
  sendString("var t = new Graph();\n");
  sendString("t.yLabel = \"Throughput\";\n");
  sendString("t.xLabel = \"Time [");
  sendString(formatTimeStamp(0, 0, 0));
  sendString(" - ");
  sendString(formatTimeStamp(0, 0, 60));
  sendString("]\";\n");

  for(i=1, maxIdx=0, minIdx=0; i<60; i++) {
    if(last60MinutesThpt[i] > last60MinutesThpt[maxIdx])
      maxIdx = i;
    if (last60MinutesThpt[minIdx] > last60MinutesThpt[i])
      minIdx = i;
  }
  
  i = (((int)(last60MinutesThpt[maxIdx]-last60MinutesThpt[minIdx])/128)*100)/1000;
  if(i == 0) i = (unsigned int)(last60MinutesThpt[maxIdx]/128);

  sprintf(buf, "t.scale = %d;\n", i);
  sendString(buf);

  sendString("t.title = \"Last 60 Minutes Average Throughput\";\n");

  sendString("t.setLegend(\"<FONT FACE=Helvetica SIZE=-1>Kbps<br>Max:&nbsp;");

  sprintf(buf, "%s@%s<br>Min:&nbsp;%s@%s</FONT>\");\n",
	  formatThroughput(last60MinutesThpt[maxIdx]),
	  formatTimeStamp(0, 0, maxIdx),
	  formatThroughput(last60MinutesThpt[minIdx]),
	  formatTimeStamp(0, 0, minIdx));
  sendString(buf);
  sendString("t.addRow(");
 
  for(i=0; i<60; i++) {
    if(i > 0) sendString(",");
    sprintf(buf, "%d", (int)(last60MinutesThpt[i]/128));
    sendString(buf);
  }
 
  sendString(");\nt.build();\n");
  sendString("</SCRIPT><NOSCRIPT>Please activate JavaScript on your browser</NOSCRIPT>\n");

  /* ************************************** */

  if(numThptSamples > 60) {
    firstSample = last24HoursThptIdx-1;   
    sendString("<p><FONT FACE=Helvetica SIZE=-1>\n<SCRIPT language=JavaScript>\n");
    sendString("var t = new Graph();\n");
    sendString("t.yLabel = \"Throughput\";\n");
    sendString("t.xLabel = \"Time [");
    sendString(formatTimeStamp(0, 0, 0));
    sendString(" - ");
    sendString(formatTimeStamp(0, 24, 0));
    sendString("]\";\n");

    for(i=1, maxIdx=0, minIdx=0; i<24; i++) {
      if(last24HoursThpt[i] > last24HoursThpt[maxIdx])
	maxIdx = i;
      if (last24HoursThpt[minIdx] > last24HoursThpt[i])
	minIdx = i;
    }
  
    i = (((int)(last24HoursThpt[maxIdx]-last24HoursThpt[minIdx])/128)*100)/1000;
    if(i == 0) i = (unsigned int)(last24HoursThpt[maxIdx]/128);

    sprintf(buf, "t.scale = %d;\n", i);
    sendString(buf);

    sendString("t.title = \"Last 24 Hours Avg Throughput\";\n");

    sendString("t.setLegend(\"<FONT FACE=Helvetica SIZE=-1>Kbps<br>Max:&nbsp;");

    sprintf(buf, "%s@%s<br>Min:&nbsp;%s@%s</FONT>\");\n",
	    formatThroughput(last24HoursThpt[maxIdx]),
	    formatTimeStamp(0, maxIdx, 0),
	    formatThroughput(last24HoursThpt[minIdx]),
	    formatTimeStamp(0, minIdx, 0));
    sendString(buf);
    sendString("t.addRow(");
 
    for(i=0; i<24; i++) {
      if(i > 0) sendString(",");
      sprintf(buf, "%d", (int)(last24HoursThpt[i]/128));
      sendString(buf);
    }
 
    sendString(");\nt.build();\n</SCRIPT>\n");
  }

  /* ************************************** */

  if(numThptSamples > 1440 /* 60 * 24 */) {
    firstSample = last30daysThptIdx-1;    

    sendString("<p><FONT FACE=Helvetica SIZE=-1>\n<SCRIPT language=JavaScript>\n");
    sendString("var t = new Graph();\n");
    sendString("t.yLabel = \"Throughput\";\n");
    sendString("t.xLabel = \"Time [");
    sendString(formatTimeStamp(0, 0, 0));
    sendString(" - ");
    sendString(formatTimeStamp(30, 0, 0));
    sendString("]\";\n");

    for(i=1, maxIdx=0, minIdx=0; i<30; i++) {
      if(last30daysThpt[i] > last30daysThpt[maxIdx])
	maxIdx = i;
      if (last30daysThpt[minIdx] > last30daysThpt[i])
	minIdx = i;
    }
  
    i = (((int)(last30daysThpt[maxIdx]-last30daysThpt[minIdx])/128)*100)/1000;
    if(i == 0) i = (unsigned int)(last30daysThpt[maxIdx]/128);

    sprintf(buf, "t.scale = %d;\n", i);
    sendString(buf);

    sendString("t.title = \"Last 30 Days Avg Throughput\";\n");

    sendString("t.setLegend(\"<FONT FACE=Helvetica SIZE=-1>Kbps<br>Max:&nbsp;");

    sprintf(buf, "%s@%s<br>Min:&nbsp;%s@%s</FONT>\");\n",
	    formatThroughput(last30daysThpt[maxIdx]),
	    formatTimeStamp(maxIdx, 0, 0),
	    formatThroughput(last30daysThpt[minIdx]),
	    formatTimeStamp(minIdx, 0, 0));
    sendString(buf);
    sendString("t.addRow(");
 
    for(i=0; i<30; i++) {
      if(i > 0) sendString(",");
      sprintf(buf, "%d", (int)(last30daysThpt[i]/128));
      sendString(buf);
    }
 
    sendString(");\nt.build();\n</SCRIPT>\n</CENTER>\n");
  }
}

/* ************************ */

int cmpStatsFctn(const void *_a, const void *_b) {
  DomainStats *a = (DomainStats *)_a;
  DomainStats *b = (DomainStats *)_b;
  TrafficCounter a_, b_;
  int rc;

  if((a == NULL) && (b != NULL)) {
    printf("WARNING (1)\n");
    return(1);
  } else if((a != NULL) && (b == NULL)) {
    printf("WARNING (2)\n");
    return(-1);
  } else if((a == NULL) && (b == NULL)) {
    printf("WARNING (3)\n");
    return(0);
  }
  
  switch(columnSort) {
  case 1:
    rc = strcasecmp(a->domainHost->dotDomainName, b->domainHost->dotDomainName);
    if(rc == 0)
      return(strcasecmp(a->domainHost->fullDomainName, b->domainHost->fullDomainName));
    else
      return rc;
  case 2: a_  = a->bytesSent, b_ = b->bytesSent; break;
  case 3: a_  = a->bytesRcvd, b_ = b->bytesRcvd; break;
  case 4: a_  = a->tcpSent  , b_ = b->tcpSent;   break;
  case 5: a_  = a->tcpRcvd  , b_ = b->tcpRcvd;   break;
  case 6: a_  = a->udpSent  , b_ = b->udpSent;   break;
  case 7: a_  = a->udpRcvd  , b_ = b->udpRcvd;   break;
  case 8: a_  = a->icmpSent , b_ = b->icmpSent;  break;
  case 9: a_  = a->icmpRcvd , b_ = b->icmpRcvd;  break;
  case 10: a_ = a->ospfSent , b_ = b->ospfSent;  break;
  case 11: a_ = a->ospfRcvd , b_ = b->ospfRcvd;  break;
  case 12: a_ = a->igmpSent , b_ = b->igmpSent;  break;
  case 13: a_ = a->igmpRcvd , b_ = b->igmpRcvd;  break;
  default:
  case 0:
    if(domainSort)
      return(strcasecmp(a->domainHost->fullDomainName, b->domainHost->fullDomainName));
    else
      return(strcasecmp(a->domainHost->hostSymIpAddress, b->domainHost->hostSymIpAddress));
  }

  if(a_ < b_)
    return(1);
  else if (a_ > b_)
    return(-1);
  else
    return(0);  
}

/* ************************ */

char* getCountryIconURL(char* domainName) {
  if((domainName == NULL) 
     || (domainName[0] == '\0')
     || (strlen(domainName) > 4))
    return("&nbsp;");
  else {
    static char flagBuf[64];
 
    sprintf(flagBuf, "<IMG ALIGN=ABSMIDDLE SRC=/statsicons/flags/%s.gif BORDER=0>", 
	    domainName);

    return(flagBuf);
  }
}

/* ************************ */

void fillDomainName(HostTraffic *el) {
  int i;

  if(el->theDomainHasBeenComputed
     || (el->hostSymIpAddress == NULL))
    return;
  
  if((el->hostSymIpAddress[0] == '*') 
     || (isdigit(el->hostSymIpAddress[strlen(el->hostSymIpAddress)-1]))) {
    /* NOTE: el->theDomainHasBeenComputed = 0 */
    el->fullDomainName = el->dotDomainName = "";
    return;
  }

  el->theDomainHasBeenComputed = 1;
  el->fullDomainName = el->dotDomainName = ""; /* Reset values... */

  if(el->hostNumIpAddress[0] == '\0') {
    return;
  }
  
  i = strlen(el->hostSymIpAddress)-1;

  while(i > 0)
    if(el->hostSymIpAddress[i] == '.')
      break;
    else
      i--;

  if((i > 0) 
	  && strcmp(el->hostSymIpAddress, el->hostNumIpAddress)
	  && (strlen(el->hostSymIpAddress) > (i+1)))
    el->dotDomainName = &el->hostSymIpAddress[i+1];
  else {
    /* Let's use the local domain name */
    #ifdef DEBUG
    printf("'%s' [%s/%s]\n", 
	   el->hostSymIpAddress, domainName, shortDomainName);
    #endif
    if((domainName[0] != '\0') 
       && (strcmp(el->hostSymIpAddress, el->hostNumIpAddress))) {
      int len  = strlen(el->hostSymIpAddress);
      int len1 = strlen(domainName);

      /* printf("%s [%s]\n", el->hostSymIpAddress, &el->hostSymIpAddress[len-len1]); */

      if((len > len1)
	 && (strcmp(&el->hostSymIpAddress[len-len1-1], domainName) == 0))
	el->hostSymIpAddress[len-len1-1] = '\0';

      el->fullDomainName = domainName;
      el->dotDomainName = shortDomainName;
    } else {
      el->fullDomainName = el->dotDomainName = "";
    }
    return;
  }

  i = 0;

  while(el->hostSymIpAddress[i] != '\0')
    if(el->hostSymIpAddress[i] == '.')
      break;
    else
      i++;

  if((el->hostSymIpAddress[i] == '.')
	 && (strlen(el->hostSymIpAddress) > (i+1)))
    el->fullDomainName = &el->hostSymIpAddress[i+1];

  /* printf("'%s'\n", el->domainName); */
}

/* ************************ */

char* getHostCountryIconURL(HostTraffic *el) {
  fillDomainName(el);
  return(getCountryIconURL(el->dotDomainName));
}

/* ************************ */

/* if domainName == NULL -> print all domains */
void printDomainStats(char* domainName, int sortedColumn, int revertOrder) {
  int idx, tmpIdx, numEntries=0;
  u_short keyValue=0;
  HostTraffic *el;
  char buf[BUF_SIZE];
  DomainStats *stats[HASHNAMESIZE], tmpStats[HASHNAMESIZE], *statsEntry;
  char htmlAnchor[128], *sign;
  TrafficCounter totBytesSent=0, totBytesRcvd=0;

  /* printf("'%s' '%d' '%d'\n", domainName, sortedColumn, revertOrder); */

  if(revertOrder)
    sign = "";
  else
    sign = "-";

  memset(stats, 0, sizeof(stats));

  if(domainName == NULL) 
    domainSort = 1;
  else
    domainSort = 0;
    
  for(idx=1; idx<HASHNAMESIZE; idx++) {
    if((el = hash_hostTraffic[idx]) == NULL)
      continue;
    else
      fillDomainName(el);
    
    if((el->fullDomainName == NULL)
       || (el->fullDomainName[0] == '\0')
       || (el->dotDomainName == NULL)
       || (el->dotDomainName == '\0'))
      continue;
    else if((domainName != NULL)
	    && (strcmp(el->fullDomainName, domainName) != 0))
      continue;

    if(domainName == NULL) {
      for(keyValue=0, tmpIdx=0; el->fullDomainName[tmpIdx] != '\0'; tmpIdx++)
	keyValue += (tmpIdx+1)*(u_short)el->fullDomainName[tmpIdx];

      keyValue %= HASHNAMESIZE;
      
      while((stats[keyValue] != NULL)
	    && (strcasecmp(stats[keyValue]->domainHost->fullDomainName, el->fullDomainName) != 0))
	keyValue = (keyValue+1)%HASHNAMESIZE;
      
      if(stats[keyValue] != NULL)
	statsEntry = stats[keyValue];
      else {
	statsEntry = &tmpStats[numEntries++];
	memset(statsEntry, 0, sizeof(DomainStats));	
	statsEntry->domainHost = el;	  
	stats[keyValue] = statsEntry;
	/* printf("[%d] %s/%s\n", numEntries, el->fullDomainName, el->dotDomainName); */
      }
    } else {
      statsEntry = &tmpStats[numEntries++];
      memset(statsEntry, 0, sizeof(DomainStats));	
      statsEntry->domainHost = el;	  
      stats[keyValue++] = statsEntry;
    }

    totBytesSent          += el->bytesSent;
    statsEntry->bytesSent += el->bytesSent;
    statsEntry->bytesRcvd += el->bytesReceived;
    totBytesRcvd          += el->bytesReceived;
    statsEntry->tcpSent   += el->tcpSentLocally + el->tcpSentRemotely;
    statsEntry->udpSent   += el->udpSentLocally + el->udpSentRemotely;
    statsEntry->icmpSent  += el->icmpSent;
    statsEntry->ospfSent  += el->ospfSent;
    statsEntry->igmpSent  += el->igmpSent;
    statsEntry->tcpRcvd   += el->tcpReceivedLocally + el->tcpReceivedFromRemote;
    statsEntry->udpRcvd   += el->udpReceivedLocally + el->tcpReceivedFromRemote;
    statsEntry->icmpRcvd  += el->icmpReceived;
    statsEntry->ospfRcvd  += el->ospfReceived;
    statsEntry->igmpRcvd  += el->igmpReceived;
  } /* for(;;) */

  printHTTPheader();

  if(numEntries == 0) {
    sendString("<P><FONT FACE=Helvetica><CENTER><H1>"
	       "<i>No Data To Display (yet)</i></H1></CENTER></FONT></CENTER>\n");
    return;
  }

  columnSort = sortedColumn;

  quicksort(tmpStats, numEntries, sizeof(DomainStats), cmpStatsFctn);

  /* avoid division by zero */
  if(totBytesSent == 0) 
    totBytesSent = 1;
  if(totBytesRcvd == 0) 
    totBytesRcvd = 1;

  if(domainName == NULL) {
    sendString("<CENTER><P><H1><FONT FACE=Helvetica>Internet "
	       "Domain Stats</FONT></H1><P>\n");
    sprintf(htmlAnchor, "<A HREF=/%s?%s", STR_DOMAIN_STATS, sign);
 } else {
    sprintf(buf, "<CENTER><P><H1><FONT FACE=Helvetica>Stats for "
	    "Domain %s</FONT></H1><P>\n", domainName);
    sendString(buf);
    sprintf(htmlAnchor, "<A HREF=/%s_%s.html?%s", DOMAIN_INFO_HTML, domainName, sign);
  }

  sprintf(buf, "<TABLE BORDER=1><TR><TH>%s0>Name</A><TH>%s1>Domain</A><TH COLSPAN=2>%s2>Sent</A>"
	  "</TH><TH COLSPAN=2>%s3>Rcvd</A></TH><TH>%s4>TCP&nbsp;Sent</A></TH>"
	  "<TH>%s5>TCP&nbsp;Rcvd</A></TH><TH>%s6>UDP&nbsp;Sent</A></TH><TH>%s7>UDP&nbsp;Rcvd</A></TH>"
	  "<TH>%s8>ICMP&nbsp;Sent</A></TH><TH>%s9>ICMP&nbsp;Rcvd</A></TH>"
	  "<TH>%s10>OSPF&nbsp;Sent</A></TH><TH>%s11>OSP&nbsp;Rcvd</A>"
	  "</TH><TH>%s12>IGMP&nbsp;Sent</A></TH>"
	  "<TH>%s13>IGMP&nbsp;Rcvd</A></TH></TR>\n",
	  htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor, 
	  htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor, 
	  htmlAnchor, htmlAnchor, htmlAnchor, htmlAnchor, 
	  htmlAnchor, htmlAnchor);
  sendString(buf);
  
  for(idx=0; idx<numEntries; idx++) {
    if(revertOrder)
      statsEntry = &tmpStats[numEntries-idx-1];
    else
      statsEntry = &tmpStats[idx];

    if(domainName == NULL)
      sprintf(htmlAnchor, "<A HREF=/%s_%s.html>%s</A>",
	      DOMAIN_INFO_HTML, statsEntry->domainHost->fullDomainName,
	      statsEntry->domainHost->fullDomainName);
    else {
      char tmpBuf[64];
      int blankId = strlen(statsEntry->domainHost->hostSymIpAddress)-
	    strlen(statsEntry->domainHost->fullDomainName)-1;
      
      strcpy(tmpBuf, statsEntry->domainHost->hostSymIpAddress);

      if((blankId > 0)
	 && (strcmp(&tmpBuf[blankId+1], domainName) == 0))
	tmpBuf[blankId] = '\0';

      sprintf(htmlAnchor, "<A HREF=/%s.html>%s</A>",
	      statsEntry->domainHost->hostNumIpAddress, tmpBuf);
    }

    sprintf(buf, "<TR %s><TH ALIGN=LEFT>%s</TH><TD ALIGN=CENTER>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%%</TD>"
	    "<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%.1f%%</TD>"
	    "<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD>"
	    "<TD ALIGN=RIGHT>%s</TD></TR>\n",
	    getRowColor(), htmlAnchor, 
	    getCountryIconURL(statsEntry->domainHost->dotDomainName),
	    formatBytes(statsEntry->bytesSent, webMode), 
	    (100*((float)statsEntry->bytesSent/(float)totBytesSent)), 
	    formatBytes(statsEntry->bytesRcvd, webMode),
	    (100*((float)statsEntry->bytesRcvd/(float)totBytesRcvd)),
	    formatBytes(statsEntry->tcpSent, (short)webMode),
	    formatBytes(statsEntry->tcpRcvd, (short)webMode),
	    formatBytes(statsEntry->udpSent, (short)webMode),
	    formatBytes(statsEntry->udpRcvd, (short)webMode),
	    formatBytes(statsEntry->icmpSent, (short)webMode),
	    formatBytes(statsEntry->icmpRcvd, (short)webMode),
	    formatBytes(statsEntry->ospfSent, (short)webMode),
	    formatBytes(statsEntry->ospfRcvd, (short)webMode),
	    formatBytes(statsEntry->igmpSent, (short)webMode),
	    formatBytes(statsEntry->igmpRcvd, (short)webMode)
	    );
    sendString(buf);
  }

  sendString("</TABLE></HTML>\n");
}


/* ************************ */

void printLogHeader() {

  if(logd != NULL) {	
    int i;

    fprintf(logd, "# date totalPkts broadcastPkts multicastPkts "
	    "ethernetBytes ipBytes nonIpBytes peakThroughput TCP UDP ICMP");
    
    for(i=0; i<numIpProtosToMonitor; i++)
      fprintf(logd, " %s", protoIPTrafficInfos[i]);

    fprintf(logd, "\n");
  }
}


/* ************************ */

void LogStatsToFile() {

  if((logd != NULL) && (ipProtoStats != NULL)) {	
    char tmpStr[255];
    int i;
    TrafficCounter tc;
        
    strcpy(tmpStr, ctime(&actTime));
    tmpStr[strlen(tmpStr)-1] = '\0'; /* remove final \n */
	 
    fprintf(logd, "\"%s\" %lu %lu %lu "
	    "%lu %lu %lu "
	    "%.1f",
	    tmpStr,
	    (unsigned long)(ethernetPkts-lastethernetPkts),
	    (unsigned long)(broadcastPkts-lastBroadcastPkts),
	    (unsigned long)(multicastPkts-lastMulticastPkts),
	    (unsigned long)(ethernetBytes-lastEthernetBytes),
	    (unsigned long)(ipBytes-lastIpBytes), 
	    (unsigned long)(ethernetBytes-ipBytes-lastNonIpBytes),
	    peakThroughput);
    fflush(logd); /* Courtesy of Robert Greimel <greimel@beluga.phys.uvic.ca> */
    lastethernetPkts = ethernetPkts;
    lastBroadcastPkts = broadcastPkts;
    lastMulticastPkts = multicastPkts;
    lastEthernetBytes = ethernetBytes;
    lastIpBytes = ipBytes;
    lastNonIpBytes = ethernetBytes-ipBytes;

    tc = tcpGlobalTrafficStats.local-tcpGlobalTrafficStats.lastLocal;
    tc += tcpGlobalTrafficStats.local2remote-tcpGlobalTrafficStats.lastLocal2remote;
    tc += tcpGlobalTrafficStats.remote-tcpGlobalTrafficStats.lastRemote;
    tc += tcpGlobalTrafficStats.remote2local-tcpGlobalTrafficStats.lastRemote2local;
    fprintf(logd, " %lu", (unsigned long)tc);

    tc = udpGlobalTrafficStats.local-udpGlobalTrafficStats.lastLocal;
    tc += udpGlobalTrafficStats.local2remote-udpGlobalTrafficStats.lastLocal2remote;
    tc += udpGlobalTrafficStats.remote-udpGlobalTrafficStats.lastRemote;
    tc += udpGlobalTrafficStats.remote2local-udpGlobalTrafficStats.lastRemote2local;
    fprintf(logd, " %lu", (unsigned long)tc);

    tc = icmpGlobalTrafficStats.local-icmpGlobalTrafficStats.lastLocal;
    tc += icmpGlobalTrafficStats.local2remote-icmpGlobalTrafficStats.lastLocal2remote;
    tc += icmpGlobalTrafficStats.remote-icmpGlobalTrafficStats.lastRemote;
    tc += icmpGlobalTrafficStats.remote2local-icmpGlobalTrafficStats.lastRemote2local;
    fprintf(logd, " %lu", (unsigned long)tc);

    for(i=0; i<numIpProtosToMonitor; i++) {           
      TrafficCounter tc;

      tc = ipProtoStats[i].local-ipProtoStats[i].lastLocal;
      tc += ipProtoStats[i].local2remote-ipProtoStats[i].lastLocal2remote;
      tc += ipProtoStats[i].remote-ipProtoStats[i].lastRemote;
      tc += ipProtoStats[i].remote2local-ipProtoStats[i].lastRemote2local;

      fprintf(logd, " %lu", (unsigned long)tc);

      ipProtoStats[i].lastLocal        = ipProtoStats[i].local;
      ipProtoStats[i].lastLocal2remote = ipProtoStats[i].local2remote;
      ipProtoStats[i].lastRemote       = ipProtoStats[i].remote;
      ipProtoStats[i].lastRemote2local = ipProtoStats[i].remote2local;
    }

    fprintf(logd, "\n");
  }
}

/* ************************ */

char* formatPkts(TrafficCounter pktNr) {
  static short bufIdx=0;
  static char staticBuffer[5][32];

  bufIdx = (bufIdx+1)%5;

  if(pktNr < 1000)
    sprintf(staticBuffer[bufIdx], "%lu", (unsigned long)pktNr);
  else if(pktNr < 1000000)
    sprintf(staticBuffer[bufIdx], "%lu,%03lu", 
	    (unsigned long)(pktNr/1000), 
	    ((unsigned long)pktNr)%1000);
  else {
    unsigned long a, b, c;
    a = (unsigned long)(pktNr/1000000);
    b = (unsigned long)((pktNr-a*1000000)/1000);
    c = ((unsigned long)pktNr)%1000;
    sprintf(staticBuffer[bufIdx], "%lu,%03lu,%03lu", a, b, c);
  }

  return(staticBuffer[bufIdx]);
}

/* ************************* */
void listNetFlows() {
  char buf[BUF_SIZE];
  FlowFilterList *list = flowsList;

  printHTTPheader();

  if(list != NULL) {
    sendString("<CENTER><P><H1><FONT FACE=Helvetica>Network Flows</FONT></H1><P>"
	       "<TABLE BORDER=1><TR><TH>Flow Name</TH><TH>Packets</TH><TH>Traffic</TH></TR>");
    
    while(list != NULL) {
      sprintf(buf, "<TR %s><TH>%s</TH><TD ALIGN=RIGHT>%s</TD><TD ALIGN=RIGHT>%s</TD></TR>\n",
	      getRowColor(), list->flowName,
	      formatPkts(list->packets),
	      formatBytes(list->bytes, (short)webMode));
      sendString(buf);
      list = list->next;
    }
    sendString("</TABLE></CENTER>");
  } else {
    sendString("<CENTER><P><i>No Network Flows have been defined (see <A HREF=ntop.html>man</A> page)</i></CENTER>\n");
  }
}

/* ************************* */

#ifdef MULTITHREADED
void* handleCursesRefresh(void* notUsed) {
  unsigned int totalSleep = 0;

  for(;;) {    
    while(totalSleep < refreshRate) {
      sleep(1);
      totalSleep++;

      while(checkKeyPressed() && (!printingUsage)) {
	printHostsTraffic(0, 0, 0, 0);
	totalSleep = 0;
      }
    }

    if(!printingUsage) {
      printHostsTraffic(0, 0, 0, 0);
    }

    totalSleep = 0;
  }
}
#endif
