/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <setjmp.h>
#include "main.h"

extern void accs(int, int, char *);
extern void signal_handling(int);
extern void sending(client_type *);
extern void client_filter_programm(void *);
extern void free_memory(void);
extern void set_tty(int);
extern int get_login_and_hostname(char *, int *);
extern jmp_buf lenv;
extern int check_version(char *, char *);
extern short get_var_from_pftprc(FILE *, const char *, char *, int);
int reply_from_server(int);

/*
 * Client--This is the client part of pftp.
 */
void Client(int portn, client_type *clientstr)
{
   char str[LONAME];
   int i=(int) (*statstr)->_OPTIONS_, len=0;

   clientstr->argc -= ((int) (*statstr)->_OPTIONS_ - (int) (*statstr)->_STANDARD_INPUT_);
   clientstr->print_wait = 0;

   /*
    * Showing percentage is not supported for STDIN.
    */
   if ((*statstr)->_STANDARD_INPUT_ || !slfp) (*statstr)->show_percent = 0;

   /*
    * Set error log file.
    */
   if (!pftplog) {
      char *tmp=NULL;
      if ((tmp = getenv("PFTPLOG"))) {
         char *val=tmp;
         for (tmp++; *tmp && *tmp != ' ' && *tmp != '\t'; tmp++);
         *tmp = '\0';
         if (*val) {
            MEM_CHECK((pftplog = (char *) calloc(SONAME, sizeof(char))));
            strcpy(pftplog, val);
         }
      }
   }

   /*
    * Initialize signal handling.
    */
   signal_handling((SET_SIG_CLIENT | SET_CLIENT_HANDLER | SET_SIGNALS));

   /*
    * Next, we need to look up the network
    * address of the remote host.
    */
   if (!(*statstr)->_HOSTNAME_) {
      MEM_CHECK(((*statstr)->_HOSTNAME_ = (char *)calloc(SONAME, sizeof(char))));
      strcpy((*statstr)->_HOSTNAME_, *((clientstr->argv)+i));
      if (get_login_and_hostname((*statstr)->_HOSTNAME_, &portn)) {
         if (slfp) fprintf(slfp, "** You entered an invalid hostname.\n");
         exit(PFTP_INVHOST_ERR);
      }
   }
   clientstr->argv += i + 1;

   /*
    * Get a socket and set options on it.
    * Eventually connect the remote host.
    */
   accs(0, portn, NULL);   

   if (s) {
      /*
       * See if the server sends an id.
       */
      if (!(*statstr)->use_udp) {
         (*statstr)->ns = dup(s);
         (*statstr)->ws = dup(s);
         signal_handling(SET_SIG_ALARM);
         if (!setjmp(lenv)) {
            char *tmp=NULL, ch[1];
            int ii=0;

            if ((*statstr)->_PFTP_DAEMON_ & BIT_TWO) alarm(27);
            else if ((*statstr)->_PFTP_DAEMON_) alarm(13);
            else alarm(7);
            for (ii=0; ii < 2; ii++) {
               for (tmp=str; (len=recv((*statstr)->ns, ch, 1, 0)) > 0 && *ch != '\n'; tmp++) {
                  *tmp = *ch;
               }
               *tmp = 0;
               if (len > 0) {
                  if (!i) alarm(0);
                  for (tmp=str; *tmp && *tmp != '\n'; tmp++);
                  *tmp = '\0';
                  if (strlen(str) > 4 && *(str+4) == ' ') {
                     *(str+4) = '\0';
                     if (!strcmp(str, "PFTP")) {
                        MEM_CHECK(((*statstr)->version = (char *)calloc(SONAME, sizeof(char))));
                        strcpy((*statstr)->version, str+5);
                     }
                     else if (!strcmp(str, "STAT")) {
                        MEM_CHECK(((*statstr)->sstatus = (char *)calloc(SONAME, sizeof(char))));
                        strcpy((*statstr)->sstatus, str+5);
                     }
                  }
               }
               else if (len < 0) {
                  if (slfp) fprintf(slfp, "** recv: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_CONNECTION_ERR);
               }
            }
            if (!(*statstr)->sstatus || !(*statstr)->version) {
               if (slfp) fprintf(slfp, "** Unable to connect to %s: Connection refused\n", \
                  (*statstr)->_HOSTNAME_);
               exit(PFTP_CONNECTION_ERR);
            }
         }
         else {
            if (slfp) fprintf(slfp, "** Unable to connect to %s: Connection timed out\n", \
               (*statstr)->_HOSTNAME_);
            exit(PFTP_TIMEOUT_ERR);
         }
         signal_handling((SET_SIG_ALARM | IGN_SIGNAL));

         /*
          * Check if a daemon is running on remote site.
          */
         if ((*statstr)->_PFTP_DAEMON_) {
            if (!strcmp((*statstr)->sstatus, "server")) {
               if (slfp && !((*statstr)->QT_FRONTEND)) {
                  fprintf(slfp, "** There is a server running on the remote site.\n");
               }
               exit(PFTP_NO_DAEMON_ERR);
            }
         }
         /*
          * Check if a server is running on remote site.
          */
         else if (strcmp((*statstr)->sstatus, "server")) {
            if (slfp && !((*statstr)->QT_FRONTEND)) {
               fprintf(slfp, "** There is a daemon running on the remote site.\n");
            }
            exit(PFTP_NO_SERVER_ERR);
         }

         /*
          * Check if remote server supports setting
          * file and directory information.
          */
         if (!(*statstr)->send_file_info) {
            if (get_var_from_pftprc((FILE *)NULL, "PFTPSINFO", str, 0)) {
               (*statstr)->send_file_info = atoi(str)? 1: 0;
            }
         }
         if ((*statstr)->send_file_info) {
            if (!check_version((*statstr)->version, "1.1.1")) {
               if (slfp && (*statstr)->verbose) {
                  fprintf(slfp, "** The server doesn't support `-I'.\n");
               }
               (*statstr)->send_file_info = 0;
            }
         }

         /*
          * If sending data to the daemon get the user name.
          */
         if ((*statstr)->_PFTP_DAEMON_) {
            int ll=0;
            char *username=NULL;
            if (*((*statstr)->rlogin)) username = (*statstr)->rlogin;   
            else {
#if defined Linux
               if ((*statstr)->ttys) {
                  signal_handling((SET_SIG_SIGIO | IGN_SIGNAL));
                  set_tty(0);
               }
#endif
               MEM_CHECK((username = (char *)calloc(SONAME, sizeof(char))));
               fprintf(stderr, "Username: "); fgets(username, SONAME, stdin);
               for (ll=0; *(username+ll); ll++) {
                  if (*(username+ll) == '\n') *(username+ll) = '\0';
               }
#if defined Linux
               if ((*statstr)->ttys && !(*statstr)->_STANDARD_INPUT_) {
                  signal_handling((SET_SIG_CLIENT | SET_CLIENT_HANDLER | SET_SIGNALS));
                  set_tty(2);
               }
#endif
            }
            if (*((*statstr)->from)) {
               sprintf(str, "USER %s\nFROM %s\nPROG %d\nGOON 1\n",
               username, (*statstr)->from, (*statstr)->usefilter);
            }
            else {
               sprintf(str, "USER %s\nPROG %d\nGOON 1\n",
               username, (*statstr)->usefilter);
            }
            len = strlen(str);
            if (write((*statstr)->ws, str, len) < 0) {
               if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_WRITETONET_ERR);
            }

            /*
             * Wait for the daemon/inetd server to be ready.
             */
            *str = 0;
            len = read((*statstr)->ns, str, SONAME);
            *(str+4) = '\0';
            if (len < 0 || strcmp(str, "COME")) {
               if (slfp) fprintf(slfp, "** The server doesn't answer to the request.\n");
               exit(PFTP_NO_ANSWER_ERR);
            }
         }
      }
      else (*statstr)->usefilter = 0;

      /*
       * Enter process of sending.
       */
      if ((*statstr)->usefilter) {
         /*
          * Send the file data into the filter program.
          */
         client_filter_programm((void *)clientstr);
      }
      else {
         (*statstr)->fd = (*statstr)->ws;
         /*
          * Actually send the files.
          */
         sending(clientstr);

         /*
          * Reset signals.
          */
         signal_handling((SET_SIG_CLIENT | DFL_SIGNAL | SET_SIGNALS));

         if (!(*statstr)->use_udp) {
            if (!(*statstr)->_STANDARD_INPUT_) {
               write((*statstr)->fd, "0 -1 0\nB", 8);
            }
            close((*statstr)->fd);
         }
      }

      if (!(*statstr)->_STANDARD_INPUT_ && !(*statstr)->use_udp) {
         int error_code=0;
         /*
          * Wait for reply from server.
          */
         if ((error_code = reply_from_server(clientstr->print_wait))) {
            if (clientstr) free(clientstr);
            free_memory();
            if (slfp) fputc('\n', slfp);
            exit(error_code);
         }
         free((*statstr)->sstatus);
         free((*statstr)->version);
      }
      shutdown(s, 2);
   }
   if (clientstr) free(clientstr);
   free_memory();
   if (slfp) fputc('\n', slfp);
}


int reply_from_server(int ok)
{
   char str[SONAME], *tmp=NULL;

   signal_handling(SET_SIG_ALARM);
   memset(str, 0, SONAME);
   if (slfp) fflush(slfp);
   if (!setjmp(lenv)) {
      alarm(60);
      if (ok && slfp) {
          if (!((*statstr)->QT_FRONTEND)) {
             if ((*statstr)->ttys) fprintf(slfp, "* Please wait ...\r");
          }
          else fprintf(stdout, "WAIT\n");
      }
      if (read((*statstr)->ns, str, SONAME)) {
         if (!*str) read((*statstr)->ns, str, SONAME);
         alarm(0);
         for (tmp=str; *tmp && *tmp != '\n'; tmp++);
         *tmp = '\0';
         *(str+4)='\0';
         if (!strcmp("OKAY", str)) {
            if (!(*statstr)->QT_FRONTEND) {
               if (slfp) fprintf(slfp, "%s.\n", str+5);
            }
            else if (slfp) fprintf(stdout, "OKAY\n");
         }
         else if (!strcmp("ERRO", str)) {
            if (!(*statstr)->QT_FRONTEND) {
               if (slfp) fprintf(slfp, "\n%s", str+5);
            }
            else if (slfp) fputs(str+5, slfp);
            return PFTP_REMOTE_ERR;
         }
      }
      else {
         if (slfp) fprintf(slfp, "\n** The server does not respond.\n");
         return PFTP_RESPONSE_ERR;
      }
   }
   else {
      if (slfp) fprintf(slfp, "** Connection timed out.\n");
      return PFTP_TIMEOUT_ERR;
   }
   return PFTP_NO_ERR;
}
