/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#if defined HAVE_LIBCRYPT && !defined HP_UX && !defined FreeBSD
#include <crypt.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#include <setjmp.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#ifdef HAS_SHADOW_PASSWD
#include <shadow.h>
#endif
#include "main.h"

extern char *time_string(void);
extern char *get_alias_user(char *, int);
extern int wait_for_data(int);
extern short mycmp(char *, char *);
short get_login_vars(int);


short check_login(int strnum)
{
   struct passwd *tmp_un=NULL;
#ifdef HAS_SHADOW_PASSWD
   struct spwd *tmp_spwd=NULL;
#endif

   /*
    * Send status to the client.
    */
   if ((*statstr)->_PFTP_DAEMON_ & BIT_ONE) {
      if (write((*(statstr+strnum))->ws, "STAT daemon\n", 12) < 0) return 0;
   }
   else {
      if (write((*(statstr+strnum))->ws, "STAT inetd server\n", 18) < 0) return 0;
   }

   /*
    * Read user name and filter id from client.
    */
   if (!get_login_vars(strnum)) {
      *((*(statstr+strnum))->REMOTEHOSTNAME) = '\0';
      if (slfp) fflush(slfp);
      return 0;
   }

   /*
    * Get entry from /etc/passwd.
    */
   if (!(tmp_un = getpwnam((*(statstr+strnum))->rlogin))) {
      if (slfp && *((*(statstr+strnum))->rlogin)) {
         fprintf(slfp, "%s Unknown user `%s' from %s\n", \
         time_string(), (*(statstr+strnum))->rlogin, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      return 0;
   }
#ifdef HAS_SHADOW_PASSWD
   if (!getuid()) {
      if (!(tmp_spwd = getspnam((*(statstr+strnum))->rlogin))) {
         if (slfp) {
            fprintf(slfp, "%s Unknown user `%s' from %s\n", \
            time_string(), (*(statstr+strnum))->rlogin, (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         return 0;
      }
   }
#endif
   if (slfp) {
      if (*((*(statstr+strnum))->from)) {
         fprintf(slfp, "%s %s@%s to %s\n", \
         time_string(), (*(statstr+strnum))->from, \
         (*(statstr+strnum))->REMOTEHOSTNAME, (*(statstr+strnum))->rlogin);
      }
      else {
         fprintf(slfp, "%s %s login from %s\n", \
         time_string(), (*(statstr+strnum))->rlogin, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
   }

   /*
    * Save encrypted password, uid, gid, and
    * home directory in statstr[strnum].
    */
#ifdef HAS_SHADOW_PASSWD
   if (tmp_spwd) {
      strcpy((*(statstr+strnum))->pw_passwd, tmp_spwd->sp_pwdp);
   }
#else
   strcpy((*(statstr+strnum))->pw_passwd, tmp_un->pw_passwd);
#endif
   strcpy((*(statstr+strnum))->pw_name, tmp_un->pw_name);
   strcpy((*(statstr+strnum))->pw_dir, tmp_un->pw_dir);
   strcpy((*(statstr+strnum))->cwd, (*(statstr+strnum))->pw_dir);
   (*(statstr+strnum))->cwd_last_ch = \
   (*(statstr+strnum))->cwd + strlen((*(statstr+strnum))->cwd);
   if (*((*(statstr+strnum))->cwd_last_ch - 1) != '/') {
      *((*(statstr+strnum))->cwd_last_ch) = '/';
      (*(statstr+strnum))->cwd_last_ch++;
   }
   (*(statstr+strnum))->pw_uid = tmp_un->pw_uid;
   (*(statstr+strnum))->pw_gid = tmp_un->pw_gid;

   /*
    * Deny root login if pftpnoroot is set.
    */
   if (pftpnoroot && !((*(statstr+strnum))->pw_uid)) {
      send((*(statstr+strnum))->ws, PFTP_ROOT_DENIED, PFTP_ROOT_DENIED_LEN, MSG_OOB);
      if (slfp) {
         fprintf(slfp, "%s Login as root from %s denied\n", \
         time_string(), (*(statstr+strnum))->REMOTEHOSTNAME);
      }
      *((*(statstr+strnum))->REMOTEHOSTNAME) = '\0';
      return 0;
   }
   /*
    * Get name of resource file.
    */
   if (((*(statstr+strnum))->pw_uid)) {
      strcpy((*(statstr+strnum))->home, (*(statstr+strnum))->pw_dir);
      strcat((*(statstr+strnum))->home, PFTPRESOURCE);
   }
   else strcpy((*(statstr+strnum))->home, PFTPSYSTEMRC);

   return 1;
}


short get_login_vars(int strnum)
{
   char *tmp=NULL;
   char str[SONAME], ch[1];
   int h=0, ns=(*(statstr+strnum))->ns;
   int goon=0;

   do {
      memset(str, 0, SONAME);
      if (!wait_for_data(ns)) {
         if (slfp) {
            fprintf(slfp, "%s Time out for %s\n", time_string(), \
            (*(statstr+strnum))->REMOTEHOSTNAME);
            fflush(slfp);
         }
         *((*(statstr+strnum))->REMOTEHOSTNAME) = '\0';
         return 0;
      }
      for (h=0, tmp=str; h < SONAME && read(ns, ch, sizeof(ch)); h++, tmp++) {
         *tmp = *ch;
         if (*tmp == '\n') break;
      }
      if (*tmp != '\n') return 0;
      *tmp = '\0';
      if (!*str) return 0;
#ifdef _PFTP_DEBUG_
      /* 
       * Just for debugging
       */
      if (slfp) {
         fprintf(slfp, "%s\n", str);
         fflush(slfp);
      }
#endif
      if ((strlen(str) < 6 || *(str+4) != ' ')) {
         if (slfp) {
            fprintf(slfp, "%s Wrong protocol from %s\n", time_string(), \
            (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         return 0;
      }

      /*
       * Setting prot.
       */
      *(str+4) = '\0';
      if (!mycmp(str, "USER")) {
         strcpy((*(statstr+strnum))->rlogin, get_alias_user(str+5, strnum));

      }
      else if (!mycmp(str, "FROM")) {
         strcpy((*(statstr+strnum))->from, str+5); 
      }
      else if (!mycmp(str, "PROG")) (*(statstr+strnum))->usefilter = atoi(str+5);
      else if (!mycmp(str, "GOON")) goon=1;
   } while (!goon);
   return 1;
}
