#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::get_node_stats( char *node,
                             int *groupsp, int *messagesp, int *unseenp,
                             int *requestedp, int *headersp )
{
   if ( !total_nodes )
   {
      strcpy( error_message, "NP_Tree: get_node_stats(): no nodes have been"
              " added to this tree object." );
      return 1;
   }

   if ( node == NULL )
   {
      strcpy( error_message, "NP_Tree: get_node_stats(): NULL node name "
              "passed as argument." );
      return 1;
   }

   NP_Node **pointer = nodes;
   int i;
   for( i = 0; i < total_nodes; ++i )
   {
      if ( !strcmp( ( *pointer )->get_name(), node ))
         break;
      ++pointer;
   }

   if ( i == total_nodes )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Tree: get_node_stats(): no such node has been added to "
                "this tree object: %s", node );
      return 1;
   }

   int groups, messages, unseen, requested, headers;
   if ( ( *pointer )->get_stats( &groups, &messages, &unseen, &requested,
                                 &headers ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: "
                "get_nodes_stats(): %s", ( *pointer )->get_error());
      return 1;
   }

   if ( groupsp != NULL )
      *groupsp = groups;

   if ( messagesp != NULL )
      *messagesp = messages;

   if ( unseenp != NULL )
      *unseenp = unseen;

   if ( requestedp != NULL )
      *requestedp = requested;
   
   if ( headersp != NULL )
      *headersp = headers;

   return 0;
}
