#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>

#include "next_article.xpm"
#include "prev_article.xpm"
#include "next_unread.xpm"
#include "prev_unread.xpm"
#include "prev_full.xpm"
#include "next_full.xpm"
#include "next_header.xpm"
#include "prev_header.xpm"
#include "next_request.xpm"
#include "prev_request.xpm"

#include "npsummary.h"

void signal_handler( int signo )
{
   _exit( signo );
}

void *summary_p;

NP_Summary::NP_Summary( int argc, char **argv )
{
   summary_p = this;
   button = reading = 0;
   text_pid = compose_pid = 0;
   list_onscreen = text_line = ordinal = 0;
   input = output = NULL;
   group_label = NULL;
   positions = NULL;
   items = NULL;
   total = headers = unseen = requested = hide_seen = hide_headers = 0;
   tree = current_node = spool_beginning = NULL;

   if ( argc < 5 )
   {
      fprintf( stderr, "npsummary: usage <server.address> <group name> "
         "<article to select or 0> <line number to highlight or -1>\n" );
      exit( 1 );
   }

   if (( server = strdup( argv[ 1 ] )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if (( group = strdup( argv[ 2 ] )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   int spool_position = atoi( argv[ 3 ] );
   text_line = atoi( argv[ 4 ] );
      
   gtk_init( &argc, &argv );

   SIGPIPE_received = 0;

   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );
   signal( SIGCHLD, SIGCHLD_handler );
   signal( SIGUSR1, SIGUSR1_handler );
   signal( SIGUSR2, SIGUSR2_handler );
   signal( SIGPIPE, SIGPIPE_handler );
   signal( SIGSEGV, signal_handler );

   home = getenv( "HOME" );

   if ( !( is_stdout_a_tty = isatty( STDOUT_FILENO )))
   {
      char buffer[ 1024 ], second_buffer[ 128 ];
      snprintf( buffer, sizeof buffer, "%s/.npsummary:pid", home );
      FILE *file;
      if (( file = fopen( buffer, "r" )) != NULL )
      {
         if ( fgets( second_buffer, sizeof second_buffer, file ) == NULL )
            exit( 0 );

         fclose( file );

         pid_t pid = atoi( second_buffer );
         if ( !( pid > 0 && kill( pid, SIGUSR2 ) && errno == ESRCH ))
            exit( 0 );
      }

      if (( file = fopen( buffer, "w" )) == NULL )
      {
         perror( "fopen" );
         exit( 1 );
      }
      fprintf( file, "%d", getpid() );
      fclose( file );
   }

   // Window 

   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_widget_realize( window );
   gtk_window_set_policy( GTK_WINDOW( window ), TRUE, TRUE, TRUE );
   gtk_container_border_width( GTK_CONTAINER( window ), 10 );

   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( exit_button_callback ), NULL );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( exit_button_callback ), NULL );
   gtk_window_set_title( GTK_WINDOW( window ),
                         "News Peruser Newsgroup Summary" );

   // Styles

   GdkColor header_col = { 0, 0xcc00, 0, 0 };
   GdkColor header_select_col = { 0, 0xffff, 0, 0 };
   GdkColor request_col = { 0, 0, 0xaa00, 0 };
   GdkColor request_select_col = { 0, 0, 0xffff, 0 };
   GdkColor dummy_col = { 0, 0, 0, 0xcc00 };
   GdkColor light_dummy_col = { 0, 0x0c00, 0xcc00, 0xff00 };

   header_style = gtk_style_copy( GTK_WIDGET( window )->style );
   header_style->fg[ GTK_STATE_NORMAL ] = header_col;
   header_style->fg[ GTK_STATE_SELECTED ] = header_select_col;

   request_style = gtk_style_copy( GTK_WIDGET( window )->style );
   request_style->fg[ GTK_STATE_NORMAL ] = request_col;
   request_style->fg[ GTK_STATE_SELECTED ] = request_select_col;

   unread_request_style = gtk_style_copy( request_style );
   unread_request_style->font =
      gdk_font_load( "-*-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*" );
   if ( unread_request_style->font == NULL )
      unread_request_style->font = gdk_font_load( "fixed" );

   read_style = gtk_style_copy( GTK_WIDGET( window )->style );

   unread_style = gtk_style_copy( GTK_WIDGET( window )->style );
   gdk_font_unref( unread_style->font );
   unread_style->font =
      gdk_font_load( "-*-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*" );
   if ( unread_style->font == NULL )
      unread_style->font = gdk_font_load( "fixed" );

   gdk_font_ref( unread_style->font );

   unread_header_style = gtk_style_copy( unread_style );
   unread_header_style->fg[ GTK_STATE_NORMAL ] = header_col;
   unread_header_style->fg[ GTK_STATE_SELECTED ] = header_select_col;

   dummy_style = gtk_style_copy( header_style );
   dummy_style->fg[ GTK_STATE_NORMAL ] = dummy_col;
   dummy_style->fg[ GTK_STATE_SELECTED ] = light_dummy_col;
   unread_dummy_style = gtk_style_copy( dummy_style );
   unread_dummy_style->font =
      gdk_font_load( "-*-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*" );
   if ( unread_dummy_style->font == NULL )
      unread_dummy_style->font = gdk_font_load( "fixed" );

   GtkWidget *vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( vbox );
   gtk_container_add( GTK_CONTAINER( window ), vbox );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

   table = gtk_table_new( 40, 40, FALSE );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_widget_show( table );
   gtk_container_add( GTK_CONTAINER( frame ), table );

   gtk_table_set_row_spacing( GTK_TABLE( table ), 38, 5 );

   scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll ),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC );
   gtk_table_attach_defaults( GTK_TABLE( table ), scroll, 0, 40, 1, 38 );

   adjustment = gtk_range_get_adjustment( 
         GTK_RANGE( GTK_SCROLLED_WINDOW( scroll )->vscrollbar ));

   tree_widget = NULL;

   GtkTooltips *tooltips = gtk_tooltips_new();

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( vbox ), hbox , FALSE, FALSE, 0 );
   gtk_widget_set_usize( hbox, 480, 5 );

   hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_widget_set_usize( hbox, 480, 27 );
   gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );

   /* left red */

   left_red_button = gtk_button_new();
   gtk_widget_show( left_red_button );
   gtk_signal_connect( GTK_OBJECT( left_red_button ), "clicked",
                       GTK_SIGNAL_FUNC( left_red_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), left_red_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, left_red_button,
                         "Step the selection backward to the previous "
                         " headers-only message in the list, if there is"
                         " one, skipping over "
                         "full articles.", NULL );

   GtkStyle *style = gtk_widget_get_default_style();
   GdkBitmap *mask;
   GdkPixmap *pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_header_xpm );
   prev_header_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_header_wid );
   gtk_container_add( GTK_CONTAINER( left_red_button ), prev_header_wid );

   /* left green */

   left_green_button = gtk_button_new();
   gtk_widget_show( left_green_button );
   gtk_signal_connect( GTK_OBJECT( left_green_button ), "clicked",
                       GTK_SIGNAL_FUNC( left_green_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), left_green_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, left_green_button,
                         "Step the selection backward to the previous "
                         " requested headers-only message in the list, if "
                         "there is one, skipping over "
                         "full articles.", NULL );

   pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_request_xpm );
   prev_request_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_request_wid );
   gtk_container_add( GTK_CONTAINER( left_green_button ), prev_request_wid );

   /* left grey */

   left_grey_button = gtk_button_new();
   gtk_widget_show( left_grey_button );
   gtk_signal_connect( GTK_OBJECT( left_grey_button ), "clicked",
                       GTK_SIGNAL_FUNC( left_grey_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), left_grey_button, TRUE, TRUE, 5 );
   gtk_tooltips_set_tip( tooltips, left_grey_button,
                         "Step the selection backward to the previous "
                         " article in the list, skipping over messages that"
                         " consist of headers only.", NULL );

   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_article_xpm );
   prev_article_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_article_wid );
   gtk_container_add( GTK_CONTAINER( left_grey_button ), prev_article_wid );


   /* left black */

   left_button = gtk_button_new();
   gtk_widget_show( left_button );
   gtk_signal_connect( GTK_OBJECT( left_button ), "clicked",
                       GTK_SIGNAL_FUNC( left_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), left_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, left_button,
                         "Step the selection backward to the"
                         " previous message in list.", NULL );

   pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_full_xpm );
   prev_full_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_full_wid );
   gtk_container_add( GTK_CONTAINER( left_button ), prev_full_wid );

   /* double arrow */

   down_button = gtk_button_new();
   gtk_widget_show( down_button );
   gtk_signal_connect( GTK_OBJECT( down_button ), "clicked",
                       GTK_SIGNAL_FUNC( down_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), down_button, TRUE, TRUE, 0 );
   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_unread_xpm );
   prev_unread_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_unread_wid );
   gtk_container_add( GTK_CONTAINER( down_button ), prev_unread_wid );
   gtk_tooltips_set_tip( tooltips, down_button,
                         "Step the selection backward to the previous "
                         "unseen messsage in the list, if there is one.",
                         NULL );

   up_button = gtk_button_new();
   gtk_widget_show( up_button );
   gtk_signal_connect( GTK_OBJECT( up_button ), "clicked",
                       GTK_SIGNAL_FUNC( up_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), up_button, TRUE, TRUE, 0 );

   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_unread_xpm );
   next_unread_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_unread_wid );
   gtk_container_add( GTK_CONTAINER( up_button ), next_unread_wid );
   gtk_tooltips_set_tip( tooltips, up_button,
                         "Step the selection forward to the next unseen "
                         "message in the list, if there is one.",
                         NULL );

   /* right black */

   right_button = gtk_button_new();
   gtk_widget_show( right_button );
   gtk_signal_connect( GTK_OBJECT( right_button ), "clicked",
                       GTK_SIGNAL_FUNC( right_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), right_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, right_button,
                         "Step the selection forward to the next message in "
                         "the list.", NULL );

   pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_full_xpm );
   next_full_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_full_wid );
   gtk_container_add( GTK_CONTAINER( right_button ), next_full_wid );

   /* right grey */

   right_grey_button = gtk_button_new();
   gtk_widget_show( right_grey_button );
   gtk_signal_connect( GTK_OBJECT( right_grey_button ), "clicked",
                       GTK_SIGNAL_FUNC( right_grey_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), right_grey_button, TRUE, TRUE, 5 );

   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_article_xpm );
   next_article_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_article_wid );
   gtk_container_add( GTK_CONTAINER( right_grey_button ), next_article_wid );
   gtk_tooltips_set_tip( tooltips, right_grey_button,
                         "Step the selection forward to the next "
                         "article in the list, skipping over messages that "
                         " consist of headers only.", NULL );
   /* right green */

   right_green_button = gtk_button_new();
   gtk_widget_show( right_green_button );
   gtk_signal_connect( GTK_OBJECT( right_green_button ), "clicked",
                       GTK_SIGNAL_FUNC( right_green_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), right_green_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, right_green_button,
                         "Step the selection forward to the next "
                         " requested headers-only message in the list, if "
                         "there is one, skipping over "
                         "full articles.", NULL );

   pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_request_xpm );
   next_request_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_request_wid );
   gtk_container_add( GTK_CONTAINER( right_green_button ), next_request_wid );

   /* right red */

   right_red_button = gtk_button_new();
   gtk_widget_show( right_red_button );
   gtk_signal_connect( GTK_OBJECT( right_red_button ), "clicked",
                       GTK_SIGNAL_FUNC( right_red_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( hbox ), right_red_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, right_red_button,
                         "Step the selection forward to the previous "
                         " headers-only message in the list, if there is"
                         " one, skipping over "
                         "full articles.", NULL );

   pixmap = 
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_header_xpm );
   next_header_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_header_wid );
   gtk_container_add( GTK_CONTAINER( right_red_button ), next_header_wid );


   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 20, 39, 40 );

   compose_button = gtk_button_new_with_label( " Compose " );
   gtk_widget_show( compose_button );

   gtk_signal_connect( GTK_OBJECT( compose_button ), "pressed",
         GTK_SIGNAL_FUNC( compose_button_callback ), this );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               compose_button, NULL,
                               "Launch the News Peruser Message Composition"
                               " program, to create an original message "
                               "for group.", NULL, NULL,
                               NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   GtkWidget *menu = gtk_menu_new();

   mark_menu = menu;

   GtkWidget *menu_item =
      gtk_menu_item_new_with_label( " Mark Current Seen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )0 );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_current_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), menu_item );

   menu_item = gtk_menu_item_new_with_label( " Mark Current Unseen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )1 );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_current_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   
   menu_item = gtk_menu_item_new_with_label( " Mark Thread Seen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )0 );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_thread_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), menu_item );

   menu_item = gtk_menu_item_new_with_label( " Mark Thread Unseen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )1 );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_thread_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   
   menu_item = gtk_menu_item_new_with_label( " Mark All Seen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )0 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_all_callback ), this );

   menu_item = gtk_menu_item_new_with_label( " Mark All Unseen " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "seen", ( gpointer )1 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( mark_all_callback ), this );
   
   mark_button = gtk_button_new_with_label( " Mark " );
   gtk_signal_connect_object( GTK_OBJECT( mark_button ), "clicked",
                              GTK_SIGNAL_FUNC( mark_button_callback ),
                              GTK_OBJECT( menu ));
   
   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 20, 39, 39, 40);
   
   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               mark_button, NULL,
                               "Mark selected messages as seen or unseen."
                               " This menu is also popped up by pressing"
                               " the middle mouse button over an item in "
                               "the tree.",
                               NULL,
                               NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );
   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));
                             
   request_menu = menu = gtk_menu_new();

   menu_item = gtk_menu_item_new_with_label( " Request Current " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer )1 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_current_callback ), this );
   
   menu_item = gtk_menu_item_new_with_label( " Unrequest Current " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer )0 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_current_callback ), this );

   menu_item = gtk_menu_item_new_with_label( " Request Thread " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer )1 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_thread_callback ), this );
   
   menu_item = gtk_menu_item_new_with_label( " Unrequest Thread " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer)0 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_thread_callback ), this );

   menu_item = gtk_menu_item_new_with_label( " Request All " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer )1 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_all_callback ), this );

   menu_item = gtk_menu_item_new_with_label( " Unrequest All " );
   gtk_widget_show( menu_item );
   gtk_object_set_data( GTK_OBJECT( menu_item ), "request", ( gpointer )0 );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( request_all_callback ), this );

   request_button = gtk_button_new_with_label( " Un/Request " );
   gtk_signal_connect_object( GTK_OBJECT( request_button ), "clicked",
                              GTK_SIGNAL_FUNC( request_button_callback ),
                              GTK_OBJECT( menu ));

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               request_button, NULL,
                               "Request full article text of selected"
                               " header-only messages for future downloading."
                               " This menu is also popped up by"
                               " double-clicking the left"
                               " mouse button over an entry in the tree. "
                               "You can toggle the requested status of the "
                               "currently-selected header, on and off, with a "
                               "single-click of the right mouse button over "
                               "the corresponding item int the tree.",
                               NULL,
                               NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " File ",
                            "Place a copy of the currently-selected message "
                            "into a Folder.", NULL, NULL,
                            GTK_SIGNAL_FUNC( file_button_callback ), this );
   
   menu = gtk_menu_new();

   menu_item = gtk_menu_item_new_with_label( " Current " );
   gtk_widget_show( menu_item ); gtk_menu_append( GTK_MENU( menu ),
   menu_item ); gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( remove_current_callback ), this );
   
   menu_item = gtk_menu_item_new_with_label( " All " );
   gtk_widget_show( menu_item );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( remove_all_callback ), this );

   remove_button = gtk_button_new_with_label( " Delete " );
   gtk_signal_connect_object( GTK_OBJECT( remove_button ), "clicked",
                              GTK_SIGNAL_FUNC( remove_button_callback ),
                              GTK_OBJECT( menu ));

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               remove_button, NULL,
                               "Remove selected messages from the group.",
                               NULL, NULL, NULL,
                               NULL, GTK_TOOLBAR( toolbar )->num_children );

   menu = gtk_menu_new();

   menu_item = gtk_menu_item_new();
   seen_label = gtk_label_new( " Hide Seen " );
   gtk_widget_show( seen_label );
   gtk_container_add( GTK_CONTAINER( menu_item ), seen_label );
   gtk_widget_show( menu_item );
   gtk_menu_append( GTK_MENU( menu ), menu_item );
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( hide_seen_callback ), this );

   menu_item = gtk_menu_item_new();
   headers_label = gtk_label_new( " Hide Headers " );
   gtk_widget_show( headers_label );
   gtk_container_add( GTK_CONTAINER( menu_item ), headers_label );
   gtk_widget_show( menu_item ); 
   gtk_menu_append( GTK_MENU( menu ), menu_item ); 
   gtk_signal_connect( GTK_OBJECT( menu_item ), "activate",
                       GTK_SIGNAL_FUNC( hide_headers_callback ), this );

   hide_button = gtk_button_new_with_label( " Show/Hide " );
   gtk_signal_connect_object( GTK_OBJECT( hide_button ), "clicked",
                              GTK_SIGNAL_FUNC( hide_button_callback ),
                              GTK_OBJECT( menu ));

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));
   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET,
                               hide_button, NULL,
                               "Disable or enable the display of "
                               "selected messages.",
                               NULL, NULL, NULL,
                               NULL, GTK_TOOLBAR( toolbar )->num_children );
   
   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 39, 40, 39, 40 );

   // font button and menu 

   font_menu = gtk_menu_new();

   first_item = gtk_menu_item_new_with_label( " Small " );
   gtk_widget_show( first_item );
   gtk_object_set_data( GTK_OBJECT( first_item ), "font", ( gpointer)0 );
   gtk_signal_connect( GTK_OBJECT( first_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( font_menu ), first_item );

   second_item = gtk_menu_item_new_with_label( " Medium " );
   gtk_widget_show( second_item );
   gtk_object_set_data( GTK_OBJECT( second_item ), "font", ( gpointer)1 );
   gtk_signal_connect( GTK_OBJECT( second_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( font_menu ), second_item );

   third_item = gtk_menu_item_new_with_label( " Large " );
   gtk_widget_show( third_item );
   gtk_object_set_data( GTK_OBJECT( third_item ), "font" , ( gpointer)2 );
   gtk_signal_connect( GTK_OBJECT( third_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( font_menu ), third_item );

   font_button = gtk_button_new_with_label( " Fonts " );
   gtk_widget_show( font_button );
   gtk_object_set_data( GTK_OBJECT( font_button ), "object", this );
   gtk_signal_connect_object( GTK_OBJECT( font_button ), "clicked",
                              GTK_SIGNAL_FUNC( fonts_button_callback ),
                              GTK_OBJECT( font_menu ));

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ), 
                               GTK_TOOLBAR_CHILD_WIDGET,
                               font_button, NULL,
                            "Change the size of the fonts used in the tree.",
                            NULL, NULL, NULL, NULL,
                            GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " List ", 
                            "Display the contents of the current newsgroup"
                            " in a sortable list.", NULL, NULL,
                            GTK_SIGNAL_FUNC( list_button_callback ), this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Close ",
                            "Close window.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( exit_button_callback ), NULL );

   item = first_item;
   FILE *font_file;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npsummary:font", home );
   if (( font_file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( buffer, sizeof buffer, font_file ) != NULL )
      {
         switch( atoi( buffer ))
         {
            case 0:
               item = first_item;
               break;

            case 1:
               item = second_item;
               break;

            case 2:
               item = third_item;
               break;
         }
      }

      fclose( font_file );
   }

   font_menu_callback( item, this );

   if ( !strcmp( group, "FOLLOW-UPS" ) ||
         !strcmp( group, "POSTED" ) ||
         !strcmp( group, "OUTBOX" ) ||
         !strcmp( group, "SENT-MAIL" ))
   {
      gtk_widget_show( remove_button );
      gtk_widget_hide( mark_button );
      gtk_widget_hide( hide_button );
      gtk_widget_hide( request_button );
      gtk_widget_hide( compose_button );
   }
   else
   {
      if ( !strcmp( server, "Folders" ))
      {
         gtk_widget_hide( compose_button );
         gtk_widget_show( remove_button );
      }
      else
      {
         gtk_widget_show( compose_button );
         gtk_widget_hide( remove_button );
      }

      gtk_widget_show( request_button );
      gtk_widget_show( mark_button );
      gtk_widget_show( hide_button );
   }

	set_size();
   gtk_widget_show( window );

   if ( --spool_position >= 0 )
   {
      for( np_thread_node_t *pointer = spool_beginning;
            pointer != NULL;
            pointer = pointer->spool_next )
      {
         if ( pointer->ordinal == spool_position )
         {
            np_thread_node_t *old = pointer;

            while( pointer->parent != NULL )
            {
               pointer = pointer->parent;
               gtk_tree_item_expand( GTK_TREE_ITEM( pointer->item ));
            }

            button = 1;
            gtk_tree_select_child( GTK_TREE( tree_widget ), 
                  GTK_WIDGET( old->item ));
            button = 0;
            break;
         }
      }
   }

   gdk_input_add( STDIN_FILENO, GDK_INPUT_READ, input_callback, this );
      
   return;
}
