#include <string.h>
#include <errno.h>

#include "npsummary.h"

void file_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->current_node == NULL )
   {
      summary->show_message( "No message in the list is selected." );
      return;
   }

   if ( summary->current_node->is_article < 0 )
      return;
   
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-folders", getenv( "HOME" ));
   NP_File folders;
   if ( folders.openr( buffer ))
   {
      if ( errno == ENOENT )
      {
         summary->show_message( "You have not created any folders. You may "
                                "create folders by pressing the configure "
                                "button on the npcollections window." );
         return;
      }

      folders.print_error();
      return;
   }

   summary->folders_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_window_set_title( GTK_WINDOW( summary->folders_window ),
                         "News Peruser Folders" );
   gtk_widget_set_usize( summary->folders_window, 300, 300 );
   gtk_container_border_width( GTK_CONTAINER( summary->folders_window ), 10 );

   GtkWidget *frame = gtk_frame_new( "Select a folder:" );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( summary->folders_window ), frame );

   GtkWidget *table = gtk_table_new( 40, 40, FALSE );
   gtk_widget_show( table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_table_set_row_spacing( GTK_TABLE( table ), 38, 5 );

   static char *titles[] = { "Configured Folders" };
   summary->folders_clist = gtk_clist_new_with_titles( 1, titles );
   gtk_widget_show( summary->folders_clist );
   gtk_table_attach_defaults( GTK_TABLE( table ), summary->folders_clist,
                              0, 40, 0, 39 );
   gtk_signal_connect( GTK_OBJECT( summary->folders_clist ), "select_row",
                       GTK_SIGNAL_FUNC( folders_clist_callback ), data );

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_table_attach_defaults( GTK_TABLE( table ), hbox, 0, 40, 39, 40 );

   GtkWidget *button = gtk_button_new_with_label( " OK " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( folders_callback ), data );
   gtk_object_set_data( GTK_OBJECT( button ), "ok", ( gpointer )1 );
   gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );

   button = gtk_button_new_with_label( " Cancel " );
   gtk_widget_show( button );
   GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( folders_callback ), data );
   gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );

   char *line;
   gtk_clist_freeze( GTK_CLIST( summary->folders_clist ));

   while(( line = folders.get_string()) != NULL )
   {
      strtok( line, "\n" );
      gtk_clist_append( GTK_CLIST( summary->folders_clist ), &line );
   }

   folders.close();

   gtk_clist_thaw( GTK_CLIST( summary->folders_clist ));

   summary->folder_selection = -1;
   gtk_widget_show( summary->folders_window );
   gtk_grab_add( summary->folders_window );

   return;
}
