/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>

#include "common_gtk.h"
#include "mainwindow.h"
#include "globals.h"

#define TABLE_WIDTH 3

int m_o_length, m_o_s_length, m_o_t_length, h_o_length, torito_length;
int use_mkisofs = TRUE;

options mkisofs_options[] = {
	{NULL, "-R", N_("Rock Ridge"), N_("Use the Rock Ridge extensions (long filenames and other UNIX file features like ownership, etc)"), TRUE},
	{NULL, "-r", N_("Anonymous Rock Ridge"), N_("File ownership and modes are set to useful values; uid/guid set to zero, all files are set readable and write bits/special mode bits are cleared"), TRUE},
	{NULL, "-l", N_("Allow 32 char filenames"), N_("Allow  full  32  character filenames - may cause problems if disc intended for use in MS-DOS systems"), TRUE},
	{NULL, "-J", N_("Joliet extension"), N_("Generate Joliet directory records  in  addition  to regular iso9660 file names, useful if disc to be used with Win9X/NT machines (gives you long filenames)"), TRUE},
	{NULL, "-T", N_("Generate TRANS.TBL files"), N_("Generate a file TRANS.TBL in each directory on the CDROM, which can be used on non-Rock Ridge capable systems to help establish the correct file names."), FALSE}
};

options mkisofs_special_options[] = {
	{NULL, "-d", N_("Omit trailing period"), N_("Omit trailing period from files that do not have a period. Violates ISO9660."), FALSE},
	{NULL, "-D", N_("No deep directory relocation"), N_("Do not use deep directory relocation, and instead just pack them in the way we see them. Violates ISO9660."), FALSE},
	{NULL, "-L", N_("Allow files to begin with period"), N_("Usually, a leading dot is replaced with an underscore in order to maintain MS-DOS compatibility. If any of the ISO extensions are enabled, this option is ignored (and always on)."), FALSE},
	{NULL, "-N", N_("Omit version number"), N_("Omit version numbers from ISO9660 file names. Violates ISO9660"), FALSE},
	{NULL, NULL, N_("Bootable CD"), N_("Create a \"El Torito\" bootable CD, you also need to fill in the boot image and catalog bellow"), FALSE},
	{NULL, "-hide-rr-moved", N_("Hide rr_moved"), N_("Rename the directory RR_MOVED to .rr_moved in the Rock Ridge tree."), FALSE}
};

options mkisofs_text_options[] = {
	{NULL, "-V", N_("Volume id: "), N_("Specifies the volume ID to be written into the master block."), FALSE},
	{NULL, "-A", N_("Application id: "), N_("This should describe the application that will be on the disc."), FALSE},
	{NULL, "-P", N_("Publisher id: "), N_("This should describe the publisher of the CDROM, usually with a mailing address and phone number."), FALSE}
};

options mkhybrid_options[] = {
	{NULL, "-hfs", N_("HFS"), N_("Create an ISO9660/HFS hybrid CD"), FALSE},
	{NULL, "-apple", N_("apple"), N_("Create an ISO9660 CD with Apple's extensions"), FALSE},
	{NULL, "-probe", N_("probe"), N_("Search the contents of files for Apple/Unix file formats"), FALSE},
	{NULL, "-netatalk", N_("netatalk"), N_("Look for NETATALK Macintosh files"), FALSE}
};

options torito_options[] = {
	{NULL, "-b", N_("Boot image: "), N_("Specifies the path/filename of the boot image to be used, relative to the first directory added in the Data-CD frame. All files in that directory will be in the root of the cd when making a bootable cd!"), FALSE},
	{NULL, "-c", N_("Boot catalog: "), N_("Specifies the path/filename of the boot catalog to be used, relative to the first directory added in the Data-CD frame. It will quietly be overwritten if it already exists"), FALSE},
};

static GtkWidget *table;

static void torito_set_in_use(GtkWidget *widget, gpointer data) {
	int i;

	if (GTK_TOGGLE_BUTTON(mkisofs_special_options[4].widget)->active)
		for (i = 0; i < sizeof(torito_options)/sizeof(options); i++)
			gtk_widget_set_sensitive(torito_options[i].widget, FALSE);
	else
		for (i = 0; i < sizeof(torito_options)/sizeof(options); i++)
			gtk_widget_set_sensitive(torito_options[i].widget, TRUE);
}

static void mkh_deselect_hfs(GtkWidget *widget, gpointer data) {
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(mkhybrid_options[1].widget), FALSE);
}

static void mkh_deselect_apple(GtkWidget *widget, gpointer data) {
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(mkhybrid_options[2].widget), FALSE);
}

/* add the i:th check-button to it's place in the table of width TABLE_WIDTH */
static void add_checkb(int i, options op[]) {
	GtkWidget *g_button;

	g_button = gtk_check_button_new_with_label(gettext(op[i].descr));
	gtk_widget_show(g_button);
	gtk_tooltips_set_tip(tooltips, g_button, gettext(op[i].tool_tip),
			NULL);
	op[i].widget = g_button;
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(g_button), op[i].default_state);
	gtk_table_attach(GTK_TABLE(table), g_button, i%TABLE_WIDTH, 1+i%TABLE_WIDTH,
			i/TABLE_WIDTH, 1+i/TABLE_WIDTH,
			GTK_SHRINK | GTK_FILL | GTK_EXPAND, GTK_SHRINK |
			GTK_FILL | GTK_EXPAND, 0, 0);
}

static void add_entry(GtkWidget *packinto, int i, options op[]) {
	GtkWidget *label, *entry, *hbox;
	/* this might look better with a table instead... */
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(packinto), hbox, FALSE, TRUE, 0);

	label = gtk_label_new(gettext(op[i].descr));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 3);

	entry = gtk_entry_new_with_max_length(128);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 3);
	gtk_tooltips_set_tip(tooltips, entry, gettext(op[i].tool_tip),
			NULL);
	op[i].widget = entry;
}

static int set_mkhybrid_in_use(GtkWidget *widget, gpointer data) {
	int i;
	for (i = 0; i < sizeof(mkhybrid_options)/sizeof(options); i++)
		gtk_widget_set_sensitive(mkhybrid_options[i].widget, TRUE);

	use_mkisofs = FALSE;

	return FALSE;
}
static int set_mkiosfs_in_use(GtkWidget *widget, gpointer data) {
	int i;
	for (i = 0; i < sizeof(mkhybrid_options)/sizeof(options); i++)
		gtk_widget_set_sensitive(mkhybrid_options[i].widget, FALSE);

	use_mkisofs = TRUE;

	return FALSE;
}

void create_options(GtkWidget *tab) {
	int i;
	GtkWidget *vbox, *frame, *vbox2, *label, *hbox;
	GtkWidget *mk_program_option_menu;
	GtkWidget *mk_program_option_menu_menu;
	GtkWidget *glade_menuitem;

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(tab), vbox);

	/* choose mkisofs/mkhybrid */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	label = gtk_label_new(_("ISO creation program: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	mk_program_option_menu = gtk_option_menu_new();
	gtk_widget_show(mk_program_option_menu);
	gtk_box_pack_start(GTK_BOX(hbox), mk_program_option_menu, FALSE, FALSE, 0);
	mk_program_option_menu_menu = gtk_menu_new();

	glade_menuitem = gtk_menu_item_new_with_label("mkisofs");
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "button_release_event",
			GTK_SIGNAL_FUNC(set_mkiosfs_in_use), NULL);
	gtk_widget_show(glade_menuitem);
	gtk_menu_append(GTK_MENU(mk_program_option_menu_menu), glade_menuitem);

	glade_menuitem = gtk_menu_item_new_with_label("mkhybrid");
	gtk_signal_connect(GTK_OBJECT(glade_menuitem), "button_release_event",
			GTK_SIGNAL_FUNC(set_mkhybrid_in_use), NULL);
	gtk_widget_show(glade_menuitem);
	gtk_menu_append(GTK_MENU(mk_program_option_menu_menu), glade_menuitem);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(mk_program_option_menu),
			mk_program_option_menu_menu);
	gtk_tooltips_set_tip(tooltips, mk_program_option_menu, _("Choose between "
				" mkiosfs and mkhybrid for making ISO images"), NULL);

	/* option frames */
	frame = make_frame(_("General filesystem options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	table = gtk_table_new(3, TABLE_WIDTH, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	for (i = 0; i < (sizeof(mkisofs_options)/sizeof(options)); i++) {
		add_checkb(i, mkisofs_options);
	}

	frame = make_frame(_("More specialized options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	table = gtk_table_new(3, TABLE_WIDTH, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	for (i = 0; i < (sizeof(mkisofs_special_options)/sizeof(options)); i++) {
		add_checkb(i, mkisofs_special_options);
	}

	frame = make_frame(_("mkhybrid options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	table = gtk_table_new(3, TABLE_WIDTH, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	for (i = 0; i < (sizeof(mkhybrid_options)/sizeof(options)); i++) {
		add_checkb(i, mkhybrid_options);
	}
/*
	gtk_signal_connect(GTK_OBJECT(mkhybrid_options[0].widget),
			"button_release_event",
			GTK_SIGNAL_FUNC(mkh_set_in_use), 0); */
	gtk_signal_connect(GTK_OBJECT(mkhybrid_options[0].widget),
			"button_release_event",
			GTK_SIGNAL_FUNC(mkh_deselect_apple), 0);
	gtk_signal_connect(GTK_OBJECT(mkhybrid_options[1].widget),
			"button_release_event",
			GTK_SIGNAL_FUNC(mkh_deselect_hfs), 0);

/* FIXME: mkh_set_in_use() should be called here, but it won't work (maybe it
 * should be after gtk_widget_show(tab)) */
	for (i = 0; i < sizeof(mkhybrid_options)/sizeof(options); i++)
		gtk_widget_set_sensitive(mkhybrid_options[i].widget, FALSE);

	frame = make_frame(_("Name options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_container_add(GTK_CONTAINER(frame), vbox2);

	for (i = 0; i < (sizeof(mkisofs_text_options)/sizeof(options)); i++)
		add_entry(vbox2, i, mkisofs_text_options);

	frame = make_frame(_("\"El Torito\" bootable CD options"), 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_container_add(GTK_CONTAINER(frame), vbox2);

	for (i = 0; i < (sizeof(torito_options)/sizeof(options)); i++)
		add_entry(vbox2, i, torito_options);

	gtk_signal_connect(GTK_OBJECT(mkisofs_special_options[4].widget),
			"button_release_event",
			GTK_SIGNAL_FUNC(torito_set_in_use), 0);
/* FIXME: same as above */
	for (i = 0; i < sizeof(torito_options)/sizeof(options); i++)
		gtk_widget_set_sensitive(torito_options[i].widget, FALSE);

	m_o_length = sizeof(mkisofs_options);
	m_o_s_length = sizeof(mkisofs_special_options);
	m_o_t_length = sizeof(mkisofs_text_options);
	h_o_length = sizeof(mkhybrid_options);
	torito_length = sizeof(torito_options);
}
