/*
** Copyright (C) 11 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "status_text.h"
#include "common_gtk.h"
#include "mainwindow.h"
#include "globals.h"

GtkWidget *mkisofs_text, *cdrecord_text, *autoscroll_text;
GtkWidget *mkisofs_text_scrollbar, *cdrecord_text_scrollbar;
GtkWidget *status_vbox;

/* scrolls down the text in the textboxes - the caller needs to
 * take care of freeze/thaw if it's wanted
 */
void scroll_down_text(GtkWidget *text, GtkWidget *scrollbar) {
	GtkAdjustment *adj;

	adj = gtk_range_get_adjustment(GTK_RANGE(GTK_SCROLLBAR(scrollbar)));

	if (adj->upper - 1 - adj->page_size > 0)
		gtk_adjustment_set_value(adj, adj->upper - 1);

	gtk_range_set_adjustment(GTK_RANGE(GTK_SCROLLBAR(scrollbar)), adj);
	gtk_adjustment_value_changed(adj);
}

/* adds new_text to the mkisofs text box in stdout color */
void add_text_mkisofs_stdout(char *new_text) {
	gtk_text_insert(GTK_TEXT(mkisofs_text), NULL, NULL, NULL, new_text, -1);
}

/* adds new_text to the mkisofs text box in stderr color */
void add_text_mkisofs_stderr(char *new_text) {
	GdkColor colour;
	GdkColormap *cmap;

	cmap = gdk_colormap_get_system();
	colour.red = 0xffff;
	colour.green = 0;
	colour.blue = 0;

	if (!gdk_color_alloc(cmap, &colour)) {
		g_warning("couldn't allocate colour");
		gtk_text_insert(GTK_TEXT(mkisofs_text), NULL, NULL, NULL, new_text, -1);
		return;
	}
	gtk_text_insert(GTK_TEXT(mkisofs_text), NULL, &colour, NULL, new_text, -1);
}

/* adds new_text to the cdrecord text box in stdout color */
void add_text_cdrecord_stdout(char *new_text) {
	gtk_text_insert(GTK_TEXT(cdrecord_text), NULL, NULL, NULL, new_text, -1);
}

/* adds new_text to the cdrecord text box in stderr color */
void add_text_cdrecord_stderr(char *new_text) {
	GdkColor colour;
	GdkColormap *cmap;

	cmap = gdk_colormap_get_system();
	colour.red = 0xffff;
	colour.green = 0;
	colour.blue = 0;

	if (!gdk_color_alloc(cmap, &colour)) {
		g_warning("couldn't allocate colour");
		gtk_text_insert(GTK_TEXT(cdrecord_text), NULL, NULL, NULL, new_text, -1);
	}

	gtk_text_insert(GTK_TEXT(cdrecord_text), NULL, &colour, NULL, new_text, -1);
}

/* Creates a textbox in a frame with the title frame_title and attaches it to vbox,
 * returning the scrollbar, the textbox is saved to text
 */

GtkWidget *create_text(GtkWidget *vbox, GtkWidget **text, char *frame_title) {
	GtkWidget *vscrollbar, *hbox, *frame;

	frame = make_frame(frame_title, 5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	*text = gtk_text_new(NULL, NULL);
	gtk_widget_show(*text);
	gtk_box_pack_start(GTK_BOX(hbox), *text, TRUE, TRUE, 0);

	vscrollbar = gtk_vscrollbar_new(GTK_TEXT(*text)->vadj);
	gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
	gtk_widget_show(vscrollbar);

	gtk_widget_realize(*text);

	return vscrollbar;
}

/* create the text box for mkisofs' stdout/stderr and attaches it to vbox */
void create_mkisofs_text(GtkWidget *vbox) {
	mkisofs_text_scrollbar = create_text(vbox, &mkisofs_text, _("mkisofs/mkhybrid/cdda2wav output"));
}

/* create the textbox for cdrecord's stdout/stderr and attaches it to vbox */
void create_cdrecord_text(GtkWidget *vbox) {
	cdrecord_text_scrollbar = create_text(vbox, &cdrecord_text, _("cdrecord output"));
}

/* clears the text in the tbox */
void del_text(GtkWidget *tbox) {
	gtk_text_freeze(GTK_TEXT(tbox));
	gtk_text_set_point(GTK_TEXT(tbox), 0);
	gtk_text_forward_delete(GTK_TEXT(tbox), gtk_text_get_length(GTK_TEXT(tbox)));
	gtk_text_thaw(GTK_TEXT(tbox));
}

/* clears the text in the mkisofs & cdrecord textboxes */
static void delete_output_text(GtkWidget *widget, gpointer data) {
	del_text(mkisofs_text);
	del_text(cdrecord_text);
}

void create_text_status(GtkWidget *tab) {
	GtkWidget *clear_text, *but_box;

	status_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(status_vbox);
	gtk_container_add(GTK_CONTAINER(tab), status_vbox);

	/* buttons */
	but_box = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(but_box);
	gtk_box_pack_start(GTK_BOX(status_vbox), but_box, FALSE, FALSE, 2);

	autoscroll_text = gtk_check_button_new_with_label(_("Autoscroll text"));
	gtk_widget_show(autoscroll_text);
      gtk_tooltips_set_tip(tooltips, autoscroll_text, _("Scroll down to "
			"the end of the text whenever something new is added"),
			NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autoscroll_text), TRUE);
	gtk_box_pack_start(GTK_BOX(but_box), autoscroll_text, FALSE, FALSE, 0);

	clear_text = gtk_button_new_with_label(_("Clear"));
	gtk_widget_show(clear_text);
      gtk_tooltips_set_tip(tooltips, clear_text, _("Clears the text boxes"),
			NULL);
	gtk_box_pack_end(GTK_BOX(but_box), clear_text, FALSE, FALSE, 2);

	gtk_signal_connect(GTK_OBJECT(clear_text), "clicked",
			GTK_SIGNAL_FUNC(delete_output_text), 0);

	/* text */
	create_mkisofs_text(status_vbox);
	create_cdrecord_text(status_vbox);
}

