/* get the directory tree */

#ifndef GETDIR_H
#define GETDIR_H

#include <gtk/gtk.h>

#include "menusys.h"

typedef struct // used for internal purposes,needed for dynamically opening directories
{
	GtkWidget *referringto; /* this is filled out by connectstdsignals */
	GtkWidget *parent;      /* this is filled out by connectstdsignals */
	/* parent is a pointer to the parent TREE_ITEM,not the parent tree itself ! */
	GtkSignalFunc select;
	GtkSignalFunc unselect;
	char dirname[1024];
	void *data;
	int allowdrag;
	void (*receiver)(GtkWidget *item,void*);
	char receiverstring[1024];
	/* 1024 ought to be enough for everybody ??? ;-) */
	char *recdata;
	menusys_menu *popup;
/* we have to care about expand management ourselves as gtk deletes any information
 * wether an item was expanded or not when the expand/collapse event occurred,
 * *before* the user gets the chance of checking. and,unfortunately,
 * gtk does not care about wether an item is expanded or not - when pressing
 * one of the mousebuttons assigned to the expand/collapse event,
 * the signal is emitted regardless of anything...
 *  ... i LOVE this practical toolkit - you realize at first glance
 * it was programmed without any view of reality :-/ 
 * This message now applies to a change done with the signal handlers for collapse
 * and expand, which solves the problem in a somewhat more sophisticated way */
} getdir_dirinfo;

GtkWidget *getdir_tree(GtkTreeItem *host,getdir_dirinfo*); 
// The host item the tree should get connected to,
// if NULL,tree is assumed to be a root tree

getdir_dirinfo *getdir_dirinfo_create(char*,
				      GtkSignalFunc,
				      GtkSignalFunc,
				      void*,
				      int allowdrag,
				      void (*receiver)(GtkWidget*,void*),
				      menusys_menu *popup
				      );
// create directory info entry as it is needed by the various callback functions
//   * Name of the Directory
//   * Handler to call when a directory is selected
//   * Handler to call when a directory is unselected 
//   * Data to pass to the handler functions
//   * allow directories to be dragged from tree
//   * if (!NULL) call this handler whenever someting is dropped onto a
//     tree item,otherwise ignore dropped items (drop will be rejected)
// those informations are handed down to the subtrees,Directoryname is adapted
// appropriately
void getdir_connectstdsignals(GtkWidget *item,  
			      GtkWidget *parent, // set this to NULL if this is a root item
			      getdir_dirinfo*);  // useful almost always except when you display a getdir_tree directly
void getdir_selectsubdir(GtkWidget *tree,char *name);


#endif // GETDIR_H
	

