// Sound recorder 0.05 Aug 01 1998, GPL 2 (see COPYRIGHTS)
// 1997, 1998  B. Warmerdam

#include "waveriff.h"

/* Init the filehandle to 0 to use as test */
TWave::TWave()
{
	fh = 0;
}

/* Close to be sure */
TWave::~TWave()
{
	close();
}

/* Create a wav structure with given arguments */
void TWave::createWave(const unsigned fmt, const unsigned chnl, const unsigned bps, const unsigned smpl)
{
	memcpy(Wave.riffChunk.chunkId, "RIFF", 4);
	Wave.riffChunk.chunkSize = 0;				// known afterwards (record mode)
	memcpy(Wave.wvFormat.Signature, "WAVE", 4);

	Wave.wvFormat.formatCommonFields.wFormatTag = fmt;
	Wave.wvFormat.formatCommonFields.wChannels = chnl;
	Wave.wvFormat.formatCommonFields.dwSamplesPerSec  = smpl;
	Wave.wvFormat.formatCommonFields.dwAvgBytesPerSec = (chnl*bps*smpl) / 8;
	Wave.wvFormat.formatCommonFields.wBlockAlign = (chnl*bps)/8;
	Wave.wvFormat.formatCommonFields.bitsPerSample = bps;

	memcpy(Wave.wvFormat.headerChunk.chunkId, "fmt ", 4);
	Wave.wvFormat.headerChunk.chunkSize = sizeof(struct WaveFormatCommonFields); 
	memcpy(Wave.wvFormat.dataChunk.chunkId, "data", 4);
	Wave.wvFormat.dataChunk.chunkSize = 0;			// known afterwards (record mode)
}

/* Create a wav file with the given arguments */
const bool TWave::create(const char * filename, 
		   const unsigned fmt,
		   const unsigned chnl,
		   const unsigned bps,
		   unsigned smpl)
{
	if(fh == 0){
		if((fh = ::fopen(filename, "w+b")) == 0){
			perror("Wave create error");
		} else {
			mode = O_WRONLY;
			createWave(fmt, chnl, bps, smpl);
			write((char *) & Wave, sizeof(Wave));
		}
	}
	return fh != 0;
}

/* Open an existing wav file */
const bool TWave::open(const char * filename)
{
	if(fh == 0){
		if((fh = ::fopen(filename, "rb")) == 0){
			perror("Wave read error");
		} else {
			mode = O_RDONLY;
			read((char *) & Wave, sizeof(Wave));
		}
	}
	return fh != 0;
}

/* Return common used data about wav */
void TWave::getWaveInfo(unsigned & fmt, unsigned & chnl, unsigned & bps, unsigned & smpl, unsigned & bs)
{
	fmt  = Wave.wvFormat.formatCommonFields.wFormatTag;
	chnl = Wave.wvFormat.formatCommonFields.wChannels;
	smpl = Wave.wvFormat.formatCommonFields.dwSamplesPerSec;
	bs   = Wave.wvFormat.formatCommonFields.dwAvgBytesPerSec;
	bps  = Wave.wvFormat.formatCommonFields.bitsPerSample;
}

/* Write data to a wav-file */
const int TWave::write(char * buffer, unsigned long len)
{
	int size = 0;

	if(fh != 0 && mode == O_WRONLY){
		size = ::fwrite(buffer, 1, len, fh);
	}
	return size;
}

/* Read data from a wav-file */
const int TWave::read(char * buffer, unsigned long len)
{
	int size = 0;

	if(fh != 0 && mode == O_RDONLY){
		size = ::fread(buffer, 1, len, fh);
	}
	return size;
}

/* Close the wav-file (if handle exists) and fill in the blanks in the header */
void TWave::close()
{
	if(fh != 0){
		if(mode == O_WRONLY){
			fseek(fh, 0L, SEEK_END);
			long fsize = ftell(fh);
			fseek(fh, 0, 0);

			Wave.wvFormat.dataChunk.chunkSize = fsize - sizeof(Wave);
			Wave.riffChunk.chunkSize = fsize - sizeof(struct Chunk);
			write((char *) & Wave, sizeof(Wave));
		}
		::fclose(fh);
		fh = 0;
	}
}

/* Return the number of samples */
const int TWave::sampleCount()
{
	return (fh != 0) ? (Wave.wvFormat.dataChunk.chunkSize / Wave.wvFormat.formatCommonFields.dwAvgBytesPerSec) : 0;
}
