#!/bin/sh

DATE=`date "+19%y/%m/%d"`

FILES="xipa10 xipasl10 xipabx10 xipass10 xipab10"

for FNAME in $FILES
do
  case "$FNAME" in
    xipa10)   NUM=3;FID="XIPA";  FSIZE="10";FDESC="Roman 10" ;;
    xipasl10) NUM=4;FID="XIPASL";FSIZE="10";FDESC="Slanted Roman 10" ;;
    xipabx10) NUM=5;FID="XIPABX";FSIZE="10";FDESC="Bold Extended Roman 10" ;;
    xipass10) NUM=6;FID="XIPASS";FSIZE="10";FDESC="Sans Serif 10" ;;
    xipab10)  NUM=7;FID="XIPAB"; FSIZE="10";FDESC="Bold Roman 10" ;;
  esac

  echo "% $FNAME.mf: XIPA $FDESC point parameter file" > $FNAME.mf
  echo "%   Version 1.0 $DATE FUKUI Rei" >> $FNAME.mf
  echo '% This file is based on:' >> $FNAME.mf
  echo '%   Computer Modern font series by D. E. Knuth and' >> $FNAME.mf
  echo '%   TSIPA by KOBAYASHI Hajime, FUKUI Rei and SHIRAKAWA Shun.' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'if unknown cmbase: input cmbase fi' >> $FNAME.mf
  echo 'if unknown tipabase: input tipabase fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo "font_identifier:=\"$FID\"; font_size ${FSIZE}pt#;" >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'Times_Compat:=true;' >> $FNAME.mf
  echo 'if Times_Compat: input tipatr fi' >> $FNAME.mf
  echo '' >> $FNAME.mf
  awk "{if (\$1 == \"p\") {
     if (\$$NUM == \"0\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
     else print \$2 \"#:=\" \$$NUM \"/36pt#;\";\
   }\
   else if (\$1 == \"P\") print \$2 \"#:=\" \$$NUM \"pt#;\";\
   else if (\$1 == \"n\") print \$2 \":=\"  \$$NUM \";\";}" param2.def |\
  sed 's/SQ/sqrt/' >> $FNAME.mf
  echo '' >> $FNAME.mf
  echo 'generate tipa    % switch to the driver file' >> $FNAME.mf
done

exit 0
