/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File: 	ctrie.h
 * Author:	Joe English
 * Created: 	12 Jan 1995
 * Description:	Character/String tries
 *
 * 1995/04/11 14:49:09
 * 1.3
 * 
 */


#ifndef CTRIE_H
#define CTRIE_H

typedef struct CTrieNode *CTrieNode, CTrieNodeRec;
typedef struct CTrie *CTrie, CTrieRec;

extern CTrie 	ctrie_create	(void);
extern void 	ctrie_destroy	(CTrie);
	/* need value destructor... */

/* Lookup table routines: */
extern int 	ctrie_haskey	(CTrie, const char *key);
extern void *	ctrie_get	(CTrie, const char *key);
extern void 	ctrie_set	(CTrie, const char *key, void *val);
extern void *	ctrie_unset	(CTrie, const char *key);

/* Prefix matching routines: */
extern CTrieNode	ctrie_root	(CTrie);
extern CTrieNode	ctrie_find	(CTrie, const char *prefix);
extern CTrieNode	ctrie_findch	(CTrieNode, char ch);
	/* lookup, lookupch identical to find, findch,
	 * but insert node if it doesn't exist.
	 */
extern CTrieNode	ctrie_lookup	(CTrie, const char *prefix);
extern CTrieNode	ctrie_lookupch	(CTrieNode, char ch);
extern int  		ctrie_hasvalue	(CTrieNode);
extern void *		ctrie_getvalue	(CTrieNode);
extern void 		ctrie_setvalue	(CTrieNode,void *);
extern int		ctrie_getkey	(CTrieNode,char *buf,int buflen);
extern int		ctrie_keylen	(CTrieNode);

/* Iterator: */
typedef void (*CTrieNodeProc)(CTrieNode node, void *closure);
extern void	ctrie_foreach	(CTrie, CTrieNodeProc, void *closure);

#endif /* CTRIE_H */

