#include <stdio.h>
#include "config.h"
#include "mswordview.h"

void wvGetSttbfAssoc(SttbfAssoc *anS,FILE *tablefd,U32 offset,U32 len)
	{
	int i,j;
	U16 slen;
	U16 extendedflag;
	fseek(tablefd,offset,SEEK_SET);
	extendedflag = read_16ubit(tablefd);
	if (extendedflag != 0xFFFF)
		{
		/*old U8 strings*/
		anS->nostrings = extendedflag;
		anS->extendedflag = 0;
		}
	else
		{
		/*U16 chars*/
		anS->nostrings = read_16ubit(tablefd);
		anS->extendedflag = 1;
		}

	anS->extradatalen = read_16ubit(tablefd);

	if (anS->extendedflag)
		{
		anS->u16strings = (U16 **)malloc(sizeof(U16 *)*anS->nostrings);
		anS->u8strings=NULL;
		}
	else
		{
		anS->u8strings = (U8 **)malloc(sizeof(U8 *)*anS->nostrings);
		anS->u16strings=NULL;
		}

	if (anS->extradatalen)
		{
		anS->extradata = (U8 **)malloc(sizeof(U8 *)*anS->nostrings);
		for (i=0;i<anS->nostrings;i++)
			anS->extradata[i] = (U8 *)malloc(anS->extradatalen);
		}
	else
		anS->extradata=NULL;

	if (anS->extendedflag)
		{
		for (i=0;i<anS->nostrings;i++)
			{
			slen = read_16ubit(tablefd);
			if (slen == 0)
				anS->u16strings[i] = NULL;
			else
				{
				anS->u16strings[i] = (U16 *)malloc(sizeof(U16)*(slen+1));
				for (j=0;j<slen;j++)
					anS->u16strings[i][j] = read_16ubit(tablefd);
				anS->u16strings[i][j]=0;
				}
			if (anS->extradatalen)
				for (j=0;j<anS->extradatalen;j++)
					anS->extradata[i][j] = getc(tablefd);
			}
		}
	else
		{
		for (i=0;i<anS->nostrings;i++)
			{
			slen = getc(tablefd);
			if (slen == 0)
				anS->u8strings[i] = NULL;
			else
				{
				anS->u8strings[i] = (U8 *)malloc(slen+1);
				for (j=0;j<slen;j++)
					anS->u8strings[i][j] = getc(tablefd);
				anS->u8strings[i][j]=0;
				}
			if (anS->extradatalen)
				for (j=0;j<anS->extradatalen;j++)
					anS->extradata[i][j] = getc(tablefd);
			}
		}
	}
