#ifndef BONNIE
#define BONNIE

#define BON_VERSION "0.99e"
#if defined(_AIX) && !defined(__GNUC__)
#define bool int
#define false 0
#define true 1
#endif

// million files (7) + up to 12 random extra chars
#define RandExtraLen (12)
#define MaxNameLen (7 + RandExtraLen)
#define Seeks (8000)
#define UpdateSeek (10)
#define SeekProcCount (3)
#define ChunkBits (13)
#define Chunk (1 << ChunkBits)
#define UnitBits (20)
#define Unit (1 << UnitBits)
#define CreateNameLen 6
#define DefaultFileSize 200
#define DirectoryUnit 1024
#define DefaultDirectorySize 30
#define DefaultDirectoryMaxSize 0
#define DefaultDirectoryMinSize 0
// 1024M per file for IO.
#define IOFileSize 1024
// 3 digits
#define MaxIOFiles 1000
#define IntSize sizeof(int)

typedef const char * CPCHAR;
typedef char * PCHAR;
typedef const char * const CPCCHAR;
typedef void * PVOID;
typedef const void * CPVOID;
typedef const void * const CPCVOID;

enum tests_t
{
  Putc,
  ReWrite,
  FastWrite,
  Getc,
  FastRead,
  Lseek,
  CreateRand,
  CreateSeq,
  StatRand,
  StatSeq,
  DelRand,
  DelSeq,
  TestCount
} ;

#ifdef OS2
typedef enum
{
  false = 0,
  true = 1
} bool;

#define rmdir(XX) { DosDeleteDir(XX); }
#define chdir(XX) DosSetCurrentDir(XX)
#define file_close(XX) { DosClose(XX); }
#define make_directory(XX) DosCreateDir(XX, NULL)
typedef HFILE FILE_TYPE;
#define pipe(XX) DosCreatePipe(&XX[0], &XX[1], 8 * 1024)
#define sleep(XX) DosSleep((XX) * 1000)
#else
#define file_close(XX) { ::close(XX); }
#define make_directory(XX) mkdir(XX, S_IRWXU)
typedef int FILE_TYPE;
#endif

int   io_error(CPCCHAR message, bool do_exit = false);

#endif
