#include <qfiledlg.h>
#include <ktopwidget.h>
#include <kstatusbar.h>
#include "klocale.h"
#include <kiconloader.h>
#include <ktoolbar.h>
#include <ktablistbox.h>
#include <kwm.h>
#include <qmessagebox.h>

#include "accwidget.h"

#include "accountwidget.h"
#include "balancedlg.h"
#include "newacctdlg.h"
#include "transferdlg.h"
#include "editacctdlg.h"
#include "notesdlg.h"

extern "C" {
#include "util.h"
#include "FileDialog.h"
}

#define IDX_ASSETS  1
#define IDX_PROFITS 2
#define IDX_BALANCE 3


void AccWidget::initMenu() {

  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());
  
  QPopupMenu *file = new QPopupMenu;
  file->insertItem( klocale->translate("&New File..."), ID_FILE_NEWFILE);
  file->insertItem(  klocale->translate("&Open File..."), ID_FILE_OPEN);
  file->insertItem(  klocale->translate("&Import QIF..."), ID_FILE_IMPORT );
  file->insertSeparator();
  file->insertItem(  klocale->translate("&Save"), ID_FILE_SAVE);
  file->insertItem(  klocale->translate("Save &As..."), ID_FILE_SAVEAS);
  file->insertSeparator();
  file->insertItem(  klocale->translate("&Quit"), ID_FILE_QUIT);

  QPopupMenu *account = new QPopupMenu;
  account->insertItem( klocale->translate("&New Account..."),ID_ACCT_NEWACCT);
  account->insertItem(  klocale->translate("&Open Account"), ID_ACCT_OPENACCT);
  account->insertItem(  klocale->translate("Open &Subaccounts"),ID_ACCT_OPENSUBACCT );
  account->insertItem(  klocale->translate("&Edit Account..."),ID_ACCT_EDITACCT);
  account->insertItem(  klocale->translate("&Delete Account..."),ID_ACCT_DELETEACCT);
  account->insertSeparator();
  account->insertItem(  klocale->translate("&Transfer"), ID_ACCT_TRANSFER);
  account->insertItem(  klocale->translate("&Report"), ID_ACCT_REPORT);
  account->insertItem(  klocale->translate("Hide &Inc/Exp..."),ID_ACCT_HIDEINCEXP);

  QPopupMenu *help = new QPopupMenu;
  help->insertItem( klocale->translate("&About..."), ID_HELP_ABOUT);
  help->insertItem( klocale->translate("&Help..."), ID_HELP_HELP);
  help->insertItem( klocale->translate("Accounts..."), ID_HELP_ACCTS);
  help->insertSeparator();
  help->insertItem( klocale->translate("&License..."), ID_HELP_LICENSE);

  connect (file, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (account, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (help, SIGNAL (activated (int)), SLOT (menuCallback (int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&File"), file );
  menu->insertItem( klocale->translate("&Account"), account );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  menu->show();
  setMenu(menu);
}

AccWidget::AccWidget() {
  KToolBar *tb;

  KIconLoader *loader = kapp->getIconLoader();
  QPixmap pixmap;

  tb = new KToolBar (this);
  addToolBar (tb);
  tb->setBarPos(KToolBar::Top);
  tb->show();
  connect(tb, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));

  pixmap = loader->loadIcon ("filenew2.xpm");
  tb->insertButton (pixmap,ID_FILE_NEWFILE); 

  pixmap = loader->loadIcon ("fileopen.xpm");
  tb->insertButton (pixmap,ID_FILE_OPEN); 

  pixmap = loader->loadIcon ("filefloppy.xpm");
  tb->insertButton (pixmap,ID_FILE_SAVE);  

   tb->insertSeparator();

   pixmap.load ("toolbar/acctopen.xpm");
   tb->insertButton (pixmap, ID_ACCT_OPENACCT);

   pixmap.load ("toolbar/acctnew.xpm");
   tb->insertButton (pixmap, ID_ACCT_NEWACCT);

   pixmap.load ("toolbar/acctedit.xpm");
   tb->insertButton (pixmap, ID_ACCT_EDITACCT);

   pixmap.load ("toolbar/acctdele.xpm");
   tb->insertButton (pixmap, ID_ACCT_DELETEACCT);


//  tb->insertSeparator();

  statusbar = new KStatusBar(this);
  setStatusBar (statusbar);

  statusbar->insertItem("Balance: -$ xxx,xxx.xx", IDX_BALANCE);
  statusbar->changeItem("Balance: $ 0.00", IDX_BALANCE);
#if 0
  statusbar->insertItem ("Assets: 12233,34 DM",IDX_ASSETS);   
  statusbar->insertItem ("Profits: 12233,34 DM",IDX_PROFITS);
  statusbar->insertItem ("",-1);
#endif

  // main list
  acctList = new QListView (this);
  acctList->setRootIsDecorated(TRUE);
  setView (acctList);

  acctList->addColumn ("Account name", 200);
  acctList->addColumn ("Type", 100);   
  int col = acctList->addColumn ("Balance", 100);
  acctList->setColumnAlignment(col, AlignRight);  

  initMenu();
  setCaption(kapp->getCaption());  

  resize(650,400);
  show();
}

AccWidget::~AccWidget() {
}

void AccWidget::selectAccount (int idx) {
  AccountWidget *aw = new AccountWidget();
  aw->show(); 
}

void AccWidget::menuCallback (int item)
{
  switch (item) {
  case ID_FILE_OPEN:
    gncFileOpen();
    break;
  case ID_FILE_SAVE:
    gncFileSave();
    return;
  case ID_FILE_SAVEAS:
    gncFileSaveAs();
    return;
  case ID_FILE_QUIT:
    gnc_shutdown(0);
    return;
  case ID_FILE_NEWFILE:
    gncFileNew();
    break;
  case ID_FILE_IMPORT:
    gncFileQIFImport();
    break;

    case ID_ACCT_NEWACCT     : doNewAcct(); break; 
    case ID_ACCT_OPENACCT    : doOpenAcct(); break;
    case ID_ACCT_OPENSUBACCT :  break;
    case ID_ACCT_EDITACCT    : doEditAcct(); break;
    case ID_ACCT_DELETEACCT  : break;
    case ID_ACCT_TRANSFER    : doTransfer();
    case ID_ACCT_REPORT      : break;
    case ID_ACCT_HIDEINCEXP  : break;

  case ID_HELP_ABOUT:
    QMessageBox::about(kapp->topWidget(), kapp->getCaption(),
                       "GnuCash 1.3 (development version)\n"
                       "This is the KDE Version which does not yet work.");
    return;

    case ID_HELP_HELP    : break;
    case ID_HELP_ACCTS   : break;
    case ID_HELP_LICENSE : break;
  }
  gnc_refresh_main_window();

}

void AccWidget::insertGroup(AccountGroup *grp, QListViewItem *parent)
{
  QListViewItem *qlvi;
  int nacc = xaccGroupGetNumAccounts(grp);

  for (int i = 0; i < nacc; i++) {
    double bal;
    char *balstr;
    QListViewItem *qlvi;
    Account *acc = xaccGroupGetAccount(grp, i);
    AccountGroup *children = xaccAccountGetChildren(acc);
    bal = xaccAccountGetBalance(acc);
    if (children)
      bal += xaccGroupGetBalance(children);
    balstr = xaccPrintAmount(bal, PRTSYM | PRTSEP);
    if (parent)
      qlvi = new QListViewItem(parent,
                               xaccAccountGetName(acc),
                               xaccAccountGetTypeStr(xaccAccountGetType(acc)),
                               balstr);
    else
      qlvi = new QListViewItem(acctList,
                               xaccAccountGetName(acc),
                               xaccAccountGetTypeStr(xaccAccountGetType(acc)),
                               balstr);
    if (children)
      insertGroup(children, qlvi);
  }
}

void AccWidget::refresh()
{
  AccountGroup *grp = gncGetCurrentGroup();

  while (acctList->firstChild())
    delete acctList->firstChild();

  insertGroup(grp);
  double bal = xaccGroupGetBalance(grp);
  statusbar->changeItem(xaccPrintAmount(bal, PRTSEP | PRTSYM), IDX_BALANCE);
}

void AccWidget::doNewAcct () {
  NewAcctDlg *na = new NewAcctDlg();
  na->exec();
}

void AccWidget::doEditAcct () {
  EditAcctDlg *ea = new EditAcctDlg();
  ea->exec();    
}

void AccWidget::doOpenAcct () {
  AccountWidget *aw = new AccountWidget();
//  aw->show(); 
}

void AccWidget::doTransfer () {
  TransferDlg *td = new TransferDlg();
  td->exec(); 
}


void AccWidget::redisplayBalance () {
}



#include "accwidget.moc"
