;;; skk-viper.el --- SKK related code for VIPER
;; Copyright (C) 1996 Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Version: 0.4
;; Keywords: japanese
;; Last Modified: Wed Nov 27 06:20:51 1996

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;; Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp> $B$5$s$K$h$k!"(B
;; viper.el $BBP1~%=!<%9$G$9!#(B
;;
;; SKK-9.x $B$G$O!"(Bviper $BBP1~$O8+Aw$j$H$J$j!"(BSKK-10.x $B$G$NBP1~$rL\;X$9J}(B
;; $B?K$G$9!#$3$N%=!<%9$O!"8=;~E@$G$O!"@5<0$K(B VIPER +SKK $B$KBP1~$9$k$b$N(B
;; $B$G$J$$$3$H$rM=$a$4N;>52<$5$$!#(B
;;
;; $BCfEg44IW(B <gy2m-nkjm@asahi-net.or.jp>

;; Following people contributed modifications to skk.el (Alphabetical order):
;;      Mikio Nakajima <gy2m-nkjm@asahi-net.or.jp>
;;      Murata Shuuichirou <mrt@mickey.ai.kyutech.ac.jp>

;;; Change log:
;; version 0.4 released 1996.11.27 (derived from the skk.el 8.6)

;;; Code:

(require 'advice)
(require 'viper)

(defadvice vip-intercept-ESC-key (before skk-add activate)
  (if (and (boundp 'skk-mode) skk-henkan-on)
      (skk-kakutei) ))

(defun vip-del-backward-char-in-insert ()
  "Delete 1 char backwards while in insert mode."
  (interactive)
  (if (and vip-ex-style-editing-in-insert (bolp))
      (beep 1)
    (skk-delete-backward-char 1) ))

(defun vip-del-backward-char-in-replace ()
  "Delete one character in replace mode.
If `vip-delete-backwards-in-replace' is t, then DEL key actually deletes
charecters. If it is nil, then the cursor just moves backwards, similarly
to Vi. The variable `vip-ex-style-editing-in-insert', if t, doesn't let the
cursor move past the beginning of line.
with skk."
  (interactive)
  (cond (vip-delete-backwards-in-replace
	 (cond ((not (bolp))
		(skk-delete-backward-char 1))
	       (vip-ex-style-editing-in-insert
		(beep 1))
	       ((bobp)
		(beep 1))
	       (t
		(skk-delete-backward-char 1))))
	(vip-ex-style-editing-in-insert
	 (if (bolp)
	     (beep 1)
	   (backward-char 1)))
	(t 
	 (backward-char 1))))

(defun skk-emulate-original-map (arg)
  ;; $B%-!<F~NO$KBP$7$F!"(BSKK $B$N%b!<%I$G$O$J$/!"(BEmacs $B$N%*%j%8%J%k$N%-!<3d$jIU$1$G(B
  ;; $B%3%^%s%I$r<B9T$9$k!#(B
  (let ((prefix-arg arg)
        (keys (skk-command-key-sequence (this-command-keys) this-command))
        local-map buf )
    (if (null keys)
        ;; no alternative commands.  may be invoked by M-x.
        nil
      (let ((minor-mode-map-alist)
            (buf (current-buffer))
	    (local-map (current-local-map)) )
	(unwind-protect
	    (progn
	      (skk-use-local-map skk-emacs-local-map)
	      (let ((command (key-binding keys)))
		(if (eq command this-command)
		    ;; avoid recursive calling of skk-emulate-original-map.
		    nil
		  ;; if no bindings are found, call `undefined'.  it's
		  ;; original behaviour.
		  (skk-cancel-undo-boundary)
		  ;(command-execute (or command (function undefined)))
		  ;; why?
		  (call-interactively (or command (function undefined))) )))
	  ;; restore skk keymap.
          (set-buffer buf)
          (skk-use-local-map local-map) )))))

;;(defadvice kill-region (around skk-ad activate)
;;  "SKK $B$N"&%b!<%I$+"'%b!<%I$@$C$?$i!"3NDj$7$F$+$i%j!<%8%g%s$r%-%k$9$k!#(B
;;$B3NDj$9$k$3$H$G!""&%b!<%I$G$O(B disable-undo $B$,(B t $B$K%;%C%H$5$l$F$$$k$N$G!"(Bnil $B$K(B
;;$B%;%C%H$7D>$7!"$^$?!""'%b!<%I$G$OJQ498uJd$K(B Overlay $B$,$+$+$C$F$$$k$N$G!"$=$l$r(B
;;$B<h$j=|$/!#$=$N8e!"%j!<%8%g%s$r%-%k$9$k!#(B"
;;  ;;(interactive "*r")
;;  (if (and (boundp 'skk-mode) skk-use-face skk-henkan-on
;;	   (not (skk-in-minibuffer-p)) )
;;      (let ((param0 (ad-get-arg 0))
;;            (param1 (ad-get-arg 1))
;;            (start (make-marker))
;;            (end (make-marker)) )
;;        ;; $B3NDj$9$k$H!"%P%C%U%!$N"&$d"'$r>C$9$N$G!"(Bkill-region $B$N0z?tCM$,3NDj(B
;;        ;; $B8e$K@5$7$$0LCV$r;X$7$F$$$J$$!#$=$3$G!"0z?t$r%^!<%+!<$K$7$F$*$/!#(B
;;        ;;
;;        ;; (interactive "r") $B$G<u$1$?0z?t$O!"?tCM$KJQ49$5$l$k!)(B  $B0z?t$N0lJ}$O(B
;;        ;; $B%^!<%/$G$"$k$O$:$J$N$K!"(Bmarkerp $B$G8!=P$G$-$J$$!#(B
;;        (set-marker start param0)
;;        (set-marker end param1)
;;        (ad-set-arg 0 start)
;;        (ad-set-arg 1 end)
;;        (skk-kakutei)
;;        ad-do-it
;;        ;; $B;2>H$5$l$F$$$J$$%^!<%+!<$O!"(BGarbage Collection $B$,%3!<%k$5$l$?$H$-$K(B
;;        ;; $B2s<}$5$l$k$,!"$=$l$^$G$N4V!"%F%-%9%H$N$I$3$+$r;X$7$F$$$k$H!"%F%-%9(B
;;        ;; $B%H$N%"%C%W%G!<%H$N:]$K$=$N%^!<%+!<CM$r99?7$9$kI,MW$,$"$k$N$G!"$I$3(B
;;        ;; $B$b;X$5$J$$$h$&$K$9$k!#(B
;;        (set-marker start nil)
;;        (set-marker end nil) )
;;    ad-do-it ))

(provide 'skk-viper)
;;; skk-viper.el ends here
