#include <glib.h>

/* needs updating if the tab positions change */
typedef enum _CSSTabPos {
	FONT = 0,
	BACKGROUND = 1,
	TEXT = 2,
	BOX = 3,
	BORDER = 4,
	SIZEPLACE = 5,
	CLASSIFICATION = 6
} CSSTabPos;

typedef enum _CSSPos {
	TOP = 0,
	RIGHT = 1,
	BOTTOM = 2,
	LEFT = 3
} CSSPos;

typedef struct _FontStyle {
	gchar *family;
	gchar *style;
	gchar *variant;
	gchar *weight;
	gchar *size;
	gchar *color;
} FontStyle;

typedef struct _BackStyle {
	gchar *color;
	gchar *image;
	gchar *repeat;
	gchar *attachment;
	gchar *position;
} BackStyle;

typedef struct _TextStyle {
	gchar *word_spacing;
	gchar *letter_spacing;
	gchar *decoration;
	gchar *vertical_align;
	gchar *transform;
	gchar *align;
	gchar *indent;
	gchar *height;
} TextStyle;

typedef struct _BoxStyle {
	gchar *margin[ 4 ];
	gchar *padding[ 4 ];
	gchar *border_color[ 4 ];
	gchar *border_width[ 4 ];
	gchar *border_style[ 4 ];
	gchar *width;
	gchar *height;
	gchar *float_;
	gchar *clear;
} BoxStyle;

typedef struct _ClassStyle {
	gchar *display;
	gchar *white_space;
	gchar *list_style_type;
	gchar *list_style_image;
	gchar *list_style_position;
} ClassStyle;


typedef struct _Style {
	FontStyle  *font;
	BackStyle  *back;
	TextStyle  *text;
	BoxStyle   *box;
	ClassStyle *class;

	gchar *name;
	gchar *class_name;
	gchar *pseudo;
} Style;

const gchar* g_module_check_init( GModule *module );
void g_module_unload( GModule *module );
void init( void ) ;

void cssWizard( void );
void cassius_about( void );
void css_wizard_delete( GtkWidget *widget, GdkEvent *event, gpointer data );
void css_wizard_clicked( GtkWidget *widget, gint button, gpointer data );
void css_close( void );
void css_dump_stylesheet( void );
void css_dump_style( void );
void style_selected( GtkCTree *tree, GtkCTreeNode *row, gint column );
void style_unselected( GtkCTree *tree, GtkCTreeNode *row, gint column );
void style_clicked( GtkWidget *widget, GdkEventButton *event );
void add_style( void );
void remove_style( void );
gboolean page_switch( GtkNotebook *notebook, GtkNotebookPage *page, 
		      guint page_num );

void color_set( GnomeColorPicker *cp, guint r, guint g, guint b, guint a,
		gchar *entry );

void css_new( void );
void css_load( void );
void css_save( void );

Style*      css_style_new( void );
FontStyle*  css_font_style_new( void );
BackStyle*  css_back_style_new( void );
TextStyle*  css_text_style_new( void );
BoxStyle*   css_box_style_new( void );
ClassStyle* css_class_style_new( void );

void css_style_destroy( Style *style );
void css_font_style_destroy( FontStyle *style );
void css_back_style_destroy( BackStyle *style );
void css_text_style_destroy( TextStyle *style );
void css_box_style_destroy( BoxStyle *style );
void css_class_style_destroy( ClassStyle *style );

gchar* css_style_output( Style *style );
gchar* css_font_style_output( FontStyle *style );
gchar* css_back_style_output( BackStyle *style );
gchar* css_text_style_output( TextStyle *style );
gchar* css_box_style_output( BoxStyle *style );
gchar* css_class_style_output( ClassStyle *style );

