/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com>
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include "sites.h"
#include "common.h"
#include "rcfile.h"
#include "gcommon.h"
#include "misc.h"
#include "operations.h"
#include "config.h"

extern struct site_t *selected_site;
extern GtkWidget *error_log_list, *error_log_window;

extern struct site_t *all_sites;

/* For the 'main' upload window */
GtkWidget *upload_window, *main_progressbar, *job_progressbar, *error_button;
GtkWidget *status_label, *op_label, *file_label, *dir_label;
GtkWidget *begin_button, *close_button, *kill_button, *keep_going_button;
pthread_t update_thread_id = 0;

void close_main_update_window (GtkWidget *button, gpointer data) {
   extern GtkWidget *connection_label;
   gtk_window_set_modal (GTK_WINDOW (upload_window), false);
   /* FIXME: Kill the pthread, write the files list back,, and enable the
    * error log button. */
   gtk_widget_destroy (upload_window);
   connection_label = NULL;
}

/* All this pissing about with functions to make the fe, functions to
 * start the thing, functions to call the thread, then more to actually
 * DO the bloody thing, are in fact necessary.... I think. */

void *actual_main_update (void *a_site) {
   int ret;
   extern bool site_keepgoing;
   
   pthread_detach (pthread_self());
   gtk_widget_set_sensitive (begin_button, FALSE);

   if (verifysite_gnome (selected_site)) {
      close_main_update_window(NULL, NULL);
      return NULL;
   }
   if (GTK_TOGGLE_BUTTON(keep_going_button)->active) {
      site_keepgoing = TRUE;
   } else {
      site_keepgoing = FALSE;
   }
   ret = site_update (selected_site, FALSE);
   DEBUG (DEBUG_GNOME, "site_update returned value of %d.\n", ret);
	switch (ret) {
   case SITE_CONNECT:
      gtk_label_set (GTK_LABEL (status_label), "Unable to establish connection.");
      gtk_label_set (GTK_LABEL (op_label), " ");
      gtk_label_set (GTK_LABEL (file_label), " ");
      gtk_label_set (GTK_LABEL (dir_label), " ");
		break;
	case SITE_AUTH:
      gtk_label_set (GTK_LABEL (status_label), "Authentication with the remote server failed..");
      gtk_label_set (GTK_LABEL (op_label), " ");
      gtk_label_set (GTK_LABEL (file_label), " ");
      gtk_label_set (GTK_LABEL (dir_label), " ");
		break;
	case SITE_ERRORS:
      gtk_label_set (GTK_LABEL (status_label), "There was a problem with the file/directory transfer.");
      gtk_label_set (GTK_LABEL (op_label), " ");
      gtk_label_set (GTK_LABEL (file_label), " ");
      gtk_label_set (GTK_LABEL (dir_label), " ");
      site_writefiles (selected_site);
      site_destroy (selected_site);
      site_readfiles (selected_site);
      refresh_selected();
      gtk_widget_set_sensitive (error_button, true);
		break;
   case SITE_LOOKUP:
      gtk_label_set (GTK_LABEL (status_label), "Unable to connect: Host name look-up failed.");
      gtk_label_set (GTK_LABEL (op_label), " ");
      gtk_label_set (GTK_LABEL (file_label), " ");
      gtk_label_set (GTK_LABEL (dir_label), " ");
		break;
   case SITE_OK:
      site_writefiles (selected_site);
      site_destroy (selected_site);
      site_readfiles (selected_site);
      gtk_label_set (GTK_LABEL (status_label), "Update complete. (No errors)");
      gtk_label_set (GTK_LABEL (op_label), " ");
      gtk_label_set (GTK_LABEL (file_label), " ");
      gtk_label_set (GTK_LABEL (dir_label), " ");
      redraw_main_area();
      refresh_selected();
		break;
   default:
      gtk_label_set (GTK_LABEL (status_label), "Unexpected Update Return Value! Contact Maintainer.");
   }
   return NULL;
}

void die_thread_die(GtkWidget *button, gpointer data) {
  if (update_thread_id != 0) {
	 if (pthread_kill(update_thread_id, 15)) {
		gtk_label_set (GTK_LABEL (status_label), "Recording uploads that were completed successfully...");
		site_writefiles (selected_site);
		gtk_label_set (GTK_LABEL (status_label), "Update finished; user terminated.");
	 } else {
		DEBUG (DEBUG_GNOME, "Could not cancel thread. Oh dear");
	 }
  } else {
	 gnome_error_dialog ("Could not find a thread to cancel!!");
  }
}


int start_main_update (void) { 
  gtk_widget_set_sensitive(begin_button, FALSE);
   gtk_widget_set_sensitive(close_button, FALSE);
/*  gtk_widget_hide(close_button);
  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (upload_window),
                                          "Stop!", GNOME_STOCK_PIXMAP_STOP);
  kill_button = g_list_last (GNOME_DIALOG (upload_window)->buttons)->data;
  gtk_signal_connect (GTK_OBJECT(kill_button), "clicked",
		      GTK_SIGNAL_FUNC(die_thread_die), NULL);
  gtk_widget_show(kill_button);*/
   if ( pthread_create (&update_thread_id, NULL, actual_main_update, 
			NULL) != 0) {
      gnome_error_dialog ("There was a problem creating the thread to do an update.");
/*		gtk_widget_hide (kill_button);
		gtk_widget_show (close_button);*/
      gtk_widget_set_sensitive(close_button, TRUE);
      return 0;
   }
   if (update_thread_id != 0)
     pthread_join (update_thread_id, NULL);
/*	gtk_widget_hide (kill_button);
	gtk_widget_show (close_button);*/
   gtk_widget_set_sensitive(close_button, TRUE);
	gtk_window_set_modal (GTK_WINDOW (upload_window), FALSE);
   return 1;
}

int main_update_please (GtkWidget *update_button, gpointer data) {
   extern GtkWidget *connection_label;
   extern float uploaded_bytes;
   GtkWidget *vbox, *table, *hbox;
   GtkWidget *label, *button;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *hseparator3;
	GtkWidget *table1;
	GtkWidget *label3;
	GtkWidget *label6;
	GtkWidget *hseparator1;
	GtkWidget *label2;
	GtkWidget *label1;
	GtkWidget *dialog_action_area1;

   uploaded_bytes = 0.0;
   if (selected_site == NULL) {
      gnome_error_dialog ("You must select a site if you want to upload the changes!");
      return 0;
   }
   if (! selected_site->is_different ) {
      fe_status ("Remote and local sites are already synchronised.");
      return 1;
   }

	make_error_window();
  upload_window = gnome_dialog_new ("Update Progress", NULL);
  gtk_object_set_data (GTK_OBJECT (upload_window), "upload_window", upload_window);
  gtk_widget_set_usize (upload_window, 480, -2);

  dialog_vbox1 = GNOME_DIALOG (upload_window)->vbox;
  gtk_object_set_data (GTK_OBJECT (upload_window), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 1);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator3);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "hseparator3", hseparator3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator3, TRUE, TRUE, 3);

  table1 = gtk_table_new (4, 2, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 1);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 2);

  status_label = gtk_label_new ("Click Upload to begin.");
  gtk_widget_ref (status_label);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "status_label", status_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (status_label);
  connection_label = status_label;
  gtk_table_attach (GTK_TABLE (table1), status_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (status_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (status_label), 7.45058e-09, 0.5);

  op_label = gtk_label_new (" ");
  gtk_widget_ref (op_label);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "op_label", op_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_label);
  gtk_table_attach (GTK_TABLE (table1), op_label, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (op_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (op_label), 7.45058e-09, 0.5);

  file_label = gtk_label_new ("");
  gtk_widget_ref (file_label);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "file_label", file_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (file_label);
  gtk_table_attach (GTK_TABLE (table1), file_label, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (file_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (file_label), 7.45058e-09, 0.5);

  label3 = gtk_label_new ("Status: ");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label3), 7.45058e-09, 0.5);

  label6 = gtk_label_new ("To: ");
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label6), 7.45058e-09, 0.5);

  dir_label = gtk_label_new (" ");
  gtk_widget_ref (dir_label);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "dir_label", dir_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dir_label);
  gtk_table_attach (GTK_TABLE (table1), dir_label, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (dir_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (dir_label), 7.45058e-09, 0.5);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 5);

  label2 = gtk_label_new ("Current Progress");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, TRUE, FALSE, 2);
  gtk_misc_set_alignment (GTK_MISC (label2), 0.5, 1);

  main_progressbar = gtk_progress_bar_new ();
  gtk_widget_ref (main_progressbar);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "main_progressbar", main_progressbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (main_progressbar);
  gtk_box_pack_start (GTK_BOX (vbox1), main_progressbar, TRUE, FALSE, 0);
  gtk_progress_set_show_text (GTK_PROGRESS (main_progressbar), TRUE);

  label1 = gtk_label_new ("Total Progress");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, TRUE, FALSE, 2);
  gtk_misc_set_alignment (GTK_MISC (label1), 0.5, 1);

  job_progressbar = gtk_progress_bar_new ();
  gtk_widget_ref (job_progressbar);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "job_progressbar", job_progressbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (job_progressbar);
  gtk_box_pack_start (GTK_BOX (vbox1), job_progressbar, TRUE, FALSE, 0);
  gtk_progress_set_show_text (GTK_PROGRESS (job_progressbar), TRUE);

  keep_going_button = gtk_check_button_new_with_label ("Keep going regardless of any errors that are encountered.");
  gtk_widget_ref (keep_going_button);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "keep_going_button", keep_going_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (keep_going_button);
  gtk_box_pack_start (GTK_BOX (vbox1), keep_going_button, TRUE, TRUE, 0);

  dialog_action_area1 = GNOME_DIALOG (upload_window)->action_area;
  gtk_object_set_data (GTK_OBJECT (upload_window), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (upload_window),
                                          "Upload", GNOME_STOCK_PIXMAP_CONVERT);
  begin_button = g_list_last (GNOME_DIALOG (upload_window)->buttons)->data;
  gtk_widget_ref (begin_button);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "begin_button", begin_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (begin_button);
  GTK_WIDGET_SET_FLAGS (begin_button, GTK_CAN_DEFAULT);

  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (upload_window),
                                          "View Errors", GNOME_STOCK_PIXMAP_SEARCH);
  error_button = g_list_last (GNOME_DIALOG (upload_window)->buttons)->data;
  gtk_widget_ref (error_button);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "error_button", error_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect_object (GTK_OBJECT (error_button), "clicked",
									  GTK_SIGNAL_FUNC(gtk_widget_show),
									  GTK_OBJECT (error_log_window));
  gtk_widget_show (error_button);
  gtk_widget_set_sensitive (error_button, FALSE);
  GTK_WIDGET_SET_FLAGS (error_button, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (upload_window), GNOME_STOCK_BUTTON_CLOSE);
  close_button = g_list_last (GNOME_DIALOG (upload_window)->buttons)->data;
  gtk_widget_ref (close_button);
  gtk_object_set_data_full (GTK_OBJECT (upload_window), "close_button", close_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_signal_connect_object (GTK_OBJECT(close_button), "clicked",
									  GTK_SIGNAL_FUNC(gtk_widget_destroy),
									  GTK_OBJECT(upload_window));
  gtk_widget_show (close_button);
  GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (begin_button), "clicked",
                      GTK_SIGNAL_FUNC (start_main_update),
                      NULL);
  gtk_widget_show(upload_window);
}
   
int fe_catchup_site (void) {
   if (selected_site == NULL) {
      fe_status ("No site has been selected to catch-up.");
      return 0;
   }
   fe_gtk_question ("This will mark ALL files as already updated.\nAre you sure you want to do this?",
		(GnomeReplyCallback) catchup_selected);
   return 0;
}

void catchup_selected (gint button_number, gpointer data) {
   gchar result[BUFSIZ];
   
   if (button_number == GNOME_YES) {
      site_catchup (selected_site);
      sprintf (result, "All files in %s of site %s\nhave been marked as updated.",
	       selected_site->local_root, selected_site->name);
      fe_status (result);
      /* On huge sites, this may take ages? Progress bars/locking of ctree
       * selection may be advisable... */
      site_writefiles (selected_site);
      redraw_main_area();
      refresh_selected();
   }
}

int fe_init_site (void) {
   if (selected_site == NULL) {
      fe_status ("No site has been selected to initialise.");
      return 0;
   }
   fe_gtk_question ("This will mark all files as *NOT* updated on the remote site.\nAre you sure you want to do this?",
		(GnomeReplyCallback) initialize_selected);
   return 0;
}

void initialize_selected (gint button_number, 
			  gpointer data) {
   gchar result[BUFSIZ];
   
   switch (button_number) {
    case GNOME_YES:
      site_initialize (selected_site);
      sprintf (result, "All files in %s of site '%s'\nhave been marked as *NOT* updated.",
	       selected_site->local_root, selected_site->name);
      fe_status (result);
      /* On huge sites, this may take ages? Progress bars/locking of ctree
       * selection may be advisable... */
      site_writefiles (selected_site);
      redraw_main_area();
      refresh_selected();
      break;
    case GNOME_NO:
      break;
   }
}

void save_default (void) {
   gchar tmp[BUFSIZ];
   extern char *rcfile;
   extern bool rcfile_saved;
   extern GtkWidget *sitecopy;
   
   if (rcfile == NULL) {
      gnome_app_error (GNOME_APP (sitecopy), "The current rcfile is set to NULL. Sites will not be saved. Contact the maintainer.");
      return;
   }
   if (rcfile_write (rcfile, all_sites) == 0) {
      sprintf (tmp, "Site definitions saved to %s.", rcfile);
      fe_status (tmp);
   } else {
      gnome_error_dialog ("There was an error writing the site definitions.\n They may not have saved correctly.");
   }
   rcfile_saved = true;
}

void delete_a_site (GtkWidget *button_or_menu, gpointer data) {
   gchar tmp[BUFSIZ];
   
   if (selected_site == NULL) {
      gnome_error_dialog ("Cannot perform deletion - no site appears to be selected");
   } else {
      sprintf (tmp, "Are you sure you wish to permanently delete the record of '%s'?",
	       selected_site->name);
      fe_gtk_question (tmp, (GnomeReplyCallback) (delete_selected));
   }
}

struct site_t *find_prev_site (struct site_t *a_site) {
   struct site_t *tmp;
   tmp = all_sites;
   while ( tmp->next != NULL) {
      if ( strcmp (tmp->next->name, selected_site->name) == 0 ) {
	 return tmp;
      } else {
	 tmp = tmp->next;
      }
   }
   return NULL; /* Bad if this ever happens */
}

void delete_selected (gint button_number) {
   struct site_t *tmp, *tmp2;
   extern GtkCTree *the_tree;
   extern GtkCTreeNode *current_site_node;
   extern bool rcfile_saved;
   
   if (button_number != GNOME_YES)
     return;
   if ( (selected_site != NULL) && (all_sites != NULL) ) {
      if (strcmp (all_sites->name, selected_site->name) == 0) {
	 all_sites = all_sites->next;
      } else {
	 tmp = find_prev_site (selected_site);
	 if (tmp->next != NULL) {
	    tmp2 = tmp->next;
	    tmp->next = tmp2->next;
	 }
      }
      gtk_ctree_remove_node (GTK_CTREE (the_tree), 
			     GTK_CTREE_NODE (current_site_node));
      selected_site = NULL;
      current_site_node = NULL;
   } else {
      gnome_error_dialog ("I've detected no site is selected, but one should be selected in order to get here. Oh dear.");
   }
   clear_main_area();
   rcfile_saved = false;
}
