/*
   webalizer_lang.english

   Webalizer V1.2x Language Support file for English.
   15-May-1998 by Bradford L. Barrett (brad@mrunix.net)
   31-May-1998 Modified for level 1.1 support (brad@mrunix.net)
   23-Jul-1998 Modified for level 1.2 support (brad@mrunix.net)
   08-Mar-1999 Updated HTTP 1.1 response codes by Yves Lafon (ylafon@w3.org)
   28-Jun-1999 Modified for level 1.3 support (brad@mrunix.net)


   Language files are named using the following convention:

   webalizer_lang.LANGUAGE

   where 'LANGUAGE' is the name of the language the file is
   translated into (ie: webalizer_lang.russian for russian).
   Either copy the desired language file to webalizer_lang.h
   or create a symbolic link, then re-compile.

   If you translate this file into a different language, please
   send a copy to brad@mrunix.net.

*/

/***********************************************************************/
/* DEFINE LANGUAGE NAME here                                           */
/***********************************************************************/

char *language  = "English";

/***********************************************************************/
/*                                                                     */
/* Informational messages                                              */
/*                                                                     */
/* These messages are only displayed while The Webalizer is being run, */
/* usually to the screen, and are not part of the HTML output.         */
/*                                                                     */
/***********************************************************************/

/* these are only used in timing totals */
/* Format:   XXX records (XXX ignored, XXX bad) in X.XX seconds        */
char *msg_records = "records";
char *msg_ignored = "ignored";
char *msg_bad     = "bad";
char *msg_in      = "in";
char *msg_seconds = "seconds";

/* progress and setup error messages */
char *msg_log_err = "Error: Can't open log file";
char *msg_log_use = "Using logfile";
char *msg_dir_err = "Error: Can't change directory to";
char *msg_dir_use = "Creating output in";
char *msg_cur_dir = "current directory";
char *msg_hostname= "Hostname for reports is";
char *msg_ign_hist= "Ignoring previous history...";
char *msg_no_hist = "History file not found...";
char *msg_get_hist= "Reading history file...";
char *msg_put_hist= "Saving history information...";
char *msg_hist_err= "Error: Unable to write history file";
char *msg_bad_hist= "Error: Ignoring invalid history record";
char *msg_bad_conf= "Error: Unable to open configuration file";
char *msg_bad_key = "Warning: Invalid keyword";
char *msg_bad_date= "Error: Skipping record (bad date)";
char *msg_ign_nscp= "Skipping Netscape header record";
char *msg_bad_rec = "Skipping bad record";
char *msg_no_vrec = "No valid records found!";
char *msg_gen_rpt = "Generating report for";
char *msg_gen_sum = "Generating summary report";
char *msg_get_data= "Reading previous run data..";
char *msg_put_data= "Saving current run data...";
char *msg_no_data = "Previous run data not found...";
char *msg_bad_data= "Error: Unable to restore run data";
char *msg_data_err= "Error: Unable to save current run data";
char *msg_dup_data= "Warning: Possible duplicate data found";

/* memory allocation errors */
char *msg_nomem_ts= "Can't allocate enough memory, Top Sites disabled!";
char *msg_nomem_tr= "Can't allocate enough memory, Top Referrers disabled!";
char *msg_nomem_tu= "Can't allocate enough memory, Top URLs disabled!";
char *msg_nomem_tc= "Can't allocate enough memory, Top Countries disabled!";
char *msg_nomem_ta= "Can't allocate enough memory, Top User Agents disabled!";
char *msg_nomem_tsr="Can't allocate enough memory, Top Search Strings disabled!";
char *msg_nomem_dh= "Error adding host node (daily), skipping";
char *msg_nomem_mh= "Error adding host node (monthly), skipping";
char *msg_nomem_u = "Error adding URL node, skipping";
char *msg_nomem_a = "Error adding User Agent node, skipping";
char *msg_nomem_r = "Error adding Referrer node, skipping";
char *msg_nomem_sc= "Error adding Search String Node, skipping";

/* log record errors */
char *msg_big_rec = "Error: Skipping oversized log record";
char *msg_big_host= "Warning: Truncating oversized hostname";
char *msg_big_date= "Warning: Truncating oversized date field";
char *msg_big_req = "Warning: Truncating oversized request field";
char *msg_big_ref = "Warning: Truncating oversized referrer field";
char *msg_big_one = "Warning: String exceeds storage size";

/* misc errors */
char *msg_no_open = "Error: Unable to open file";

/* Help display... */
char *h_usage1 = "Usage";
char *h_usage2 = "[options] [log file]";
char *h_msg[]= {
         "-h        = print this help message"             ,
         "-v -V     = print version information"           ,
         "-d        = print additional debug info"         ,
         "-F        = Use FTP log format"                  ,
         "-f        = Fold sequence errors"                ,
         "-g        = use GMT (UTC) timestamps"            ,
         "-i        = ignore history file"                 ,
         "-p        = preserve state (incremental)"        ,
         "-q        = supress informational messages"      ,
         "-Q        = supress _ALL_ messages"              ,
         "-Y        = supress country graph"               ,
         "-G        = supress hourly graph"                ,
         "-H        = supress hourly stats"                ,
         "-L        = supress color coded graph legends"   ,
         "-l num    = use num background lines on graph"   ,
         "-m num    = Visit timout value (HHMMSS format)"  ,
         "-T        = print timing information"            ,
         "-c file   = use configuration file 'file'"       ,
         "-n name   = hostname to use"                     ,
         "-o dir    = output directory to use"             ,
         "-t name   = report title 'name'"                 ,
         "-a name   = hide user agent 'name'"              ,
         "-r name   = hide referrer 'name'"                ,
         "-s name   = hide site 'name'"                    ,
         "-u name   = hide URL 'name'"                     ,
         "-x name   = Use filename extension 'name'"       ,
         "-P name   = Page type extension 'name'"          ,
         "-I name   = Index alias 'name'"                  ,
         "-A num    = Display num top agents"              ,
         "-C num    = Display num top countries"           ,
         "-R num    = Display num top referrers"           ,
         "-S num    = Display num top sites"               ,
         "-U num    = Display num top URL's"               ,
         "-e num    = Display num top Entry Pages"         ,
         "-E num    = Display num top Exit Pages"          };

#define LAST_HLP_MSG (int)(sizeof(h_msg)/sizeof(char *))

/***********************************************************************/
/*                                                                     */
/* HTML strings                                                        */
/*                                                                     */
/* These strings are used as part of the HTML output generated by The  */
/* Webalizer.                                                          */ 
/*                                                                     */
/***********************************************************************/

/* header strings */
char *msg_hhdr_sp = "Summary Period";
char *msg_hhdr_gt = "Generated";

/* main index strings */
char *msg_main_us = "Usage summary for";
char *msg_main_per= "Last 12 Months";
char *msg_main_sum= "Summary by Month";
char *msg_main_da = "Daily Avg";
char *msg_main_mt = "Monthly Totals";

/* month HTML page strings */
char *msg_hmth_du = "Daily usage for";
char *msg_hmth_hu = "Hourly usage for";

/* table header strings */
char *msg_h_by    = "By";
char *msg_h_avg   = "Avg";
char *msg_h_max   = "Max";
char *msg_h_total = "Total";
char *msg_h_totals= "Totals";
char *msg_h_day   = "Day";
char *msg_h_mth   = "Month";
char *msg_h_hour  = "Hour";
char *msg_h_hits  = "Hits";
char *msg_h_pages = "Pages";
char *msg_h_visits= "Visits";
char *msg_h_files = "Files";
char *msg_h_sites = "Sites";
char *msg_h_xfer  = "KBytes";
char *msg_h_hname = "Hostname";
char *msg_h_url   = "URL";
char *msg_h_agent = "User Agent";
char *msg_h_ref   = "Referrer";
char *msg_h_ctry  = "Country";
char *msg_h_search= "Search String";

/* links along top of page */
char *msg_hlnk_ds = "Daily Statistics";
char *msg_hlnk_hs = "Hourly Statistics";
char *msg_hlnk_u  = "URL's";
char *msg_hlnk_s  = "Sites";
char *msg_hlnk_a  = "Agents";
char *msg_hlnk_c  = "Countries";
char *msg_hlnk_r  = "Referrers";
char *msg_hlnk_en = "Entry";
char *msg_hlnk_ex = "Exit";
char *msg_hlnk_sr = "Search";

/* monthly total table */
char *msg_mtot_ms = "Monthly Statistics for";
char *msg_mtot_th = "Total Hits";
char *msg_mtot_tf = "Total Files";
char *msg_mtot_tx = "Total KBytes";
char *msg_mtot_us = "Total Unique Sites";
char *msg_mtot_ur = "Total Unique Referrers";
char *msg_mtot_ua = "Total Unique User Agents";
char *msg_mtot_uu = "Total Unique URL's";
char *msg_mtot_mhd= "Hits per Day";
char *msg_mtot_mhh= "Hits per Hour";
char *msg_mtot_mfd= "Files per Day";
char *msg_mtot_mpd= "Pages per Day";
char *msg_mtot_mvd= "Visits per Day";
char *msg_mtot_mkd= "KBytes per Day";
char *msg_mtot_rc = "Hits by Response Code";

/* daily total table */
char *msg_dtot_ds = "Daily Statistics for";

/* hourly total table */
char *msg_htot_hs = "Hourly Statistics for";

/* country pie chart */
char *msg_ctry_use= "Usage by Country for";

/* top tables */
/* Formatted as "Top xxx of xxx Total something" */
char *msg_top_top = "Top";
char *msg_top_of  = "of";
char *msg_top_s   = "Total Sites";
char *msg_top_u   = "Total URL's";
char *msg_top_r   = "Total Referrers";
char *msg_top_a   = "Total User Agents";
char *msg_top_c   = "Total Countries";
char *msg_top_en  = "Total Entry Pages";
char *msg_top_ex  = "Total Exit Pages";
char *msg_top_sr  = "Total Search Strings";

/* short month names MUST BE 3 CHARS in size... pad if needed*/
char *s_month[12]={ "Jan", "Feb", "Mar",
                    "Apr", "May", "Jun",
                    "Jul", "Aug", "Sep",
                    "Oct", "Nov", "Dec"};

/* long month names - can be any length */
char *l_month[12]={ "January",  "February", "March",   "April",
                    "May",      "June",     "July",    "August",
                    "September","October",  "November","December"};

/* response code descriptions... order IS important!      */
struct response_code response[] =
       { { "Undefined response code",                    0 },
         { "Code 100 - Continue",                        0 },
         { "Code 101 - Switching Protocols",             0 },
         { "Code 200 - OK",                              0 },
         { "Code 201 - Created",                         0 },
         { "Code 202 - Accepted",                        0 },
         { "Code 203 - Non-Authoritative Information",   0 },
         { "Code 204 - No Content",                      0 },
         { "Code 205 - Reset Content",                   0 },
         { "Code 206 - Partial Content",                 0 },
         { "Code 300 - Multiple Choices",                0 },
         { "Code 301 - Moved Permanently",               0 },
         { "Code 302 - Found",                           0 },
         { "Code 303 - See Other",                       0 },
         { "Code 304 - Not Modified",                    0 },
         { "Code 305 - Use Proxy",                       0 },
         { "Code 307 - Moved Temporarily",               0 },
         { "Code 400 - Bad Request",                     0 },
         { "Code 401 - Unauthorized",                    0 },
         { "Code 402 - Payment Required",                0 },
         { "Code 403 - Forbidden",                       0 },
         { "Code 404 - Not Found",                       0 },
         { "Code 405 - Method Not Allowed",              0 },
         { "Code 406 - Not Acceptable",                  0 },
         { "Code 407 - Proxy Authentication Required",   0 },
         { "Code 408 - Request Timeout",                 0 },
         { "Code 409 - Conflict",                        0 },
         { "Code 410 - Gone",                            0 },
         { "Code 411 - Length Required",                 0 },
         { "Code 412 - Precondition Failed",             0 },
         { "Code 413 - Request Entity Too Large",        0 },
         { "Code 414 - Request-URI Too Long",            0 },
         { "Code 415 - Unsupported Media Type",          0 },
         { "Code 416 - Requested Range Not Satisfiable", 0 },
         { "Code 417 - Expectation Failed",              0 },
         { "Code 500 - Internal Server Error",           0 },
         { "Code 501 - Not Implemented",                 0 },
         { "Code 502 - Bad Gateway",                     0 },
         { "Code 503 - Service Unavailable",             0 },
         { "Code 504 - Gateway Timeout",                 0 },
         { "Code 505 - HTTP Version Not Supported",      0 } };

char *msg_title   = "Usage Statistics for";
char *msg_h_other = "Other";

/* Country codes (previously in ctry.h header file) */

struct	country_code { u_long idx;
                         char *desc;
                       u_long count;
                       u_long files;
                       double  xfer;
                     } ctry[] = {

{ 0,                      "Unresolved/Unknown",               0,0,0 },
{ IDX_3C('c','o','m'),    "US Commercial",                    0,0,0 },
{ IDX_3C('e','d','u'),    "US Educational",                   0,0,0 },
{ IDX_3C('g','o','v'),    "US Government",                    0,0,0 },
{ IDX_3C('i','n','t'),    "International (int)",              0,0,0 },
{ IDX_3C('m','i','l'),    "US Military",                      0,0,0 },
{ IDX_3C('n','e','t'),    "Network",                          0,0,0 },
{ IDX_3C('o','r','g'),    "Non-Profit Organization",          0,0,0 },
{ IDX_4C('a','r','p','a'),"Old style Arpanet (arpa)",         0,0,0 },
{ IDX_4C('n','a','t','o'),"Nato field (nato)",                0,0,0 },
{ IDX_2C('a','d'),        "Andorra",                          0,0,0 },
{ IDX_2C('a','e'),        "United Arab Emirates",             0,0,0 },
{ IDX_2C('a','f'),        "Afghanistan",                      0,0,0 },
{ IDX_2C('a','g'),        "Antigua and Barbuda",              0,0,0 },
{ IDX_2C('a','i'),        "Anguilla",                         0,0,0 },
{ IDX_2C('a','l'),        "Albania",                          0,0,0 },
{ IDX_2C('a','m'),        "Armenia",                          0,0,0 },
{ IDX_2C('a','n'),        "Netherlands Antilles",             0,0,0 },
{ IDX_2C('a','o'),        "Angola",                           0,0,0 },
{ IDX_2C('a','q'),        "Antarctica",                       0,0,0 },
{ IDX_2C('a','r'),        "Argentina",                        0,0,0 },
{ IDX_2C('a','s'),        "American Samoa",                   0,0,0 },
{ IDX_2C('a','t'),        "Austria",                          0,0,0 },
{ IDX_2C('a','u'),        "Australia",                        0,0,0 },
{ IDX_2C('a','w'),        "Aruba",                            0,0,0 },
{ IDX_2C('a','z'),        "Azerbaijan",                       0,0,0 },
{ IDX_2C('b','a'),        "Bosnia and Herzegovina",           0,0,0 },
{ IDX_2C('b','b'),        "Barbados",                         0,0,0 },
{ IDX_2C('b','d'),        "Bangladesh",                       0,0,0 },
{ IDX_2C('b','e'),        "Belgium",                          0,0,0 },
{ IDX_2C('b','f'),        "Burkina Faso",                     0,0,0 },
{ IDX_2C('b','g'),        "Bulgaria",                         0,0,0 },
{ IDX_2C('b','h'),        "Bahrain",                          0,0,0 },
{ IDX_2C('b','i'),        "Burundi",                          0,0,0 },
{ IDX_2C('b','j'),        "Benin",                            0,0,0 },
{ IDX_2C('b','m'),        "Bermuda",                          0,0,0 },
{ IDX_2C('b','n'),        "Brunei Darussalam",                0,0,0 },
{ IDX_2C('b','o'),        "Bolivia",                          0,0,0 },
{ IDX_2C('b','r'),        "Brazil",                           0,0,0 },
{ IDX_2C('b','s'),        "Bahamas",                          0,0,0 },
{ IDX_2C('b','t'),        "Bhutan",                           0,0,0 },
{ IDX_2C('b','v'),        "Bouvet Island",                    0,0,0 },
{ IDX_2C('b','w'),        "Botswana",                         0,0,0 },
{ IDX_2C('b','y'),        "Belarus",                          0,0,0 },
{ IDX_2C('b','z'),        "Belize",                           0,0,0 },
{ IDX_2C('c','a'),        "Canada",                           0,0,0 },
{ IDX_2C('c','c'),        "Cocos (Keeling) Islands",          0,0,0 },
{ IDX_2C('c','f'),        "Central African Republic",         0,0,0 },
{ IDX_2C('c','g'),        "Congo",                            0,0,0 },
{ IDX_2C('c','h'),        "Switzerland",                      0,0,0 },
{ IDX_2C('c','i'),        "Cote D'Ivoire (Ivory Coast)",      0,0,0 },
{ IDX_2C('c','k'),        "Cook Islands",                     0,0,0 },
{ IDX_2C('c','l'),        "Chile",                            0,0,0 },
{ IDX_2C('c','m'),        "Cameroon",                         0,0,0 },
{ IDX_2C('c','n'),        "China",                            0,0,0 },
{ IDX_2C('c','o'),        "Colombia",                         0,0,0 },
{ IDX_2C('c','r'),        "Costa Rica",                       0,0,0 },
{ IDX_2C('c','s'),        "Czechoslovakia (former)",          0,0,0 },
{ IDX_2C('c','u'),        "Cuba",                             0,0,0 },
{ IDX_2C('c','v'),        "Cape Verde",                       0,0,0 },
{ IDX_2C('c','x'),        "Christmas Island",                 0,0,0 },
{ IDX_2C('c','y'),        "Cyprus",                           0,0,0 },
{ IDX_2C('c','z'),        "Czech Republic",                   0,0,0 },
{ IDX_2C('d','e'),        "Germany",                          0,0,0 },
{ IDX_2C('d','j'),        "Djibouti",                         0,0,0 },
{ IDX_2C('d','k'),        "Denmark",                          0,0,0 },
{ IDX_2C('d','m'),        "Dominica",                         0,0,0 },
{ IDX_2C('d','o'),        "Dominican Republic",               0,0,0 },
{ IDX_2C('d','z'),        "Algeria",                          0,0,0 },
{ IDX_2C('e','c'),        "Ecuador",                          0,0,0 },
{ IDX_2C('e','e'),        "Estonia",                          0,0,0 },
{ IDX_2C('e','g'),        "Egypt",                            0,0,0 },
{ IDX_2C('e','h'),        "Western Sahara",                   0,0,0 },
{ IDX_2C('e','r'),        "Eritrea",                          0,0,0 },
{ IDX_2C('e','s'),        "Spain",                            0,0,0 },
{ IDX_2C('e','t'),        "Ethiopia",                         0,0,0 },
{ IDX_2C('f','i'),        "Finland",                          0,0,0 },
{ IDX_2C('f','j'),        "Fiji",                             0,0,0 },
{ IDX_2C('f','k'),        "Falkland Islands (Malvinas)",      0,0,0 },
{ IDX_2C('f','m'),        "Micronesia",                       0,0,0 },
{ IDX_2C('f','o'),        "Faroe Islands",                    0,0,0 },
{ IDX_2C('f','r'),        "France",                           0,0,0 },
{ IDX_2C('f','x'),        "France, Metropolitan",             0,0,0 },
{ IDX_2C('g','a'),        "Gabon",                            0,0,0 },
{ IDX_2C('g','b'),        "Great Britain (UK)",               0,0,0 },
{ IDX_2C('g','d'),        "Grenada",                          0,0,0 },
{ IDX_2C('g','e'),        "Georgia",                          0,0,0 },
{ IDX_2C('g','f'),        "French Guiana",                    0,0,0 },
{ IDX_2C('g','h'),        "Ghana",                            0,0,0 },
{ IDX_2C('g','i'),        "Gibraltar",                        0,0,0 },
{ IDX_2C('g','l'),        "Greenland",                        0,0,0 },
{ IDX_2C('g','m'),        "Gambia",                           0,0,0 },
{ IDX_2C('g','n'),        "Guinea",                           0,0,0 },
{ IDX_2C('g','p'),        "Guadeloupe",                       0,0,0 },
{ IDX_2C('g','q'),        "Equatorial Guinea",                0,0,0 },
{ IDX_2C('g','r'),        "Greece",                           0,0,0 },
{ IDX_2C('g','s'),        "S. Georgia and S. Sandwich Isls.", 0,0,0 },
{ IDX_2C('g','t'),        "Guatemala",                        0,0,0 },
{ IDX_2C('g','u'),        "Guam",                             0,0,0 },
{ IDX_2C('g','w'),        "Guinea-Bissau",                    0,0,0 },
{ IDX_2C('g','y'),        "Guyana",                           0,0,0 },
{ IDX_2C('h','k'),        "Hong Kong",                        0,0,0 },
{ IDX_2C('h','m'),        "Heard and McDonald Islands",       0,0,0 },
{ IDX_2C('h','n'),        "Honduras",                         0,0,0 },
{ IDX_2C('h','r'),        "Croatia (Hrvatska)",               0,0,0 },
{ IDX_2C('h','t'),        "Haiti",                            0,0,0 },
{ IDX_2C('h','u'),        "Hungary",                          0,0,0 },
{ IDX_2C('i','d'),        "Indonesia",                        0,0,0 },
{ IDX_2C('i','e'),        "Ireland",                          0,0,0 },
{ IDX_2C('i','l'),        "Israel",                           0,0,0 },
{ IDX_2C('i','n'),        "India",                            0,0,0 },
{ IDX_2C('i','o'),        "British Indian Ocean Territory",   0,0,0 },
{ IDX_2C('i','q'),        "Iraq",                             0,0,0 },
{ IDX_2C('i','r'),        "Iran",                             0,0,0 },
{ IDX_2C('i','s'),        "Iceland",                          0,0,0 },
{ IDX_2C('i','t'),        "Italy",                            0,0,0 },
{ IDX_2C('j','m'),        "Jamaica",                          0,0,0 },
{ IDX_2C('j','o'),        "Jordan",                           0,0,0 },
{ IDX_2C('j','p'),        "Japan",                            0,0,0 },
{ IDX_2C('k','e'),        "Kenya",                            0,0,0 },
{ IDX_2C('k','g'),        "Kyrgyzstan",                       0,0,0 },
{ IDX_2C('k','h'),        "Cambodia",                         0,0,0 },
{ IDX_2C('k','i'),        "Kiribati",                         0,0,0 },
{ IDX_2C('k','m'),        "Comoros",                          0,0,0 },
{ IDX_2C('k','n'),        "Saint Kitts and Nevis",            0,0,0 },
{ IDX_2C('k','p'),        "Korea (North)",                    0,0,0 },
{ IDX_2C('k','r'),        "Korea (South)",                    0,0,0 },
{ IDX_2C('k','w'),        "Kuwait",                           0,0,0 },
{ IDX_2C('k','y'),        "Cayman Islands",                   0,0,0 },
{ IDX_2C('k','z'),        "Kazakhstan",                       0,0,0 },
{ IDX_2C('l','a'),        "Laos",                             0,0,0 },
{ IDX_2C('l','b'),        "Lebanon",                          0,0,0 },
{ IDX_2C('l','c'),        "Saint Lucia",                      0,0,0 },
{ IDX_2C('l','i'),        "Liechtenstein",                    0,0,0 },
{ IDX_2C('l','k'),        "Sri Lanka",                        0,0,0 },
{ IDX_2C('l','r'),        "Liberia",                          0,0,0 },
{ IDX_2C('l','s'),        "Lesotho",                          0,0,0 },
{ IDX_2C('l','t'),        "Lithuania",                        0,0,0 },
{ IDX_2C('l','u'),        "Luxembourg",                       0,0,0 },
{ IDX_2C('l','v'),        "Latvia",                           0,0,0 },
{ IDX_2C('l','y'),        "Libya",                            0,0,0 },
{ IDX_2C('m','a'),        "Morocco",                          0,0,0 },
{ IDX_2C('m','c'),        "Monaco",                           0,0,0 },
{ IDX_2C('m','d'),        "Moldova",                          0,0,0 },
{ IDX_2C('m','g'),        "Madagascar",                       0,0,0 },
{ IDX_2C('m','h'),        "Marshall Islands",                 0,0,0 },
{ IDX_2C('m','k'),        "Macedonia",                        0,0,0 },
{ IDX_2C('m','l'),        "Mali",                             0,0,0 },
{ IDX_2C('m','m'),        "Myanmar",                          0,0,0 },
{ IDX_2C('m','n'),        "Mongolia",                         0,0,0 },
{ IDX_2C('m','o'),        "Macau",                            0,0,0 },
{ IDX_2C('m','p'),        "Northern Mariana Islands",         0,0,0 },
{ IDX_2C('m','q'),        "Martinique",                       0,0,0 },
{ IDX_2C('m','r'),        "Mauritania",                       0,0,0 },
{ IDX_2C('m','s'),        "Montserrat",                       0,0,0 },
{ IDX_2C('m','t'),        "Malta",                            0,0,0 },
{ IDX_2C('m','u'),        "Mauritius",                        0,0,0 },
{ IDX_2C('m','v'),        "Maldives",                         0,0,0 },
{ IDX_2C('m','w'),        "Malawi",                           0,0,0 },
{ IDX_2C('m','x'),        "Mexico",                           0,0,0 },
{ IDX_2C('m','y'),        "Malaysia",                         0,0,0 },
{ IDX_2C('m','z'),        "Mozambique",                       0,0,0 },
{ IDX_2C('n','a'),        "Namibia",                          0,0,0 },
{ IDX_2C('n','c'),        "New Caledonia",                    0,0,0 },
{ IDX_2C('n','e'),        "Niger",                            0,0,0 },
{ IDX_2C('n','f'),        "Norfolk Island",                   0,0,0 },
{ IDX_2C('n','g'),        "Nigeria",                          0,0,0 },
{ IDX_2C('n','i'),        "Nicaragua",                        0,0,0 },
{ IDX_2C('n','l'),        "Netherlands",                      0,0,0 },
{ IDX_2C('n','o'),        "Norway",                           0,0,0 },
{ IDX_2C('n','p'),        "Nepal",                            0,0,0 },
{ IDX_2C('n','r'),        "Nauru",                            0,0,0 },
{ IDX_2C('n','t'),        "Neutral Zone",                     0,0,0 },
{ IDX_2C('n','u'),        "Niue",                             0,0,0 },
{ IDX_2C('n','z'),        "New Zealand (Aotearoa)",           0,0,0 },
{ IDX_2C('o','m'),        "Oman",                             0,0,0 },
{ IDX_2C('p','a'),        "Panama",                           0,0,0 },
{ IDX_2C('p','e'),        "Peru",                             0,0,0 },
{ IDX_2C('p','f'),        "French Polynesia",                 0,0,0 },
{ IDX_2C('p','g'),        "Papua New Guinea",                 0,0,0 },
{ IDX_2C('p','h'),        "Philippines",                      0,0,0 },
{ IDX_2C('p','k'),        "Pakistan",                         0,0,0 },
{ IDX_2C('p','l'),        "Poland",                           0,0,0 },
{ IDX_2C('p','m'),        "St. Pierre and Miquelon",          0,0,0 },
{ IDX_2C('p','n'),        "Pitcairn",                         0,0,0 },
{ IDX_2C('p','r'),        "Puerto Rico",                      0,0,0 },
{ IDX_2C('p','t'),        "Portugal",                         0,0,0 },
{ IDX_2C('p','w'),        "Palau",                            0,0,0 },
{ IDX_2C('p','y'),        "Paraguay",                         0,0,0 },
{ IDX_2C('q','a'),        "Qatar",                            0,0,0 },
{ IDX_2C('r','e'),        "Reunion",                          0,0,0 },
{ IDX_2C('r','o'),        "Romania",                          0,0,0 },
{ IDX_2C('r','u'),        "Russian Federation",               0,0,0 },
{ IDX_2C('r','w'),        "Rwanda",                           0,0,0 },
{ IDX_2C('s','a'),        "Saudi Arabia",                     0,0,0 },
{ IDX_2C('s','B'),        "Solomon Islands",                  0,0,0 },
{ IDX_2C('s','c'),        "Seychelles",                       0,0,0 },
{ IDX_2C('s','d'),        "Sudan",                            0,0,0 },
{ IDX_2C('s','e'),        "Sweden",                           0,0,0 },
{ IDX_2C('s','g'),        "Singapore",                        0,0,0 },
{ IDX_2C('s','h'),        "St. Helena",                       0,0,0 },
{ IDX_2C('s','i'),        "Slovenia",                         0,0,0 },
{ IDX_2C('s','j'),        "Svalbard and Jan Mayen Islands",   0,0,0 },
{ IDX_2C('s','k'),        "Slovak Republic",                  0,0,0 },
{ IDX_2C('s','l'),        "Sierra Leone",                     0,0,0 },
{ IDX_2C('s','m'),        "San Marino",                       0,0,0 },
{ IDX_2C('s','n'),        "Senegal",                          0,0,0 },
{ IDX_2C('s','o'),        "Somalia",                          0,0,0 },
{ IDX_2C('s','r'),        "Suriname",                         0,0,0 },
{ IDX_2C('s','t'),        "Sao Tome and Principe",            0,0,0 },
{ IDX_2C('s','u'),        "USSR (former)",                    0,0,0 },
{ IDX_2C('s','v'),        "El Salvador",                      0,0,0 },
{ IDX_2C('s','y'),        "Syria",                            0,0,0 },
{ IDX_2C('s','z'),        "Swaziland",                        0,0,0 },
{ IDX_2C('t','c'),        "Turks and Caicos Islands",         0,0,0 },
{ IDX_2C('t','d'),        "Chad",                             0,0,0 },
{ IDX_2C('t','f'),        "French Southern Territories",      0,0,0 },
{ IDX_2C('t','g'),        "Togo",                             0,0,0 },
{ IDX_2C('t','h'),        "Thailand",                         0,0,0 },
{ IDX_2C('t','j'),        "Tajikistan",                       0,0,0 },
{ IDX_2C('t','k'),        "Tokelau",                          0,0,0 },
{ IDX_2C('t','m'),        "Turkmenistan",                     0,0,0 },
{ IDX_2C('t','n'),        "Tunisia",                          0,0,0 },
{ IDX_2C('t','o'),        "Tonga",                            0,0,0 },
{ IDX_2C('t','p'),        "East Timor",                       0,0,0 },
{ IDX_2C('t','r'),        "Turkey",                           0,0,0 },
{ IDX_2C('t','t'),        "Trinidad and Tobago",              0,0,0 },
{ IDX_2C('t','v'),        "Tuvalu",                           0,0,0 },
{ IDX_2C('t','w'),        "Taiwan",                           0,0,0 },
{ IDX_2C('t','z'),        "Tanzania",                         0,0,0 },
{ IDX_2C('u','a'),        "Ukraine",                          0,0,0 },
{ IDX_2C('u','g'),        "Uganda",                           0,0,0 },
{ IDX_2C('u','k'),        "United Kingdom",                   0,0,0 },
{ IDX_2C('u','m'),        "US Minor Outlying Islands",        0,0,0 },
{ IDX_2C('u','s'),        "United States",                    0,0,0 },
{ IDX_2C('u','y'),        "Uruguay",                          0,0,0 },
{ IDX_2C('u','z'),        "Uzbekistan",                       0,0,0 },
{ IDX_2C('v','a'),        "Vatican City State (Holy See)",    0,0,0 },
{ IDX_2C('v','c'),        "Saint Vincent and the Grenadines", 0,0,0 },
{ IDX_2C('v','e'),        "Venezuela",                        0,0,0 },
{ IDX_2C('v','g'),        "Virgin Islands (British)",         0,0,0 },
{ IDX_2C('v','i'),        "Virgin Islands (U.S.)",            0,0,0 },
{ IDX_2C('v','n'),        "Viet Nam",                         0,0,0 },
{ IDX_2C('v','u'),        "Vanuatu",                          0,0,0 },
{ IDX_2C('w','f'),        "Wallis and Futuna Islands",        0,0,0 },
{ IDX_2C('w','s'),        "Samoa",                            0,0,0 },
{ IDX_2C('y','e'),        "Yemen",                            0,0,0 },
{ IDX_2C('y','t'),        "Mayotte",                          0,0,0 },
{ IDX_2C('y','u'),        "Yugoslavia",                       0,0,0 },
{ IDX_2C('z','a'),        "South Africa",                     0,0,0 },
{ IDX_2C('z','m'),        "Zambia",                           0,0,0 },
{ IDX_2C('z','r'),        "Zaire",                            0,0,0 },
{ IDX_2C('z','w'),        "Zimbabwe",                         0 ,0,0}};

#define MAX_CTRY (int)(sizeof(ctry)/sizeof(struct country_code))
