"""AccessRule module

Provide a simple method to set up Access Rules
"""

from Globals import HTMLFile, MessageDialog

class AccessRule:
    meta_type = 'Set Access Rule'

def manage_addAccessRule(self, method_id=None, REQUEST=None, **ignored):
    """Point a __before_traverse__ entry at the specified method"""
    # We want the original object, not stuff in between, and no acquisition
    self = self.this() 
    self = getattr(self, 'aq_base', self)
    priority = (1, 'AccessRule')

    if method_id is None or (REQUEST and REQUEST.form.has_key('none')):
        btrmap = getattr(self, '__before_traverse__', None)
        if btrmap and btrmap.has_key(priority):
            method_id = btrmap[priority]
            del btrmap[priority]
            if len(btrmap):
                self.__before_traverse__ = btrmap
            else:
                del self.__before_traverse__
            try: del getattr(self, method_id).icon
            except: pass
        if REQUEST:
            return MessageDialog(title='No Access Rule',
              message='This object now has no Access Rule',
              action='%s/manage_main' % REQUEST['URL1'])
    elif method_id and hasattr(self, method_id):
        btrmap = getattr(self, '__before_traverse__', {})
        old_method_id = btrmap.get(priority, None)
        btrmap[priority] = method_id
        self.__before_traverse__ = btrmap
        try: 
            getattr(self, method_id).icon = 'misc_/SiteAccess/AccessRule.gif'
            if old_method_id: del getattr(self, old_method_id).icon
        except: pass
        if REQUEST:
            return MessageDialog(title='Access Rule Set',
              message='"%s" is now the Access Rule for this object' % method_id,
              action='%s/manage_main' % REQUEST['URL1'])
    else:
        if REQUEST:
            return MessageDialog(title='Invalid Method Id',
              message='"%s" is not the Id of a method of this object' % method_id,
              action='%s/manage_main' % REQUEST['URL1'])

def getAccessRule(self, REQUEST=None):
    "Return the name of the current AccessRule, if any"
    self = self.this() 
    self = getattr(self, 'aq_base', self)
    priority = (1, 'AccessRule')
    return getattr(self, '__before_traverse__', {}).get(priority, '')

constructors = (
  ('manage_addAccessRuleForm', HTMLFile('www/AccessRuleAdd', globals())),
  ('manage_addAccessRule', manage_addAccessRule),
  ('manage_getAccessRule', getAccessRule),
)
