"""SiteRoot module

Defines the Traverser base class and SiteRoot class
"""

from Globals import HTMLFile, MessageDialog, Persistent
from OFS.SimpleItem import Item
from Acquisition import Implicit, ImplicitAcquisitionWrapper
from ExtensionClass import Base
from string import split, strip

class Traverser(Persistent, Item):
    """Class for overriding container's __before_traverse__

    Containers are expected to have at most one instance of any particular
    subclass, with Id equal to the meta_type of the subclass."""

    meta_type='Traverser'
    priority = (100, meta_type)

    __ac_permissions__=()

    def manage_addToContainer(self, container, nextURL=''):
       try:
          container._setObject(self.id, self)
       except:
          if nextURL:
            return MessageDialog(title='Item Exists',
              message='This object already contains a %s' % self.meta_type,
              action=nextURL)
       else:
            self.manage_afterAdd(self, container)
            
            if nextURL:
              return MessageDialog(title='Item Added',
                message='This object now has a %s' % self.meta_type, 
                action=nextURL)

    def manage_beforeDelete(self, item, container):
        if item is self:
            try:
                del container.__before_traverse__[self.priority]
            except: pass

    def manage_afterAdd(self, item, container):
        if item is self:
            id = self.id
            if callable(id): id = id()

            # We want the original object, not stuff in between, and no acquisition
            container = container.this() 
            container = getattr(container, 'aq_base', container)

            cbt = getattr(container, '__before_traverse__', {})
            cbt[self.priority] = id
            container.__before_traverse__ = cbt

    def _setId(self, id):
        if id != self.id:
            raise Globals.MessageDialog(
                title='Invalid Id',
                message='Cannot change the id of a %s' % self.meta_type,
                action ='./manage_main',)

class SiteRoot(Traverser, Implicit):
    """SiteAccess.SiteRoot object

    A SiteRoot causes traversal of its container to replace the part
    of the Request path traversed so far with the request's SiteRootURL."""

    id = meta_type = 'SiteRoot'
    title = ''
    priority = (50, meta_type)

    manage_options=({'label':'Edit', 'action':'manage_main'},)

    manage = manage_main = HTMLFile('www/SiteRootEdit', globals())

    def __init__(self, title, base, path):
        '''Title'''
        self.title = strip(title)
        self.base = base = strip(base)
        self.path = path = strip(path)
        if base: self.SiteRootBASE = base
        else:
            try: del self.SiteRootBASE
            except: pass
        if path: self.SiteRootPATH = path
        else:
            try: del self.SiteRootPATH
            except: pass

    def manage_edit(self, title, base, path, REQUEST=None):
        '''Set the title, base, and path'''
        self.__init__(title, base, path)
        if REQUEST:
          return MessageDialog(title='SiteRoot changed.',
            message='The title is now "%s"<br>'
                    'The base is now "%s"<br>'
                    'The path is now "%s"<br>' % (title, base, path),
            action='%s/manage_main' % REQUEST['URL1'])

    def __call__(self, client, request, response=None):
        '''Traversing'''
        srd = [None, None]
        for i in (0, 1):
            srp = ('SiteRootBASE', 'SiteRootPATH')[i]
            try:
                srd[i] = getattr(self, srp)
            except AttributeError:
                srd[i] = request.get(srp, None)
                if srd[i] is None:
                    srd[i] = request.environ.get(srp, None)
        if srd <> [None, None]:
            base, path = srd
            request.setURL(base, path)
            if path is not None:
                path = filter(None, split(path, '/'))
                if base is None: base = request.script
                self.aq_parent._v_absolute_url = [base, path]
        else:
            try: del self.aq_parent._v_absolute_url
            except: pass

    def get_size(self):
        '''Make FTP happy'''
        return 0

def manage_addSiteRoot(self, title='', base='', path='', REQUEST=None, **ignored):
    """ """
    sr=SiteRoot(title, base, path)
    if REQUEST:
        return sr.manage_addToContainer(self.this(), '%s/manage_main' % REQUEST['URL1'])
    else:
        sr.manage_addToContainer(self.this())

constructors = (
  ('manage_addSiteRootForm', HTMLFile('www/SiteRootAdd', globals())),
  ('manage_addSiteRoot', manage_addSiteRoot),
)
