/****************************************************************************
 * This module is mostly all new
 * by Rob Nation
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************
 * Later modified for BowMan
 * by Bo Yang
 *
 * Modifications: Copyright 1995 Bo Yang. No further restrictions,
 * as long as this copyright notice is preserved.
 * 
/***********************************************************************
 *
 * afterstep icon code
 *
 ***********************************************************************/

#include "../configure.h"

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#ifdef NeXT
#include <fcntl.h>
#endif

#include <X11/Intrinsic.h>
#ifdef XPM
#include <X11/xpm.h>
#endif /* XPM */
#include "afterstep.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"
#include "module.h"

#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif /* SHAPE */

void GrabIconButtons(ASWindow *, Window);
void GrabIconKeys(ASWindow *, Window);
MyFont *IconFont;
static int IconTitleHeight(ASWindow *Tmp_win, int extraHeight);


/****************************************************************************
 *
 * Creates an icon window as needed
 *
 ****************************************************************************/
void CreateIconWindow(ASWindow *tmp_win, int def_x, int def_y)
{
  int final_x, final_y;
  unsigned long valuemask;		/* mask for create windows */
  XSetWindowAttributes attributes;	/* attributes for create windows */
  Window wt;

  ReleaseIconStuff(tmp_win);

  if(tmp_win->flags & SUPPRESSICON)
    return;

  SearchIcon(tmp_win, &tmp_win->icon_bitmap_file);
  GetIcon(tmp_win);
  final_x = def_x;
  final_y = def_y;
  if(final_x <0)
    final_x = 0;
  if(final_y <0)
    final_y = 0;
  
  if(final_x + tmp_win->icon_p_width >=Scr.MyDisplayWidth)
    final_x = Scr.MyDisplayWidth - tmp_win->icon_p_width-1;
  if(final_y + tmp_win->icon_p_height >=Scr.MyDisplayHeight)
    final_y = Scr.MyDisplayHeight - tmp_win->icon_p_height-1;

  tmp_win->icon_x_loc = final_x;
  tmp_win->icon_y_loc = final_y;

  /* clip to fit on screen */
  attributes.background_pixel = Scr.StdColors.back;
  valuemask =  CWBorderPixel | CWCursor | CWEventMask | CWBackPixel;
  attributes.border_pixel = Scr.StdColors.fore;
  attributes.cursor = Scr.ASCursors[DEFAULT];
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask | 
			   ExposureMask | KeyPressMask|EnterWindowMask |
			   FocusChangeMask );
  
  /* Create the icon window */
  tmp_win->icon_pixmap_w = 
    XCreateWindow(dpy, Scr.Root, final_x, final_y, 
		  tmp_win->icon_p_width, tmp_win->icon_p_height, 
		  0, CopyFromParent,
		  CopyFromParent,CopyFromParent,valuemask,&attributes);
  if (tmp_win->icon_type == APP_WINDOW_ICON)
    {
      int resize = FALSE;
      int width = tmp_win->icon_pm_width;
      int height = tmp_win->icon_pm_height;
      Window swallowed_w = (Window) tmp_win->icon_interior;
      int titleH = IconTitleHeight(tmp_win, 1);

      if (width > tmp_win->icon_p_width - 4)
	width = tmp_win->icon_p_width - 4,  resize = TRUE;
      if (height > tmp_win->icon_p_height - titleH - 4)
	height = tmp_win->icon_p_height - titleH - 4,  resize = TRUE;
      if (resize)
      {
	unsigned int bw = tmp_win->icon_pm_border << 1;
	XResizeWindow(dpy, swallowed_w, width - bw, height - bw);
      }
      XReparentWindow(dpy, swallowed_w, tmp_win->icon_pixmap_w,
		      (tmp_win->icon_p_width - width) / 2,
		      (tmp_win->icon_p_height - titleH - height) / 2 + titleH);
      XMapWindow(dpy, swallowed_w);
    }

#ifdef SHAPE
  if (tmp_win->flags & SHAPED_ICON  &&  Scr.flags & KeepIconWindows)
    {
      XShapeCombineMask(dpy, tmp_win->icon_pixmap_w, ShapeBounding,2, 2,
			tmp_win->icon_maskPixmap, ShapeSet);
    }
#endif

  if(tmp_win->icon_pixmap_w != None)
    {
      XSaveContext(dpy, tmp_win->icon_pixmap_w, ASContext, (caddr_t)tmp_win);
      XDefineCursor(dpy, tmp_win->icon_pixmap_w, Scr.ASCursors[DEFAULT]);
      GrabIconButtons(tmp_win,tmp_win->icon_pixmap_w);
      GrabIconKeys(tmp_win,tmp_win->icon_pixmap_w);
    }
  return;
}


/****************************************************************************
 *
 * Draws the icon window
 *
 ****************************************************************************/
void DrawIconWindow(ASWindow *Tmp_win)
{
  int titleH;

  if(Tmp_win->flags & SUPPRESSICON  ||  Tmp_win->icon_pixmap_w == None)
    return;

  flush_expose (Tmp_win->icon_pixmap_w);
  XSetWindowBackgroundPixmap(dpy,Tmp_win->icon_pixmap_w, Scr.IconBgPixmap);
  XClearWindow(dpy, Tmp_win->icon_pixmap_w);  
  XMoveWindow(dpy,Tmp_win->icon_pixmap_w,Tmp_win->icon_x_loc,
	      Tmp_win->icon_y_loc);
  
  /* need to locate the icon pixmap */
  titleH = IconTitleHeight(Tmp_win, -4);
  if (Tmp_win->icon_interior  &&  Tmp_win->icon_type != APP_WINDOW_ICON)
    {
      int w, h, x, y;
      x = y =0.0;
      w = Tmp_win->icon_pm_width;
      if( w > Tmp_win->icon_p_width-16) {
	x = (w- Tmp_win->icon_p_width+16)/2;
	w = Tmp_win->icon_p_width-16;
	}
      h = Tmp_win->icon_pm_height;
      if( h > Tmp_win->icon_p_height-16) {
	y = (h- Tmp_win->icon_p_height+16)/2;
	h = Tmp_win->icon_p_height-16;
	}
      if( Tmp_win->icon_maskPixmap) {
	XSetClipOrigin( dpy, Scr.FontGC, (Tmp_win->icon_p_width-w)/2,
		(Tmp_win->icon_p_height-h)/2+titleH);
 	XSetClipMask( dpy, Scr.FontGC, Tmp_win->icon_maskPixmap);
	}
      if(Tmp_win->iconDepth == Scr.d_depth) {
	  XCopyArea(dpy,Tmp_win->icon_interior,Tmp_win->icon_pixmap_w,Scr.FontGC,
		x, y,
		w, h,
		(Tmp_win->icon_p_width-w)/2,
		(Tmp_win->icon_p_height-h)/2+titleH);
	}
      else
	XCopyPlane(dpy,Tmp_win->icon_interior,Tmp_win->icon_pixmap_w,Scr.FontGC,
		x, y,
		w, h,
		(Tmp_win->icon_p_width-w)/2,
		(Tmp_win->icon_p_height-h)/2+titleH, 1);
      XSetClipMask( dpy, Scr.FontGC, 0);
    }
  if (Scr.flags & IconTitle)
    {
      int textX, cnt=0;
      char *text=NULL;
	  
      XSetForeground(dpy, Scr.IconGC, Scr.HiColors.back);
      XFillRectangle(dpy, Tmp_win->icon_pixmap_w, Scr.IconGC, 1, 1,
		     Tmp_win->icon_p_width-2,titleH+6);
      XSetForeground(dpy, Scr.IconGC, Scr.HiColors.fore);	  
      if (Tmp_win->icon_name==NULL) {
	if (Tmp_win->name!=NULL) {
	  cnt = strlen(Tmp_win->name);
	  textX = XTextWidth(Scr.IconFont.font,Tmp_win->name, cnt);
	  if (textX < Tmp_win->icon_p_width) {
	    textX = (Tmp_win->icon_p_width-textX)/2;
	    text = Tmp_win->name;
	  } else {
	    int i;
	    /* try to find approx. characters that fit here */
	    i=(Tmp_win->icon_p_width*cnt)/textX;
	    textX = 1;
	    text = &(Tmp_win->name[cnt-i]);
	    cnt = i;
	  }
	}
      } else {
	cnt = strlen(Tmp_win->icon_name);
	textX = XTextWidth(Scr.IconFont.font,Tmp_win->icon_name, cnt);
	if (textX < Tmp_win->icon_p_width) {
	  textX = (Tmp_win->icon_p_width-textX)/2;
	  text = Tmp_win->icon_name;
	} else {
	  int i;
	  /* try to find approx. characters that fit here */
	  i=(Tmp_win->icon_p_width*cnt)/textX;
	  textX = 1;
	  text = &(Tmp_win->icon_name[cnt-i]);
	  cnt = i;
	}
      }
      XDrawString(dpy, Tmp_win->icon_pixmap_w, Scr.IconGC, textX,
		  Scr.IconFont.font->ascent+1,  text, cnt);	  
    }
}

  
/***********************************************************************
 *
 *  Procedure:
 *	AutoPlace - Find a home for an icon
 *
 ************************************************************************/
void AutoPlace(ASWindow *t)
{
  int test_x=0, test_y=0,tw,th,tx,ty,i,temp_h,temp_w;
  int base_x, base_y;
  int width,height;
  ASWindow *test_window;
  Bool loc_ok;
  int real_x=10, real_y=10;

  /* New! Put icon in same page as the center of the window */
  /* Not a good idea for StickyIcons */
  if((Scr.flags & StickyIcons)||(t->flags & STICKY))
    {
      base_x = 0;
      base_y = 0;
    }
  else
    {
      base_x=((t->frame_x+Scr.Vx+(t->frame_width>>1))/Scr.MyDisplayWidth)*
	Scr.MyDisplayWidth - Scr.Vx;
      base_y=((t->frame_y+Scr.Vy+(t->frame_height>>1))/Scr.MyDisplayHeight)*
	Scr.MyDisplayHeight - Scr.Vy;
    }
  if(t->flags & ICON_MOVED)
    {
      /* just make sure the icon is on this screen */
      t->icon_x_loc = t->icon_x_loc % Scr.MyDisplayWidth + base_x;
      t->icon_y_loc = t->icon_y_loc % Scr.MyDisplayHeight + base_y;
      if(t->icon_x_loc < 0)
	t->icon_x_loc += Scr.MyDisplayWidth;
      if(t->icon_y_loc < 0)
	t->icon_y_loc += Scr.MyDisplayHeight;
    }
  else if (t->wmhints && t->wmhints->flags & IconPositionHint)
    {
      t->icon_x_loc = t->wmhints->icon_x;
      t->icon_y_loc = t->wmhints->icon_y;
    }
  else
    {
      width = t->icon_p_width;
      height = t->icon_p_height;
      loc_ok = False;  
      
      /* check all boxes in order */
      i=0;
      while((i<Scr.NumBoxes)&&(!loc_ok))
	{
	  /* In each IconBox, start at the upper left, travel right, then
	   * down */
	  test_y = Scr.IconBoxes[i][1]+base_y;
	  
	  temp_h = height;
	  temp_w = width;
	  
	  /* OK second try at this.
	   * If the window is taller than the icon box, ignore the icon height
	   * when figuring where to put it. Same goes for the width */
	  /* This should permit reasonably graceful handling of big icons. */
	  if(width >= (Scr.IconBoxes[i][2] - Scr.IconBoxes[i][0]))
	    temp_w = 0;
	  if(height >= (Scr.IconBoxes[i][3] - Scr.IconBoxes[i][1]))
	    temp_h = 0;
	  
	  while(((test_y + temp_h) < (Scr.IconBoxes[i][3]+base_y))&&(!loc_ok))
	    {

	      test_x = Scr.IconBoxes[i][0]+base_x;
	      while(((test_x + temp_w) < (Scr.IconBoxes[i][2]+base_x))&&
		    (!loc_ok))
		{
		  real_x = test_x;
		  real_y = test_y;
		  
		  if(test_x + width > (Scr.MyDisplayWidth/*-2*/+base_x))
		    real_x = Scr.MyDisplayWidth - width /*-2*/ + base_x;
		  if(test_y + height > (Scr.MyDisplayHeight/*-2*/+base_y))
		    real_y = Scr.MyDisplayHeight - height /*-2*/+base_y;
		  if(test_x <base_x)
		    real_x = base_x;
		  if(test_y < base_y)
		    real_y = base_y;
		  loc_ok = True;
		  test_window = Scr.ASRoot.next;
		  while((test_window != (ASWindow *)0)&&(loc_ok == True))
		    {
		      if(test_window->Desk == t->Desk)
			{
			  if((test_window->flags&ICONIFIED)&&
                             test_window->icon_pixmap_w&&
			     (test_window != t))
			    {
			      tw=test_window->icon_p_width;
			      th=test_window->icon_p_height;
			      tx = test_window->icon_x_loc;
			      ty = test_window->icon_y_loc;
			  
			      if((tx<(real_x+width+1))&&((tx+tw+1) > real_x)&&
				 (ty<(real_y+height+1))&&((ty+th +1)>real_y))
				{
				  loc_ok = False;
				}
			    }
			  if(Scr.flags & StubbornIconPlacement)
			    {
			      if(!(test_window->flags&ICONIFIED)&&
				 (test_window!=t))
				{
				  tw=test_window->frame_width;
				  th=test_window->frame_height;
				  tx = test_window->frame_x;
				  ty = test_window->frame_y;
			  
				  if((tx < (real_x+width+1))&&
				     ((tx+tw+1)>real_x)&&
				     (ty < (real_y+height+1))&&
				     ((ty+th+1)>real_y))
				    {
				      loc_ok = False;
				    }
				}
			    }
			}
		      test_window = test_window->next;
		    }
		  test_x +=1; 
		}
	      test_y +=1; 
	    }
	  i++;
	}
      if(loc_ok == False)
	return;
      t->icon_x_loc = real_x;
      t->icon_y_loc = real_y;
    }

  if(t->icon_pixmap_w)
    XMoveWindow(dpy,t->icon_pixmap_w,t->icon_x_loc, t->icon_y_loc);

  Broadcast(M_ICON_LOCATION,7,t->w,t->frame,
	    (unsigned long)t,
	    t->icon_x_loc,t->icon_y_loc,
	    t->icon_p_width, t->icon_p_height);
}

/***********************************************************************
 *
 *  Procedure:
 *	GrabIconButtons - grab needed buttons for the icon window
 *
 *  Inputs:
 *	tmp_win - the afterstep window structure to use
 *
 ***********************************************************************/
void GrabIconButtons(ASWindow *tmp_win, Window w)
{
  MouseButton *MouseEntry;

  MouseEntry = Scr.MouseButtonRoot;
  while(MouseEntry != (MouseButton *)0)
    {
      if((MouseEntry->func != (int)0)&&(MouseEntry->Context & C_ICON))
	{
	  if(MouseEntry->Button >0)
	      MyXGrabButton(dpy, MouseEntry->Button, MouseEntry->Modifier, w, 
			True, ButtonPressMask | ButtonReleaseMask,
			GrabModeAsync, GrabModeAsync, None, 
			Scr.ASCursors[DEFAULT]);
	  else
	    {
	      int i;
	      for (i = 0; i < MAX_BUTTONS; i++)
	        {
		  MyXGrabButton(dpy, i+1, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.ASCursors[DEFAULT]);
	    }
	}
	}
      
      MouseEntry = MouseEntry->NextButton;
    }
  return;
}



/***********************************************************************
 *
 *  Procedure:
 *	GrabIconKeys - grab needed keys for the icon window
 *
 *  Inputs:
 *	tmp_win - the afterstep window structure to use
 *
 ***********************************************************************/
void GrabIconKeys(ASWindow *tmp_win,Window w)
{
  FuncKey *tmp;
  for (tmp = Scr.FuncKeyRoot.next; tmp != NULL; tmp = tmp->next)
    {
      if (tmp->cont & C_ICON)
        {
	  MyXGrabKey(dpy, tmp->keycode, tmp->mods, w, True,
		 GrabModeAsync, GrabModeAsync);
        }
    }
  return;
}


/****************************************************************************
 *
 * Looks for a monochrome icon bitmap file
 *
 ****************************************************************************/
static int GetBitmapFile(ASWindow *tmp_win)
{
  char *path;
  int HotX,HotY;
  unsigned int width, height;
  Pixmap pixmap;
  extern char *IconPath;

  path = findIconFile(tmp_win->icon_bitmap_file, IconPath, R_OK);
  if (path == NULL)
    return FALSE;

  if (XReadBitmapFile(dpy, Scr.Root,path, &width, &height, &pixmap,
		      &HotX, &HotY) == BitmapSuccess)
    {
      tmp_win->icon_type = OUR_BITMAP_ICON;
      tmp_win->icon_pm_width = width;
      tmp_win->icon_pm_height = height;
      tmp_win->icon_pm_border = 0;
      tmp_win->icon_interior = (Drawable) pixmap;
      tmp_win->icon_maskPixmap = None;
      free(path);
      return TRUE;
    }
    
  free(path);
  return FALSE;
}

/****************************************************************************
 *
 * Looks for a color XPM icon file
 *
 ****************************************************************************/
static int GetXPMFile(ASWindow *tmp_win)
{
#ifdef XPM
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
  unsigned int width, height;
  Pixmap pixmap, mask;
  extern char *PixmapPath;
  char *path;

  path = findIconFile(tmp_win->icon_bitmap_file, PixmapPath, R_OK);
  if (path == NULL)
    return FALSE;

  XGetWindowAttributes(dpy,Scr.Root,&root_attr);
  xpm_attributes.colormap = root_attr.colormap;
  xpm_attributes.closeness = 40000; /* Allow for "similar" colors */
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels | XpmColormap | XpmCloseness;

  if (XpmReadFileToPixmap(dpy, Scr.Root, path, &pixmap, &mask,
			  &xpm_attributes) == XpmSuccess ) {
      tmp_win->icon_type = OUR_PIXMAP_ICON;
      tmp_win->icon_interior = (Drawable) pixmap;
      tmp_win->icon_maskPixmap = mask;
      tmp_win->icon_pm_width = xpm_attributes.width;
      tmp_win->icon_pm_height = xpm_attributes.height;
      tmp_win->icon_pm_border = 0;
      tmp_win->iconDepth = Scr.d_depth;
#ifdef SHAPE
      if (tmp_win->icon_maskPixmap)
	tmp_win->flags |= SHAPED_ICON;
      else
#endif
      free(path);
      return TRUE;
  }
  free(path);
#endif /* XPM */
  return FALSE;
}

/****************************************************************************
 *
 * Looks for an application supplied icon window
 *
 ****************************************************************************/
static int GetIconWindow(ASWindow *tmp_win)
{
  Window w;
  unsigned int width, height;

  /* We are guaranteed that wmhints is non-null when calling this
   * routine */
  if (!(tmp_win->wmhints->flags & IconWindowHint))
    return FALSE;
  if ((w = tmp_win->wmhints->icon_window) == None)
    return FALSE;
  if(XGetGeometry(dpy, w, &JunkRoot, 
		  &JunkX, &JunkY, &width, &height,
		  &JunkBW, &JunkDepth)==0)
    {
      fprintf(stderr,"Help! Bad Icon Window!\n");
      return FALSE;
    }
#if 1
  /* Experimental. An application-supplied border looks ugly against
     the AfterStep-supplied icon background, so nuke the border. */
  XSetWindowBorderWidth (dpy, w, 0);
  JunkBW = 0;
#endif
  tmp_win->icon_type = APP_WINDOW_ICON;
  tmp_win->icon_interior = (Drawable)(w);
  tmp_win->icon_maskPixmap = None;
  tmp_win->icon_pm_width = width + (JunkBW<<1);
  tmp_win->icon_pm_height = height + (JunkBW<<1);
  tmp_win->icon_pm_border = JunkBW;
  if (tmp_win->wmhints->flags & IconMaskHint)
    if (tmp_win->wmhints->icon_mask != None)
      {
#ifdef SHAPE
	tmp_win->flags |= SHAPED_ICON;
#endif
	tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
      }
  return TRUE;
}


/****************************************************************************
 *
 * Looks for an application supplied bitmap or pixmap
 *
 ****************************************************************************/
static int GetIconBitmap(ASWindow *tmp_win)
{
  Pixmap pixmap;
  unsigned int width, height;

  /* We are guaranteed that wmhints is non-null when calling this
   * routine */
  if (!(tmp_win->wmhints->flags & IconPixmapHint))
    return FALSE;
  if ((pixmap = tmp_win->wmhints->icon_pixmap) == None)
    return FALSE;
  if (XGetGeometry(dpy, pixmap, &JunkRoot, &JunkX, &JunkY,
		   &width, &height, &JunkBW, &JunkDepth))
    {
      fprintf(stderr,"Help! Bad Icon Pixmap!\n");
      return FALSE;
    }
  tmp_win->icon_type = APP_PIXMAP_ICON;
  tmp_win->icon_interior = (Drawable) pixmap;
  tmp_win->icon_maskPixmap = None;
  tmp_win->icon_pm_width = width;
  tmp_win->icon_pm_height = height;
  tmp_win->icon_pm_border = 0;
  tmp_win->iconDepth = JunkDepth;
  if (tmp_win->wmhints->flags & IconMaskHint)
    if (tmp_win->wmhints->icon_mask != None)
      {
#ifdef SHAPE
	tmp_win->flags |= SHAPED_ICON;
#endif
	tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
      }
  return TRUE;
}



/***********************************************************************
 *
 *  Procedure:
 *	DeIconify a window
 *
 ***********************************************************************/
void DeIconify(ASWindow *tmp_win)
{
  ASWindow *t, *tn, *tmp;
  int new_x,new_y,w2,h2;

  /* now de-iconify transients */
  for (t = Scr.ASRoot.next; t != NULL; t = tn)
    {
      tn = t->next;
      if ((t == tmp_win)|| 
	  ((t->flags & TRANSIENT) &&(t->transientfor == tmp_win->w)))
	{
	  t->flags |= MAPPED;
	  if(Scr.Hilite == t)
	    SetBorder (t, False,True,True,None);
	  /* make sure that the window is on this screen */
	  if((t->frame_x < 0)||(t->frame_y<0)||
	     (t->frame_x >= Scr.MyDisplayWidth)||
	     (t->frame_y >= Scr.MyDisplayHeight))
	    
	    {
	      /* try to put at least half the window
	       * in the current screen, if the current desktop
	       * is the windows desktop */
	      if(Scr.flags & StubbornIcons)
		t->Desk = t->DeIconifyDesk;
	      else
		t->Desk = Scr.CurrentDesk;

	      if(t->Desk == Scr.CurrentDesk)
		{
		  new_x = t->frame_x;
		  new_y = t->frame_y;
		  w2 = (t->frame_width>>1);
		  h2 = (t->frame_height>>1);
		  if(!(Scr.flags & StubbornIcons))
		    {
		      if (( new_x < -w2) || (new_x > (Scr.MyDisplayWidth-w2 )))
			{
			  new_x = new_x % Scr.MyDisplayWidth;
			  if ( new_x < -w2 )
			    new_x += Scr.MyDisplayWidth;
			}
		      if ((new_y < -h2) || (new_y > (Scr.MyDisplayHeight-h2 )))
			{
			  new_y = new_y % Scr.MyDisplayHeight;
			  if ( new_y < -h2 )
			    new_y += Scr.MyDisplayHeight;
			}
		    }
		  SetupFrame(t,new_x,new_y,
			     t->frame_width,t->frame_height,False);
		}
	    }
	  if (t->icon_pixmap_w) 
	    XUnmapWindow(dpy, t->icon_pixmap_w);
	  XFlush(dpy);
	  Broadcast(M_DEICONIFY,5,t->w,t->frame,(unsigned long)t,
		    t->icon_x_loc,t->icon_y_loc,
		    t->icon_p_width,t->icon_p_height);
	  XMapWindow(dpy, t->w);
	  if(t->Desk == Scr.CurrentDesk)
	    {
	      XMapWindow(dpy, t->frame);
	      t->flags |= MAP_PENDING;
	    }
	  XMapWindow(dpy, t->Parent);
	  SetMapStateProp(t, NormalState);
	  t->flags &= ~ICONIFIED;
	  t->flags &= ~ICON_UNMAPPED;
	  /* Need to make sure the border is colored correctly,
	   * in case it was stuck or unstuck while iconified. */
	  tmp = Scr.Hilite;
	  Scr.Hilite = t;
	  SetBorder(t,False,True,True,None);
	  Scr.Hilite = tmp;
	  XRaiseWindow(dpy,t->w);
	  /*  Commented out for locking code 03/08/97
	  if (t->icon_pixmap_w) 
	    XUnmapWindow(dpy, t->icon_pixmap_w);
	  Broadcast(M_DEICONIFY,3,t->w,t->frame,(unsigned long)t,0,0,0,0);
	  */
	}
    }
  RaiseWindow(tmp_win);

  if((Scr.flags & StubbornIcons)||(Scr.flags & ClickToFocus))
    FocusOn(tmp_win,1,False);

  for (t = Scr.ASRoot.next; t != NULL; t = t->next)
    {
	/* If its an icon, and its sticking, autoplace it so
	* that it doesn't wind up on top a a stationary
	* icon */
	if(((Scr.flags & StickyIcons))&&(t->flags & ICONIFIED)
	  &&(!(t->flags & ICON_MOVED))&&(!(t->flags & ICON_UNMAPPED)))
	    AutoPlace(t);
    }

  MoveResizePagerView(tmp_win);
  return;
}


/****************************************************************************
 *
 * Iconifies the selected window
 *
 ****************************************************************************/
void Iconify(ASWindow *tmp_win, int def_x, int def_y)
{
  ASWindow *t;
  XWindowAttributes winattrs;
  unsigned long eventMask;

  XGetWindowAttributes(dpy, tmp_win->w, &winattrs);
  eventMask = winattrs.your_event_mask;

  if((tmp_win)&&(tmp_win == Scr.Hilite)&&
     (Scr.flags & ClickToFocus)&&(tmp_win->next))
    {
      SetFocus(tmp_win->next->w,tmp_win->next,False);
    }


  /* iconify transients first */
  for (t = Scr.ASRoot.next; t != NULL; t = t->next)
    {
      if ((t==tmp_win)||
	  ((t->flags & TRANSIENT) && (t->transientfor == tmp_win->w)))
	{
	  /*
	   * Prevent the receipt of an UnmapNotify, since that would
	   * cause a transition to the Withdrawn state.
	   */
	  t->flags &= ~MAPPED;
	  XSelectInput(dpy, t->w, eventMask & ~StructureNotifyMask);
          XUnmapWindow(dpy, t->w);
          XSelectInput(dpy, t->w, eventMask);
          XUnmapWindow(dpy, t->frame);
	  t->DeIconifyDesk = t->Desk;
	  if (t->icon_pixmap_w)
	    XUnmapWindow(dpy, t->icon_pixmap_w);

	  SetMapStateProp(t, IconicState);
	  SetBorder (t, False,False,False,None);
	  if(t != tmp_win)
	    {
	      t->flags |= ICONIFIED|ICON_UNMAPPED;

	      Broadcast(M_ICONIFY,7,t->w,t->frame,
			(unsigned long)t,
			-10000, -10000,
			t->icon_p_width, 
			t->icon_p_height);
	      BroadcastConfig(M_CONFIGURE_WINDOW,t);
	    }
	  if(t!= tmp_win)
	    MoveResizePagerView(t);
	}
    } 

    if(tmp_win->flags & ICON_MOVED)
      CreateIconWindow(tmp_win,tmp_win->icon_x_loc,tmp_win->icon_y_loc);
    else
      CreateIconWindow(tmp_win, def_x, def_y);

  AutoPlace(tmp_win);
  tmp_win->flags |= ICONIFIED;
  tmp_win->flags &= ~ICON_UNMAPPED;

  XFlush(dpy);

  Broadcast(M_ICONIFY,7,tmp_win->w,tmp_win->frame,
	    (unsigned long)tmp_win,
	    tmp_win->icon_x_loc,tmp_win->icon_y_loc,
	    tmp_win->icon_p_width, 
	    tmp_win->icon_p_height);
  BroadcastConfig(M_CONFIGURE_WINDOW,tmp_win);

  LowerWindow(tmp_win);
  if(tmp_win->Desk == Scr.CurrentDesk)
    {
      
      if(tmp_win->icon_pixmap_w != None)
	XMapWindow(dpy, tmp_win->icon_pixmap_w);
      MoveResizePagerView(tmp_win);
    }
  if((Scr.flags & ClickToFocus)||(Scr.flags & SloppyFocus))
    {
      if ((tmp_win)&&(tmp_win == Scr.Focus))
	{
	  if(Scr.PreviousFocus == Scr.Focus)
	    Scr.PreviousFocus = NULL;
	  if((Scr.flags & ClickToFocus)&&(tmp_win->next))
	    SetFocus(tmp_win->next->w, tmp_win->next, False);
	  else
	    {
	      SetFocus(Scr.NoFocusWin, NULL, False);
	    }
	}
    }
  return;
}

void GetIcon(ASWindow *tmp_win)
{
  if (tmp_win->wmhints != NULL)
    {
      /* First preference is an app-supplied icon window */
      if (GetIconWindow(tmp_win))
	goto found;

      /* Second preference is an app-supplied pixmap */
      if (GetIconBitmap(tmp_win))
	goto found;
    }
  if (tmp_win->icon_bitmap_file != NULL)
    {
      /* Third preference is a color pixmap given in .steprc file */
      if (GetXPMFile(tmp_win))
	goto found;

      /* Fourth preference is a monochrome pixmap given in .steprc file */
      if (GetBitmapFile(tmp_win))
	goto found;
    }

  /* Else there is nothing inside the icon. Pretend that the application
     gave us an empty pixmap. */
  tmp_win->icon_type = APP_PIXMAP_ICON;
  tmp_win->icon_interior = None;
  tmp_win->icon_maskPixmap = None;
  tmp_win->icon_pm_width = 0;
  tmp_win->icon_pm_height = 0;

  /* We have determined the icon's interior */
found:
  if (tmp_win->icon_pm_width == 0  ||  tmp_win->icon_pm_height == 0)
    {
      tmp_win->icon_pm_width = Scr.IconBgWidth - 16;
      tmp_win->icon_pm_height = Scr.IconBgHeight - 16;
    }
#ifdef SHAPE
  if (Scr.flags & KeepIconWindows)
    {
      /*FIXME: Above condition is not sufficient*/
      tmp_win->icon_p_width = tmp_win->icon_pm_width;
      tmp_win->icon_p_height = tmp_win->icon_pm_height;
      return;
    }
#endif
  tmp_win->icon_p_width = Scr.IconBgWidth;
  tmp_win->icon_p_height = Scr.IconBgHeight;
}


/* Release a window's pixmaps */
void ReleasePixmaps(ASWindow *tmp_win)
{
  if (tmp_win->icon_interior != None)
    XFreePixmap(dpy, (Pixmap) tmp_win->icon_interior);
  if (tmp_win->icon_maskPixmap != None)
    XFreePixmap(dpy, tmp_win->icon_maskPixmap);
}


/* Release all icon resources for specified window */
void ReleaseIconStuff(ASWindow *tmp_win)
{
  Window w;

  switch (tmp_win->icon_type)
    {
    default:
    case NULL_ICON:		/* no icon resources held */
      return;
    case OUR_BITMAP_ICON:	/* bitmap inside icon; we free */
    case OUR_PIXMAP_ICON:	/* pixmap inside icon; we free */
      ReleasePixmaps(tmp_win);
      break;
    case APP_PIXMAP_ICON:	/* app pixmap inside icon; not ours to free  */
      break;
    case APP_WINDOW_ICON:	/* application-supplied window inside icon */
      if (tmp_win->icon_interior != None)
	{
	  Window swallowed_w = (Window) tmp_win->icon_interior;
	  XUnmapWindow(dpy, swallowed_w);
	  /* Reparent swallowed window so it won't die when icon window is
	     destroyed */
	  XReparentWindow(dpy, swallowed_w, Scr.Root, 0, 0);
	  XDeleteContext(dpy, swallowed_w, ASContext);
	}
      break;
    }
  if ((w = tmp_win->icon_pixmap_w) != None)
    {
      XDestroyWindow(dpy, w);
      XDeleteContext(dpy, w, ASContext);
    }
  tmp_win->icon_type = NULL_ICON;
  tmp_win->icon_pixmap_w = None;
  tmp_win->icon_interior = None;
  tmp_win->iconDepth = 0;
  tmp_win->flags &= ~SHAPED_ICON;
}


/****************************************************************************
 *
 * Returns height of a window's icon title plus an extraHeight.
 * Returns zero if icon titles are disabled or the window has no title.
 *
 ****************************************************************************/
static int IconTitleHeight(ASWindow *Tmp_win, int extraHeight)
{
  if (!(Scr.flags & IconTitle))
    return 0;
  if (Tmp_win->icon_name == NULL  &&  Tmp_win->name == NULL)
    return 0;
  return Scr.IconFont.height + extraHeight;
}
