/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "loadicon.h"
#include "createicon.h"
#include "positionarrange.h"
#include "stringfunctions.h"
#include <X11/extensions/shape.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "color.h"
#include "includepixmaps/noicon.xpm"
#include "includepixmaps/littlenoicon.xpm"
#include "includepixmaps/littlelink.xpm"
#include "pixmap.h"
#include "iwc.h"
#include "extension.h"
#include "positiontext.h"
#include "iconmanager.h"

#include <time.h>

#include <grp.h>
#include <pwd.h>
#include "shell.h"

XFontStruct *fontst=NULL;
Pixmap littlelinkpix=0;
Pixmap littlenoicon=0;
GC gch=0;

/* WriteDetailIcon is used mainly for expose Events in the detail view. It
   writes the complete line of the specified item */
void WriteDetailIcon(struct item *direntry)
{
  mode_t um;
  struct passwd *username;
  struct group *groupname;
  char *text=NULL;
  time_t now;
  int nowyear;
  int fileyear;
  char timestr[80];
  
  if (direntry->mark==False) {
    XSetBackground(GetDisplay(),gch,GetBGColor());
    XSetForeground(GetDisplay(),gch,GetFGColor());
    XSetWindowBackground(GetDisplay(),direntry->Iconwindow,GetBGColor());
  } else {
    XSetBackground(GetDisplay(),gch,GetFGColor());
    XSetForeground(GetDisplay(),gch,GetBGColor());
    XSetWindowBackground(GetDisplay(),direntry->Iconwindow,GetFGColor());
  }
  XClearWindow(GetDisplay(),direntry->Iconwindow);    
  text=malloc(13);
  sprintf(text,"%11ld",direntry->info.st_size);
  XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                   1,12,text,strlen(text));
  free(text);
  text=strdup(direntry->filename);
  if (strlen(text)>31)
    text[31]=0;
  XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                   115,12,text,strlen(text));
  free(text);
  time(&now);
  nowyear=localtime(&now)->tm_year;
  fileyear=localtime(&(direntry->info.st_mtime))->tm_year;
  if (fileyear<nowyear)
    strftime(timestr,79,"%b %d  %Y",localtime(&(direntry->info.st_mtime)));
  else
    strftime(timestr,79,"%b %d %H:%M",localtime(&(direntry->info.st_mtime)));
  if (timestr[4]=='0')
    timestr[4]=' ';
  XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,368,12,timestr,12);
  /*XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                   304,12,ctime(&(direntry->info.st_mtime)),24);*/
  text=malloc(11);
  um=direntry->info.st_mode & S_IFMT;
  if (direntry->type>=2) strcpy(text,"l");
  else if (um == S_IFSOCK) strcpy(text,"s");
  else if (um == S_IFREG) strcpy(text,"-");
  else if (um == S_IFDIR) strcpy(text,"d");
  else if (um == S_IFBLK) strcpy(text,"b");
  else if (um == S_IFCHR) strcpy(text,"c");
  else strcpy(text,"f");
  um=direntry->info.st_mode;
  if ((um & S_IRUSR)==0) strcat(text,"-");
  else strcat(text,"r");
  if ((um & S_IWUSR)==0) strcat(text,"-");
  else strcat(text,"w");
  if ((um & S_IXUSR)==0) strcat(text,"-");
  else {
    if ((um & S_ISUID)==0) strcat(text,"x");
    else strcat(text,"s");
  }
  if ((um & S_IRGRP)==0) strcat(text,"-");
  else strcat(text,"r");
  if ((um & S_IWGRP)==0) strcat(text,"-");
  else strcat(text,"w");
  if ((um & S_IXGRP)==0) strcat(text,"-");
  else {
    if ((um & S_ISGID)==0) strcat(text,"x");
    else strcat(text,"s");
  }
  if ((um & S_IROTH)==0) strcat(text,"-");
  else strcat(text,"r");
  if ((um & S_IWOTH)==0) strcat(text,"-");
  else strcat(text,"w");
  if ((um & S_IXOTH)==0) strcat(text,"-");
  else {
    if ((um & S_ISVTX)==0) strcat(text,"x");
    else strcat(text,"t");
  }
  XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,472,12,text,10);
  free(text);
  username=getpwuid(direntry->info.st_uid);
  if (username!=NULL) {
    XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                     559,12,username->pw_name,strlen(username->pw_name));
  } else {
    text=malloc(13);
    sprintf(text,"%d",(int)direntry->info.st_uid);
    XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                     559,12,text,strlen(text));
    free(text);
  }
  groupname=getgrgid(direntry->info.st_gid);
  if (groupname!=NULL) {
    XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                     631,12,groupname->gr_name,strlen(groupname->gr_name));
  } else {
    text=malloc(13);
    sprintf(text,"%d",(int)direntry->info.st_gid);
    XDrawImageString(GetDisplay(),direntry->Iconwindow,gch,
                     631,12,text,strlen(text));
    free(text);
  }
  XSetClipMask(GetDisplay(),gch,direntry->minis);
  XCopyArea(GetDisplay(),direntry->mini,direntry->Iconwindow,gch,
		0,0,14,14,96,0);
  XSetClipMask(GetDisplay(),gch,None);
  if (direntry->type>=2)
      XCopyArea(GetDisplay(),littlelinkpix,direntry->Iconwindow,gch,
		0,0,7,8,104,7);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,0,0,0,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,92,0,92,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,364,0,364,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,468,0,468,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,555,0,555,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,627,0,627,14);
  XDrawLine(GetDisplay(),direntry->Iconwindow,gch,699,0,699,14);    
}

/* This function creates a usable and seeable icon from the specified item. If
   the newicon option is set it creates a new window (icon) otherwise it
   modifies an existing icon (ex:change name, marking or icon). plusmore is a
   flag that makes dfm able to show an additional "+more" in the icon in order
   to show that more files are selected (moving an icon). */
void CreateIconWithDirentry(struct item *direntry,int newicon,int plusmore)
{
  Window root;
  char *pos;
  char *icon;
  char *start;
  char *text=NULL,*text2;
  char *fullname;
  static char *ourfont=NULL;
  static Pixmap noicon=0;
  static XFontStruct *fontst;
  static GC gc=0;
  Pixmap backgroundpixmap=0,shapepixmap=0;
  Pixmap backgroundpixmap2,shapepixmap2;
  XSetWindowAttributes xswa;
  unsigned long valuemask;
  int x,y;
  int isxvpic;
  unsigned int width,height,dummy,depth,twidth,nwidth;
  int xposicon,xpostext;
  
  if (gch==None) {
    gch=XCreateGC(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0);
    XSetClipOrigin(GetDisplay(),gch,96,0);
    DataPixmap(littlelink_xpm,&littlelinkpix,NULL);
    DataPixmap(noicon_xpm,&noicon,NULL);
    DataPixmap(littlenoicon_xpm,&littlenoicon,NULL);
  }
  if (ourfont==NULL || strcmp(GetFontName(),ourfont)!=0) {
    if (ourfont!=NULL) {
      XFreeFont(GetDisplay(),fontst);
      free(ourfont);
    }
    if (GetKindOfWindow()!=DETAIL)
      fontst=XLoadQueryFont(GetDisplay(),GetFontName());
    if (fontst==NULL)
      fontst=XLoadQueryFont(GetDisplay(),"8x13");
    XSetFont(GetDisplay(),gch,fontst->fid);
    ourfont=malloc(strlen(GetFontName())+1);
    strcpy(ourfont,GetFontName());
  }
  fullname=malloc(strlen(direntry->filename)+strlen(GetPath())+1);
  strcpy(fullname,GetPath());
  strcat(fullname,direntry->filename);
  GetFileInfoFromDesktop(fullname,&pos,&icon,&start);
  if (icon==NULL || start==NULL) {
    free(icon);
    free(start);
    GetExtensionParameter(fullname,&icon,&start);  
    GetXVIconName(direntry->filename,&icon);
  }
  xswa.override_redirect=True;
  xswa.background_pixel=GetBGColor();
  valuemask=CWOverrideRedirect|CWBackPixel;  
  if (newicon==True) {
    if (GetIsDesktop()==True) {
      direntry->Iconwindow=
        XCreateWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()),
	              0,0,1,1,0,CopyFromParent,InputOutput,
		      CopyFromParent,valuemask,&xswa);
      XLowerWindow(GetDisplay(),direntry->Iconwindow);
    } else {
      direntry->Iconwindow=
        XCreateWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,CopyFromParent,InputOutput,
		      CopyFromParent,valuemask,&xswa);
    }
  }  
  if (GetKindOfWindow()==NORMAL) {
    /***************************NORMAL****************************/
    loadicon(icon,0,&backgroundpixmap,&shapepixmap,&isxvpic);
    if (backgroundpixmap==0) {
      free(icon);
      icon=NULL;
      GetExtensionParameter(fullname,&icon,&text);
      free(text);
      loadicon(icon,0,&backgroundpixmap,&shapepixmap,&isxvpic);
    }
    if (backgroundpixmap==0) {
      backgroundpixmap=noicon;
      isxvpic=False;
    }
    if (direntry->mark==False) {
      XSetBackground(GetDisplay(),gch,GetBGColor());
      XSetForeground(GetDisplay(),gch,GetFGColor());
    } else {
      XSetBackground(GetDisplay(),gch,GetFGColor());
      XSetForeground(GetDisplay(),gch,GetBGColor());
    }      
    if (strcmp(direntry->filename,".linktorootdir/")==0) {
      text=malloc(strlen("/")+1);
      strcpy(text,"/");
    } else {
      if (strcmp(direntry->filename,".linktohomedir/")==0) {
	text=malloc(strlen("~/")+1);
	strcpy(text,"~/");
      } else {
	text=malloc(strlen(direntry->filename)+1);
	strcpy(text,direntry->filename);
      }     
    } 
    XGetGeometry(GetDisplay(),backgroundpixmap,&root,&x,&y,&width,&height,
		 &dummy,&depth);
    twidth=XTextWidth(fontst,text,strlen(text));
    if (twidth<width) {
      xpostext=(width-twidth)/2;
      xposicon=0;
      nwidth=width;
    } else {
      xposicon=(twidth-width)/2;
      xpostext=0;
      nwidth=twidth;
    }
    if (direntry->type>=2 || GetIsDesktop()==True)
      nwidth=nwidth+7;
      /*nwidth=nwidth+11;*/
    if (plusmore==True)
      nwidth=nwidth+8+XTextWidth(fontst,"+ more",strlen("+ more"));
    backgroundpixmap2=
      XCreatePixmap(GetDisplay(),direntry->Iconwindow,
	            nwidth,height+2+fontst->ascent+fontst->descent,depth);
    if (direntry->mark==True) {
      XFillRectangle(GetDisplay(),backgroundpixmap2,gch,
                     xposicon,0,width,height);
      XSetFunction(GetDisplay(),gch,GXxor);
    }
    XCopyArea(GetDisplay(),backgroundpixmap,backgroundpixmap2,gch,
              0,0,width,height,xposicon,0);
    XSetFunction(GetDisplay(),gch,GXcopy);
    if (direntry->type>=2) 
    XCopyArea(GetDisplay(),littlelinkpix,backgroundpixmap2,gch,
              0,0,7,8,xpostext+twidth,height-2);
    /*XCopyArea(GetDisplay(),linkpix,backgroundpixmap2,gch,
              0,0,11,11,xpostext+twidth,height-5);*/
    if (isxvpic==True)
      XFreePixmap(GetDisplay(),backgroundpixmap);
    XDrawImageString(GetDisplay(),backgroundpixmap2,gch,
                     xpostext,height+2+fontst->ascent,text,strlen(text));
    if (plusmore==True)
      XDrawImageString(GetDisplay(),backgroundpixmap2,gch,
		       xpostext+twidth+8,height+2+fontst->ascent,
		       "+ more",strlen("+ more"));
    XSetWindowBackgroundPixmap(GetDisplay(),direntry->Iconwindow,
                               backgroundpixmap2);
    shapepixmap2=
      XCreatePixmap(GetDisplay(),direntry->Iconwindow,
	            nwidth,height+2+fontst->ascent+fontst->descent,1);
    if (gc==None)
      gc=XCreateGC(GetDisplay(),shapepixmap2,0,0);
    XSetForeground(GetDisplay(),gc,0);
    XFillRectangle(GetDisplay(),shapepixmap2,gc,0,0,
		   nwidth,height+2+fontst->ascent+fontst->descent);
    XSetBackground(GetDisplay(),gc,0);
    XSetForeground(GetDisplay(),gc,1);
    if (shapepixmap==0)
      XFillRectangle(GetDisplay(),shapepixmap2,gc,xposicon,0,width,height);
    else
      XCopyArea(GetDisplay(),shapepixmap,shapepixmap2,gc,0,0,width,height,
		xposicon,0);
    XFillRectangle(GetDisplay(),shapepixmap2,gc,
                   xpostext,height+2,twidth,fontst->ascent+fontst->descent);
    if (plusmore==True)
      XFillRectangle(GetDisplay(),shapepixmap2,gc,xpostext+twidth+8,height+2,
                     XTextWidth(fontst,"+ more",strlen("+ more")),
		     fontst->ascent+fontst->descent);
    if (direntry->type>=2)
      XFillRectangle(GetDisplay(),shapepixmap2,gc,
                     xpostext+twidth,height-2,7,8);
      /*XFillRectangle(GetDisplay(),shapepixmap2,gc,
                     xpostext+twidth,height-5,11,11);*/
    XShapeCombineMask(GetDisplay(),direntry->Iconwindow,ShapeBounding,0,0, 
		      shapepixmap2,ShapeSet);
    
    XFreePixmap(GetDisplay(),backgroundpixmap2);
    XFreePixmap(GetDisplay(),shapepixmap2);
    
    if (pos==NULL) {
      PositionArrange(direntry,nwidth,height+2+fontst->ascent+fontst->descent);
      SendFileInfoToDesktop(fullname,NULL,icon,start);
    } else {
      GetPositionFromText(pos,&x,&y,NULL);
      XMoveWindow(GetDisplay(),direntry->Iconwindow,x,y);
    }
    if (GetIsDesktop()==True)
      XSelectInput(GetDisplay(),direntry->Iconwindow,PointerMotionMask|
		   EnterWindowMask|ButtonReleaseMask|ButtonPressMask|
		   ExposureMask);
    else
      XSelectInput(GetDisplay(),direntry->Iconwindow,PointerMotionMask|
		   ButtonReleaseMask|ButtonPressMask);
    XResizeWindow(GetDisplay(),direntry->Iconwindow,
                  nwidth,height+2+fontst->ascent+fontst->descent);
    free(text);
  } else if (GetKindOfWindow()==DETAIL) {
    /***************DETAIL**************************/
    loadicon(icon,14,&backgroundpixmap,&shapepixmap,&isxvpic);
    if (backgroundpixmap==0) {
      free(icon);
      icon=NULL;
      GetExtensionParameter(fullname,&icon,&text);
      free(text);
      loadicon(icon,14,&backgroundpixmap,&shapepixmap,&isxvpic);
    }
    if (backgroundpixmap==0) {
      backgroundpixmap=littlenoicon;
      isxvpic=False;
    }
    direntry->mini=backgroundpixmap;
    direntry->minis=shapepixmap;
    SendFileInfoToDesktop(fullname,NULL,icon,start);
    if (newicon==True) {
      XSelectInput(GetDisplay(),direntry->Iconwindow,PointerMotionMask|
		   ButtonReleaseMask|ButtonPressMask|ExposureMask);
      PositionArrange(direntry,732,15);
    }
    XResizeWindow(GetDisplay(),direntry->Iconwindow,700,15);
    WriteDetailIcon(direntry);
  } else {
    /******************************STRUCTURE**************************/
    text2=GenerateLastNameWithoutSlash(fullname);
    loadicon(icon,14,&backgroundpixmap,&shapepixmap,&isxvpic);
    if (backgroundpixmap==0) {
      free(icon);
      icon=NULL;
      GetExtensionParameter(fullname,&icon,&text);
      free(text);
      loadicon(icon,14,&backgroundpixmap,&shapepixmap,&isxvpic);
    }
    if (backgroundpixmap==0) {
      backgroundpixmap=littlenoicon;
      isxvpic=False;
    }
    nwidth=XTextWidth(fontst,text2,strlen(text2));
    backgroundpixmap2=XCreatePixmap(GetDisplay(),direntry->Iconwindow,
				    18+nwidth,2+fontst->ascent+fontst->descent,
				    XDefaultDepth(GetDisplay(),
	                            XDefaultScreen(GetDisplay())));
    XSetFunction(GetDisplay(),gch,GXcopy);
    shapepixmap2=XCreatePixmap(GetDisplay(),direntry->Iconwindow,
			       18+nwidth,2+fontst->ascent+fontst->descent,1);
    if (gc==None) 
      gc=XCreateGC(GetDisplay(),shapepixmap2,0,0);
    XSetForeground(GetDisplay(),gc,0);
    XFillRectangle(GetDisplay(),shapepixmap2,gc,0,0,
		   18+nwidth,2+fontst->ascent+fontst->descent);
    XSetForeground(GetDisplay(),gc,1);
    XFillRectangle(GetDisplay(),shapepixmap2,gc,18,0,
		   nwidth,2+fontst->ascent+fontst->descent);
    if (direntry->mark==False) {
      XSetForeground(GetDisplay(),gch,GetBGColor());
      XFillRectangle(GetDisplay(),backgroundpixmap2,gch,
                     18,0,nwidth,2+fontst->ascent+fontst->descent);
      XSetBackground(GetDisplay(),gch,GetBGColor());
      XSetForeground(GetDisplay(),gch,GetFGColor());
    } else {
      XSetForeground(GetDisplay(),gch,GetFGColor());
      XFillRectangle(GetDisplay(),backgroundpixmap2,gch,
                     18,0,nwidth,2+fontst->ascent+fontst->descent);
      XSetBackground(GetDisplay(),gch,GetFGColor());
      XSetForeground(GetDisplay(),gch,GetBGColor());
    }      
    if (direntry->mark==True) {
      XFillRectangle(GetDisplay(),backgroundpixmap2,gch,
                     0,0,18+nwidth,2+fontst->ascent+fontst->descent);
      XSetFunction(GetDisplay(),gch,GXxor);
    }
    XCopyArea(GetDisplay(),backgroundpixmap,backgroundpixmap2,gch,
		0,0,14,14,1,(2+fontst->ascent+fontst->descent)/2-7);
    if (shapepixmap!=0)
      XCopyArea(GetDisplay(),shapepixmap,shapepixmap2,gc,
		0,0,14,14,1,(2+fontst->ascent+fontst->descent)/2-7);
    if (direntry->type>=2) {
      XCopyArea(GetDisplay(),littlelinkpix,backgroundpixmap2,gch,
		0,0,7,8,9,(2+fontst->ascent+fontst->descent)/2);
      XFillRectangle(GetDisplay(),shapepixmap2,gc,
                     9,(2+fontst->ascent+fontst->descent)/2,7,8);
    }
    XSetFunction(GetDisplay(),gch,GXcopy);
    XDrawImageString(GetDisplay(),backgroundpixmap2,gch,
                     18,1+fontst->ascent,text2,strlen(text2));
    XSetWindowBackgroundPixmap(GetDisplay(),direntry->Iconwindow,
                               backgroundpixmap2);
    XShapeCombineMask(GetDisplay(),direntry->Iconwindow,ShapeBounding,0,0, 
		      shapepixmap2,ShapeSet);
    XFreePixmap(GetDisplay(),backgroundpixmap2);
    XFreePixmap(GetDisplay(),shapepixmap2);
    SendFileInfoToDesktop(fullname,NULL,icon,start);
    XSelectInput(GetDisplay(),direntry->Iconwindow,PointerMotionMask|
		 ButtonReleaseMask|ButtonPressMask);
    XResizeWindow(GetDisplay(),direntry->Iconwindow,
                  18+nwidth,2+fontst->ascent+fontst->descent);
    free(text2);
    free(text);
    /******************************************************************/
  }
  if (GetIsDesktop()==False)
    XMapRaised(GetDisplay(),direntry->Iconwindow);
  else
    XMapWindow(GetDisplay(),direntry->Iconwindow);
  if (newicon==False && GetKindOfWindow()!=DETAIL)
    XClearWindow(GetDisplay(),direntry->Iconwindow);
  free(fullname);
  free(pos);
  free(icon);
  free(start);
}
