/* create.c */
/* functions for creating widgets, adding them to containers,
   setting callbacks */
/* Copyright (C) 1999 Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"create.h"

GtkWidget *
create_vbox(GtkWidget *container)
{
  GtkWidget *rv = NULL;

  rv = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_hbox(GtkWidget *container)
{
  GtkWidget *rv = NULL;

  rv = gtk_hbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_hseparator(GtkWidget *container)
{
  GtkWidget *rv = NULL;

  rv = gtk_hseparator_new();
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_label(GtkWidget *container, char *text)
{
  GtkWidget *rv = NULL;
  
  rv = gtk_label_new(text);
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_button(GtkWidget *container, void (*callback)(gpointer *),
	      gpointer *callback_data)
{
  GtkWidget *rv = NULL;
  
  rv = gtk_button_new();
  gtk_signal_connect(GTK_OBJECT(rv), "clicked", GTK_SIGNAL_FUNC(callback),
		     callback_data);
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_entry(GtkWidget *container)
{
  GtkWidget *rv = NULL;
  
  rv = gtk_entry_new();
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_toggle_button(GtkWidget *container, void (*callback)(gpointer *),
		     gpointer *callback_data, gint state, char *label)
{
  GtkWidget *rv = NULL;
  
  rv = gtk_check_button_new_with_label(label);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(rv), state);
  gtk_signal_connect(GTK_OBJECT(rv), "toggled", GTK_SIGNAL_FUNC(callback),
		     callback_data);
  gtk_container_add(GTK_CONTAINER(container), rv);
  gtk_widget_show(rv);
  return(rv);
}

GtkWidget *
create_filesel(char *title, void (*ok)(GtkWidget *, GtkFileSelection *),
	       void(*cancel)(GtkWidget *, GtkFileSelection *))
     /* create a file selection widget with ok, cancel as callbacks */
{
  GtkWidget *rv = NULL;

  rv = gtk_file_selection_new(title);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(rv)->ok_button),
		     "clicked", GTK_SIGNAL_FUNC(ok), rv);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(rv)->cancel_button),
		     "clicked", GTK_SIGNAL_FUNC(cancel), rv);
  gtk_widget_show(rv);

  return(rv);
}
