/***************************************************************************
                          miscingredient.h  -  misc entry
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/


#ifndef MISCINGREDIENT_H
#define MISCINGREDIENT_H

#include <qmap.h>
#include <qlistview.h>
#include <qstring.h>

/**
  *@author David Johnson
  */
class MiscIngredient {
public:
	/** constructor */
	MiscIngredient();
	/** full constructor */
	MiscIngredient(const QString &mname, const unsigned &mquant, const QString &hnotes);
	/** copy constructor */
	MiscIngredient(const MiscIngredient &m);
	/** assignment operator */
	MiscIngredient operator=(const MiscIngredient &m);
	/** comparison operator */
	bool operator==(const MiscIngredient &m);
	/** destructor */
	~MiscIngredient();

	/** return name */
	QString getName();
	/** return quantity (in ounces) */
	unsigned getQuantity();
	/** return MiscIngredient notes */
	QString getNotes();
		
	/** return quantity as string */
	QString getQuantityString();
	
	/** return object as string, for serialization */
	QString serializeOut();
	/** set object to string, for serialization */
	void serializeIn(const QString &mname, const QString &mvalue);

private:
	/** format an UInt to fixed decimal */
	QString formatValue(const unsigned &value, const unsigned &fix);
	
private:
	QString name;
	unsigned quantity; // measured in pounds
	QString notes;
	
	unsigned divisor, leftuint;
	QString leftstring, rightstring;
};

typedef QValueList<MiscIngredient> MiscIngredientList;
typedef QValueList<MiscIngredient>::Iterator MiscIngredientIterator;

class MiscIngredientListItem : public QListViewItem {
public:
	/** constructor */
	MiscIngredientListItem(QListView * parent, QString, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	/** destructor */
	~MiscIngredientListItem();
	/** get iterator to misc item */
	MiscIngredientIterator getMiscIngredientIterator();
	/** set iterator to misc item */
	void setMiscIngredientIterator(MiscIngredientIterator &it);
	/** set misc to match iterator */
	void setToIterator();
private:
	MiscIngredientIterator mit;
};

#endif // MISCINGREDIENT_H





