;;;; $Id: debianapps-menu.scm,v 1.3 2000/01/13 07:28:06 gjb Exp $
;;;; debianapps-menu.scm
;;;; Copyright (C) 1999, 2000 Francesco Tapparo and Greg J. Badros
;;;;
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;;;; Boston, MA 02111-1307 USA
;;;;
;;;; END OF LICENSE
;;;;
;;;; For Debian GNU/Linux systems.
;;;;
;;;; Changelog:
;;;; 12/3/1999 Francesco Tapparo: 
;;;;           moved the menuitems out of make-debianapps-menu
;;;;           now make-debianapps-menu accepts #&key arguments and
;;;;           pass them to menu.
;;;;           removed default-menu-file and added the *debian-menu-path*
;;;;           option
;;;;           the menu generated is now much more good looking and much
;;;;           more similar to the default one (code borrowed from 
;;;;           Greg's system.scwmrc)

(define-module (app scwm debianapps-menu)
  :use-module (app scwm std-menus)
  :use-module (app scwm base)
  :use-module (app scwm optargs)
  :use-module (app scwm defoption)
  :use-module (app scwm file)
  :use-module (app scwm winops-menu)
  :use-module (app scwm winlist-menu)
  :use-module (app scwm preferences))


(define-scwm-option *debian-menu-path* (list "/etc/X11/scwm")
  "The path (list of directories as strings) to search for the menuitems list"
  #:type 'path
  #:group 'file-locations)

(define-public default-debianapps-menu-title "Debian Apps")

(define (menu-header title)
  (list (menu-title title #f)
	menu-separator))

(define menu-footer 
  (list menu-separator
	(menuitem "&Window Operations" #:image-left "mini-zoom.xpm" 
		  #:submenu menu-window-ops)
	(menuitem "Windows by &resource" #:image-left "mini-windows.xpm" 
		  #:submenu (lambda () (make-window-list-menu #:by-resource #t)))
	menu-separator
	(menuitem "Scwm &Options...." #:action (lambda () (scwm-options-dialog)))	   
	(menuitem "Desks" #:submenu menu-desk)
	menu-separator
	(menuitem "Themes" #:submenu (lambda () (menu-global-theme)))
	(menuitem "E&xit Scwm" #:image-left "mini-stop.xpm" 
		  #:submenu menu-quit-verify)))


(define*-public (make-debianapps-menu #&key
				      (title default-debianapps-menu-title)
				      (menu-file "scwm_menus")
				      #&allow-other-keys
				      #&rest rest)
  "Read menu-file and return a menu object.
TITLE is the string to be used as title of the menu.  
MENU-FILE is the file used to create the menu entries, 
as generated by the menu program in the Debian systems. 
The rest of the arguments are passed to the menu procedure"
  (load (find-file-in-path menu-file
			   (optget '*debian-menu-path*)))
  (apply menu (append
	       (list (append (menu-header title) /Debian-list menu-footer))
	       rest)))
