;;;; $Id: module-types.scm,v 1.3 1998/12/05 04:20:51 jtl Exp $
;;;; Copyright (C) 1997-1998 Maciej Stachowiak and Greg J. Badros

(define-module (app scwm module-types))

(define-public M_NEW_PAGE           1)
(define-public M_NEW_DESK           2)
(define-public M_ADD_WINDOW         4)
(define-public M_RAISE_WINDOW       8)
(define-public M_LOWER_WINDOW       16)
(define-public M_CONFIGURE_WINDOW   32)
(define-public M_FOCUS_CHANGE       64)
(define-public M_DESTROY_WINDOW     128)
(define-public M_ICONIFY            256)
(define-public M_DEICONIFY          512)
(define-public M_WINDOW_NAME        1024)
(define-public M_ICON_NAME          2048)
(define-public M_RES_CLASS          4096)
(define-public M_RES_NAME           8192)
(define-public M_END_WINDOWLIST     16384)
(define-public M_ICON_LOCATION      32768)
(define-public M_MAP                65536)
(define-public M_ERROR              131072)
(define-public M_CONFIG_INFO        262144)
(define-public M_END_CONFIG_INFO    524288)
(define-public M_ICON_FILE          1048576)
(define-public M_DEFAULTICON        2097152)
(define-public M_STRING             4194304)
(define-public M_MINI_ICON          8388608)
(define-public M_WINDOWSHADE        16777216)
(define-public M_DEWINDOWSHADE      33554432)

(define-public module-event-number-to-name-alist
  (list 
   (cons 1 "M_NEW_PAGE")
   (cons 2 "M_NEW_DESK")
   (cons 4 "M_ADD_WINDOW")
   (cons 8 "M_RAISE_WINDOW")
   (cons 16 "M_LOWER_WINDOW")
   (cons 32 "M_CONFIGURE_WINDOW")
   (cons 64 "M_FOCUS_CHANGE")
   (cons 128 "M_DESTROY_WINDOW")
   (cons 256 "M_ICONIFY")
   (cons 512 "M_DEICONIFY")
   (cons 1024 "M_WINDOW_NAME")
   (cons 2048 "M_ICON_NAME")
   (cons 4096 "M_RES_CLASS")
   (cons 8192 "M_RES_NAME")
   (cons 16384 "M_END_WINDOWLIST")
   (cons 32768 "M_ICON_LOCATION")
   (cons 65536 "M_MAP")
   (cons 131072 "M_ERROR")
   (cons 262144 "M_CONFIG_INFO")
   (cons 524288 "M_END_CONFIG_INFO")
   (cons 1048576 "M_ICON_FILE")
   (cons 2097152 "M_DEFAULTICON")
   (cons 4194304 "M_STRING")
   (cons 8388608 "M_MINI_ICON")
   (cons 16777216 "M_WINDOWSHADE")
   (cons 33554432 "M_DEWINDOWSHADE")))


;; Usage e.g.: (module-event-name-from-number 8192)
(define-public (module-event-name-from-number num)
  "Return the string module event name for event number NUM."
  (cdr (assoc num module-event-number-to-name-alist)))
