/***  SPECIAL.C: Contains miscallaneous routines  ***/

/* ########################################################################

   uwm - THE ude WINDOW MANAGER

   ########################################################################

   Copyright (c) : Christian Ruppert

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif

#include "uwm.h"
#include "init.h"
#include "uwmmenu.h"
#include "windows.h"
#include "winmenu.h"
#include "applications.h"
#include "move.h"
#include "resize.h"
#include "desktop.h"

extern UDEScreen TheScreen;
extern Display *disp;
extern InitStruct InitS;
extern Atom WM_PROTOCOLS;

#define PGRABLEVEL 32    /* usually shouldn't go deeper than 2 or 3. */
unsigned int pgrabmasks[PGRABLEVEL];
Cursor pgrabmice[PGRABLEVEL];
Window pgrabwins[PGRABLEVEL];
int grabstat=0,pgrabstat=-1;


void RaiseWin(UltimateContext *uc)
{
  Node2End(TheScreen.UltimateList,InNodeList(TheScreen.UltimateList,uc));
  if(uc->frame) XRaiseWindow(disp,uc->frame);
  else XRaiseWindow(disp,uc->win);
}

void LowerWin(UltimateContext *uc)
{
  Node2Start(TheScreen.UltimateList,InNodeList(TheScreen.UltimateList,uc));
  if(uc->frame) XLowerWindow(disp,uc->frame);
  else XLowerWindow(disp,uc->win);
}

void SendWMProtocols(UltimateContext *uc, Atom prot)
{
  XEvent event;

  memset(&event,0,sizeof(XEvent));
  event.xclient.type = ClientMessage;
  event.xclient.window = uc->win;
  event.xclient.message_type = WM_PROTOCOLS;
  event.xclient.format = 32;
  event.xclient.data.l[0] = prot;
  event.xclient.data.l[1] = CurrentTime;
  if(!XSendEvent(disp,uc->win,False,0L,&event))
    fprintf(TheScreen.errout,"UWM: Couldn't send message to client.\n");
}


/* ShowMenu, added by Tim Coleman December 12 1998.
 * This is to allow the user to configure which menu is brought up
 * by which button. 
 * This is called from HandleButtonPress()
 */

void ShowMenu(int menuNumber, int x, int y) 
{
  switch (InitS.menuType[menuNumber]) {
    case 'U':
          WMMenu(x,y);
          break;
    case 'D':
          DeiconifyMenu(x,y);
          break;
    case 'A':
          ApplicationMenu(x,y);
          break;
  }
}

void BorderButton(char a,UltimateContext *uc,int x,int y,int x_root,int y_root)
{
  switch (InitS.BorderButtons[a]) {
    case 'M':
             RaiseWin(uc);
             StartWinMenu(uc,x_root,y_root);
          break;
    case 'D':
             StartDragging(uc,x,y);
          break;
    case 'R':
             StartResizing(uc,x_root,y_root);
          break;
  }
}

/*** will send a Configure-event to owner of uc-window ***/
void SendConfigureEvent(UltimateContext *uc)
{
  XEvent ToClient;                  
  ToClient.type=ConfigureNotify;
  ToClient.xconfigure.display=disp;
  ToClient.xconfigure.event=uc->win;
  ToClient.xconfigure.window=uc->win;
  ToClient.xconfigure.x=uc->Attr.x+uc->BorderWidth-uc->Attributes.border_width;
  ToClient.xconfigure.y=uc->Attr.y+uc->BorderWidth+TheScreen.TitleHeight-\
                                              uc->Attributes.border_width;
  ToClient.xconfigure.width=uc->Attributes.width;
  ToClient.xconfigure.height=uc->Attributes.height;
  ToClient.xconfigure.border_width=uc->Attributes.border_width;
  ToClient.xconfigure.above=uc->frame;
  ToClient.xconfigure.override_redirect=False;
  XSendEvent(disp,uc->win,False,StructureNotifyMask,&ToClient);
}

/* needs to be called after each writing access to TheScreen.desktop */
void UpdateDesktop()
{
  XChangeProperty(disp, TheScreen.root, TheScreen.UDE_SETTINGS_PROPERTY,
                  TheScreen.UDE_SETTINGS_PROPERTY, 8, PropModeReplace,
                  (unsigned char *) &TheScreen.desktop, sizeof(UDEDesktop));
}

/*** system() call that forks but continues with the program instead of waiting
     for the process to terminate (zombie elimination is done by the sigchld-
     routine) */
pid_t MySystem(char *comm)
{
  pid_t r;
  if(!(r=fork())){
    execlp("sh","sh","-c",comm,NULL);
    fprintf(TheScreen.errout,"UWM: couldn't start application: %s\n",comm);
    exit(0);
  }
  return(r);
}

/* MyCalloc: allocates memory and quits if allocation fails. */
/* ATTENTION: Unlike calloc() MyCalloc() does not clear alloc'ed mem!!! */
void *MyCalloc(size_t n,size_t s)
{
  void *ret;
  if(!(ret=malloc(n*s))) SeeYa(1,"Fatal: couldn't allocate menory");
  return(ret);
}

void GrabPointer(Window win,unsigned int mask,Cursor mouse)
{
  pgrabstat++;
  if(!(pgrabstat<PGRABLEVEL))
    SeeYa(1,"UWM: probably got stuck in some loop (pointer grab)");
  pgrabmasks[pgrabstat]=mask;
  pgrabmice[pgrabstat]=mouse;
  pgrabwins[pgrabstat]=win;
  while(XGrabPointer(disp,pgrabwins[pgrabstat],True,pgrabmasks[pgrabstat],\
                    GrabModeAsync,GrabModeAsync,None,pgrabmice[pgrabstat],\
                                                CurrentTime)!=GrabSuccess);
}

void UngrabPointer()
{
  pgrabstat--;
  if(pgrabstat<0) XUngrabPointer(disp,CurrentTime);
  else {
    XGrabPointer(disp,pgrabwins[pgrabstat],True,pgrabmasks[pgrabstat],\
                GrabModeAsync,GrabModeAsync,None,pgrabmice[pgrabstat],\
                                                          CurrentTime);
  }
}

void GrabServer()
{
  if(!grabstat) XGrabServer(disp);
  grabstat++;
}

void UngrabServer()
{
  grabstat--;
  if(!grabstat) XUngrabServer(disp);
}
