/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the Network Research
 * 	Group at Lawrence Berkeley National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
static const char rcsid[] =
    "@(#) $Header: encoder-adpcm.cc,v 1.5 96/03/16 13:12:50 van Exp $ (LBL)";

#include <string.h>
#include "config.h"
#include "rtp.h"
#include "encoder.h"
#include "transmitter.h"
extern "C" {
#include "adpcm.h"
}

class ADPCMEncoder : public PCM_Encoder {
public:
	ADPCMEncoder();
	virtual void encode(u_int32_t ts, u_int8_t* samples, int cc);
protected:
	adpcm_state tstate_;
};

static class ADPCMEncoderMatcher : public Matcher {
public:
	ADPCMEncoderMatcher() : Matcher("encoder") {}
	TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "dvi") == 0 ||
		    strcasecmp(fmt, "adpcm") == 0)
			return (new ADPCMEncoder);
		else
			return (0);
	}
} adpcm_encoder_matcher;


ADPCMEncoder::ADPCMEncoder()
{
	memset((char*)&tstate_, 0, sizeof(tstate_));
}

void ADPCMEncoder::encode(u_int32_t ts, u_int8_t* frame, int len)
{
	register int marker = (ts != last_ts_) ? htons(RTP_M) : 0;
	last_ts_ = ts + len;

	Transmitter::pktbuf* pb = tx_->alloc(ts, RTP_PT_DVI);
	rtphdr* rh = (rtphdr*)pb->hdr;
	rh->rh_flags |= marker;
	pb->iov[0].iov_len = sizeof(rtphdr);
	u_int8_t* o = (u_int8_t*)pb->iov[1].iov_base;
	*(struct adpcm_state*)o = tstate_;
	HTONS(((struct adpcm_state*)o)->valprev);
	adpcm_coder(frame, o + sizeof(struct adpcm_state), len, &tstate_);
	len = (len >> 1) + sizeof(struct adpcm_state);
	pb->iov[1].iov_len = len;
	tx_->send(pb);
}
