/*
   File     : supportfuncs.c
   Author   : Lionel ULMER
   Creation : 07/12/96

   Fichier contenant les fonctions de gestion des deux AsciiText
   widgets, les call-backs des diffrents boutons et les fonctions de
   time-out / entre de fichier.
*/

/* Fichiers ncessaire  Xt */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
/* Fichiers d'include public des widgets utiliss */
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
/* Includes prement X */
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

/* Fichier des variables globales du module Interface */
#include "global.h"
#include "initui.h"
#include "initfuncs.h"
#include "widget.h"
#include "members.h"
#include "supportfuncs.h"
#include "mainloop.h"
#include "mc.h"


Widget button[BUTTONSNUMBER]; /* interactive buttons, popup-menu */
int evthandle;		/* exit or not from event handling */
char pllist[MAXPLAYERLIST];     /* Label displayed */

/* local variables */
static char prevpllist[MAXPLAYERLIST];
static Solid prevsobject;


/* ButtonAction: callback for dynamic button */
void ButtonAction(Widget w, XtPointer cld, XtPointer cad)
{
  int meth, pm = 0;
  struct timeval tv;

  meth = (int) cld;
  if (meth < 0) {
    trace(DBG_WIN, "Popup action");
    meth = -(meth+1);
    pm = 1;
  }
  
  /* if exit from Popup without methods choice */
  if (pm == 0 && cbutton == 3)
    csobject = pobject;
  gettimeofday(&tv, NULL);
  trace(DBG_WIN, "Call method: %d of object %p", meth, csobject);
  specialAction(csobject, meth, tv.tv_sec, tv.tv_usec);

  if (pm == 1) {
    csobject = pobject;
    trace(DBG_WIN, "Current: %p Previous: %p", csobject, pobject);
  }
  else
    cpopup = (cpopup+1) % 256;
  cbutton = 0;
}

/* destroy the popup-menu when it has left screen */
void menuPopDown(Widget w, XtPointer cld, XtPointer cad)
{
  int i;
  
  XtDestroyWidget(popm);
  XtDestroyWidget(popline);
  for (i=0; i < BUTTONSNUMBER && popbutton[i] != NULL; i++)
    XtDestroyWidget(popbutton[i]);
}

/* TimeOut: callback for time-out. On fait la diffrence entre
   le time-out 3D, le time-out rezo et le time-out monde avec cld */
Public
void TimeOut(XtPointer cld, XtIntervalId *iid)
{
  int type;
  unsigned int nextto;
  struct timeval tv;

  /* what kind of time-out ? */
  type = (int) cld;
  if (type & POPUPTO) { /* if time-out coming from a popup */
    type &= ~POPUPTO;
    if (type == cpopup) {
      popev.xany.send_event = True;
      XtDispatchEvent(&popev);
    }
  }
  else {    
    switch (type) {
    case NETTO: /* Network Timeout */
      nextto = networkTimeout();
      XtAppAddTimeOut(appContext, nextto, TimeOut, (XtPointer) type);
      break;
    case WMGTTO: /* Iconified and call WMgt */
      gettimeofday(&tv, NULL);
      /* compute the world */
      if (doWorldCalculation(tv.tv_sec, tv.tv_usec))
	XtAppAddTimeOut(appContext, WMGT_TIMEOUT, TimeOut, (XtPointer) type);
      break;
    case EVTTO:
      evthandle = 0;
    default:
      break;
    }
  }
}

/* called when something occurs on a file-descriptor */
Public
void FDEvent(XtPointer cld, int *fd, XtInputId *iid)
{
  switch ((int) cld) {
  case NETFD:
    incoming(*fd);
  default:
    break;
  }
}

/* if selectioned object disapear */
Public
void selectedObjectDeletion(Solid solid)
{
  if (solid == csobject) {
    csobject = NULL;
    updateButtonBar();
  }
  if (solid == pobject)
    pobject = NULL;
  if (solid == prevsobject)
    prevsobject = NULL;
}

/* change the buttonbar according to csobject and pllist */
Public
void updateButtonBar()
{  
  int i;
  char *objectname, *blist, buf[64];

  if (csobject != prevsobject) { /* Un nouvel objet a t slectionn */
    if (csobject == NULL) { /* Pas d'objet */
      XtVaSetValues(labelSep, XtNlabel,"         ", NULL);
      /* Destruction des boutons prcdents */
      for (i=0; (i<BUTTONSNUMBER) && (button[i] != NULL); i++) {
	XtDestroyWidget(button[i]);
	button[i] = NULL;
      }
    }
    else {
      /* Get object name */
      getObjectHumanName(csobject, &objectname, &blist);
      trace(DBG_WIN, "Object: %s", objectname);
      /* Change buttonbar */
      XtVaSetValues(labelSep, XtNlabel, objectname, NULL);
      /* Delete previous buttons */
      for (i=0; (i<BUTTONSNUMBER) && (button[i] != NULL); i++) {
	XtDestroyWidget(button[i]);
	button[i] = NULL;
      }
      XtDestroyWidget(labelPlayer);
      XtDestroyWidget(labelLeft);
      /* Decode methods and add new buttons */
      for (i=0; (i<BUTTONSNUMBER) && (*blist != '\0'); i++) {
        sprintf(buf, "button%d", i);
        /* trace(DBG_WIN, "%s: %s", buf, blist); */
        button[i] = XtVaCreateManagedWidget(buf, commandWidgetClass, panedVB,
                                          XtNlabel, blist, NULL);
        XtAddCallback(button[i], XtNcallback, ButtonAction, (XtPointer) i);
        blist += HNAME_LEN;
      }
      createLabelPlayer();
      createLabelLeft();
    }
    prevsobject = csobject;
  }
  else if (strcmp(pllist, prevpllist)) { /* players list have changed */
    XtDestroyWidget(labelPlayer);
    XtDestroyWidget(labelLeft);
    createLabelPlayer();
    createLabelLeft();
    strcpy(prevpllist, pllist);
  }
}
 
/* initialize dynamic button  bar */
void initButtonBar()
{
  int i;

  /* Pour ne pas changer la buttonbar pour rien */
  prevsobject = NULL;
  prevpllist[0] = '\0';
  
  /* Initialisation du label indiquant l'objet actif */
  labelSep = XtVaCreateManagedWidget("labelSep", labelWidgetClass, panedVB,
                                   XtNlabel,"         ", NULL);

  /* Initialize player list , me first */
  strcpy(pllist, "Members:");

  /* Initialization action buttons to NULL */
  for (i=0; i<BUTTONSNUMBER; i++)
    button[i] = NULL;
  createLabelPlayer();
  createLabelLeft();
}

/* initialization Label where is displayed local members list */
void createLabelPlayer()
{
  labelPlayer = XtVaCreateManagedWidget("labelPlayer", labelWidgetClass,panedVB,
				      XtNlabel, pllist, NULL);
}

/* initialization label "bottom" */
void createLabelLeft()
{
  static char version[16];

  sprintf(version, "VREng\n%s", VERSION);
  sprintf(toolname, "VREng-%s", VERSION);
  labelLeft = XtVaCreateManagedWidget("labelLeft", labelWidgetClass, panedVB,
				    XtNlabel, version, NULL);
}

void writeLabelStatus(char *str)
{
  XtVaSetValues(statusLabel, XtNlabel, str, NULL);
}

/* quitChannel */
Public
void quitChannel(Channel * pchan)
{
  int i;

  ChannelFree(pchan);
  for (i=0; i < cnt_fd; i++) {
    XtRemoveInput(id_fd[i]);
    close(tab_fd[i]);
  }
  free(id_fd);
  nb_chan--;
  trace(DBG_IPMC, "quitChannel: nb_chan=%d", nb_chan);
}

/* newChannel */
Public
void newChannel(char *chan_str)
{
  int i;
  Channel *pchan;

  trace(DBG_IPMC, "newChannel: chan_str=%s", chan_str);
  strncpy(curr_chan, newvrmc(chan_str), CHAN_LEN);
  notice("channel: %s", curr_chan);

  pchan = ChannelAlloc();
  cnt_fd = ChannelOpen(pchan, curr_chan, &tab_fd);
  id_fd = (XtInputId *) malloc(cnt_fd * sizeof(XtInputId));
  for (i=0; i < cnt_fd; i++) {
    id_fd[i] = XtAppAddInput(appContext, tab_fd[i],
                     (XtPointer) XtInputReadMask, FDEvent, (XtPointer) NETFD);
  }
  nb_chan++;
  trace(DBG_IPMC, "newChannel: pchan=%x nb_chan=%d cnt_fd=%d", pchan, nb_chan, cnt_fd);
}

/* initialChannel */
Public
void initialChannel(char *chan_str)
{
  int i;
  Channel *pchan;

  strncpy(curr_chan, newvrmc(chan_str), CHAN_LEN);
  notice("initialWorld: %s", curr_chan);

  pchan = ChannelAlloc();
  cnt_fd = ChannelOpen(pchan, curr_chan, &tab_fd);
  id_fd = (XtInputId *) malloc(cnt_fd * sizeof(XtInputId));
  for (i=0; i < cnt_fd; i++) {
    id_fd[i] = XtAppAddInput(appContext, tab_fd[i],
                     (XtPointer) XtInputReadMask, FDEvent, (XtPointer) NETFD);
  }
  nb_chan++;
  trace(DBG_IPMC, "initialChannel: pchan=%x nb_chan=%d cnt_fd=%d", pchan, nb_chan, cnt_fd);
}

