/*
 * manage group/port/ttl
 *
 * Philippe Dax
 * Oct 1997
 */


#include "global.h"
#include "mc.h"


char * getvrgroup(char * mc)
{
	static char group[GROUP_LEN], m[CHAN_LEN];
	char *p;

	strncpy(m, mc, sizeof(m));
	p = strchr(m, '/');
	*p = '\0';
	strncpy(group, m, sizeof(group));
	return(group);
}

unsigned short getvrport(char *mc)
{
	unsigned short port;
	char *p;

	p = strchr(mc, '/');
	port = (unsigned short) atoi(++p);
	trace(DBG_IPMC, "getvrport: port=%u", port);
	return(port);
}

unsigned char getvrttl(char *mc)
{
	unsigned char ttl;
	char *p;

	p = strrchr(mc, '/');
	ttl = (unsigned char) atoi(++p);
	trace(DBG_IPMC, "getvrttl: ttl=%u", ttl);
	return(ttl);
}

char * newvrmc(char *mc)
{
	unsigned short port;
	static char nmc[CHAN_LEN];
	static char group[GROUP_LEN];

	trace(DBG_IPMC, "newvrmc: mc=%s", mc);
	strncpy(group, getvrgroup(mc), sizeof(group));
	port = (unsigned short) getvrport(mc);
	strncpy(nmc, createmc(group, port, ttlorigin), sizeof(nmc));
	trace(DBG_IPMC, "newvrmc: nmc=%s", nmc);
	return(nmc);
}

char * createmc(char *group, unsigned short port, unsigned char ttl)
{
	static char nmc[CHAN_LEN];

	sprintf(nmc, "%s/%u/%d", group, port, ttl);
	trace(DBG_IPMC, "createmc: nmc=%s", nmc);
	return(nmc);
}

int getworldid(char *mc)
{
	int wid;
	char lowip, *p;
	unsigned short port;
	char group[GROUP_LEN];

	strncpy(group, getvrgroup(mc), sizeof(group));
	p = strrchr(group, '.');
	lowip = (char) atoi(++p);
	port = getvrport(mc);
	wid = lowip * port * ttlorigin;
	return((int) wid);
}

