/*
 * Xterm tool
 *
 * Philippe Dax
 * Oct 1997
 */


#include "global.h"
#include "xterm.h"

#ifdef WITHXTERM

/* global variable */
int xtermtool = SSH_TOOL;
int xtermpid = -1;

Public
void startxterm(char *host)
{
	trace(DBG_TOOL, "xterm: host=%s", host);
	xtermpid = fork();
	switch (xtermpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for xterm");
		break;
	case 0:
#ifdef WITHSSH
		if (xtermtool == SSH_TOOL)
			execl(XTERMPATH, "xterm", "-e", "ssh", host,
				(char *) NULL);
#endif
#ifdef WITHTELNET
		if (xtermtool == TELNET_TOOL)
			execl(XTERMPATH, "xterm", "-e", "telnet", host,
				(char *) NULL);
#endif
		trace(DBG_TOOL, "can't exec xterm");
		exit(1);
	default:
		break;
	}
}

Public
void quitxterm()
{
	if (xtermpid > 0) {
		kill(xtermpid, SIGKILL);
	}
}

#endif /* WITHXTERM */
