#ifndef CHANNEL_H
#define CHANNEL_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "rtp.h"


#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif


/*
 * Channel
 */
typedef struct _Channel {
  u_int32	group;			/* group address */
  int		sd[5];			/* sockets descriptors */
  struct ip_mreq mreq;			/* multicast IGMP */
  struct sockaddr_in sin_mcast_rtp;	/* RTP datas */
  struct sockaddr_in sin_mcast_rtcp;	/* RTCP datas */
  struct sockaddr_in sin_ucast_data;	/* UDP datas */
  struct sockaddr_in * sa[3];		/* sockets addresses */
  struct _Session *session;
  struct _Channel *next;
} Channel;


void ChannelInit();
Channel * ChannelAlloc();
void ChannelFree(Channel *);
int ChannelOpen(Channel *, const char *, int **);
void ChannelClose(Channel *);
int getfdbysa(Channel *, struct sockaddr_in *, int);
struct sockaddr_in * getsabysa(Channel *, struct sockaddr_in *, int);


#endif /* CHANNEL_H */
