#include "global.h"
#include "net_shm.h"


/**********************************/
/*** Fonctions de support dates ***/
/**********************************/

/* calcule t2-t1, en secondes. Juste (mais negatif) meme si t1>t2 */ 
Public
double diffDates(struct timeval t1, struct timeval t2)
{
  double d = (double)t2.tv_sec - (double)t1.tv_sec;

  d += ((double)t2.tv_usec - (double)t1.tv_usec)*1e-6; 
  return d;
}

/* ajoute d secondes a la date. OK meme si d<0 */
Public
void addToDate(struct timeval *t, double d)
{
  double f = floor(d);

  t->tv_sec += (signed long) f;
  t->tv_usec += (u_int32) ((d-f)*1e6);
  while (t->tv_usec >= 1000000) {
    t->tv_usec -= 1000000;
    t->tv_sec++;
  }
}

/* calcule une nouvelle date pour le assume_at de la propriete
 * et met le last_seen a "maintenant" 
 */
Public
void resetDates(Property * p)
{
  struct timeval now;

  gettimeofday(&now, NULL);
  p->last_seen = now;
  p->assume_at = now;
  addToDate(&p->assume_at, MIN_ASSUME_DELAY 
	    + rand()/(RAND_MAX+1.0)*(MAX_ASSUME_DELAY-MIN_ASSUME_DELAY));
}

