#ifndef NET_DECLS_H
#define NET_DECLS_H

#include <sys/types.h>

#include "rtp.h"

/*
 * NetObjectId
 *
 * A NetObjectId identifies a distributed object
 */
typedef struct {
  /* private */
#ifdef WITH_SSRC
  u_int32 ssrc_id;
#endif
  u_int32 host_id;
  u_int16 port_id;
  u_int16 obj_id;	/* object id -- network format */
} NetObjectId;

/* 
 * Property
 */
typedef struct {
  /* private */
  u_int8 responsible;
  u_int8 reserved;
  int16 version;
  struct timeval last_seen;
  struct timeval assume_at;
} Property;

/*
 * Object Header
 */
typedef struct NetObject {
  NetObjectId noid;		/* Net object id */
  u_int8 type;			/* object type */
  u_int8 permanent;		/* Is object permanent ? */
  /* private */
  Property *prop;		/* property[countProperties] of Object */
  struct NetObject *next;	/* next Object */
  struct NetObject *prev;	/* prev Object */
} NetObject;

/* 
 * Payload
 *
 * A payload is a message body
 */
#define MAX_TEXT 235	/* max size of datas */
typedef struct {
  /* private */
  u_int8 len;
  u_int8 current;
  u_int8 content[MAX_TEXT];
} Payload;


#endif /* NET_DECLS_H */
