#include "global.h"
#include "parse.h"
#include "move.h"


/* update times arrays */
Private
void ballUpdateTime(long sec, long usec, float *lasting, WObject *pball)
{
  *lasting = (float)(sec - pball->ext.ball.move.sec) +
    ((float)(usec - pball->ext.ball.move.usec) / MILLION);
  if (*lasting < pball->ext.ball.move.remaintime) {
    pball->ext.ball.move.remaintime -= *lasting;
    pball->ext.ball.move.sec = sec;
    pball->ext.ball.move.usec = usec;
  }
  else {
    *lasting = pball->ext.ball.move.remaintime;
    pball->ext.ball.move.remaintime = 0;
    pball->ext.ball.move.sec = pball->ext.ball.move.usec = 0;
  }
}

/* systeme d'equations regissant les mouvements imposes */
Private
void ballChangePosition(float lasting, WObject *pball)
{
  pball->x += lasting * pball->ext.ball.move.deltap.v[0];
  pball->y += lasting * pball->ext.ball.move.deltap.v[1];
  pball->z += lasting * pball->ext.ball.move.deltap.v[2];
  trace(DBG_FORCE, "forced position: pball->z=%f", pball->z);
  pball->a1 += lasting * pball->ext.ball.move.deltaa.v[0];
  pball->a2 += lasting * pball->ext.ball.move.deltaa.v[1];
}

/* systeme d'equations regissant les mouvements permanents */
Private
void ballChangePermanent(float lasting, WObject *pball)
{
  pball->z -= lasting * GRAVITY;
  pball->a1 += lasting * (-0.5);
  pball->a2 += lasting * (-0.5);
}

/* condition to make position changes  */
Private
int ballChange(WObject *pball)
{
  return (pball->ext.ball.move.remaintime > 0.0005) ? TRUE : FALSE;
}

/* push */
Private
void ballMethode0(WObject *pball, long sec, long usec)
{
  pball->ext.ball.move.deltap.v[0] = (float)(cos((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[1] = (float)(sin((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[2] = 0;
  pball->ext.ball.move.deltaa.v[0] = 0;
  pball->ext.ball.move.deltaa.v[1] = 0;
  pball->ext.ball.move.deltaa.v[2] = 0;
  pball->ext.ball.move.sec = sec;
  pball->ext.ball.move.usec = usec;
  pball->ext.ball.move.remaintime = pball->ext.ball.remaint;
}

/* pull */
Private
void ballMethode1(WObject *pball, long sec, long usec)
{
  pball->ext.ball.move.deltap.v[0] = - (float)(cos((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[1] = - (float)(sin((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[2] = 0;
  pball->ext.ball.move.deltaa.v[0] = 0;
  pball->ext.ball.move.deltaa.v[1] = 0;
  pball->ext.ball.move.deltaa.v[2] = 0;
  pball->ext.ball.move.sec = sec;
  pball->ext.ball.move.usec = usec;
  pball->ext.ball.move.remaintime = pball->ext.ball.remaint;
}

/* shoot */
Private
void ballMethode2(WObject *pball, long sec, long usec)
{
  pball->ext.ball.move.deltap.v[0] = (float)(cos((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[1] = (float)(sin((double)plocaluser->a1))* pball->ext.ball.lspeed;
  pball->ext.ball.move.deltap.v[2] = BALLMAXZ;
  pball->ext.ball.move.deltaa.v[0] = 0;
  pball->ext.ball.move.deltaa.v[1] = 0;
  pball->ext.ball.move.deltaa.v[2] = 0;
  pball->ext.ball.move.sec = sec;
  pball->ext.ball.move.usec = usec;
  pball->ext.ball.move.remaintime = pball->ext.ball.remaint;
}

/* destroy */
Private
void ballMethode3(WObject *pball, long sec, long usec)
{
  deleteObjectFromGrid(pball);
  mobilelist = deleteObjectFromList(pball, mobilelist);
  SolidDelete(pball->soh);
  declareDeletion((NetObject*) pball);
  deleteNetObject((NetObject*) pball);
  selectedObjectDeletion(pball->soh);
  free(pball);
}

/* creation: this method is invisible: called by the cauldron */
Private
void ballMethodeCreate(WObject *pcauldron, long sec, long usec)
{
  WObject *pball;
  char geometry[80];

  pball = (WObject*) malloc(sizeof(WObject));
  memset(pball, 0, sizeof(WObject));    
  pball->noh.type = BALLTYPE;
  strcpy(pball->h_name, BALLNAME);
  pball->ext.ball.move.remaintime = 0.0;
  pball->changeflag = FALSE;
  pball->x = pcauldron->x + (float)drand48() * 2 -1;
  pball->y = pcauldron->y + (float)drand48() * 2 -1;
  pball->z = pcauldron->z + BALLORIGZ;
  pball->a1 = 0;
  sprintf(geometry, "sphere,radius=%s,diffuse=%s", BALLRADIUS, BALLCOLOR);
  pball->soh = SolidParser(geometry);  
  updateObjectIn3D(pball);
  setOptionalBuffer(pball);
  pball->ext.ball.lspeed = BALLSPEED;
  pball->ext.ball.remaint = BALLREMAINT;
  pball->ext.ball.origz = pball->z;
  pball->secs = sec;
  pball->usecs = usec;
  updateBB(pball);
  mobilelist = addObjectToList(pball, mobilelist);
  insertObjectIntoGrid(pball);
  createNetObject((NetObject*) pball, VOLATILE);
  declareCreation(&(plocaluser->noh));
  trace(DBG_FORCE, "ball-create: pball->z=%f", pball->z);
}

/* ball creation from the network */
Private
void createBallFromNetwork (WObject *pball, Payload *ppl)
{
  char geometry[80];

  strcpy(pball->h_name, BALLNAME);
  pball->ext.ball.move.remaintime = 0.0;
  pball->changeflag = FALSE;
  sprintf(geometry, "sphere,radius=%s,diffuse=%s", BALLRADIUS, BALLCOLOR);
  pball->soh = SolidParser(geometry);
  setOptionalBuffer(pball);
  updateObjectIn3D(pball);
  pball->ext.ball.lspeed = BALLSPEED;
  pball->ext.ball.remaint = BALLREMAINT;
  pball->secs = -1.0;
  updateBB(pball);
  mobilelist = addObjectToList(pball, mobilelist);
  insertObjectIntoGrid(pball);
  setAllProperties((NetObject *) pball, ppl);
} 

/* ball update to the network */
Private
int updateBallToNetwork(WObject *pball, WObject *poldball)
{
  int change = FALSE;
  
  if ((pball->x != poldball->x) || (pball->y != poldball->y)) {
    declareDelta(&(pball->noh), BALLPROPXY);
    change = TRUE;
  }
  if (ABSF(pball->z - poldball->z) > BALLDELTAZ) {
    declareDelta(&(pball->noh), BALLPROPZ);
    change = TRUE;
  }
  if (pball->a1 != poldball->a1)
    change = TRUE;
  if (pball->a2 != poldball->a2)
    change = TRUE;
  return change;
}

/* object intersection: jump */
Private
void ballIntersect(WObject *pwoh, WObject *pwohold, WObject *pball)
{
  pwoh->z += BALLRADIUSD;
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
}

/* ball functions initialization */
Public
void initBallFuncList(void)
{
  generalFuncList[BALLTYPE].createFromNetwork = createBallFromNetwork;  
  generalFuncList[BALLTYPE].change = ballChange;
  generalFuncList[BALLTYPE].updateTime = ballUpdateTime;
  generalFuncList[BALLTYPE].changePosition = ballChangePosition;
  generalFuncList[BALLTYPE].updateToNetwork = updateBallToNetwork;
  generalFuncList[BALLTYPE].whenIntersect = ballIntersect;
  generalFuncList[BALLTYPE].changePermanent= ballChangePermanent;

  propertiesnumber[BALLTYPE] = BALLPROPERTIES;

  setFuncList[BALLPROPXY][BALLTYPE].pf = set_xy;
  setFuncList[BALLPROPZ][BALLTYPE].pf = set_z;
  setFuncList[BALLPROPA1][BALLTYPE].pf = set_a1;
  setFuncList[BALLPROPHNAME][BALLTYPE].pf = set_hname;
  setFuncList[BALLPROPA2][BALLTYPE].pf = set_a2;
  getFuncList[BALLPROPXY][BALLTYPE].pf = get_xy;
  getFuncList[BALLPROPZ][BALLTYPE].pf = get_z;
  getFuncList[BALLPROPA1][BALLTYPE].pf = get_a1;
  getFuncList[BALLPROPHNAME][BALLTYPE].pf = get_hname;
  getFuncList[BALLPROPA2][BALLTYPE].pf = get_a2;

  strcpy(generalMethodList[BALLPUSH][BALLTYPE].name, "Push");
  generalMethodList[BALLPUSH][BALLTYPE].method = ballMethode0;
  strcpy(generalMethodList[BALLPULL][BALLTYPE].name, "Pull");
  generalMethodList[BALLPULL][BALLTYPE].method = ballMethode1;
  strcpy(generalMethodList[BALLSHOOT][BALLTYPE].name, "Shoot");
  generalMethodList[BALLSHOOT][BALLTYPE].method = ballMethode2;
  strcpy(generalMethodList[BALLKILL][BALLTYPE].name, "Destroy");
  generalMethodList[BALLKILL][BALLTYPE].method = ballMethode3;
  strcpy(generalMethodList[BALLCREAT][BALLTYPE].name, "");
  generalMethodList[BALLCREAT][BALLTYPE].method = ballMethodeCreate;

  defmaxlasting[BALLTYPE] = BALLDEFMAXLAST;
}
