#include "global.h"
#include "parse.h"


int section_type = WALLTYPE;
char *fileline;

GeneralInitList generalInitList[] = {
/*  0 */	{ENDNAME,	ENDTYPE,	NULL},
/*  1 */	{USERNAME,	USERTYPE,	USERINIT},
/*  2 */	{WALLNAME,	WALLTYPE,	WALLINIT},
/*  3 */	{DOORNAME,	DOORTYPE,	DOORINIT},
/*  4 */	{CAULDRONNAME,	CAULDRONTYPE,	CAULDRONINIT},
/*  5 */	{BALLNAME,	BALLTYPE,	BALLINIT},
/*  6 */	{STEPNAME,	STEPTYPE,	STEPINIT},
/*  7 */	{EARTHNAME,	EARTHTYPE,	EARTHINIT},
/*  8 */	{GATENAME,	GATETYPE,	GATEINIT},
/*  9 */	{HOSTNAME,	HOSTTYPE,	HOSTINIT},
/* 10 */	{BOARDNAME,	BOARDTYPE,	BOARDINIT},
/* 11 */	{WEBNAME,	WEBTYPE,	WEBINIT},
/* 12 */	{VRMLNAME,	VRMLTYPE,	VRMLINIT},
/* 13 */	{BUTTONNAME,	BUTTONTYPE,	BUTTONINIT},
/* 14 */	{ANIMATORNAME,	ANIMATORTYPE,	ANIMATORINIT},
/* 15 */	{LIFTNAME,	LIFTTYPE,	LIFTINIT},
/* 16 */	{ROCKETNAME,	ROCKETTYPE,	ROCKETINIT},
/* 17 */	{CELLNAME,	CELLTYPE,	CELLINIT},
/* 18 */	{AOINAME,	AOITYPE,	AOIINIT},
/* 19 */	{DOCNAME,	DOCTYPE,	DOCINIT},
/* 20 */	{WALLSNAME,	WALLSTYPE,	NULL},
/* 21 */	{ENTRYNAME,	ENTRYTYPE,	ENTRYINIT},
		{"",		UNKNOWNTYPE,	NULL}
};


/* change of section type */
Private
int parseSectionType(Fileline l, int *psection_type)
{
  int i;
  char *w, tokend[2];
  Fileline w_tmp;

  strcpy(w_tmp, l);
  if ((w = strtok(w_tmp, SEP)) == NULL)
    fatal("W_mgt: I can't get an object from the Fileline:\n%s\n", l);

  switch (*w) {
    case '[': tokend[0] = ']'; break;
    case '<': tokend[0] = '>'; break;
    default: return SAMESECTION;
  }
  tokend[1] = '\0';
  w = strtok(&w[1], tokend);

  for (i = 0; generalInitList[i].type != UNKNOWNTYPE; i++) {
    if (!strncasecmp(w, generalInitList[i].name, sizeof(generalInitList[i].name))) {
      *psection_type = generalInitList[i].type;
      return SECTIONCHANGE;
    }
  }
  *psection_type = UNKNOWNTYPE;
  warning("parse: unknown object %s", w);
  return SAMESECTION;
}

int parseCfgDatas(char *buf, int size)
{
  char *fline;
  int i, linesize, i0 = 0, i1 = 0;

  if ((size == NETEOF) || (size == NETERROR)) {
    free(fileline);
    fileline = NULL;
    return 0;
  }
  
  if (fileline != NULL) {
    linesize = strlen(fileline);
    fline = (char*) malloc(sizeof(char) * (size + 1 + linesize));
    strcpy(fline, fileline);
  }
  else {
    fline = (char*) malloc(sizeof(char) * (size + 1));
    linesize = 0;
  }
  for (i = 0; i < size; i++)
    fline[linesize + i] = buf[i];
  linesize += size;
  fline[linesize] = '\0';

  while (1) {
    for (i = i0; i < linesize; i++)
      if (fline[i] == '\n') {
	i1 = i;
	i = linesize+1;
      }
    if (i == linesize + 2) {
      fileline = (char*) malloc(sizeof(char) * (i1 - i0 + 1));
	for (i = 0; i < i1 - i0; i++)
	  fileline[i] = fline[i0 + i];
      fileline[i1 - i0] = '\0';	

      /* discard comments begining with a # (Philippe Dax) */
      if (fileline[0] == '#') {
        free(fileline);
        fileline = NULL;
        i0 = i1 + 1;
        continue;
      }

      if (parseSectionType(fileline, &section_type) == SAMESECTION) {
	trace(DBG_WMGT, "Wmgt: cfg : #%s#", fileline);
        /* discard lines under unknown type (Philippe Dax) */
        if (section_type == UNKNOWNTYPE) {
	  free(fileline);
	  fileline = NULL;
	  i0 = i1 + 1;
	  continue;
        }
	if (section_type == WALLSTYPE) {
	  load_walls(fileline);
	  free(fileline);
	  fileline = NULL;
	  i0 = i1 + 1;
	  section_type = UNKNOWNTYPE;
	  continue;
	}
	if (generalFuncList [section_type].createFromFileline == NULL) {
	  warning("WMgt: Bad type in creating from file!");
          continue;
        }
	generalFuncList[section_type].createFromFileline(fileline);
      }
      free(fileline);
      fileline = NULL;
      i0 = i1 + 1;
    }
    else
      break;
  }
  fileline = (char*) malloc(sizeof(char) * (linesize - i0 + 1));
  for (i = 0; i < linesize - i0; i++)
    fileline[i] = fline[i + i0];
  fileline[linesize - i0] = '\0';
  free(fline);
  return 0;
}

int readCfg(void *handle, void *b)
{
  int i;
  char buf[BUFF_LEN];

  if (b == NULL) {
    warning("readCfg: error opening file");
    wmgtlockstate = LOCK_DOWNLOADED;
    return 0;
  }
  else {
    while ((i = httpRead(b, buf, sizeof(buf))) > 0) {
      parseCfgDatas(buf, i);
      if (section_type == ENDTYPE)
	wmgtlockstate = LOCK_DOWNLOADED;
    }
  }
  return 0;
}

/* check fileline */
Public
char *
parseFileLine(char *line)
{
  char *ptok;

  if ((ptok = strtok(line, SEP)) == NULL)
    fatal("parse: I can't get anything from the fileline:\n%s\n", line);

  return ptok;
}

/* parse object name: fill name and named */
Public
char *
parseName(char *line, u_int8 named, char name[])
{
  if (*line == '(') {
    /* The object has a name */
    int i;

    line++;
    for (i = 0; *line != ')' && i <OBJNAME_LEN -1; name[i++] = *line++)
      ;
    name[i] = '\0';
    line++;
    while (*line == ' ')
      line++;
    named = 1;
  }
  return line;
}

/* parse space position: x y z */
Public
char *
parsePositionXYZ(char *ptok, WObject *pwoh)
{
  pwoh->x  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->y  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->z  = (float) atof(ptok); ptok = strtok(NULL, SEP);

  return ptok;
}

/* parse space position: x y z a1 */
Public
char *
parsePosition(char *ptok, WObject *pwoh)
{
  pwoh->x  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->y  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->z  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->a1 = (float) atof(ptok); ptok = strtok(NULL, SEP);

  return ptok;
}

/* parse space position: x y z a1 a2 a3 */
Public
char *
parsePositionXYZa1a2a3(char *ptok, WObject *pwoh)
{
  pwoh->x  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->y  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->z  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->a1 = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->a2 = (float) atof(ptok); ptok = strtok(NULL, SEP);
  pwoh->a3 = (float) atof(ptok); ptok = strtok(NULL, SEP);

  return ptok;
}

