#include "global.h"
#include "parse.h"


/* step parser */
Private
void stepParser(char *l, WObject *pstep)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pstep);
  pstep->soh = SolidParser(w);
}

/* create a step from a fileline */
Private
void createStepFromFile(Fileline l)
{
  WObject *pstep;

  pstep = (WObject*) malloc(sizeof(WObject));
  memset(pstep, 0, sizeof(WObject));    
  pstep->noh.type = STEPTYPE;
  stepParser(l, pstep);
  strcpy(pstep->h_name, STEPNAME);
  updateObjectIn3D(pstep);
  setOptionalBuffer(pstep);
  updateBB(pstep);
  stilllist = addObjectToList(pstep, stilllist);
  insertObjectIntoGrid(pstep);
} 

/* object intersects: up */
Private
void stepIntersect(WObject *pwoh, WObject *pwohold, WObject *pstep)
{
  pwoh->z += STEPSIZE;	/* 0.02 */
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
}

/* functions initialization */
Public
void initStepFuncList(void)
{
  generalFuncList[STEPTYPE].createFromFileline = createStepFromFile;
  generalFuncList[STEPTYPE].whenIntersect = stepIntersect;
  
  propertiesnumber[STEPTYPE] = 0;
}
