#define MM_IMAGE_RGB   1
#define MM_IMAGE_RGBA  2

/* we only deal with 8 bits RGB images */

typedef struct {
  int xsize;
  int ysize;
  int format;
  unsigned char *pixmap;
} MM_Image;

typedef struct MM_Anim_Image {
  MM_Image image;
  struct MM_Anim_Image *next;
} MM_Anim_Image;

typedef struct {
  float delay;
  int nb_images;
  MM_Anim_Image *images;
} MM_Anim;

typedef int (*MM_ReadFunc)(void *handle,char *buf,int length);
typedef void (*MM_DisplayImageFunc)(void *handle,MM_Image *image);

MM_Image *MM_loadPPM(void *handle,MM_ReadFunc read_func,
		    MM_DisplayImageFunc display_func);

MM_Image *MM_loadGIF(void *handle,MM_ReadFunc read_func,
		     MM_DisplayImageFunc display_func);

MM_Image *MM_loadJPEG(void *handle,MM_ReadFunc read_func,
		      MM_DisplayImageFunc display_func);

MM_Image *MM_loadPNG(void *handle,MM_ReadFunc read_func,
		     MM_DisplayImageFunc display_func);

MM_Image *MM_loadPCX(void *handle,MM_ReadFunc read_func,
		     MM_DisplayImageFunc display_func);

MM_Image *MM_newImage(int xsize,int ysize,int format);
void MM_freeImage(MM_Image *image);
MM_Image *MM_resizeImage(int xsize,int ysize,MM_Image *src);


void MM_freeAnim(MM_Anim *anim);

/*  modifier pour utiliser mime. */

int MM_getType(char *url);

enum {
  MM_TYPE_UNKNOWN=1,
  MM_TYPE_PPM,
  MM_TYPE_GIF,
  MM_TYPE_JPEG,
  MM_TYPE_PNG,
  MM_TYPE_PCX
};

