#include <system.h>

#include "mmedia.h"
#include "global.h"


typedef struct {
  void *th;
  MM_ReadFunc read_func;
  int ch;
} Ppm;

static void get_ch(Ppm *s)
{
  unsigned char data;
  int ret_len;
  ret_len=s->read_func(s->th, &data, 1);
  if (ret_len < 1) data=0;
  s->ch = data;
}

static void get_ch1(Ppm *s)
{
  get_ch(s);
  while (s->ch == '#') {
    do {
      get_ch(s);
    } while (s->ch != 0 && s->ch != '\n' && s->ch!='\r');
    get_ch(s);
  }
}

static int is_space(int ch)
{
  return (ch == ' ' || ch == '\n' ||
	  ch == '\r' || ch == '\t');
}

static void skip_spaces(Ppm *s)
{
  while (is_space(s->ch)) {
    get_ch1(s);
  }
}

/* returns -1 if error */
static int get_int(Ppm *s)
{
  int n=0;

  if (!(s->ch >= '0' && s->ch <= '9')) return -1;
  do {
    n=n*10+(s->ch-'0');
    get_ch1(s);
  } while (s->ch >= '0' && s->ch <= '9');
  return n;
}


MM_Image *MM_loadPPM(void *th, MM_ReadFunc read_func,
		    MM_DisplayImageFunc display_func)
{
  Ppm s1;
  Ppm *s = &s1;
  char header[2];
  int i,xsize,ysize,maxval;
  MM_Image *image;

  s->read_func=read_func;
  s->th = th;

  get_ch(s);
  header[0]=s->ch;
  get_ch(s);
  header[1]=s->ch;
#ifdef DEBUG_PPM
  trace(DBG_ZV, "In ppm: %c%c", header[0], header[1]);
#endif
  if (header[0]!='P' || header[1]!='6') return NULL;

  get_ch1(s);
  skip_spaces(s);
  xsize=get_int(s);
  skip_spaces(s);
  ysize=get_int(s);
  skip_spaces(s);
  maxval=get_int(s);
  if (!is_space(s->ch)) return NULL;
#ifdef DEBUG_PPM
  trace(DBG_ZV, "In ppm: %d %d %d", xsize, ysize, maxval);
#endif

  /* we read the data */
  image = MM_newImage(xsize,ysize,MM_IMAGE_RGB);

  for (i=0; i < ysize; i++) {
    s->read_func(s->th, image->pixmap+i*xsize*3, xsize*3);
    display_func(s->th, image);
  }
  return image;
}

