#include "extreme.h"
/******************************************************
*    strparse                                         *
*                                                     *
*       Takes a pointer to a string and a delimiter   *
*       and a list of char arrays to split string     *
*       by with delimiter delimiter.                  *
*                                                     *
*                                                     *
******************************************************/
int strparse(char *string, const char *delim, int sections, ...) {

  int idx, length, mark, delimsfound = 0;
  int delimlen;
  char *strparts, *thisarg_addr;
   

  va_list arg_addr;
  va_start(arg_addr, sections);
  strparts = string;
  delimlen = strlen(delim);
  length = strlen(string);
  if (sections == 1) {
    thisarg_addr = va_arg(arg_addr, char*);
    strcpy(thisarg_addr, strparts);
  }

  for (idx = 0; idx < length && delimsfound < sections - 1; idx++) {
      /* If the current address for delimlen long equals the delim */
      if ((strncmp(strparts + idx, delim, delimlen)) == 0) {
         delimsfound++;
         *(strparts + idx) = '\0';
         if (delimsfound < (sections - 1) || delimsfound == 1) {
           if (delimsfound == 1) {
                thisarg_addr = va_arg(arg_addr, char*);
                strcpy(thisarg_addr, strparts);
                mark = idx;
                if (sections == 2) {
                  thisarg_addr = va_arg(arg_addr, char*);
                  strcpy(thisarg_addr, strparts + idx + delimlen);
                }
           } else {
                thisarg_addr = va_arg(arg_addr, char*);
                strcpy(thisarg_addr, strparts + mark + delimlen);
                mark = idx;
           }
         } else {
           thisarg_addr = va_arg(arg_addr, char*);
           strcpy(thisarg_addr, strparts + mark + delimlen);
           thisarg_addr = va_arg(arg_addr, char*);
           strcpy(thisarg_addr, strparts + idx + delimlen);
         }
         strncpy(strparts + idx, delim, delimlen);
      }
  }

  va_end(arg_addr);
  return(delimsfound + 1);
}
