.\" @(#)convert_to_xview.1 1.2 90/06/19 SMI;
.TH CONVERT_TO_XVIEW 1  "11 June 1990"
.SH NAME
convert_to_xview \- convert a SunView1 source program to XView source
.SH SYNOPSIS
.B convert_to_xview 
[
.B -m
] 
.I filename...
.SH AVAILABILITY
This command is available with the XView software distribution.
.SH DESCRIPTION
.B convert_to_xview 
is a shell script which uses 
sed(1) 
scripts to convert 
.I SunView1.x 
programs to the XView Application Programming Interface (API).  
.B convert_to_xview 
parses filename and creates a new file with 
the XView API in the current directory called 
.B filename.converted_to_xview.
The default conversion that is done is called FULL conversion.  
FULL conversion of SunView source converts 
everything to XView naming conventions regardless of API compatibility support 
(e.g., changes 
.B WIN_FONT 
to 
.B XV_FONT 
even though 
.B WIN_FONT 
would still work).
.LP
The other type of conversion is called MINIMAL conversion.  MINIMAL conversion retains SunView 
compatibility wherever possible and inserts a unique flag and comments at every instance 
where manual conversion is necessary in C language source comment form.  
The flag and comments will look something like this:
.LP
.B "	#ifdef XVIEW_COMMENT"
.br
.B "	XView CONVERSION - Make sure to use xv_init to process the attrs"
.br
.B "	first. Sect 3.2"
.br
.B 	#endif
.LP
The original SunView1.x file is not modified.   After the file is converted, you should 
then search for 
.LP
.B	XView CONVERSION
.LP
in the new converted program 
.B (filename.converted_to_xview). 
Use the conversion 
documentation, XView 1.0 Reference Manual: Converting SunView Applications, 
to determine the proper conversion for these flagged items.  
In some possible cases, the comments may make references to sections in 
the manual which should be consulted to correctly convert something.   
.LP
.SH OPTIONS
.TP
[-m]
Perform minimal conversion only. 
.SH ENVIRONMENT
The script recognizes the environment variable $OPENWINHOME as the 
root directory for the installation point for 
.B convert_to_xview.
By default it should be installed into the root directory '/'.  
Additionally, the sed(1) scripts 
that are used by 
.B convert_to_xview 
must be located in the 
.B $OPENWINHOME/conversion 
directory.
.SH EXAMPLES
Convert foo.c from SunView1 to XView:
.LP
.B 	% convert_to_xview foo.c
.br
.B 	----Converting File: foo.c
.br
.B 	--Done
.br
.B 	%
.LP
Now go in and edit (with your favorite text editor such as vi,textedit, 
etc.) the result of the conversion 
(my_program.c.converted_to_xview) and see if there is anythingthat 
didn't get converted:
.sp
.B	% textedit foo.c.converted
.sp
Do only minimal conversion of my_program.c & your_program.c to XView:
.sp
.B 	% convert_to_xview -m foo.c blah.c
.br
.B 	----Converting File: foo.c
.br
.B 	----Converting File: blah.c
.br
.B 	--Done
.br
.B 	%
.br
The above would create two files new files and each will only
had minimal conversion performed (just flags inserted).
.SH FILES
.br
.B 	$OPENWINHOME/bin/xview/convert_to_xview
.br
.B 	$OPENWINHOME/bin/xview/convert_to_xview.README 
(this file)
.LP
Where $OPENWINHOME is the installation/mount point for XView.
.SH SEE ALSO
.B "sunview(1), sed(1), textedit(1), vi(1), sh(1)"

