package biss.awt;

import biss.DateLib;

/**
 * simple TextField contents checker to validate dates. It currently
 * does just character checking (no grammar yet).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class EntryDateChecker
  implements EntryKeyFilter, EntryValidator
{

public boolean isValidKey( int pos, char c ) {
	switch( pos) {
	case 0: return ( (c >= '0') && (c <='3'));
	case 1: return ( (c >= '0') && (c <='9'));
	case 2: return ( c == '.' );
	case 3: return ( (c >= '0') && (c <='1'));
	case 4: return ( (c >= '0') && (c <='9'));
	case 5: return ( c == '.' );
	case 6: return ( (c >= '1') && (c <='2'));
	case 7: return ( (c >= '0') && (c <='9'));
	case 8: return ( (c >= '0') && (c <='9'));
	case 9: return ( (c >= '0') && (c <='9'));
	}
	return false;
}

public String validateContents (String cont) {
	if ( (cont.length() != 10) || ( DateLib.dateFromEDF( cont) == null) )
		return "???";
	return cont;
}
}
