package biss.awt;

import biss.Queue;

/**
 * Thread object used for asynchronous (accumulative) drawing in
 * panes. Requires the pane to implement the DrawablePane interface.
 * Useful to do time-consuming draw operations in the background
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class PaneDrawer
  extends Thread
{
	DrawablePane Pane;
	Queue DrawQueue;
	int Delay = 100;
	boolean StopIt = false;

public PaneDrawer ( DrawablePane pane, Queue queue ) {
	this( pane, queue, 0);
}

public PaneDrawer ( DrawablePane pane, Queue queue, int delay ) {
	Pane = pane;
	DrawQueue = queue;
	Delay = delay;

	setDaemon( true);
	setPriority( Thread.MIN_PRIORITY);
	start();
}

public void run () {
	try {
		while ( !StopIt ) {
			if ( Pane.getPeer() == null ) break;
			
			if ( DrawQueue.empty() ) {
				synchronized ( DrawQueue ) {
					// termination safeguard. This is NOT the recommended way
					// to shut down a PaneDrawer thread because there might be
					// lengthy drawPane operations which might cause Graphics operations
					// after the Pane was closed (causing BadDrawable X errors).
					// However, most VMs seem to have problems with explicitly stopped
					// threads
					DrawQueue.wait(3000);
				}
			}
			else {
				Pane.drawPane();

				if ( Awt.AwtToolkit == Awt.TK_WIN )
					Awt.DefToolkit.sync();  // WORKAROUND: WinNT sync bug

				if ( Delay > 0 ) sleep( Delay);					
			}
		}
	}
	catch ( Exception x ) {
		x.printStackTrace();
	}
}

public void stopIt () {
	synchronized ( DrawQueue ) {
		StopIt = true;
		DrawQueue.notify();
	}
}
}
