.TH plot3d1 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot3d1 - gray or color level plotting of a surface.
.SH DESCRIPTION
.nf
plot3d1(x,y,z,[theta,alpha,leg,flag,ebox])
plot3d1(xf,yf,zf [,theta,alpha,leg [,flag,ebox]])
.fi
.SH PARAMETERS
see \fVplot3d\fR for a full description. There's just a slight
difference, the value of the \fVmode\fR parameter is unused, only its
sign. If the sign is negative the grid is not drawn. 
.SH DESCRIPTION
plots a surface  \fVz=f(x,y)\fR (points) 
with colors depending on the z-level of the surface.
Enter the command \fVplot3d1()\fR to see a demo or \fVfac3d1()\fR.
.SH EXAMPLE 
.nf
plot3d1(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[2,2,3]);
xbasc();
plot3d1(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[-2,2,3]);
xbasc();
t=(0:0.3:2*%pi)';zmat=sin(t)*cos(t');
[xx,yy,zz]=genfac3d(t,t,zmat);
plot3d1([xx xx],[yy yy],[zz 4+zz]);
xbasc();
plot3d1([xx xx],[yy yy],list([zz zz+4],[4*ones(1,400) 5*ones(1,400)]))
.fi
.SH AUTHOR
J.Ph.C.
