.TH SIMP G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
simp - rational simplification
.SH CALLING SEQUENCE
.nf
[N1,D1]=simp(N,D)
H1=simp(H)
.fi
.SH PARAMETERS
.TP
N,D 
: real polynomials or real matrix polynomials
.TP
H 
: rational matrix (i.e matrix with entries \fVn/d\fR ,\fVn\fR and \fVd\fR real polynomials) 
.SH DESCRIPTION
\fV[n1,d1]=simp(n,d)\fR calculates two polynomials \fVn1\fR and \fVd1\fR
such that \fVn1/d1 = n/d\fR.
.LP
If \fVN\fR and \fVD\fR are polynomial matrices the calculation
is performed element-wise.
.LP
\fVH1=simp(H)\fR is also valid (each entry of \fVH\fR is 
simplified in \fVH1\fR).
.LP
Caution: 
.LP
-no threshold is given i.e. \fVsimp\fR cannot forces a
simplification.
.LP
-For linear dynamic systems which include integrator(s) simplification
changes the static gain. (\fVH(0)\fR for continuous systems or \fVH(1)\fR for
discrete systems)
.LP
-for complex data, \fVsimp\fR returns its input(s).
.LP
-rational simplification is called after nearly each operations on 
rationals. It is possible to toggle simplification on or off using
\fVsimp_mode\fR function.
.SH EXAMPLES
.nf
s=poly(0,'s');
[n,d]=simp((s+1)*(s+2),(s+1)*(s-2))

simp_mode(%F);hns=s/s
simp_mode(%T);hns=s/s

.fi
.SH SEE ALSO
roots, trfmod, poly, clean, simp_mode

