/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */



#ifndef _DICTIONARY_H_
#define _DICTIONARY_H_


#include <stdlib.h>
#include "OSHeaders.h"

class DictValueElement;
class DictValueIDManager;

class Dictionary
{
public:
	Dictionary(DictValueIDManager* inDictValueIDManager = NULL);
	virtual ~Dictionary();
	
	UInt32 GenerateIDForSignature(FourCharCode inValueSignature);
	UInt32 AddValue(FourCharCode inValueSignature, const void* inValueBuffer, UInt32 inBufferLen);
	void GetValue(UInt32 inValueID, void* ioValueBuffer, UInt32 inBufferLen, UInt32* ioValueLen);
	void SetValue(UInt32 inValueID, const void* inValueBuffer, UInt32 inBufferLen);
	void DisposeValue(UInt32 inValueID);

	UInt32 LookupIDBySignature(FourCharCode inValueSignature);

protected:
	
	void GrowValueElementArray(UInt32 inNewID);
	
	UInt32	fValueElementArraySize;
	DictValueElement**	fValueElementArray;	//Array of "DictValueElement*"s
	DictValueIDManager* fDictValueIDManager;
};

//Just serves up IDs (array indexes)
class DictValueIDManager
{
public:
	DictValueIDManager() : fNextAvailableID(1), fTagsArraySize(0), fTagsArray(NULL) {}
	~DictValueIDManager(){ delete[] fTagsArray;}

	UInt32 LookupIDBySignature(FourCharCode inValueSignature);
	FourCharCode LookupSignatureByID(UInt32 inValueID);
	
	UInt32 GenerateIDForSignature(FourCharCode inValueSignature);
	inline bool ValidValueID(UInt32 inValueID) {return (inValueID > 0) && (inValueID<fNextAvailableID);}
	inline UInt32 GetNextAvailableID() {return fNextAvailableID;}

	UInt32 fNextAvailableID;
	UInt32 fTagsArraySize;
	FourCharCode* fTagsArray;
};

#endif